/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.Maps;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.documentation.docstrings.DocStringLineParser;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.toolbox.Substring;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TagBasedDocString
extends DocStringLineParser
implements StructuredDocString {
    protected final String myDescription;
    protected final Map<String, Substring> mySimpleTagValues;
    protected final Map<String, Map<Substring, Substring>> myArgTagValues;
    private static final Pattern a;
    private static final Pattern b;
    private static final Pattern c;
    public static String[] PARAM_TAGS;
    public static String[] PARAM_TYPE_TAGS;
    public static String[] VARIABLE_TAGS;
    public static String[] RAISES_TAGS;
    public static String[] RETURN_TAGS;
    @NotNull
    private final String d;
    public static String TYPE;
    private static final long f;

    protected TagBasedDocString(@NotNull Substring docStringText, @NotNull String tagPrefix) {
        if (docStringText == null) {
            TagBasedDocString.b(0);
        }
        if (tagPrefix == null) {
            TagBasedDocString.b(1);
        }
        super(docStringText);
        this.mySimpleTagValues = Maps.newHashMap();
        this.myArgTagValues = Maps.newHashMap();
        this.d = tagPrefix;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < this.getLineCount(); ++i10) {
            Substring substring = this.getLine(i10).trim();
            if (substring.startsWith(tagPrefix)) {
                i10 = this.parseTag(i10, tagPrefix);
                continue;
            }
            stringBuilder.append(substring.toString()).append("\n");
        }
        this.myDescription = stringBuilder.toString();
    }

    public abstract List<String> getAdditionalTags();

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            TagBasedDocString.b(2);
        }
        return string;
    }

    @Override
    public String getSummary() {
        List list2 = StringUtil.split((String)StringUtil.trimLeading((String)this.myDescription), (String)"\n", (boolean)true, (boolean)false);
        if (list2.size() > 1 && ((String)list2.get(1)).isEmpty()) {
            return (String)list2.get(0);
        }
        return "";
    }

    @NotNull
    private Map<Substring, Substring> a(String string) {
        LinkedHashMap linkedHashMap = this.myArgTagValues.get(string);
        if (linkedHashMap == null) {
            linkedHashMap = Maps.newLinkedHashMap();
            this.myArgTagValues.put(string, linkedHashMap);
        }
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        if (linkedHashMap2 == null) {
            TagBasedDocString.b(3);
        }
        return linkedHashMap2;
    }

    protected int parseTag(int lineno, String tagPrefix) {
        long l2 = f ^ 0x4E990E34A1A5L;
        Substring substring = this.getLine(lineno).trimLeft();
        if (substring.startsWith(tagPrefix)) {
            Substring substring2 = substring.substring(tagPrefix.length());
            Matcher matcher = a.matcher(substring2);
            Matcher matcher2 = b.matcher(substring2);
            Matcher matcher3 = null;
            if (matcher.matches()) {
                matcher3 = matcher;
            } else if (matcher2.matches()) {
                matcher3 = matcher2;
            }
            if (matcher3 != null) {
                Substring substring3;
                Substring substring4 = substring2.getMatcherGroup(matcher3, 1);
                Substring substring5 = substring2.getMatcherGroup(matcher3, 2).trim();
                TextRange textRange = substring2.getMatcherGroup(matcher3, 3).trim().getTextRange();
                int n2 = this.getLineCount();
                int n3 = textRange.getStartOffset();
                int n4 = textRange.getEndOffset();
                while (lineno + 1 < n2 && !(substring3 = this.getLine(lineno + 1).trim()).isEmpty() && !substring3.startsWith(tagPrefix)) {
                    n4 = substring3.getTextRange().getEndOffset();
                    ++lineno;
                }
                substring3 = new Substring(substring5.getSuperString(), n3, n4);
                String string = substring4.toString();
                if (substring5.isEmpty()) {
                    this.mySimpleTagValues.put(string, substring3);
                } else {
                    Matcher matcher4;
                    if (("param".equals(string) || "parameter".equals(string) || "arg".equals(string) || "argument".equals(string)) && (matcher4 = c.matcher(substring5)).matches()) {
                        Substring substring6 = substring5.getMatcherGroup(matcher4, 1).trim();
                        substring5 = substring5.getMatcherGroup(matcher4, 2);
                        this.a(TYPE).put(substring5, substring6);
                    }
                    this.a(string).put(substring5, substring3);
                }
            }
        }
        return lineno;
    }

    protected static List<String> toUniqueStrings(List<?> objects) {
        ArrayList<String> arrayList = new ArrayList<String>(objects.size());
        for (Object obj : objects) {
            String string = obj.toString();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Nullable
    public Substring getTagValue(String ... tagNames) {
        for (String string : tagNames) {
            Substring substring = this.mySimpleTagValues.get(string);
            if (substring == null) continue;
            return substring;
        }
        return null;
    }

    @Nullable
    public Substring getTagValue(String tagName, @NotNull String argName) {
        Map<Substring, Substring> map2;
        if (argName == null) {
            TagBasedDocString.b(4);
        }
        return (map2 = this.myArgTagValues.get(tagName)) != null ? map2.get(new Substring(argName)) : null;
    }

    @Nullable
    public Substring getTagValue(String[] tagNames, @NotNull String argName) {
        if (argName == null) {
            TagBasedDocString.b(5);
        }
        for (String string : tagNames) {
            Map<Substring, Substring> map2 = this.myArgTagValues.get(string);
            Substring substring = new Substring(argName);
            if (map2 == null || !map2.containsKey(substring)) continue;
            return map2.get(substring);
        }
        return null;
    }

    public List<Substring> getTagArguments(String ... tagNames) {
        ArrayList<Substring> arrayList = new ArrayList<Substring>();
        for (String string : tagNames) {
            Map<Substring, Substring> map2 = this.myArgTagValues.get(string);
            if (map2 == null) continue;
            arrayList.addAll(map2.keySet());
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Substring> getParameterSubstrings() {
        ArrayList<Substring> arrayList = new ArrayList<Substring>();
        arrayList.addAll(this.getTagArguments(PARAM_TAGS));
        arrayList.addAll(this.getTagArguments(PARAM_TYPE_TAGS));
        ArrayList<Substring> arrayList2 = arrayList;
        if (arrayList2 == null) {
            TagBasedDocString.b(6);
        }
        return arrayList2;
    }

    @Override
    protected boolean isBlockEnd(int lineNum) {
        return this.getLine(lineNum).trimLeft().startsWith(this.d);
    }

    static {
        f = com.jetbrains.python.psi.c.a(-4240804960074314741L, -6715811819642792459L, MethodHandles.lookup().lookupClass()).a(194309252273418L);
        long l2 = f ^ 0x1AC2FFEFA933L;
        a = Pattern.compile("([a-z]+)(\\s+:class:[^:]*|[^:]*)\\s*:\\s*?(.*)");
        b = Pattern.compile("([a-z]+)\\s+([a-zA-Z_0-9]*)\\s*:?\\s*?([^:]*)");
        c = Pattern.compile("(.*?)\\s+([a-zA-Z_0-9]+)");
        PARAM_TAGS = new String[]{"param", "parameter", "arg", "argument"};
        PARAM_TYPE_TAGS = new String[]{"type"};
        VARIABLE_TAGS = new String[]{"ivar", "cvar", "var"};
        RAISES_TAGS = new String[]{"raises", "raise", "except", "exception"};
        RETURN_TAGS = new String[]{"return", "returns"};
        TYPE = "type";
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x1415B15339D4L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docStringText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagPrefix";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/TagBasedDocString";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/TagBasedDocString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagValuesMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterSubstrings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTagValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

