/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.editor.a;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyJoinLinesHandler
implements JoinRawLinesHandlerDelegate {
    private static final Joiner[] a;
    private static final long b;

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start2, int end) {
        if (document == null) {
            PyJoinLinesHandler.a(0);
        }
        if (file == null) {
            PyJoinLinesHandler.a(1);
        }
        return -1;
    }

    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file, int start2, int end) {
        if (document == null) {
            PyJoinLinesHandler.a(2);
        }
        if (file == null) {
            PyJoinLinesHandler.a(3);
        }
        if (!(file instanceof PyFile)) {
            return -1;
        }
        CharSequence charSequence = document.getCharsSequence();
        if (start2 >= 0 && charSequence.charAt(start2) == '\n') {
            --start2;
        }
        if (start2 >= 0 && charSequence.charAt(start2) == '\\') {
            --start2;
        }
        while (start2 >= 0 && charSequence.charAt(start2) == ' ' || charSequence.charAt(start2) == '\t') {
            --start2;
        }
        if (start2 < 0) {
            return -1;
        }
        PsiElement psiElement = file.findElementAt(start2);
        PsiElement psiElement2 = file.findElementAt(end);
        if (psiElement != null && psiElement2 != null) {
            PyExpression pyExpression = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyExpression.class);
            PyExpression pyExpression2 = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement2, PyExpression.class);
            Request request = new Request(document, start2, end, psiElement, pyExpression, psiElement2, pyExpression2, null);
            for (Joiner joiner : a) {
                Result result = joiner.join(request);
                if (result == null) continue;
                int n2 = start2 + 1 - result.cutFromLeft;
                document.replaceString(n2, end + result.cutIntoRight, (CharSequence)result.replacement);
                return n2 + result.caretOffset;
            }
        }
        return -1;
    }

    private static String a(String string, int n2) {
        String string2;
        if (string.length() < n2) {
            return "";
        }
        List list2 = StringUtil.split((String)string, (String)" ");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        int n3 = 0;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext() && (n3 += (string2 = (String)iterator.next()).length() + 1) < n2) {
            stringBuilder.append(string2);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private static int a(Request request, int n2) {
        int n3 = PyJoinLinesHandler.a(request);
        int n4 = CodeStyle.getSettings((PsiFile)request.leftElem.getContainingFile()).getRightMargin((Language)PythonLanguage.getInstance());
        int n5 = request.document.getLineEndOffset(request.document.getLineNumber(n3)) - n3;
        return n4 - n5 - n2;
    }

    private static int a(@NotNull Request request) {
        if (request == null) {
            PyJoinLinesHandler.a(4);
        }
        int n2 = request.document.getLineNumber(request.firstLineEndOffset);
        return request.document.getLineStartOffset(n2);
    }

    static {
        b = c.a(1110626009531464794L, -9028053334310452282L, MethodHandles.lookup().lookupClass()).a(22725289478334L);
        a = new Joiner[]{new OpenBracketJoiner(null), new CloseBracketJoiner(null), new StringLiteralJoiner(null), new StmtJoiner(null), new BinaryExprJoiner(null), new CommentJoiner(null), new StripBackslashJoiner(null)};
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x3E12687387A7L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "req";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/editor/PyJoinLinesHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryJoinLines";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryJoinRawLines";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLeftLineStartOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StripBackslashJoiner
    implements Joiner {
        static final TokenSet SINGLE_QUOTED_STRINGS;
        private static final long a;

        private StripBackslashJoiner() {
        }

        @Override
        @Nullable
        public Result join(@NotNull Request req) {
            String string;
            int n2;
            long l2 = a ^ 0x3FC6AF193CEAL;
            if (req == null) {
                StripBackslashJoiner.a(0);
            }
            if ((n2 = (string = req.document.getText(new TextRange(req.firstLineEndOffset + 1, req.secondLineStartOffset))).indexOf(92)) >= 0) {
                if (req.leftElem == req.rightElem && SINGLE_QUOTED_STRINGS.contains(req.leftElem.getNode().getElementType())) {
                    return new Result(string.replaceFirst("\\\\\\n", ""), 0);
                }
                return new Result(string.substring(0, n2), 0);
            }
            return null;
        }

        /* synthetic */ StripBackslashJoiner(a x0) {
            this();
        }

        static {
            a = c.a(-4040034110784317256L, 5358212057753614740L, MethodHandles.lookup().lookupClass()).a(141014897514138L);
            SINGLE_QUOTED_STRINGS = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.SINGLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_UNICODE});
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x4861FB82F020L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$StripBackslashJoiner", "join"));
        }
    }

    private static class CommentJoiner
    implements Joiner {
        private static final long a = c.a(4264821031562844461L, -2664764487413163615L, MethodHandles.lookup().lookupClass()).a(277589688238294L);

        private CommentJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            long l2 = a ^ 0x10530FF143F2L;
            if (req == null) {
                CommentJoiner.a(0);
            }
            if (req.leftElem instanceof PsiComment && req.rightElem instanceof PsiComment) {
                int n2;
                int n3;
                CharSequence charSequence = req.document.getCharsSequence();
                TextRange textRange = req.rightElem.getTextRange();
                int n4 = textRange.getEndOffset();
                for (n3 = n2 = textRange.getStartOffset() + 1; n3 < n4 && " \t".indexOf(charSequence.charAt(n3)) >= 0; ++n3) {
                }
                int n5 = n3 - n2 + 1;
                String string = req.rightElem.getText().substring(n5);
                String string2 = " " + PyJoinLinesHandler.a(string, PyJoinLinesHandler.a(req, 0));
                n5 += string2.length() - 1;
                if (!string2.trim().isEmpty()) {
                    string2 = string2 + "\n";
                    req.document.insertString(req.secondLineStartOffset + n5, (CharSequence)"# ");
                }
                return new Result(string2, 0, 0, n5);
            }
            return null;
        }

        /* synthetic */ CommentJoiner(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x44C838CA2FC4L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$CommentJoiner", "join"));
        }
    }

    private static class StringLiteralJoiner
    implements Joiner {
        private static final long a = c.a(3995111106016415996L, 753106894091358849L, MethodHandles.lookup().lookupClass()).a(142207514055299L);

        private StringLiteralJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                StringLiteralJoiner.a(0);
            }
            PyStringElement pyStringElement = (PyStringElement)PsiTreeUtil.getParentOfType((PsiElement)req.leftElem, PyStringElement.class, (boolean)false);
            PyStringElement pyStringElement2 = (PyStringElement)PsiTreeUtil.getParentOfType((PsiElement)req.rightElem, PyStringElement.class, (boolean)false);
            if (pyStringElement != null && pyStringElement2 != null && pyStringElement != pyStringElement2) {
                PsiElement psiElement = pyStringElement2.getParent();
                if ((pyStringElement.getParent() == psiElement && psiElement instanceof PyStringLiteralExpression || req.leftExpr instanceof PyStringLiteralExpression && req.rightExpr instanceof PyStringLiteralExpression) && pyStringElement.isTerminated() && pyStringElement2.isTerminated() && StringLiteralJoiner.a(pyStringElement, pyStringElement2)) {
                    String string = pyStringElement.getQuote();
                    String string2 = pyStringElement2.getQuote();
                    int n2 = Math.max(string.length(), string2.length());
                    int n3 = PyJoinLinesHandler.a(req, n2);
                    String string3 = PyJoinLinesHandler.a(pyStringElement2.getContent(), n3);
                    if (string.equals(string2)) {
                        return StringLiteralJoiner.a(req, pyStringElement, pyStringElement2, string3, string);
                    }
                    return StringLiteralJoiner.a(req, pyStringElement, pyStringElement2, string3);
                }
            }
            return null;
        }

        @Nullable
        private static Result a(@NotNull Request request, @NotNull PyStringElement pyStringElement, @NotNull PyStringElement pyStringElement2, @NotNull String string) {
            if (request == null) {
                StringLiteralJoiner.a(1);
            }
            if (pyStringElement == null) {
                StringLiteralJoiner.a(2);
            }
            if (pyStringElement2 == null) {
                StringLiteralJoiner.a(3);
            }
            if (string == null) {
                StringLiteralJoiner.a(4);
            }
            if (!pyStringElement.isTripleQuoted() && !pyStringElement2.isTripleQuoted()) {
                if (!pyStringElement2.getContent().contains(pyStringElement.getQuote())) {
                    int n2 = pyStringElement2.getTextOffset() + pyStringElement2.getContentRange().getEndOffset();
                    String string2 = pyStringElement.getQuote();
                    request.document.replaceString(n2, n2 + 1, (CharSequence)string2);
                    return StringLiteralJoiner.a(request, pyStringElement, pyStringElement2, string, string2);
                }
                if (!pyStringElement.getContent().contains(pyStringElement2.getQuote())) {
                    int n3 = pyStringElement.getTextOffset() + pyStringElement.getContentRange().getStartOffset() - 1;
                    String string3 = pyStringElement2.getQuote();
                    request.document.replaceString(n3, n3 + 1, (CharSequence)string3);
                    return StringLiteralJoiner.a(request, pyStringElement, pyStringElement2, string, string3);
                }
            }
            return null;
        }

        @NotNull
        private static Result a(@NotNull Request request, @NotNull PyStringElement pyStringElement, @NotNull PyStringElement pyStringElement2, @NotNull String string, @NotNull String string2) {
            long l2 = a ^ 0x236F6E6433ACL;
            if (request == null) {
                StringLiteralJoiner.a(5);
            }
            if (pyStringElement == null) {
                StringLiteralJoiner.a(6);
            }
            if (pyStringElement2 == null) {
                StringLiteralJoiner.a(7);
            }
            if (string == null) {
                StringLiteralJoiner.a(8);
            }
            if (string2 == null) {
                StringLiteralJoiner.a(9);
            }
            int n2 = pyStringElement2.getContentRange().getStartOffset();
            String string3 = "";
            if (!string.isEmpty()) {
                n2 = string.length() + pyStringElement2.getQuote().length();
                int n3 = pyStringElement.getTextOffset() + pyStringElement.getPrefixLength() - PyJoinLinesHandler.a(request);
                int n4 = pyStringElement2.getTextOffset() + pyStringElement2.getContentRange().getStartOffset() + string.length();
                request.document.insertString(n4, (CharSequence)pyStringElement2.getQuote());
                request.document.insertString(n4, (CharSequence)StringUtil.repeat((String)" ", (int)n3));
                string3 = string2 + "\\\n";
            }
            Result result = new Result(string + string3, 0, pyStringElement.getQuote().length(), n2);
            if (result == null) {
                StringLiteralJoiner.a(10);
            }
            return result;
        }

        private static boolean a(@NotNull PyStringElement pyStringElement, @NotNull PyStringElement pyStringElement2) {
            if (pyStringElement == null) {
                StringLiteralJoiner.a(11);
            }
            if (pyStringElement2 == null) {
                StringLiteralJoiner.a(12);
            }
            return pyStringElement.isUnicode() == pyStringElement2.isUnicode() && pyStringElement.isRaw() == pyStringElement2.isRaw() && pyStringElement.isBytes() == pyStringElement2.isBytes() && pyStringElement.isFormatted() == pyStringElement2.isFormatted();
        }

        /* synthetic */ StringLiteralJoiner(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x2406B5499FC6L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 10: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "req";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftElem";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightElem";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quote";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/editor/PyJoinLinesHandler$StringLiteralJoiner";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftNodeInfo";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightNodeInfo";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/editor/PyJoinLinesHandler$StringLiteralJoiner";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultAndSplitStringIfTooLong";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processStringsWithDifferentQuotes";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getResultAndSplitStringIfTooLong";
                    break;
                }
                case 10: {
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "haveSamePrefixes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StmtJoiner
    implements Joiner {
        private static final long a = c.a(5966506290468239398L, -2299961709251985993L, MethodHandles.lookup().lookupClass()).a(49861148925475L);

        private StmtJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            PyStatement pyStatement;
            PyStatement pyStatement2;
            long l2 = a ^ 0xD7F0E7C20ECL;
            if (req == null) {
                StmtJoiner.a(0);
            }
            if ((pyStatement2 = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)req.leftExpr, PyStatement.class)) != null && (pyStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)req.rightExpr, PyStatement.class)) != null && pyStatement != pyStatement2) {
                return new Result("; ", 1);
            }
            return null;
        }

        /* synthetic */ StmtJoiner(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x73A8996E279AL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$StmtJoiner", "join"));
        }
    }

    private static class BinaryExprJoiner
    implements Joiner {
        private static final long a = c.a(1028225563525297002L, 5489094141908932244L, MethodHandles.lookup().lookupClass()).a(244071634019460L);

        private BinaryExprJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                BinaryExprJoiner.a(0);
            }
            if (req.leftExpr instanceof PyBinaryExpression || req.rightExpr instanceof PyBinaryExpression) {
                return new Result(" ", 1);
            }
            return null;
        }

        /* synthetic */ BinaryExprJoiner(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x6F7CCDBD5C0EL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$BinaryExprJoiner", "join"));
        }
    }

    private static class CloseBracketJoiner
    implements Joiner {
        private static final TokenSet a;
        private static final long b;

        private CloseBracketJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                CloseBracketJoiner.a(0);
            }
            if (a.contains(req.rightElem.getNode().getElementType())) {
                return new Result("", 0);
            }
            return null;
        }

        /* synthetic */ CloseBracketJoiner(a x0) {
            this();
        }

        static {
            b = c.a(5661379507211880909L, -4925022085164291097L, MethodHandles.lookup().lookupClass()).a(169362647429570L);
            a = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RBRACKET, PyTokenTypes.RBRACE, PyTokenTypes.RPAR});
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x6D5A3FE2A8ADL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$CloseBracketJoiner", "join"));
        }
    }

    private static class OpenBracketJoiner
    implements Joiner {
        private static final TokenSet a;
        private static final long b;

        private OpenBracketJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                OpenBracketJoiner.a(0);
            }
            if (a.contains(req.leftElem.getNode().getElementType())) {
                return new Result("", 0);
            }
            return null;
        }

        /* synthetic */ OpenBracketJoiner(a x0) {
            this();
        }

        static {
            b = c.a(-4841945556880812899L, -112240307721255156L, MethodHandles.lookup().lookupClass()).a(126309764720373L);
            a = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LBRACKET, PyTokenTypes.LBRACE, PyTokenTypes.LPAR});
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x39CD26708154L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$OpenBracketJoiner", "join"));
        }
    }

    private static interface Joiner {
        @Nullable
        public Result join(@NotNull Request var1);
    }

    private static class Request {
        final Document document;
        final PsiElement leftElem;
        final PsiElement rightElem;
        final PyExpression leftExpr;
        final PyExpression rightExpr;
        final int secondLineStartOffset;
        final int firstLineEndOffset;
        private static final long a = c.a(6596995424425272204L, -8037985758420921229L, MethodHandles.lookup().lookupClass()).a(157266109201744L);

        private Request(@NotNull Document document, int firstLineEndOffset, int secondLineStartOffset, @NotNull PsiElement leftElem, @Nullable PyExpression leftExpr, @NotNull PsiElement rightElem, @Nullable PyExpression rightExpr) {
            if (document == null) {
                Request.a(0);
            }
            if (leftElem == null) {
                Request.a(1);
            }
            if (rightElem == null) {
                Request.a(2);
            }
            this.document = document;
            this.firstLineEndOffset = firstLineEndOffset;
            this.secondLineStartOffset = secondLineStartOffset;
            this.leftElem = leftElem;
            this.rightElem = rightElem;
            this.leftExpr = leftExpr;
            this.rightExpr = rightExpr;
        }

        /* synthetic */ Request(Document x0, int x1, int x2, PsiElement x3, PyExpression x4, PsiElement x5, PyExpression x6, a x7) {
            this(x0, x1, x2, x3, x4, x5, x6);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x75797DE15D28L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftElem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rightElem";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/editor/PyJoinLinesHandler$Request";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Result {
        final String replacement;
        final int caretOffset;
        final int cutFromLeft;
        final int cutIntoRight;
        private static final long a = c.a(6212453114690745277L, 710032738146623635L, MethodHandles.lookup().lookupClass()).a(74519428636347L);

        Result(@NotNull String replacement, int cursorOffset) {
            if (replacement == null) {
                Result.a(0);
            }
            this(replacement, cursorOffset, 0, 0);
        }

        Result(@NotNull String replacement, int cursorOffset, int cutFromLeft, int cutIntoRight) {
            if (replacement == null) {
                Result.a(1);
            }
            this.cutFromLeft = cutFromLeft;
            this.cutIntoRight = cutIntoRight;
            this.replacement = replacement;
            this.caretOffset = cursorOffset;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x3DCB0EFC1986L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/jetbrains/python/editor/PyJoinLinesHandler$Result", "<init>"));
        }
    }
}

