/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import com.jetbrains.python.sdk.pipenv.UsePipEnvQuickFix;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInterpreterInspection
extends PyInspection {
    private static final long a = c.a(-5013429177166343884L, 4282209883301441987L, MethodHandles.lookup().lookupClass()).a(7341096643056L);

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = a ^ 0x263D3550353AL;
        String string = PyBundle.message("INSP.NAME.invalid.interpreter", new Object[0]);
        if (string == null) {
            PyInterpreterInspection.b(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyInterpreterInspection.b(1);
        }
        if (session == null) {
            PyInterpreterInspection.b(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyInterpreterInspection.b(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0xB1E9371403FL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ConfigureInterpreterFix
    implements LocalQuickFix {
        private static final long a = c.a(-3154260608432512425L, 5550047946265067919L, MethodHandles.lookup().lookupClass()).a(191357491834226L);

        @NotNull
        public String getFamilyName() {
            long l2 = a ^ 0x3DE3E95663ECL;
            if ("Configure Python interpreter" == null) {
                ConfigureInterpreterFix.a(0);
            }
            return "Configure Python interpreter";
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                ConfigureInterpreterFix.a(1);
            }
            if (descriptor2 == null) {
                ConfigureInterpreterFix.a(2);
            }
            ConfigureInterpreterFix.showProjectInterpreterDialog(project);
        }

        public static void showProjectInterpreterDialog(@NotNull Project project) {
            long l2 = a ^ 0xD58769C6E1AL;
            if (project == null) {
                ConfigureInterpreterFix.a(3);
            }
            ShowSettingsUtil.getInstance().showSettingsDialog(project, "Project Interpreter");
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x5B4A5EEB875L;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "showProjectInterpreterDialog";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private static final long c = com.jetbrains.python.psi.c.a(-4918838458803275425L, -5360473382794250013L, MethodHandles.lookup().lookupClass()).a(20378777753820L);

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.b(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyFile(PyFile node) {
            String string;
            long l2 = c ^ 0x3F9701AF7A60L;
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
            if (module2 == null) {
                return;
            }
            Sdk sdk = PythonSdkType.findPythonSdk(module2);
            boolean bl2 = PlatformUtils.isPyCharm();
            String string2 = bl2 ? "project" : "module";
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (UsePipEnvQuickFix.Companion.isApplicable(module2)) {
                arrayList.add(new UsePipEnvQuickFix(sdk, module2));
            }
            if (bl2) {
                arrayList.add(new ConfigureInterpreterFix());
            }
            String string3 = string = bl2 ? "PyCharm" : "Python plugin";
            if (sdk == null) {
                this.registerProblem((PsiElement)node, "No Python interpreter configured for the " + string2, arrayList.toArray(LocalQuickFix.EMPTY_ARRAY));
            } else {
                String string4;
                Module module3 = PySdkExtKt.getAssociatedModule(sdk);
                String string5 = string4 = module3 != null ? module3.getName() : PySdkExtKt.getAssociatedModulePath(sdk);
                if (PipenvKt.isPipEnv(sdk) && module3 != module2) {
                    String string6 = string4 != null ? "Pipenv interpreter is associated with another " + string2 + ": '" + string4 + "'" : "Pipenv interpreter is not associated with any " + string2;
                    this.registerProblem((PsiElement)node, string6, arrayList.toArray(LocalQuickFix.EMPTY_ARRAY));
                } else if (PythonSdkType.isInvalid(sdk)) {
                    this.registerProblem((PsiElement)node, "Invalid Python interpreter selected for the " + string2, arrayList.toArray(LocalQuickFix.EMPTY_ARRAY));
                } else {
                    LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
                    if (!LanguageLevel.SUPPORTED_LEVELS.contains((Object)languageLevel)) {
                        this.registerProblem((PsiElement)node, "Python " + (Object)((Object)languageLevel) + " has reached its end-of-life date and it is no longer supported in " + string + ".", arrayList.toArray(LocalQuickFix.EMPTY_ARRAY));
                    }
                }
            }
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = c ^ 0x4EAF3E550A63L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyInterpreterInspection$Visitor", "<init>"));
        }
    }
}

