/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.intentions.PyAnnotateTypesIntention;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.quickfix.PyQuickFixUtil;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyMissingTypeHintsInspection
extends PyInspection {
    public boolean m_onlyWhenTypesAreKnown = true;
    private static final long a = c.a(3845447991438158358L, -5386281190489092162L, MethodHandles.lookup().lookupClass()).a(86085547660670L);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMissingTypeHintsInspection.b(0);
        }
        if (session == null) {
            PyMissingTypeHintsInspection.b(1);
        }
        PyElementVisitor pyElementVisitor = new PyElementVisitor(){
            private static final long a = c.a(8888829718651802236L, -4227356253209016793L, MethodHandles.lookup().lookupClass()).a(129043741066036L);

            @Override
            public void visitPyFunction(PyFunction function) {
                ASTNode aSTNode;
                boolean bl2;
                long l2 = a ^ 0x38DAECD71AF4L;
                if (function.getTypeComment() == null && !PyMissingTypeHintsInspection.a(function) && (bl2 = PyMissingTypeHintsInspection.this.b(function)) && (aSTNode = function.getNameNode()) != null) {
                    holder.registerProblem(aSTNode.getPsi(), "Type hinting is missing for function definition", new LocalQuickFix[]{new AddTypeHintsQuickFix(function.getName())});
                }
            }
        };
        if (pyElementVisitor == null) {
            PyMissingTypeHintsInspection.b(2);
        }
        return pyElementVisitor;
    }

    private boolean b(PyFunction pyFunction) {
        if (this.m_onlyWhenTypesAreKnown) {
            PySignature pySignature = PySignatureCacheManager.getInstance(pyFunction.getProject()).findSignature(pyFunction);
            return pySignature != null && PyMissingTypeHintsInspection.a(pySignature);
        }
        return true;
    }

    private static boolean a(@NotNull PySignature pySignature) {
        long l2 = a ^ 0x1CD557B3412L;
        if (pySignature == null) {
            PyMissingTypeHintsInspection.b(3);
        }
        return !"NoneType".equals(pySignature.getReturnTypeQualifiedName()) || pySignature.getArgs().size() > 1 || pySignature.getArgs().size() == 1 && !"self".equals(((PySignature.NamedParameter)pySignature.getArgs().get(0)).getName());
    }

    private static boolean a(PyFunction pyFunction) {
        for (PyParameter pyParameter : pyFunction.getParameterList().getParameters()) {
            PyNamedParameter pyNamedParameter = pyParameter.getAsNamed();
            if (pyNamedParameter == null || pyNamedParameter.getAnnotation() == null) continue;
            return true;
        }
        return pyFunction.getAnnotation() != null;
    }

    public JComponent createOptionsPanel() {
        long l2 = a ^ 0x23572B295B07L;
        return new SingleCheckboxOptionsPanel("Only when types are known(collected from run-time or inferred)", (InspectionProfileEntry)this, "m_onlyWhenTypesAreKnown");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x3536D94D0964L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMissingTypeHintsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMissingTypeHintsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canAnnotate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddTypeHintsQuickFix
    implements LocalQuickFix {
        private final String a;
        private static final long b = c.a(8318705768960271442L, -3020173540628113958L, MethodHandles.lookup().lookupClass()).a(173748314451517L);

        AddTypeHintsQuickFix(@NotNull String name) {
            if (name == null) {
                AddTypeHintsQuickFix.a(0);
            }
            this.a = name;
        }

        @Nls
        @NotNull
        public String getName() {
            long l2 = b ^ 0x6584014497F4L;
            String string = "Add type hints for '" + this.a + "'";
            if (string == null) {
                AddTypeHintsQuickFix.a(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            long l2 = b ^ 0x1B7638F9036CL;
            if ("Add type hints" == null) {
                AddTypeHintsQuickFix.a(2);
            }
            return "Add type hints";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PyFunction pyFunction;
            if (project == null) {
                AddTypeHintsQuickFix.a(3);
            }
            if (descriptor2 == null) {
                AddTypeHintsQuickFix.a(4);
            }
            if ((pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), PyFunction.class)) != null) {
                PyAnnotateTypesIntention.annotateTypes(PyQuickFixUtil.getEditor(pyFunction), pyFunction);
            }
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = b ^ 0x1620F025739FL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyMissingTypeHintsInspection$AddTypeHintsQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyMissingTypeHintsInspection$AddTypeHintsQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

