/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PySubstitutionChunkReference;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.inspections.quickfix.PyAddSpecifierToFormatQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PySliceItem;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedRatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringFormatInspection
extends PyInspection {
    private static final long a = c.a(5157130606669512683L, -3795346425657032785L, MethodHandles.lookup().lookupClass()).a(200843769364719L);

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = a ^ 0x606CA460B97AL;
        String string = PyBundle.message("INSP.NAME.str.format", new Object[0]);
        if (string == null) {
            PyStringFormatInspection.b(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyStringFormatInspection.b(1);
        }
        if (session == null) {
            PyStringFormatInspection.b(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyStringFormatInspection.b(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x3201859DF1D7L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyStringFormatInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyStringFormatInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private static final long c = com.jetbrains.python.psi.c.a(4541952823945689226L, -9115185107199552352L, MethodHandles.lookup().lookupClass()).a(29905841973389L);

        static int inspectCallExpression(@NotNull PyCallExpression callExpression, @NotNull PyResolveContext resolveContext, @NotNull TypeEvalContext evalContext) {
            IntSummaryStatistics intSummaryStatistics;
            if (callExpression == null) {
                Visitor.b(0);
            }
            if (resolveContext == null) {
                Visitor.b(1);
            }
            if (evalContext == null) {
                Visitor.b(2);
            }
            if ((intSummaryStatistics = callExpression.multiResolveCalleeFunction(resolveContext).stream().map(pyCallable -> pyCallable.getCallType(evalContext, callExpression)).collect(Collectors.summarizingInt(pyType -> {
                if (pyType instanceof PyNoneType) {
                    return 1;
                }
                if (pyType instanceof PyClassType) {
                    return Visitor.a(evalContext, (PyClassType)pyType);
                }
                if (pyType instanceof PyUnionType) {
                    int n2 = 1;
                    boolean bl2 = true;
                    for (PyType pyType2 : ((PyUnionType)pyType).getMembers()) {
                        PyClassType pyClassType = PyUtil.as(pyType2, PyClassType.class);
                        if (pyClassType != null) {
                            int n3 = Visitor.a(evalContext, pyClassType);
                            bl2 = bl2 && n3 != -1;
                            n2 = Math.max(n2, n3);
                            continue;
                        }
                        bl2 = false;
                    }
                    return bl2 ? n2 : -1;
                }
                return -1;
            }))).getMin() == intSummaryStatistics.getMax()) {
                return intSummaryStatistics.getMin();
            }
            return -1;
        }

        private static int a(@NotNull TypeEvalContext typeEvalContext, PyClassType pyClassType) {
            long l2 = c ^ 0x764AA47C3018L;
            if (typeEvalContext == null) {
                Visitor.b(3);
            }
            if (!pyClassType.getPyClass().isSubclass("tuple", typeEvalContext)) {
                return 1;
            }
            if (pyClassType instanceof PyTupleType) {
                return ((PyTupleType)pyClassType).getElementCount();
            }
            return -1;
        }

        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            if (node.getLeftExpression() instanceof PyStringLiteralExpression && node.isOperator("%")) {
                Inspection inspection = new Inspection(this, this.myTypeEvalContext);
                PyStringLiteralExpression pyStringLiteralExpression = (PyStringLiteralExpression)node.getLeftExpression();
                inspection.a(pyStringLiteralExpression);
                if (inspection.isProblem()) {
                    return;
                }
                inspection.a(node.getRightExpression());
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyStringLiteralExpression pyStringLiteralExpression;
            long l2 = c ^ 0x5374823AA160L;
            PyExpression pyExpression = node.getCallee();
            if (pyExpression != null && pyExpression.getName() != null && pyExpression.getName().equals("format") && (pyStringLiteralExpression = (PyStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)pyExpression, PyStringLiteralExpression.class)) != null) {
                NewStyleInspection newStyleInspection = new NewStyleInspection(pyStringLiteralExpression, this, this.myTypeEvalContext);
                newStyleInspection.inspect();
            }
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x2DA075DB1DDEL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveContext";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evalContext";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inspectCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countElements";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class NewStyleInspection {
            private static final List<String> a;
            private static final List<String> f;
            private static final ImmutableMap<Character, String> e;
            private final PyStringLiteralExpression d;
            private boolean g = false;
            private final Visitor h;
            private final TypeEvalContext b;
            private final Map<String, String> c = new HashMap<String, String>();
            private static final long i;

            NewStyleInspection(PyStringLiteralExpression formatExpression, Visitor visitor2, TypeEvalContext context) {
                this.d = formatExpression;
                this.h = visitor2;
                this.b = context;
            }

            public void inspect() {
                long l2 = i ^ 0x6AE63F3C3C84L;
                String string = this.d.getText();
                PyStringFormatParser pyStringFormatParser = new PyStringFormatParser(string);
                List list2 = ContainerUtil.findAll(pyStringFormatParser.parseNewStyle(), PyStringFormatParser.NewStyleSubstitutionChunk.class);
                for (int i10 = 0; i10 < list2.size(); ++i10) {
                    PyStringFormatParser.NewStyleSubstitutionChunk newStyleSubstitutionChunk = i10 > 0 ? (PyStringFormatParser.NewStyleSubstitutionChunk)list2.get(i10 - 1) : null;
                    PyStringFormatParser.NewStyleSubstitutionChunk newStyleSubstitutionChunk2 = (PyStringFormatParser.NewStyleSubstitutionChunk)list2.get(i10);
                    if (newStyleSubstitutionChunk != null) {
                        if (newStyleSubstitutionChunk.getManualPosition() != null && newStyleSubstitutionChunk2.getAutoPosition() != null) {
                            this.a(this.d, PyBundle.message("INSP.manual.to.auto.field.numbering", new Object[0]));
                        } else if (newStyleSubstitutionChunk.getAutoPosition() != null && newStyleSubstitutionChunk2.getManualPosition() != null) {
                            this.a(this.d, PyBundle.message("INSP.auto.to.manual.field.numbering", new Object[0]));
                        }
                    }
                    String string2 = this.a(newStyleSubstitutionChunk2);
                    if (this.isProblem()) continue;
                    this.a(newStyleSubstitutionChunk2, string2);
                }
            }

            private String a(@NotNull PyStringFormatParser.NewStyleSubstitutionChunk newStyleSubstitutionChunk) {
                char c10;
                String string;
                long l2 = i ^ 0x7B028552A2EL;
                if (newStyleSubstitutionChunk == null) {
                    NewStyleInspection.a(0);
                }
                HashSet<String> hashSet = new HashSet<String>();
                boolean bl2 = false;
                String string2 = string = newStyleSubstitutionChunk.getMappingKey() != null ? newStyleSubstitutionChunk.getMappingKey() : String.valueOf(newStyleSubstitutionChunk.getPosition());
                if (newStyleSubstitutionChunk.hasSignOption() || newStyleSubstitutionChunk.useAlternateForm() || newStyleSubstitutionChunk.hasZeroPadding() || newStyleSubstitutionChunk.hasThousandsSeparator()) {
                    NewStyleInspection.a(hashSet, f);
                    bl2 = true;
                }
                if (newStyleSubstitutionChunk.getPrecision() != null) {
                    List<String> list2 = Arrays.asList("str", "float", "complex");
                    NewStyleInspection.a(hashSet, list2);
                    bl2 = true;
                }
                if ((c10 = newStyleSubstitutionChunk.getConversionType()) != '\u0000') {
                    if (e.containsKey((Object)Character.valueOf(c10))) {
                        String[] stringArray = ((String)e.get((Object)Character.valueOf(c10))).split(" or ");
                        NewStyleInspection.a(hashSet, Arrays.asList(stringArray));
                        bl2 = true;
                    } else {
                        this.a(this.d, PyBundle.message("INSP.unsupported.format.character", Character.valueOf(c10)));
                    }
                }
                if (!hashSet.isEmpty()) {
                    this.c.put(string, StringUtil.join(hashSet, (String)" or "));
                } else if (bl2) {
                    this.a(this.d, PyBundle.message("INSP.incompatible.options", string));
                }
                return string;
            }

            private void a(@NotNull PyStringFormatParser.NewStyleSubstitutionChunk newStyleSubstitutionChunk, @NotNull String string) {
                boolean bl2;
                long l2 = i ^ 0x2C29FB972DDDL;
                if (newStyleSubstitutionChunk == null) {
                    NewStyleInspection.a(1);
                }
                if (string == null) {
                    NewStyleInspection.a(2);
                }
                PsiElement psiElement = new PySubstitutionChunkReference(this.d, newStyleSubstitutionChunk).resolve();
                boolean bl3 = bl2 = newStyleSubstitutionChunk.getMappingKeyElementIndex() != null;
                if (psiElement == null) {
                    String string2 = newStyleSubstitutionChunk.getMappingKey();
                    if (string2 != null) {
                        this.a(this.d, bl2 ? PyBundle.message("INSP.too.few.args.for.fmt.string", new Object[0]) : PyBundle.message("INSP.key.$0.has.no.arg", string2));
                    } else {
                        this.a(this.d, PyBundle.message("INSP.too.few.args.for.fmt.string", new Object[0]));
                    }
                } else {
                    this.a(this.d, psiElement, string);
                }
            }

            private void a(@NotNull PsiElement psiElement, @NotNull String string) {
                if (psiElement == null) {
                    NewStyleInspection.a(3);
                }
                if (string == null) {
                    NewStyleInspection.a(4);
                }
                this.g = true;
                this.h.registerProblem(psiElement, string);
            }

            private void a(@NotNull PyStringLiteralExpression pyStringLiteralExpression, @NotNull PsiElement psiElement, @NotNull String string) {
                PyTypedElement pyTypedElement;
                long l2 = i ^ 0x24875FDC9193L;
                if (pyStringLiteralExpression == null) {
                    NewStyleInspection.a(5);
                }
                if (psiElement == null) {
                    NewStyleInspection.a(6);
                }
                if (string == null) {
                    NewStyleInspection.a(7);
                }
                if ((pyTypedElement = PyUtil.as(psiElement, PyTypedElement.class)) != null && this.c.containsKey(string)) {
                    PyType pyType = this.b.getType(pyTypedElement);
                    PyType pyType2 = PyTypeParser.getTypeByName(pyStringLiteralExpression, this.c.get(string));
                    if (pyType2 != null && pyType != null && a.contains(pyType.getName()) && !PyTypeChecker.match(pyType2, pyType, this.b)) {
                        this.a((PsiElement)pyTypedElement, PyBundle.message("INSP.unexpected.type.$0", pyType.getName()));
                    }
                }
            }

            private static void a(@NotNull Set<String> set, @NotNull List<String> list2) {
                if (set == null) {
                    NewStyleInspection.a(8);
                }
                if (list2 == null) {
                    NewStyleInspection.a(9);
                }
                if (set.isEmpty()) {
                    set.addAll(list2);
                } else {
                    set.retainAll(list2);
                }
            }

            public boolean isProblem() {
                return this.g;
            }

            static {
                i = com.jetbrains.python.psi.c.a(8441848837502664135L, -9061590257903644636L, MethodHandles.lookup().lookupClass()).a(204080301915321L);
                long l2 = i ^ 0x29C2EAF4116BL;
                a = Arrays.asList("str", "int", "long", "float", "complex", "None");
                f = Arrays.asList("int", "long", "float", "complex");
                e = ImmutableMap.builder().put((Object)Character.valueOf('s'), (Object)"str or None").put((Object)Character.valueOf('b'), (Object)"int").put((Object)Character.valueOf('c'), (Object)"int").put((Object)Character.valueOf('d'), (Object)"int").put((Object)Character.valueOf('o'), (Object)"int").put((Object)Character.valueOf('x'), (Object)"int").put((Object)Character.valueOf('X'), (Object)"int").put((Object)Character.valueOf('n'), (Object)"int or long or float or complex").put((Object)Character.valueOf('e'), (Object)"long or float or complex").put((Object)Character.valueOf('E'), (Object)"long or float or complex").put((Object)Character.valueOf('f'), (Object)"long or float or complex").put((Object)Character.valueOf('F'), (Object)"long or float or complex").put((Object)Character.valueOf('g'), (Object)"long or float or complex").put((Object)Character.valueOf('G'), (Object)"long or float or complex").put((Object)Character.valueOf('%'), (Object)"long or float").build();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = i ^ 0x1A3DFAC68E0AL;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chunk";
                        break;
                    }
                    case 2: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mappingKey";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "problemTarget";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "anchor";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "types";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "supportedTypes";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$NewStyleInspection";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectNewStyleChunkAndGetMappingKey";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectArguments";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblem";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTypesCompatibleForCheckedTypesOnly";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "specifyTypes";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class Inspection {
            private static final ImmutableMap<Character, String> g;
            private final Map<String, Boolean> b = new HashMap<String, Boolean>();
            private int e = 0;
            private boolean a = false;
            private final Visitor c;
            private final TypeEvalContext f;
            private final Map<String, String> d = new LinkedHashMap<String, String>();
            private static final long h;

            Inspection(Visitor visitor2, TypeEvalContext typeEvalContext) {
                this.c = visitor2;
                this.f = typeEvalContext;
            }

            private int a(@Nullable PyExpression pyExpression, @NotNull PsiElement psiElement) {
                long l2 = h ^ 0x6DDAA2B3D96DL;
                if (psiElement == null) {
                    Inspection.a(0);
                }
                Class[] classArray = new Class[]{PyLiteralExpression.class, PySubscriptionExpression.class, PyBinaryExpression.class, PyConditionalExpression.class};
                PyBuiltinCache pyBuiltinCache = PyBuiltinCache.getInstance(psiElement);
                PyResolveContext pyResolveContext = PyResolveContext.noImplicits().withTypeEvalContext(this.f);
                String string = this.d.get("1");
                if (PsiTreeUtil.instanceOf((Object)pyExpression, (Class[])classArray)) {
                    if (string != null) {
                        PyType pyType = this.f.getType(pyExpression);
                        if (pyType instanceof PyTupleType) {
                            PyTupleType pyTupleType = (PyTupleType)pyType;
                            this.a(psiElement, pyTupleType);
                            return pyTupleType.getElementCount();
                        }
                        this.a(pyExpression, string, psiElement);
                    }
                    return 1;
                }
                if (pyExpression instanceof PyReferenceExpression) {
                    if ("__dict__".equals(pyExpression.getName())) {
                        return -1;
                    }
                    List<QualifiedRatedResolveResult> list2 = ((PyReferenceExpression)pyExpression).multiFollowAssignmentsChain(pyResolveContext);
                    if (list2.isEmpty()) {
                        return -1;
                    }
                    PsiElement psiElement2 = PyUtil.filterTopPriorityResults(list2).get(0).getElement();
                    if (psiElement2 == pyExpression || !(psiElement2 instanceof PyExpression)) {
                        return -1;
                    }
                    if (psiElement2 instanceof PyDictLiteralExpression) {
                        return this.a(pyExpression, psiElement, true);
                    }
                    return this.a((PyExpression)psiElement2, psiElement);
                }
                if (pyExpression instanceof PyCallExpression) {
                    PyExpression pyExpression2 = ((PyCallExpression)pyExpression).getCallee();
                    if (pyExpression2 != null && "dict".equals(pyExpression2.getName())) {
                        return 1;
                    }
                    return Visitor.inspectCallExpression((PyCallExpression)pyExpression, pyResolveContext, this.f);
                }
                if (pyExpression instanceof PyParenthesizedExpression) {
                    PyExpression pyExpression3 = ((PyParenthesizedExpression)pyExpression).getContainedExpression();
                    if (pyExpression3 != null) {
                        return this.a(pyExpression3, psiElement);
                    }
                } else {
                    if (pyExpression instanceof PyTupleExpression) {
                        if (PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)pyExpression, (boolean)false)) {
                            PyExpression[] pyExpressionArray = ((PyTupleExpression)pyExpression).getElements();
                            int n2 = 1;
                            for (PyExpression pyExpression4 : pyExpressionArray) {
                                String string2 = this.d.get(Integer.toString(n2));
                                if (string2 != null) {
                                    this.a(pyExpression4, string2, (PsiElement)pyExpression4);
                                }
                                ++n2;
                            }
                            return pyExpressionArray.length;
                        }
                        PyTupleType pyTupleType = (PyTupleType)this.f.getType(pyExpression);
                        assert (pyTupleType != null);
                        this.a(psiElement, pyTupleType);
                        return pyTupleType.getElementCount();
                    }
                    if (pyExpression instanceof PyDictLiteralExpression) {
                        return this.a(pyExpression, psiElement, false);
                    }
                    if (PsiTreeUtil.instanceOf((Object)pyExpression, (Class[])new Class[]{PySequenceExpression.class, PyComprehensionElement.class})) {
                        if (string != null) {
                            this.a(psiElement, pyBuiltinCache.getStrType(), PyTypeParser.getTypeByName(psiElement, string, this.f));
                            return 1;
                        }
                    } else if (pyExpression instanceof PySliceExpression && string != null) {
                        PyType pyType = this.f.getType(((PySliceExpression)pyExpression).getOperand());
                        PyType pyType2 = PyBuiltinCache.getInstance((PsiElement)pyExpression).getStringType(LanguageLevel.forElement((PsiElement)pyExpression));
                        PyClassType pyClassType = PyBuiltinCache.getInstance((PsiElement)pyExpression).getListType();
                        if (pyType == null) {
                            return -1;
                        }
                        if (PyTypeChecker.match(pyClassType, pyType, this.f) || PyTypeChecker.match(pyType2, pyType, this.f)) {
                            this.a(psiElement, pyBuiltinCache.getStrType(), PyTypeParser.getTypeByName(psiElement, string, this.f));
                            return 1;
                        }
                        PySliceItem pySliceItem = ((PySliceExpression)pyExpression).getSliceItem();
                        if (pySliceItem != null) {
                            PyExpression pyExpression5 = pySliceItem.getLowerBound();
                            PyExpression pyExpression6 = pySliceItem.getUpperBound();
                            PyExpression pyExpression7 = pySliceItem.getStride();
                            if (pyExpression6 instanceof PyNumericLiteralExpression) {
                                BigInteger bigInteger = pyExpression5 instanceof PyNumericLiteralExpression ? ((PyNumericLiteralExpression)pyExpression5).getBigIntegerValue() : BigInteger.ZERO;
                                int n3 = ((PyNumericLiteralExpression)pyExpression6).getBigIntegerValue().subtract(bigInteger).intValue();
                                int n4 = pyExpression7 instanceof PyNumericLiteralExpression ? ((PyNumericLiteralExpression)pyExpression7).getBigIntegerValue().intValue() : 1;
                                int n5 = n3 / n4;
                                int n6 = n3 % n4 == 0 ? 0 : 1;
                                return n5 + n6;
                            }
                        }
                        return -1;
                    }
                }
                return -1;
            }

            private void a(@NotNull PsiElement psiElement, PyTupleType pyTupleType) {
                if (psiElement == null) {
                    Inspection.a(1);
                }
                List list2 = ContainerUtil.map(this.d.values(), string -> {
                    if (string == null) {
                        return null;
                    }
                    PyBuiltinCache pyBuiltinCache = PyBuiltinCache.getInstance(psiElement);
                    PyType pyType = PyTypeParser.getTypeByName(psiElement, string, this.f);
                    if (pyType == pyBuiltinCache.getStrType()) {
                        return null;
                    }
                    return pyType;
                });
                PyTupleType pyTupleType2 = PyTupleType.create(psiElement, list2);
                this.a(psiElement, pyTupleType, pyTupleType2);
            }

            private static Map<PyExpression, PyExpression> a(PsiFile psiFile, String string) {
                HashMap<PyExpression, PyExpression> hashMap = new HashMap<PyExpression, PyExpression>();
                Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)psiFile, PySubscriptionExpression.class);
                for (PySubscriptionExpression pySubscriptionExpression : collection) {
                    PyExpression pyExpression;
                    PsiElement psiElement;
                    if (!pySubscriptionExpression.getOperand().getText().equals(string) || !((psiElement = pySubscriptionExpression.getParent()) instanceof PyAssignmentStatement) || !pySubscriptionExpression.equals(((PyAssignmentStatement)psiElement).getLeftHandSideExpression()) || (pyExpression = pySubscriptionExpression.getIndexExpression()) == null) continue;
                    hashMap.put(pyExpression, ((PyAssignmentStatement)psiElement).getAssignedValue());
                }
                return hashMap;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private int a(PyExpression pyExpression, PsiElement psiElement, boolean bl2) {
                PyExpression pyExpression2;
                Map<Object, Object> map2;
                long l2 = h ^ 0x18AD9564B11DL;
                if (bl2) {
                    map2 = Inspection.a(pyExpression.getContainingFile(), pyExpression.getText());
                    pyExpression2 = ((PyReferenceExpression)pyExpression).followAssignmentsChain(PyResolveContext.noImplicits().withTypeEvalContext(this.f)).getElement();
                } else {
                    map2 = new HashMap();
                    pyExpression2 = pyExpression;
                }
                if (pyExpression2 == null) {
                    return 0;
                }
                PyKeyValueExpression[] pyKeyValueExpressionArray = ((PyDictLiteralExpression)pyExpression2).getElements();
                if (this.b.isEmpty()) {
                    if (this.e <= 0) return 0;
                    if (this.e <= 1 || this.e != pyKeyValueExpressionArray.length + map2.size()) return 1;
                    this.a((PsiElement)pyExpression, PyBundle.message("INSP.format.requires.no.mapping", new Object[0]));
                }
                int n2 = 0;
                for (PyKeyValueExpression pyKeyValueExpression : pyKeyValueExpressionArray) {
                    PyExpression pyExpression3 = pyKeyValueExpression.getKey();
                    PyExpression pyExpression4 = pyKeyValueExpression.getValue();
                    if (pyExpression3 instanceof PyStringLiteralExpression) {
                        this.a(psiElement, (PyStringLiteralExpression)pyExpression3, pyExpression4);
                        continue;
                    }
                    if (!(pyExpression3 instanceof PyReferenceExpression)) continue;
                    ++n2;
                }
                for (Map.Entry entry : map2.entrySet()) {
                    PyExpression pyExpression5 = (PyExpression)entry.getKey();
                    PyExpression pyExpression6 = (PyExpression)entry.getValue();
                    if (pyExpression5 instanceof PyStringLiteralExpression) {
                        this.a(psiElement, (PyStringLiteralExpression)pyExpression5, pyExpression6);
                        continue;
                    }
                    if (!(pyExpression5 instanceof PyReferenceExpression)) continue;
                    ++n2;
                }
                int n3 = 0;
                for (String string : this.b.keySet()) {
                    if (this.b.get(string).booleanValue() || ++n3 <= n2) continue;
                    this.a(psiElement, PyBundle.message("INSP.key.$0.has.no.arg", string));
                    return pyKeyValueExpressionArray.length + map2.size();
                }
                return pyKeyValueExpressionArray.length + map2.size();
            }

            private void a(PsiElement psiElement, PyStringLiteralExpression pyStringLiteralExpression, PyExpression pyExpression) {
                String string = pyStringLiteralExpression.getStringValue();
                if (this.b.get(string) != null) {
                    this.b.put(string, true);
                    if (pyExpression != null) {
                        this.a(pyExpression, this.d.get(string), psiElement);
                    }
                }
            }

            private void a(@NotNull PsiElement psiElement, @NotNull String string, @NotNull LocalQuickFix localQuickFix) {
                if (psiElement == null) {
                    Inspection.a(2);
                }
                if (string == null) {
                    Inspection.a(3);
                }
                if (localQuickFix == null) {
                    Inspection.a(4);
                }
                this.a = true;
                this.c.registerProblem(psiElement, string, localQuickFix);
            }

            private void a(@NotNull PsiElement psiElement, @NotNull String string) {
                if (psiElement == null) {
                    Inspection.a(5);
                }
                if (string == null) {
                    Inspection.a(6);
                }
                this.a = true;
                this.c.registerProblem(psiElement, string);
            }

            private void a(@NotNull PyExpression pyExpression, @NotNull String string, @NotNull PsiElement psiElement) {
                if (pyExpression == null) {
                    Inspection.a(7);
                }
                if (string == null) {
                    Inspection.a(8);
                }
                if (psiElement == null) {
                    Inspection.a(9);
                }
                PyType pyType = this.f.getType(pyExpression);
                PyType pyType2 = PyTypeParser.getTypeByName(psiElement, string, this.f);
                if (pyType != null) {
                    this.a(psiElement, pyType, pyType2);
                }
            }

            private void a(@NotNull PsiElement psiElement, @Nullable PyType pyType, @Nullable PyType pyType2) {
                long l2 = h ^ 0x6BE0D35664D9L;
                if (psiElement == null) {
                    Inspection.a(10);
                }
                if (pyType2 != null && "str".equals(pyType2.getName())) {
                    return;
                }
                if (pyType != null && !PyTypeChecker.match(pyType2, pyType, this.f)) {
                    this.a(psiElement, PyBundle.message("INSP.unexpected.type.$0", pyType.getName()));
                }
            }

            private void a(@NotNull PyStringLiteralExpression pyStringLiteralExpression) {
                long l2 = h ^ 0x465A052D8ED9L;
                if (pyStringLiteralExpression == null) {
                    Inspection.a(11);
                }
                String string = pyStringLiteralExpression.getText();
                List<PyStringFormatParser.SubstitutionChunk> list2 = PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(string));
                this.e = list2.size();
                this.b.clear();
                boolean bl2 = list2.size() > 0 && list2.get(0).getMappingKey() != null;
                for (int i10 = 0; i10 < list2.size(); ++i10) {
                    LanguageLevel languageLevel;
                    PyStringFormatParser.PercentSubstitutionChunk percentSubstitutionChunk = PyUtil.as(list2.get(i10), PyStringFormatParser.PercentSubstitutionChunk.class);
                    if (percentSubstitutionChunk == null) continue;
                    String string2 = Integer.toString(i10 + 1);
                    if (bl2) {
                        if (percentSubstitutionChunk.getMappingKey() == null || percentSubstitutionChunk.isUnclosedMapping()) {
                            this.a((PsiElement)pyStringLiteralExpression, PyBundle.message("INSP.too.few.keys", new Object[0]));
                            break;
                        }
                        string2 = percentSubstitutionChunk.getMappingKey();
                        this.b.put(string2, false);
                    }
                    this.a(pyStringLiteralExpression, percentSubstitutionChunk.getWidth());
                    this.a(pyStringLiteralExpression, percentSubstitutionChunk.getPrecision());
                    char c10 = percentSubstitutionChunk.getConversionType();
                    if (c10 == 'b' && ((languageLevel = LanguageLevel.forElement(pyStringLiteralExpression)).isOlderThan(LanguageLevel.PYTHON35) || !Inspection.a(pyStringLiteralExpression, this.f))) {
                        this.a((PsiElement)pyStringLiteralExpression, "Unsupported format character 'b'");
                        return;
                    }
                    languageLevel = LanguageLevel.forElement(pyStringLiteralExpression);
                    if (g.containsKey((Object)Character.valueOf(c10)) && (!languageLevel.isPython2() || c10 != 'a')) {
                        this.d.put(string2, (String)g.get((Object)Character.valueOf(c10)));
                        continue;
                    }
                    this.a((PsiElement)pyStringLiteralExpression, PyBundle.message("INSP.no.format.specifier.char", new Object[0]), new PyAddSpecifierToFormatQuickFix());
                    return;
                }
            }

            private static boolean a(@NotNull PyStringLiteralExpression pyStringLiteralExpression, @NotNull TypeEvalContext typeEvalContext) {
                if (pyStringLiteralExpression == null) {
                    Inspection.a(12);
                }
                if (typeEvalContext == null) {
                    Inspection.a(13);
                }
                PyBuiltinCache pyBuiltinCache = PyBuiltinCache.getInstance(pyStringLiteralExpression);
                PyClassType pyClassType = pyBuiltinCache.getBytesType(LanguageLevel.forElement(pyStringLiteralExpression));
                PyType pyType = typeEvalContext.getType(pyStringLiteralExpression);
                return pyClassType != null && pyType != null && PyTypeChecker.match(pyClassType, pyType, typeEvalContext);
            }

            private void a(@NotNull PyStringLiteralExpression pyStringLiteralExpression, String string) {
                long l2 = h ^ 0x27FDFD7FA661L;
                if (pyStringLiteralExpression == null) {
                    Inspection.a(14);
                }
                if ("*".equals(string)) {
                    ++this.e;
                    if (this.b.size() > 0) {
                        this.a((PsiElement)pyStringLiteralExpression, "Can't use '*' in formats when using a mapping");
                    }
                }
            }

            public boolean isProblem() {
                return this.a;
            }

            private void a(@Nullable PyExpression pyExpression) {
                long l2 = h ^ 0x7187BB0FC5DAL;
                if (pyExpression == null) {
                    return;
                }
                if (pyExpression instanceof PyParenthesizedExpression) {
                    this.a(((PyParenthesizedExpression)pyExpression).getContainedExpression());
                } else {
                    PyClassType pyClassType = PyUtil.as(this.f.getType(pyExpression), PyClassType.class);
                    if (pyClassType != null && this.b.size() > 0 && !PyABCUtil.isSubclass(pyClassType.getPyClass(), "Mapping", this.f)) {
                        this.a((PsiElement)pyExpression, PyBundle.message("INSP.format.requires.mapping", new Object[0]));
                        return;
                    }
                    this.b(pyExpression);
                }
            }

            private void b(@NotNull PyExpression pyExpression) {
                long l2 = h ^ 0x34DE9335F31CL;
                if (pyExpression == null) {
                    Inspection.a(15);
                }
                int n2 = this.a(pyExpression, (PsiElement)pyExpression);
                if (this.b.isEmpty() && n2 >= 0) {
                    if (this.e < n2) {
                        this.a((PsiElement)pyExpression, PyBundle.message("INSP.too.many.args.for.fmt.string", new Object[0]));
                    } else if (this.e > n2) {
                        this.a((PsiElement)pyExpression, PyBundle.message("INSP.too.few.args.for.fmt.string", new Object[0]));
                    }
                }
            }

            static {
                h = com.jetbrains.python.psi.c.a(2197484296020895851L, 1766458106037620813L, MethodHandles.lookup().lookupClass()).a(121282160785800L);
                long l2 = h ^ 0x18B4211FF8ECL;
                g = ImmutableMap.builder().put((Object)Character.valueOf('d'), (Object)"int or long or float").put((Object)Character.valueOf('i'), (Object)"int or long or float").put((Object)Character.valueOf('o'), (Object)"int or long or float").put((Object)Character.valueOf('u'), (Object)"int or long or float").put((Object)Character.valueOf('x'), (Object)"int or long or float").put((Object)Character.valueOf('X'), (Object)"int or long or float").put((Object)Character.valueOf('e'), (Object)"float").put((Object)Character.valueOf('E'), (Object)"float").put((Object)Character.valueOf('f'), (Object)"float").put((Object)Character.valueOf('F'), (Object)"float").put((Object)Character.valueOf('g'), (Object)"float").put((Object)Character.valueOf('G'), (Object)"float").put((Object)Character.valueOf('c'), (Object)"str").put((Object)Character.valueOf('r'), (Object)"str").put((Object)Character.valueOf('a'), (Object)"str").put((Object)Character.valueOf('s'), (Object)"str").put((Object)Character.valueOf('b'), (Object)"bytes").build();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = h ^ 0x70DBB9A291BBL;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "problemTarget";
                        break;
                    }
                    case 1: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rightExpression";
                        break;
                    }
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "quickFix";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedTypeName";
                        break;
                    }
                    case 11: 
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "formatExpression";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expr";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectArguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "matchEntireTupleTypes";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblem";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkExpressionType";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTypeCompatible";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectPercentFormat";
                        break;
                    }
                    case 12: 
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isBytesLiteral";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectWidth";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectArgumentsNumber";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

