/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMakeFunctionReturnTypeQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PyFunction> c;
    private final SmartPsiElementPointer<PyAnnotation> a;
    private final SmartPsiElementPointer<PsiComment> b;
    private final String d;
    private static final long e = com.jetbrains.python.psi.c.a(6165327815767868686L, -6913353971187564781L, MethodHandles.lookup().lookupClass()).a(210232194744273L);

    public PyMakeFunctionReturnTypeQuickFix(@NotNull PyFunction function, @Nullable String returnTypeName, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.a(0);
        }
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.a(1);
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)function.getProject());
        this.c = smartPointerManager.createSmartPsiElementPointer((PsiElement)function);
        PyAnnotation pyAnnotation = function.getAnnotation();
        this.a = pyAnnotation != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)pyAnnotation) : null;
        PsiComment psiComment = function.getTypeComment();
        this.b = psiComment != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)psiComment) : null;
        this.d = returnTypeName == null ? PythonDocumentationProvider.getTypeName(function.getReturnStatementType(context), context) : returnTypeName;
    }

    @NotNull
    public String getName() {
        long l2 = e ^ 0x40AF07BF3E1FL;
        PyFunction pyFunction = (PyFunction)this.c.getElement();
        String string = pyFunction != null ? pyFunction.getName() : "function";
        String string2 = PyBundle.message("QFIX.NAME.make.$0.return.$1", string, this.d);
        if (string2 == null) {
            PyMakeFunctionReturnTypeQuickFix.a(2);
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        long l2 = e ^ 0x5BD289C36AB9L;
        String string = PyBundle.message("QFIX.NAME.make.$0.return.$1", "function", "inferred type");
        if (string == null) {
            PyMakeFunctionReturnTypeQuickFix.a(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiComment psiComment;
        long l2 = e ^ 0x68DF065200D5L;
        if (project == null) {
            PyMakeFunctionReturnTypeQuickFix.a(4);
        }
        if (descriptor2 == null) {
            PyMakeFunctionReturnTypeQuickFix.a(5);
        }
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(project);
        if (this.a != null) {
            PyAnnotation pyAnnotation = (PyAnnotation)this.a.getElement();
            if (pyAnnotation != null) {
                PyExpression pyExpression = pyAnnotation.getValue();
                if (pyExpression == null) {
                    return;
                }
                pyExpression.replace((PsiElement)pyElementGenerator.createExpressionFromText(LanguageLevel.PYTHON34, this.d));
            }
        } else if (this.b != null && (psiComment = (PsiComment)this.b.getElement()) != null) {
            StringBuilder stringBuilder = new StringBuilder(psiComment.getText());
            stringBuilder.delete(stringBuilder.indexOf("->"), stringBuilder.length());
            stringBuilder.append("-> ").append(this.d);
            PsiComment psiComment2 = pyElementGenerator.createFromText(LanguageLevel.PYTHON27, PsiComment.class, stringBuilder.toString());
            psiComment.replace((PsiElement)psiComment2);
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x7F1328176430L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

