/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonLexer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;

public class PythonHighlightingLexer
extends PythonLexer {
    private final LanguageLevel b;
    private state c = state.init;
    private boolean a = false;
    private int d = -1;
    private static final long e = com.jetbrains.python.psi.c.a(-756656379765748806L, -3161297262572957476L, MethodHandles.lookup().lookupClass()).a(22218475905479L);

    public PythonHighlightingLexer(LanguageLevel languageLevel) {
        this.b = languageLevel;
        this.a = false;
    }

    @NotNull
    public static IElementType convertStringType(@NotNull IElementType tokenType, @NotNull String tokenText, @NotNull LanguageLevel languageLevel, boolean unicodeImport) {
        if (tokenType == null) {
            PythonHighlightingLexer.a(0);
        }
        if (tokenText == null) {
            PythonHighlightingLexer.a(1);
        }
        if (languageLevel == null) {
            PythonHighlightingLexer.a(2);
        }
        String string = PyStringLiteralUtil.getPrefix(tokenText);
        if (tokenType == PyTokenTypes.SINGLE_QUOTED_STRING) {
            if (languageLevel.isPy3K()) {
                if (!PyStringLiteralUtil.isBytesPrefix(string)) {
                    PyElementType pyElementType = PyTokenTypes.SINGLE_QUOTED_UNICODE;
                    if (pyElementType == null) {
                        PythonHighlightingLexer.a(3);
                    }
                    return pyElementType;
                }
            } else if (unicodeImport && !PyStringLiteralUtil.isBytesPrefix(string) || PyStringLiteralUtil.isUnicodePrefix(string)) {
                PyElementType pyElementType = PyTokenTypes.SINGLE_QUOTED_UNICODE;
                if (pyElementType == null) {
                    PythonHighlightingLexer.a(4);
                }
                return pyElementType;
            }
        }
        if (tokenType == PyTokenTypes.TRIPLE_QUOTED_STRING) {
            if (languageLevel.isPy3K()) {
                if (!PyStringLiteralUtil.isBytesPrefix(string)) {
                    PyElementType pyElementType = PyTokenTypes.TRIPLE_QUOTED_UNICODE;
                    if (pyElementType == null) {
                        PythonHighlightingLexer.a(5);
                    }
                    return pyElementType;
                }
            } else if (unicodeImport && !PyStringLiteralUtil.isBytesPrefix(string) || PyStringLiteralUtil.isUnicodePrefix(string)) {
                PyElementType pyElementType = PyTokenTypes.TRIPLE_QUOTED_UNICODE;
                if (pyElementType == null) {
                    PythonHighlightingLexer.a(6);
                }
                return pyElementType;
            }
        }
        IElementType iElementType = tokenType;
        if (iElementType == null) {
            PythonHighlightingLexer.a(7);
        }
        return iElementType;
    }

    public IElementType getTokenType() {
        long l2 = e ^ 0x71D1E549FCFAL;
        IElementType iElementType = super.getTokenType();
        if (PyTokenTypes.STRING_NODES.contains(iElementType)) {
            return PythonHighlightingLexer.convertStringType(iElementType, this.getTokenText(), this.b, this.a);
        }
        if (iElementType == PyTokenTypes.IDENTIFIER) {
            String string = this.getTokenText();
            if (this.b.hasWithStatement()) {
                if (string.equals("with")) {
                    return PyTokenTypes.WITH_KEYWORD;
                }
                if (string.equals("as")) {
                    return PyTokenTypes.AS_KEYWORD;
                }
            }
            if (this.b.hasPrintStatement() && string.equals("print")) {
                return PyTokenTypes.PRINT_KEYWORD;
            }
            if (this.b.isPy3K()) {
                if (string.equals("None")) {
                    return PyTokenTypes.NONE_KEYWORD;
                }
                if (string.equals("True")) {
                    return PyTokenTypes.TRUE_KEYWORD;
                }
                if (string.equals("False")) {
                    return PyTokenTypes.FALSE_KEYWORD;
                }
                if (string.equals("nonlocal")) {
                    return PyTokenTypes.NONLOCAL_KEYWORD;
                }
                if (string.equals("__debug__")) {
                    return PyTokenTypes.DEBUG_KEYWORD;
                }
                if (this.b.isAtLeast(LanguageLevel.PYTHON37)) {
                    if (string.equals("async")) {
                        return PyTokenTypes.ASYNC_KEYWORD;
                    }
                    if (string.equals("await")) {
                        return PyTokenTypes.AWAIT_KEYWORD;
                    }
                }
            } else if (string.equals("exec")) {
                return PyTokenTypes.EXEC_KEYWORD;
            }
        }
        return iElementType;
    }

    public void advance() {
        long l2 = e ^ 0x1FDA4684C3E5L;
        IElementType iElementType = super.getTokenType();
        switch (this.c) {
            case init: {
                if (iElementType == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(iElementType) || PyTokenTypes.END_OF_LINE_COMMENT == iElementType || PyTokenTypes.DOCSTRING == iElementType) break;
                if (iElementType == PyTokenTypes.FROM_KEYWORD) {
                    this.c = state.pending_future;
                    break;
                }
                this.c = state.stop;
                break;
            }
            case pending_future: {
                if (iElementType == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(iElementType)) break;
                if (iElementType == PyTokenTypes.IDENTIFIER && "__future__".equals(super.getTokenText())) {
                    this.c = state.pending_import;
                    break;
                }
                this.c = state.stop;
                break;
            }
            case pending_import: {
                if (iElementType == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(iElementType)) break;
                if (iElementType == PyTokenTypes.IMPORT_KEYWORD) {
                    this.c = state.pending_lpar;
                    break;
                }
                this.c = state.stop;
                break;
            }
            case pending_lpar: {
                if (iElementType == PyTokenTypes.LPAR) {
                    this.c = state.pending_id;
                    break;
                }
            }
            case pending_id: {
                if (iElementType == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(iElementType)) break;
                if (iElementType == PyTokenTypes.IDENTIFIER) {
                    this.c = state.pending_comma;
                    if (!"unicode_literals".equals(super.getTokenText())) break;
                    this.a = true;
                    this.d = this.getTokenEnd();
                    break;
                }
                this.c = state.init;
                break;
            }
            case pending_comma: {
                if (iElementType == PyTokenTypes.RPAR || iElementType == PyTokenTypes.BACKSLASH) break;
                if (PyTokenTypes.LINE_BREAK == iElementType) {
                    this.c = state.init;
                }
                if (PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(iElementType) || iElementType != PyTokenTypes.COMMA) break;
                this.c = state.pending_id;
                break;
            }
        }
        super.advance();
    }

    public int getImportOffset() {
        return this.d;
    }

    public void clearState(int position) {
        this.c = state.init;
        this.d = position;
        this.a = false;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x2BAA057300AFL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/lexer/PythonHighlightingLexer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/lexer/PythonHighlightingLexer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertStringType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertStringType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class state
    extends Enum<state> {
        public static final /* enum */ state init;
        public static final /* enum */ state pending_future;
        public static final /* enum */ state pending_import;
        public static final /* enum */ state pending_lpar;
        public static final /* enum */ state pending_id;
        public static final /* enum */ state pending_comma;
        public static final /* enum */ state stop;
        private static final /* synthetic */ state[] a;

        public static state[] values() {
            return (state[])a.clone();
        }

        public static state valueOf(String name) {
            return Enum.valueOf(state.class, name);
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(-8746309081046164200L, -7863107808675599094L, MethodHandles.lookup().lookupClass()).a(267248851267745L) ^ 0x4DDBA1A75BC7L;
            init = new state();
            pending_future = new state();
            pending_import = new state();
            pending_lpar = new state();
            pending_id = new state();
            pending_comma = new state();
            stop = new state();
            a = new state[]{init, pending_future, pending_import, pending_lpar, pending_id, pending_comma, stop};
        }
    }
}

