/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.psi.c;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyAbstractPackageCache {
    private static final Logger b;
    private static final Gson a;
    @SerializedName(value="packages")
    protected final TreeMap<String, PackageInfo> myPackages = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private static final long e;

    protected PyAbstractPackageCache() {
    }

    @NotNull
    protected static <T extends PyAbstractPackageCache> T load(@NotNull Class<T> classToken, @NotNull T fallbackValue, @NotNull Path cacheFilePath) {
        long l2 = e ^ 0x34B0DCD9A68EL;
        if (classToken == null) {
            PyAbstractPackageCache.a(0);
        }
        if (fallbackValue == null) {
            PyAbstractPackageCache.a(1);
        }
        if (cacheFilePath == null) {
            PyAbstractPackageCache.a(2);
        }
        Object object = fallbackValue;
        try (BufferedReader bufferedReader = Files.newBufferedReader(cacheFilePath, StandardCharsets.UTF_8);){
            object = (PyAbstractPackageCache)a.fromJson((Reader)bufferedReader, classToken);
            b.info("Loaded " + ((PyAbstractPackageCache)object).getPackageNames().size() + " packages from " + cacheFilePath);
        }
        catch (NoSuchFileException noSuchFileException) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                b.info("Package cache " + cacheFilePath + " was not found");
            }
        }
        catch (IOException iOException) {
            b.warn("Cannot load package cache " + cacheFilePath, (Throwable)iOException);
        }
        T t2 = object;
        if (t2 == null) {
            PyAbstractPackageCache.a(3);
        }
        return t2;
    }

    protected static void store(@NotNull PyAbstractPackageCache newValue, @NotNull String cacheFileName) {
        long l2 = e ^ 0x7983DC611DDL;
        if (newValue == null) {
            PyAbstractPackageCache.a(4);
        }
        if (cacheFileName == null) {
            PyAbstractPackageCache.a(5);
        }
        try {
            Path path = PyAbstractPackageCache.getDefaultCachePath(cacheFileName);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                a.toJson((Object)newValue, (Appendable)bufferedWriter);
            }
        }
        catch (IOException iOException) {
            b.warn("Cannot save " + cacheFileName + " package cache to the filesystem", (Throwable)iOException);
        }
    }

    @NotNull
    protected static Path getDefaultCachePath(@NotNull String cacheFileName) {
        long l2 = e ^ 0x2296EC3CF612L;
        if (cacheFileName == null) {
            PyAbstractPackageCache.a(6);
        }
        Path path = Paths.get(PathManager.getSystemPath(), "python_packages", cacheFileName);
        if (path == null) {
            PyAbstractPackageCache.a(7);
        }
        return path;
    }

    @NotNull
    public Set<String> getPackageNames() {
        Set<String> set = Collections.unmodifiableSet(this.myPackages.keySet());
        if (set == null) {
            PyAbstractPackageCache.a(8);
        }
        return set;
    }

    public boolean containsPackage(@NotNull String name) {
        if (name == null) {
            PyAbstractPackageCache.a(9);
        }
        return this.myPackages.containsKey(name);
    }

    @Nullable
    public List<String> getVersions(@NotNull String packageName) {
        PackageInfo packageInfo;
        if (packageName == null) {
            PyAbstractPackageCache.a(10);
        }
        return (packageInfo = this.myPackages.get(packageName)) != null ? packageInfo.getVersions() : null;
    }

    public String toString() {
        long l2 = e ^ 0x3CDE04D7B26BL;
        return String.format("%s(size=%d): %s...", this.getClass().getSimpleName(), this.myPackages.size(), ((StreamEx)StreamEx.ofKeys(this.myPackages).limit(5L)).joining((CharSequence)", "));
    }

    static {
        e = c.a(1353512081607014982L, 5468960841925616927L, MethodHandles.lookup().lookupClass()).a(244948766572691L);
        b = Logger.getInstance(PyPIPackageCache.class);
        a = new GsonBuilder().registerTypeAdapter(new TypeToken<TreeMap<String, PackageInfo>>(){}.getType(), type -> new TreeMap(String.CASE_INSENSITIVE_ORDER)).create();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x4B99F29B3101L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToken";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheFilePath";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyAbstractPackageCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheFileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyAbstractPackageCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCachePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCachePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsPackage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVersions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class PackageInfo {
        public static final PackageInfo EMPTY;
        @SerializedName(value="v")
        private List<String> a;
        private static final long b;

        public PackageInfo(@NotNull List<String> versions) {
            if (versions == null) {
                PackageInfo.a(0);
            }
            this.a = versions;
        }

        public PackageInfo() {
        }

        @Nullable
        public List<String> getVersions() {
            return this.a != null ? Collections.unmodifiableList(this.a) : null;
        }

        static {
            b = c.a(-3368901318662343777L, 2921621615554651699L, MethodHandles.lookup().lookupClass()).a(95505348786948L);
            EMPTY = new PackageInfo();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x38D90E0F25E9L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/jetbrains/python/packaging/PyAbstractPackageCache$PackageInfo", "<init>"));
        }
    }
}

