/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.FollowingCommentBinder;
import com.jetbrains.python.parsing.LeadingCommentsBinder;
import com.jetbrains.python.parsing.Parsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.ParsingScope;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class StatementParsing
extends Parsing
implements ITokenTypeRemapper {
    private static final Logger b;
    @NonNls
    protected static final String TOK_FUTURE_IMPORT = "__future__";
    @NonNls
    protected static final String TOK_WITH_STATEMENT = "with_statement";
    @NonNls
    protected static final String TOK_NESTED_SCOPES = "nested_scopes";
    @NonNls
    protected static final String TOK_PRINT_FUNCTION = "print_function";
    @NonNls
    protected static final String TOK_WITH = "with";
    @NonNls
    protected static final String TOK_AS = "as";
    @NonNls
    protected static final String TOK_PRINT = "print";
    @NonNls
    protected static final String TOK_NONE = "None";
    @NonNls
    protected static final String TOK_TRUE = "True";
    @NonNls
    protected static final String TOK_DEBUG = "__debug__";
    @NonNls
    protected static final String TOK_FALSE = "False";
    @NonNls
    protected static final String TOK_NONLOCAL = "nonlocal";
    @NonNls
    protected static final String TOK_EXEC = "exec";
    @NonNls
    public static final String TOK_ASYNC = "async";
    @NonNls
    protected static final String TOK_AWAIT = "await";
    private static final String d = "Expression expected";
    public static final String IDENTIFIER_EXPECTED = "Identifier expected";
    private Phase c = Phase.NONE;
    private boolean e = false;
    protected Set<FUTURE> myFutureFlags = EnumSet.noneOf(FUTURE.class);
    private static final long j;

    public StatementParsing(ParsingContext context, @Nullable FUTURE futureFlag) {
        super(context);
        if (futureFlag != null) {
            this.myFutureFlags.add(futureFlag);
        }
    }

    private void b(boolean bl2) {
        this.e = bl2;
        this.myBuilder.setTokenTypeRemapper((ITokenTypeRemapper)this);
    }

    public void parseStatement() {
        long l2 = j ^ 0x49088E915310L;
        while (this.myBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            this.myBuilder.advanceLexer();
        }
        IElementType iElementType = this.myBuilder.getTokenType();
        if (iElementType == null) {
            return;
        }
        if (iElementType == PyTokenTypes.WHILE_KEYWORD) {
            this.i();
            return;
        }
        if (iElementType == PyTokenTypes.IF_KEYWORD) {
            this.parseIfStatement(PyTokenTypes.IF_KEYWORD, PyTokenTypes.ELIF_KEYWORD, PyTokenTypes.ELSE_KEYWORD, PyElementTypes.IF_STATEMENT);
            return;
        }
        if (iElementType == PyTokenTypes.FOR_KEYWORD) {
            this.b(this.myBuilder.mark());
            return;
        }
        if (iElementType == PyTokenTypes.TRY_KEYWORD) {
            this.j();
            return;
        }
        if (iElementType == PyTokenTypes.DEF_KEYWORD) {
            this.getFunctionParser().parseFunctionDeclaration(this.myBuilder.mark(), false);
            return;
        }
        if (iElementType == PyTokenTypes.AT) {
            this.getFunctionParser().parseDecoratedDeclaration();
            return;
        }
        if (iElementType == PyTokenTypes.CLASS_KEYWORD) {
            this.c();
            return;
        }
        if (iElementType == PyTokenTypes.WITH_KEYWORD) {
            this.a(this.myBuilder.mark());
            return;
        }
        if (iElementType == PyTokenTypes.ASYNC_KEYWORD) {
            this.a(false);
            return;
        }
        if (this.atToken(PyTokenTypes.IDENTIFIER, TOK_ASYNC) && this.a(true)) {
            return;
        }
        this.parseSimpleStatement();
    }

    protected void parseSimpleStatement() {
        this.parseSimpleStatement(true);
    }

    protected void parseSimpleStatement(boolean checkLanguageLevel) {
        long l2 = j ^ 0x8AEFBE495B7L;
        PsiBuilder psiBuilder = this.myContext.getBuilder();
        IElementType iElementType = psiBuilder.getTokenType();
        if (iElementType == null) {
            return;
        }
        if (iElementType == PyTokenTypes.PRINT_KEYWORD && this.hasPrintStatement()) {
            this.b(psiBuilder);
            return;
        }
        if (iElementType == PyTokenTypes.ASSERT_KEYWORD) {
            this.k();
            return;
        }
        if (iElementType == PyTokenTypes.BREAK_KEYWORD) {
            this.parseKeywordStatement(psiBuilder, PyElementTypes.BREAK_STATEMENT);
            return;
        }
        if (iElementType == PyTokenTypes.CONTINUE_KEYWORD) {
            this.parseKeywordStatement(psiBuilder, PyElementTypes.CONTINUE_STATEMENT);
            return;
        }
        if (iElementType == PyTokenTypes.DEL_KEYWORD) {
            this.b();
            return;
        }
        if (iElementType == PyTokenTypes.EXEC_KEYWORD) {
            this.f();
            return;
        }
        if (iElementType == PyTokenTypes.GLOBAL_KEYWORD) {
            this.a(PyElementTypes.GLOBAL_STATEMENT);
            return;
        }
        if (iElementType == PyTokenTypes.NONLOCAL_KEYWORD) {
            this.a(PyElementTypes.NONLOCAL_STATEMENT);
            return;
        }
        if (iElementType == PyTokenTypes.IMPORT_KEYWORD) {
            this.parseImportStatement((IElementType)PyElementTypes.IMPORT_STATEMENT, (IElementType)PyElementTypes.IMPORT_ELEMENT);
            return;
        }
        if (iElementType == PyTokenTypes.FROM_KEYWORD) {
            this.d();
            return;
        }
        if (iElementType == PyTokenTypes.PASS_KEYWORD) {
            this.parseKeywordStatement(psiBuilder, PyElementTypes.PASS_STATEMENT);
            return;
        }
        if (iElementType == PyTokenTypes.RETURN_KEYWORD) {
            this.a(psiBuilder);
            return;
        }
        if (iElementType == PyTokenTypes.RAISE_KEYWORD) {
            this.a();
            return;
        }
        PsiBuilder.Marker marker = psiBuilder.mark();
        if (psiBuilder.getTokenType() == PyTokenTypes.YIELD_KEYWORD) {
            this.getExpressionParser().parseYieldOrTupleExpression(false);
            this.checkEndOfStatement();
            marker.done((IElementType)PyElementTypes.EXPRESSION_STATEMENT);
            return;
        }
        if (this.getExpressionParser().parseExpressionOptional()) {
            PyElementType pyElementType;
            block26: {
                pyElementType = PyElementTypes.EXPRESSION_STATEMENT;
                if (PyTokenTypes.AUG_ASSIGN_OPERATIONS.contains(psiBuilder.getTokenType())) {
                    pyElementType = PyElementTypes.AUG_ASSIGNMENT_STATEMENT;
                    psiBuilder.advanceLexer();
                    if (!this.getExpressionParser().parseYieldOrTupleExpression(false)) {
                        psiBuilder.error(d);
                    }
                } else if (this.atToken(PyTokenTypes.EQ) || this.atToken(PyTokenTypes.COLON) && checkLanguageLevel && this.myContext.getLanguageLevel().isPy3K()) {
                    marker.rollbackTo();
                    marker = psiBuilder.mark();
                    this.getExpressionParser().parseExpression(false, true);
                    b.assertTrue(psiBuilder.getTokenType() == PyTokenTypes.EQ || psiBuilder.getTokenType() == PyTokenTypes.COLON, (Object)psiBuilder.getTokenType());
                    if (psiBuilder.getTokenType() == PyTokenTypes.COLON) {
                        pyElementType = PyElementTypes.TYPE_DECLARATION_STATEMENT;
                        this.getFunctionParser().parseParameterAnnotation();
                    }
                    if (psiBuilder.getTokenType() == PyTokenTypes.EQ) {
                        PsiBuilder.Marker marker2;
                        pyElementType = PyElementTypes.ASSIGNMENT_STATEMENT;
                        psiBuilder.advanceLexer();
                        while (true) {
                            boolean bl2;
                            marker2 = psiBuilder.mark();
                            boolean bl3 = bl2 = psiBuilder.getTokenType() == PyTokenTypes.YIELD_KEYWORD;
                            if (!this.getExpressionParser().parseYieldOrTupleExpression(false)) {
                                marker2.drop();
                                psiBuilder.error(d);
                                break block26;
                            }
                            if (psiBuilder.getTokenType() != PyTokenTypes.EQ) break;
                            if (bl2) {
                                marker2.drop();
                                psiBuilder.error("Cannot assign to 'yield' expression");
                            } else {
                                marker2.rollbackTo();
                                this.getExpressionParser().parseExpression(false, true);
                                b.assertTrue(psiBuilder.getTokenType() == PyTokenTypes.EQ, (Object)psiBuilder.getTokenType());
                            }
                            psiBuilder.advanceLexer();
                        }
                        marker2.drop();
                    }
                }
            }
            this.checkEndOfStatement();
            marker.done((IElementType)pyElementType);
            return;
        }
        marker.drop();
        psiBuilder.advanceLexer();
        this.reportParseStatementError(psiBuilder, iElementType);
    }

    protected void reportParseStatementError(PsiBuilder builder, IElementType firstToken) {
        long l2 = j ^ 0x71559CB7908BL;
        if (firstToken == PyTokenTypes.INCONSISTENT_DEDENT) {
            builder.error("Unindent does not match any outer indentation level");
        } else if (firstToken == PyTokenTypes.INDENT) {
            builder.error("Unexpected indent");
        } else {
            builder.error("Statement expected, found " + firstToken.toString());
        }
    }

    protected boolean hasPrintStatement() {
        return this.myContext.getLanguageLevel().hasPrintStatement() && !this.myFutureFlags.contains((Object)FUTURE.PRINT_FUNCTION);
    }

    protected boolean hasWithStatement() {
        return this.myContext.getLanguageLevel().hasWithStatement() || this.myFutureFlags.contains((Object)FUTURE.WITH_STATEMENT);
    }

    protected void checkEndOfStatement() {
        long l2 = j ^ 0x760D51F80D97L;
        PsiBuilder psiBuilder = this.myContext.getBuilder();
        ParsingScope parsingScope = this.getParsingContext().getScope();
        if (psiBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            psiBuilder.advanceLexer();
            parsingScope.setAfterSemicolon(false);
        } else if (psiBuilder.getTokenType() == PyTokenTypes.SEMICOLON) {
            if (!parsingScope.isSuite()) {
                psiBuilder.advanceLexer();
                parsingScope.setAfterSemicolon(true);
                if (psiBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
                    psiBuilder.advanceLexer();
                    parsingScope.setAfterSemicolon(false);
                }
            }
        } else if (!psiBuilder.eof()) {
            psiBuilder.error("End of statement expected");
        }
    }

    private void b(PsiBuilder psiBuilder) {
        b.assertTrue(psiBuilder.getTokenType() == PyTokenTypes.PRINT_KEYWORD);
        PsiBuilder.Marker marker = psiBuilder.mark();
        psiBuilder.advanceLexer();
        if (psiBuilder.getTokenType() == PyTokenTypes.GTGT) {
            PsiBuilder.Marker marker2 = psiBuilder.mark();
            psiBuilder.advanceLexer();
            this.getExpressionParser().parseSingleExpression(false);
            marker2.done((IElementType)PyElementTypes.PRINT_TARGET);
        } else {
            this.getExpressionParser().parseSingleExpression(false);
        }
        while (psiBuilder.getTokenType() == PyTokenTypes.COMMA) {
            psiBuilder.advanceLexer();
            if (this.getEndOfStatementsTokens().contains(psiBuilder.getTokenType())) break;
            this.getExpressionParser().parseSingleExpression(false);
        }
        this.checkEndOfStatement();
        marker.done((IElementType)PyElementTypes.PRINT_STATEMENT);
    }

    protected void parseKeywordStatement(PsiBuilder builder, IElementType statementType) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        this.checkEndOfStatement();
        marker.done(statementType);
    }

    private void a(PsiBuilder psiBuilder) {
        b.assertTrue(psiBuilder.getTokenType() == PyTokenTypes.RETURN_KEYWORD);
        PsiBuilder.Marker marker = psiBuilder.mark();
        psiBuilder.advanceLexer();
        if (psiBuilder.getTokenType() != null && !this.getEndOfStatementsTokens().contains(psiBuilder.getTokenType())) {
            this.getExpressionParser().parseExpression();
        }
        this.checkEndOfStatement();
        marker.done((IElementType)PyElementTypes.RETURN_STATEMENT);
    }

    private void b() {
        long l2 = j ^ 0x58778CC64E17L;
        this.assertCurrentToken(PyTokenTypes.DEL_KEYWORD);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getExpressionParser().parseSingleExpression(false)) {
            this.myBuilder.error(d);
        }
        while (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
            this.myBuilder.advanceLexer();
            if (this.getEndOfStatementsTokens().contains(this.myBuilder.getTokenType()) || this.getExpressionParser().parseSingleExpression(false)) continue;
            this.myBuilder.error(d);
        }
        this.checkEndOfStatement();
        marker.done((IElementType)PyElementTypes.DEL_STATEMENT);
    }

    private void a() {
        long l2 = j ^ 0x70453082A9C1L;
        this.assertCurrentToken(PyTokenTypes.RAISE_KEYWORD);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getEndOfStatementsTokens().contains(this.myBuilder.getTokenType())) {
            this.getExpressionParser().parseSingleExpression(false);
            if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                this.getExpressionParser().parseSingleExpression(false);
                if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                    this.myBuilder.advanceLexer();
                    this.getExpressionParser().parseSingleExpression(false);
                }
            } else if (this.myBuilder.getTokenType() == PyTokenTypes.FROM_KEYWORD) {
                this.myBuilder.advanceLexer();
                if (!this.getExpressionParser().parseSingleExpression(false)) {
                    this.myBuilder.error(d);
                }
            }
        }
        this.checkEndOfStatement();
        marker.done((IElementType)PyElementTypes.RAISE_STATEMENT);
    }

    private void k() {
        long l2 = j ^ 0x7ACD3F680F15L;
        this.assertCurrentToken(PyTokenTypes.ASSERT_KEYWORD);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.getExpressionParser().parseSingleExpression(false)) {
            if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                if (!this.getExpressionParser().parseSingleExpression(false)) {
                    this.myContext.getBuilder().error(d);
                }
            }
            this.checkEndOfStatement();
        } else {
            this.myContext.getBuilder().error(d);
        }
        marker.done((IElementType)PyElementTypes.ASSERT_STATEMENT);
    }

    protected void parseImportStatement(IElementType statementType, IElementType elementType) {
        PsiBuilder psiBuilder = this.myContext.getBuilder();
        PsiBuilder.Marker marker = psiBuilder.mark();
        psiBuilder.advanceLexer();
        this.a(elementType, true, false, false);
        this.checkEndOfStatement();
        marker.done(statementType);
    }

    private void d() {
        long l2 = j ^ 0x2CFED8579262L;
        PsiBuilder psiBuilder = this.myContext.getBuilder();
        this.assertCurrentToken(PyTokenTypes.FROM_KEYWORD);
        this.c = Phase.FROM;
        PsiBuilder.Marker marker = psiBuilder.mark();
        psiBuilder.advanceLexer();
        boolean bl2 = false;
        boolean bl3 = this.g();
        PyStubElementType pyStubElementType = PyElementTypes.FROM_IMPORT_STATEMENT;
        if (bl3 && this.parseOptionalDottedName() || this.parseDottedName()) {
            ImportTypes importTypes = this.checkFromImportKeyword();
            pyStubElementType = importTypes.statement;
            IElementType iElementType = importTypes.element;
            if (this.c == Phase.FUTURE) {
                this.c = Phase.IMPORT;
                bl2 = true;
            }
            if (psiBuilder.getTokenType() == PyTokenTypes.MULT) {
                PsiBuilder.Marker marker2 = psiBuilder.mark();
                psiBuilder.advanceLexer();
                marker2.done(importTypes.starElement);
            } else if (psiBuilder.getTokenType() == PyTokenTypes.LPAR) {
                psiBuilder.advanceLexer();
                this.a(iElementType, false, true, bl2);
                this.checkMatches(PyTokenTypes.RPAR, ") expected");
            } else {
                this.a(iElementType, false, false, bl2);
            }
        } else if (bl3) {
            ImportTypes importTypes = this.checkFromImportKeyword();
            pyStubElementType = importTypes.statement;
            this.a(importTypes.element, false, false, bl2);
        }
        this.checkEndOfStatement();
        marker.done((IElementType)pyStubElementType);
        this.c = Phase.NONE;
    }

    protected ImportTypes checkFromImportKeyword() {
        long l2 = j ^ 0x57C8D04FF34L;
        this.checkMatches(PyTokenTypes.IMPORT_KEYWORD, "'import' expected");
        return new ImportTypes((IElementType)PyElementTypes.FROM_IMPORT_STATEMENT, (IElementType)PyElementTypes.IMPORT_ELEMENT, (IElementType)PyElementTypes.STAR_IMPORT_ELEMENT);
    }

    private boolean g() {
        PsiBuilder psiBuilder = this.myContext.getBuilder();
        boolean bl2 = false;
        while (psiBuilder.getTokenType() == PyTokenTypes.DOT) {
            bl2 = true;
            psiBuilder.advanceLexer();
        }
        return bl2;
    }

    private void a(IElementType iElementType, boolean bl2, boolean bl3, boolean bl4) {
        long l2 = j ^ 0x5E590D7D2499L;
        PsiBuilder psiBuilder = this.myContext.getBuilder();
        do {
            PsiBuilder.Marker marker = psiBuilder.mark();
            if (bl2) {
                if (!this.parseDottedNameAsAware(true, false)) {
                    marker.drop();
                    break;
                }
            } else {
                String string = this.a(this.getReferenceType());
                if (bl4) {
                    if (TOK_WITH_STATEMENT.equals(string)) {
                        this.myFutureFlags.add(FUTURE.WITH_STATEMENT);
                    } else if (TOK_NESTED_SCOPES.equals(string)) {
                        this.myFutureFlags.add(FUTURE.NESTED_SCOPES);
                    } else if (TOK_PRINT_FUNCTION.equals(string)) {
                        this.myFutureFlags.add(FUTURE.PRINT_FUNCTION);
                    }
                }
            }
            this.b(true);
            if (psiBuilder.getTokenType() == PyTokenTypes.AS_KEYWORD) {
                psiBuilder.advanceLexer();
                this.b(false);
                this.a((IElementType)PyElementTypes.TARGET_EXPRESSION);
            }
            marker.done(iElementType);
            this.b(false);
            if (psiBuilder.getTokenType() != PyTokenTypes.COMMA) break;
            psiBuilder.advanceLexer();
        } while (!bl3 || psiBuilder.getTokenType() != PyTokenTypes.RPAR);
    }

    @Nullable
    private String a(IElementType iElementType) {
        long l2 = j ^ 0x64009DD6892EL;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
            String string = this.myBuilder.getTokenText();
            this.myBuilder.advanceLexer();
            marker.done(iElementType);
            return string;
        }
        this.myBuilder.error(IDENTIFIER_EXPECTED);
        marker.drop();
        return null;
    }

    public boolean parseOptionalDottedName() {
        return this.parseDottedNameAsAware(false, true);
    }

    public boolean parseDottedName() {
        return this.parseDottedNameAsAware(false, false);
    }

    protected boolean parseDottedNameAsAware(boolean expect_as, boolean optional) {
        long l2 = j ^ 0x302A86D1E93EL;
        if (this.myBuilder.getTokenType() != PyTokenTypes.IDENTIFIER) {
            if (optional) {
                return true;
            }
            this.myBuilder.error(IDENTIFIER_EXPECTED);
            return false;
        }
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        marker.done(this.getReferenceType());
        boolean bl2 = this.e;
        this.b(expect_as);
        while (this.myBuilder.getTokenType() == PyTokenTypes.DOT) {
            marker = marker.precede();
            this.myBuilder.advanceLexer();
            this.checkMatches(PyTokenTypes.IDENTIFIER, IDENTIFIER_EXPECTED);
            marker.done(this.getReferenceType());
        }
        this.b(bl2);
        return true;
    }

    private void a(PyElementType pyElementType) {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.a((IElementType)PyElementTypes.TARGET_EXPRESSION);
        while (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
            this.myBuilder.advanceLexer();
            this.a((IElementType)PyElementTypes.TARGET_EXPRESSION);
        }
        this.checkEndOfStatement();
        marker.done((IElementType)pyElementType);
    }

    private void f() {
        this.assertCurrentToken(PyTokenTypes.EXEC_KEYWORD);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.getExpressionParser().parseExpression(true, false);
        if (this.myBuilder.getTokenType() == PyTokenTypes.IN_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.getExpressionParser().parseSingleExpression(false);
            if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                this.getExpressionParser().parseSingleExpression(false);
            }
        }
        this.checkEndOfStatement();
        marker.done((IElementType)PyElementTypes.EXEC_STATEMENT);
    }

    protected void parseIfStatement(PyElementType ifKeyword, PyElementType elifKeyword, PyElementType elseKeyword, PyElementType elementType) {
        long l2 = j ^ 0x5DD4A031EA89L;
        this.assertCurrentToken(ifKeyword);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        PsiBuilder.Marker marker2 = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getExpressionParser().parseSingleExpression(false)) {
            this.myBuilder.error("expression expected");
        }
        this.h();
        marker2.done((IElementType)PyElementTypes.IF_PART_IF);
        PsiBuilder.Marker marker3 = this.myBuilder.mark();
        while (this.myBuilder.getTokenType() == elifKeyword) {
            this.myBuilder.advanceLexer();
            if (!this.getExpressionParser().parseSingleExpression(false)) {
                this.myBuilder.error("expression expected");
            }
            this.h();
            marker3.done((IElementType)PyElementTypes.IF_PART_ELIF);
            marker3 = this.myBuilder.mark();
        }
        marker3.drop();
        PsiBuilder.Marker marker4 = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == elseKeyword) {
            this.myBuilder.advanceLexer();
            this.h();
            marker4.done((IElementType)PyElementTypes.ELSE_PART);
        } else {
            marker4.drop();
        }
        marker.done((IElementType)elementType);
    }

    private boolean e() {
        long l2 = j ^ 0x5C2C0DBCA0DAL;
        if (this.myBuilder.getTokenType() == PyTokenTypes.COLON) {
            this.myBuilder.advanceLexer();
            return true;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            this.myBuilder.error("Colon expected");
            return true;
        }
        PsiBuilder.Marker marker = this.myBuilder.mark();
        while (!this.atAnyOfTokens(null, PyTokenTypes.DEDENT, PyTokenTypes.STATEMENT_BREAK, PyTokenTypes.COLON)) {
            this.myBuilder.advanceLexer();
        }
        boolean bl2 = this.matchToken(PyTokenTypes.COLON);
        if (!bl2 && this.atToken(PyTokenTypes.STATEMENT_BREAK)) {
            this.myBuilder.advanceLexer();
        }
        marker.error("Colon expected");
        return bl2;
    }

    private void b(PsiBuilder.Marker marker) {
        this.assertCurrentToken(PyTokenTypes.FOR_KEYWORD);
        this.parseForPart();
        PsiBuilder.Marker marker2 = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.ELSE_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.h();
            marker2.done((IElementType)PyElementTypes.ELSE_PART);
        } else {
            marker2.drop();
        }
        marker.done((IElementType)PyElementTypes.FOR_STATEMENT);
    }

    protected void parseForPart() {
        long l2 = j ^ 0x213CB327CA1FL;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.getExpressionParser().parseExpression(true, true);
        this.checkMatches(PyTokenTypes.IN_KEYWORD, "'in' expected");
        this.getExpressionParser().parseExpression();
        this.h();
        marker.done((IElementType)PyElementTypes.FOR_PART);
    }

    private void i() {
        long l2 = j ^ 0x7D834DA84B30L;
        this.assertCurrentToken(PyTokenTypes.WHILE_KEYWORD);
        PsiBuilder.Marker marker = this.myBuilder.mark();
        PsiBuilder.Marker marker2 = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getExpressionParser().parseSingleExpression(false)) {
            this.myBuilder.error(d);
        }
        this.h();
        marker2.done((IElementType)PyElementTypes.WHILE_PART);
        PsiBuilder.Marker marker3 = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.ELSE_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.h();
            marker3.done((IElementType)PyElementTypes.ELSE_PART);
        } else {
            marker3.drop();
        }
        marker.done((IElementType)PyElementTypes.WHILE_STATEMENT);
    }

    private void j() {
        PsiBuilder.Marker marker;
        long l2 = j ^ 0x619AC1DB847FL;
        this.assertCurrentToken(PyTokenTypes.TRY_KEYWORD);
        PsiBuilder.Marker marker2 = this.myBuilder.mark();
        PsiBuilder.Marker marker3 = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.h();
        marker3.done((IElementType)PyElementTypes.TRY_PART);
        boolean bl2 = false;
        if (this.myBuilder.getTokenType() == PyTokenTypes.EXCEPT_KEYWORD) {
            bl2 = true;
            while (this.myBuilder.getTokenType() == PyTokenTypes.EXCEPT_KEYWORD) {
                marker = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                if (this.myBuilder.getTokenType() != PyTokenTypes.COLON) {
                    if (!this.getExpressionParser().parseSingleExpression(false)) {
                        this.myBuilder.error(d);
                    }
                    this.b(true);
                    if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA || this.myBuilder.getTokenType() == PyTokenTypes.AS_KEYWORD) {
                        this.myBuilder.advanceLexer();
                        if (!this.getExpressionParser().parseSingleExpression(true)) {
                            this.myBuilder.error(d);
                        }
                    }
                }
                this.h();
                marker.done((IElementType)PyElementTypes.EXCEPT_PART);
            }
            marker = this.myBuilder.mark();
            if (this.myBuilder.getTokenType() == PyTokenTypes.ELSE_KEYWORD) {
                this.myBuilder.advanceLexer();
                this.h();
                marker.done((IElementType)PyElementTypes.ELSE_PART);
            } else {
                marker.drop();
            }
        }
        marker = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.FINALLY_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.h();
            marker.done((IElementType)PyElementTypes.FINALLY_PART);
        } else {
            marker.drop();
            if (!bl2) {
                this.myBuilder.error("'except' or 'finally' expected");
            }
        }
        marker2.done((IElementType)PyElementTypes.TRY_EXCEPT_STATEMENT);
    }

    private void h() {
        if (this.e()) {
            this.parseSuite();
        } else {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            marker.done((IElementType)PyElementTypes.STATEMENT_LIST);
        }
    }

    private void a(PsiBuilder.Marker marker) {
        long l2 = j ^ 0x6D34D57E63D3L;
        this.assertCurrentToken(PyTokenTypes.WITH_KEYWORD);
        this.myBuilder.advanceLexer();
        do {
            PsiBuilder.Marker marker2 = this.myBuilder.mark();
            this.getExpressionParser().parseExpression();
            this.b(true);
            if (this.myBuilder.getTokenType() == PyTokenTypes.AS_KEYWORD) {
                this.myBuilder.advanceLexer();
                if (!this.getExpressionParser().parseSingleExpression(true)) {
                    this.myBuilder.error(IDENTIFIER_EXPECTED);
                }
            }
            marker2.done((IElementType)PyElementTypes.WITH_ITEM);
        } while (this.matchToken(PyTokenTypes.COMMA));
        this.h();
        marker.done((IElementType)PyElementTypes.WITH_STATEMENT);
    }

    private void c() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.parseClassDeclaration(marker);
    }

    public void parseClassDeclaration(PsiBuilder.Marker classMarker) {
        Object object;
        this.assertCurrentToken(PyTokenTypes.CLASS_KEYWORD);
        this.myBuilder.advanceLexer();
        this.parseIdentifierOrSkip(PyTokenTypes.LPAR, PyTokenTypes.COLON);
        if (this.myBuilder.getTokenType() == PyTokenTypes.LPAR) {
            this.getExpressionParser().parseArgumentList();
        } else {
            object = this.myBuilder.mark();
            object.done((IElementType)PyElementTypes.ARGUMENT_LIST);
        }
        object = this.getParsingContext();
        ((ParsingContext)object).pushScope(((ParsingContext)object).getScope().withClass());
        this.h();
        ((ParsingContext)object).popScope();
        classMarker.done((IElementType)PyElementTypes.CLASS_DECLARATION);
    }

    private boolean a(boolean bl2) {
        long l2 = j ^ 0x7E4EA5802E05L;
        if (!bl2) {
            this.assertCurrentToken(PyTokenTypes.ASYNC_KEYWORD);
        }
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.advanceAsync(bl2);
        IElementType iElementType = this.myBuilder.getTokenType();
        if (iElementType == PyTokenTypes.DEF_KEYWORD) {
            this.getFunctionParser().parseFunctionDeclaration(marker, true);
            return true;
        }
        if (iElementType == PyTokenTypes.WITH_KEYWORD) {
            this.a(marker);
            return true;
        }
        if (iElementType == PyTokenTypes.FOR_KEYWORD) {
            this.b(marker);
            return true;
        }
        if (bl2) {
            marker.rollbackTo();
        } else {
            marker.drop();
            this.myBuilder.error("'def' or 'with' or 'for' expected");
        }
        return false;
    }

    public void parseSuite() {
        this.parseSuite(null, null);
    }

    public void parseSuite(@Nullable PsiBuilder.Marker endMarker, @Nullable IElementType elType) {
        long l2 = j ^ 0x6D3667D199FDL;
        if (this.myBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            boolean bl2;
            this.myBuilder.advanceLexer();
            PsiBuilder.Marker marker = this.myBuilder.mark();
            boolean bl3 = bl2 = this.myBuilder.getTokenType() == PyTokenTypes.INDENT;
            if (bl2) {
                this.myBuilder.advanceLexer();
                if (this.myBuilder.eof()) {
                    this.myBuilder.error("Indented block expected");
                } else {
                    while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != PyTokenTypes.DEDENT) {
                        this.parseStatement();
                    }
                }
            } else {
                this.myBuilder.error("Indent expected");
            }
            marker.done((IElementType)PyElementTypes.STATEMENT_LIST);
            marker.setCustomEdgeTokenBinders((WhitespacesAndCommentsBinder)LeadingCommentsBinder.INSTANCE, (WhitespacesAndCommentsBinder)FollowingCommentBinder.INSTANCE);
            if (endMarker != null) {
                endMarker.done(elType);
            }
            if (bl2 && !this.myBuilder.eof()) {
                this.checkMatches(PyTokenTypes.DEDENT, "Dedent expected");
            }
        } else {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            if (this.myBuilder.eof()) {
                this.myBuilder.error("Statement expected");
            } else {
                ParsingContext parsingContext = this.getParsingContext();
                parsingContext.pushScope(parsingContext.getScope().withSuite());
                this.parseSimpleStatement();
                parsingContext.popScope();
                while (this.matchToken(PyTokenTypes.SEMICOLON) && !this.matchToken(PyTokenTypes.STATEMENT_BREAK)) {
                    parsingContext.pushScope(parsingContext.getScope().withSuite());
                    this.parseSimpleStatement();
                    parsingContext.popScope();
                }
            }
            marker.done((IElementType)PyElementTypes.STATEMENT_LIST);
            if (endMarker != null) {
                endMarker.done(elType);
            }
        }
    }

    public IElementType filter(IElementType source, int start2, int end, CharSequence text2) {
        return this.filter(source, start2, end, text2, true);
    }

    protected IElementType filter(IElementType source, int start2, int end, CharSequence text2, boolean checkLanguageLevel) {
        long l2 = j ^ 0x520DE4D2C171L;
        if ((this.e || this.hasWithStatement()) && source == PyTokenTypes.IDENTIFIER && StatementParsing.a(text2, start2, end, TOK_AS)) {
            return PyTokenTypes.AS_KEYWORD;
        }
        if (this.c == Phase.FROM && source == PyTokenTypes.IDENTIFIER && StatementParsing.a(text2, start2, end, TOK_FUTURE_IMPORT)) {
            this.c = Phase.FUTURE;
            return source;
        }
        if (this.hasWithStatement() && source == PyTokenTypes.IDENTIFIER && StatementParsing.a(text2, start2, end, TOK_WITH)) {
            return PyTokenTypes.WITH_KEYWORD;
        }
        if (this.hasPrintStatement() && source == PyTokenTypes.IDENTIFIER && StatementParsing.a(text2, start2, end, TOK_PRINT)) {
            return PyTokenTypes.PRINT_KEYWORD;
        }
        if ((this.myContext.getLanguageLevel().isPy3K() || !checkLanguageLevel) && source == PyTokenTypes.IDENTIFIER) {
            if (StatementParsing.a(text2, start2, end, TOK_NONE)) {
                return PyTokenTypes.NONE_KEYWORD;
            }
            if (StatementParsing.a(text2, start2, end, TOK_TRUE)) {
                return PyTokenTypes.TRUE_KEYWORD;
            }
            if (StatementParsing.a(text2, start2, end, TOK_FALSE)) {
                return PyTokenTypes.FALSE_KEYWORD;
            }
            if (StatementParsing.a(text2, start2, end, TOK_DEBUG)) {
                return PyTokenTypes.DEBUG_KEYWORD;
            }
            if (StatementParsing.a(text2, start2, end, TOK_NONLOCAL)) {
                return PyTokenTypes.NONLOCAL_KEYWORD;
            }
            LanguageLevel languageLevel = this.myContext.getLanguageLevel();
            if (languageLevel.isAtLeast(LanguageLevel.PYTHON35) || !checkLanguageLevel) {
                if (StatementParsing.a(text2, start2, end, TOK_ASYNC) && (languageLevel.isAtLeast(LanguageLevel.PYTHON37) || this.myContext.getScope().isAsync() || this.myBuilder.lookAhead(1) == PyTokenTypes.DEF_KEYWORD)) {
                    return PyTokenTypes.ASYNC_KEYWORD;
                }
                if (StatementParsing.a(text2, start2, end, TOK_AWAIT) && (languageLevel.isAtLeast(LanguageLevel.PYTHON37) || this.myContext.getScope().isAsync())) {
                    return PyTokenTypes.AWAIT_KEYWORD;
                }
            }
        } else if ((this.myContext.getLanguageLevel().isPython2() || !checkLanguageLevel) && source == PyTokenTypes.IDENTIFIER && StatementParsing.a(text2, start2, end, TOK_EXEC)) {
            return PyTokenTypes.EXEC_KEYWORD;
        }
        return source;
    }

    protected TokenSet getEndOfStatementsTokens() {
        return PyTokenTypes.END_OF_STATEMENT;
    }

    private static boolean a(CharSequence charSequence, int n2, int n3, String string) {
        return CharArrayUtil.regionMatches((CharSequence)charSequence, (int)n2, (int)n3, (CharSequence)string) && n3 - n2 == string.length();
    }

    static {
        j = com.jetbrains.python.psi.c.a(-1178887482738941304L, 2045822673466040206L, MethodHandles.lookup().lookupClass()).a(147002496399504L);
        long l2 = j ^ 0x74645A438B49L;
        b = Logger.getInstance((String)"#com.jetbrains.python.parsing.StatementParsing");
    }

    public static class ImportTypes {
        public final IElementType statement;
        public final IElementType element;
        public IElementType starElement;

        public ImportTypes(IElementType statement, IElementType element, IElementType starElement) {
            this.statement = statement;
            this.element = element;
            this.starElement = starElement;
        }
    }

    public static final class FUTURE
    extends Enum<FUTURE> {
        public static final /* enum */ FUTURE ABSOLUTE_IMPORT;
        public static final /* enum */ FUTURE DIVISION;
        public static final /* enum */ FUTURE GENERATORS;
        public static final /* enum */ FUTURE NESTED_SCOPES;
        public static final /* enum */ FUTURE WITH_STATEMENT;
        public static final /* enum */ FUTURE PRINT_FUNCTION;
        private static final /* synthetic */ FUTURE[] a;

        public static FUTURE[] values() {
            return (FUTURE[])a.clone();
        }

        public static FUTURE valueOf(String name) {
            return Enum.valueOf(FUTURE.class, name);
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(-8264349301714549272L, 1695041425362790065L, MethodHandles.lookup().lookupClass()).a(241791781041679L) ^ 0x317DC4281CCFL;
            ABSOLUTE_IMPORT = new FUTURE();
            DIVISION = new FUTURE();
            GENERATORS = new FUTURE();
            NESTED_SCOPES = new FUTURE();
            WITH_STATEMENT = new FUTURE();
            PRINT_FUNCTION = new FUTURE();
            a = new FUTURE[]{ABSOLUTE_IMPORT, DIVISION, GENERATORS, NESTED_SCOPES, WITH_STATEMENT, PRINT_FUNCTION};
        }
    }

    protected static final class Phase
    extends Enum<Phase> {
        public static final /* enum */ Phase NONE;
        public static final /* enum */ Phase FROM;
        public static final /* enum */ Phase FUTURE;
        public static final /* enum */ Phase IMPORT;
        private static final /* synthetic */ Phase[] a;

        public static Phase[] values() {
            return (Phase[])a.clone();
        }

        public static Phase valueOf(String name) {
            return Enum.valueOf(Phase.class, name);
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(-6602110568010433988L, 7840607350870513615L, MethodHandles.lookup().lookupClass()).a(46940167239774L) ^ 0x19BA2303CE2L;
            NONE = new Phase();
            FROM = new Phase();
            FUTURE = new Phase();
            IMPORT = new Phase();
            a = new Phase[]{NONE, FROM, FUTURE, IMPORT};
        }
    }
}

