/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonLexer;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringLiteralUtil {
    public static final String PREFIX_CHARACTERS = "ubcrf";
    public static final int MAX_PREFIX_LENGTH = 3;
    private static final ImmutableList<String> b;
    private static final Logger a;
    private static final long c;

    private PyStringLiteralUtil() {
    }

    @NotNull
    public static String getStringValue(@NotNull String s2) {
        if (s2 == null) {
            PyStringLiteralUtil.a(0);
        }
        String string = PyStringLiteralUtil.getStringValueTextRange(s2).substring(s2);
        if (string == null) {
            PyStringLiteralUtil.a(1);
        }
        return string;
    }

    public static TextRange getStringValueTextRange(@NotNull String s2) {
        Pair<String, String> pair;
        if (s2 == null) {
            PyStringLiteralUtil.a(2);
        }
        if ((pair = PyStringLiteralUtil.getQuotes(s2)) != null) {
            return TextRange.create((int)((String)pair.getFirst()).length(), (int)(s2.length() - ((String)pair.getSecond()).length()));
        }
        return TextRange.allOf((String)s2);
    }

    public static boolean isStringLiteralToken(@NotNull String text2) {
        if (text2 == null) {
            PyStringLiteralUtil.a(3);
        }
        PythonLexer pythonLexer = new PythonLexer();
        pythonLexer.start(text2);
        return PyTokenTypes.STRING_NODES.contains(pythonLexer.getTokenType()) && pythonLexer.getTokenEnd() == pythonLexer.getBufferEnd() || PyTokenTypes.FSTRING_START == pythonLexer.getTokenType();
    }

    public static boolean isQuoted(@Nullable String text2) {
        return text2 != null && PyStringLiteralUtil.getQuotes(text2) != null;
    }

    @Nullable
    public static Pair<String, String> getQuotes(@NotNull String text2) {
        if (text2 == null) {
            PyStringLiteralUtil.a(4);
        }
        String string = PyStringLiteralUtil.getPrefix(text2);
        String string2 = text2.substring(string.length());
        for (String string3 : b) {
            Pair<String, String> pair = PyStringLiteralUtil.a(string2, string, string3);
            if (pair == null) continue;
            return pair;
        }
        return null;
    }

    @NotNull
    public static TextRange getContentRange(@NotNull String text2) {
        long l2 = c ^ 0x58FD8D747723L;
        if (text2 == null) {
            PyStringLiteralUtil.a(5);
        }
        a.assertTrue(PyStringLiteralUtil.isStringLiteralToken(text2), (Object)("Text of a single string literal node expected: " + text2));
        int n2 = PyStringLiteralUtil.getPrefixLength(text2);
        int n3 = 1;
        String string = text2.substring(n2);
        if (string.startsWith("\"\"\"") || string.startsWith("'''")) {
            n3 = 3;
        }
        String string2 = text2.substring(n2, n2 + n3);
        int n4 = text2.length();
        if (text2.substring(n2 += n3).endsWith(string2)) {
            n4 -= n3;
        }
        TextRange textRange = new TextRange(n2, n4);
        if (textRange == null) {
            PyStringLiteralUtil.a(6);
        }
        return textRange;
    }

    public static int getPrefixEndOffset(@NotNull CharSequence text2, int startOffset) {
        int n2;
        long l2 = c ^ 0x22681472D29AL;
        if (text2 == null) {
            PyStringLiteralUtil.a(7);
        }
        for (n2 = startOffset; n2 < Math.min(startOffset + 3, text2.length()) && PREFIX_CHARACTERS.indexOf(Character.toLowerCase(text2.charAt(n2))) >= 0; ++n2) {
        }
        return n2;
    }

    public static int getPrefixLength(@NotNull String text2) {
        if (text2 == null) {
            PyStringLiteralUtil.a(8);
        }
        return PyStringLiteralUtil.getPrefixEndOffset(text2, 0);
    }

    @NotNull
    public static String getPrefix(@NotNull CharSequence text2) {
        if (text2 == null) {
            PyStringLiteralUtil.a(9);
        }
        String string = PyStringLiteralUtil.getPrefix(text2, 0);
        if (string == null) {
            PyStringLiteralUtil.a(10);
        }
        return string;
    }

    @NotNull
    public static String getPrefix(@NotNull CharSequence text2, int startOffset) {
        if (text2 == null) {
            PyStringLiteralUtil.a(11);
        }
        String string = text2.subSequence(startOffset, PyStringLiteralUtil.getPrefixEndOffset(text2, startOffset)).toString();
        if (string == null) {
            PyStringLiteralUtil.a(12);
        }
        return string;
    }

    public static boolean isUnicodePrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.a(13);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'u', (int)0) >= 0;
    }

    public static boolean isBytesPrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.a(14);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'b', (int)0) >= 0;
    }

    public static boolean isRawPrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.a(15);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'r', (int)0) >= 0;
    }

    public static boolean isFormattedPrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.a(16);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'f', (int)0) >= 0;
    }

    public static char flipQuote(char quote) {
        return quote == '\"' ? (char)'\'' : '\"';
    }

    @Nullable
    private static Pair<String, String> a(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        int n2;
        int n3;
        if (string == null) {
            PyStringLiteralUtil.a(17);
        }
        if (string2 == null) {
            PyStringLiteralUtil.a(18);
        }
        if (string3 == null) {
            PyStringLiteralUtil.a(19);
        }
        if ((n3 = string.length()) >= 2 * (n2 = string3.length()) && string.startsWith(string3) && string.endsWith(string3)) {
            return Pair.create((Object)(string2 + string.substring(0, n2)), (Object)string.substring(n3 - n2));
        }
        return null;
    }

    public static TextRange getTextRange(PsiElement element) {
        if (element instanceof PyStringLiteralExpression) {
            List<TextRange> list2 = ((PyStringLiteralExpression)element).getStringValueTextRanges();
            return list2.get(0);
        }
        return new TextRange(0, element.getTextLength());
    }

    @Nullable
    public static String getText(@Nullable PyExpression ex2) {
        if (ex2 == null) {
            return null;
        }
        return ex2.getText();
    }

    @Nullable
    public static String getStringValue(@Nullable PsiElement o2) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression pyStringLiteralExpression = (PyStringLiteralExpression)o2;
            return pyStringLiteralExpression.getStringValue();
        }
        return o2.getText();
    }

    public static String stripQuotesAroundValue(String text2) {
        Pair<String, String> pair = PyStringLiteralUtil.getQuotes(text2);
        if (pair == null) {
            return text2;
        }
        return text2.substring(((String)pair.first).length(), text2.length() - ((String)pair.second).length());
    }

    static {
        c = com.jetbrains.python.psi.c.a(-1928394125825118652L, 7284450018611656034L, MethodHandles.lookup().lookupClass()).a(132067985659701L);
        long l2 = c ^ 0x51CE7AAA4824L;
        b = ImmutableList.of((Object)"'''", (Object)"\"\"\"", (Object)"'", (Object)"\"");
        a = Logger.getInstance(PyStringLiteralUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x72D7ACF3F2E6L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyStringLiteralUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quote";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyStringLiteralUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRange";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStringValueTextRange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteralToken";
                break;
            }
            case 4: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getQuotes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContentRange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixEndOffset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixLength";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isUnicodePrefix";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isBytesPrefix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isRawPrefix";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isFormattedPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

