/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFQDNNames;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyEvaluator {
    @NotNull
    private final Set<PyExpression> b = new HashSet<PyExpression>();
    @Nullable
    private Map<String, Object> c = null;
    private boolean e = true;
    private boolean a = true;
    private boolean f = true;
    private boolean d = false;
    private static final long j = com.jetbrains.python.psi.c.a(4069955168750445024L, -7351603115474655054L, MethodHandles.lookup().lookupClass()).a(75721532366085L);

    public void setNamespace(@Nullable Map<String, Object> namespace) {
        this.c = namespace;
    }

    public void setEvaluateCollectionItems(boolean evaluateCollectionItems) {
        this.e = evaluateCollectionItems;
    }

    public void setAllowExpressionsAsValues(boolean allowExpressionsAsValues) {
        this.d = allowExpressionsAsValues;
    }

    public void setEvaluateKeys(boolean evaluateKeys) {
        this.a = evaluateKeys;
    }

    public void enableResolve(boolean enableResolve) {
        this.f = enableResolve;
    }

    @Nullable
    @Contract(value="null -> null")
    public Object evaluate(@Nullable PyExpression expression) {
        if (expression == null || this.b.contains(expression)) {
            return null;
        }
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid((PsiElement)expression));
        this.b.add(expression);
        if (expression instanceof PyParenthesizedExpression) {
            return this.evaluate(((PyParenthesizedExpression)expression).getContainedExpression());
        }
        if (expression instanceof PySequenceExpression) {
            return this.evaluateSequence((PySequenceExpression)expression);
        }
        Boolean bl2 = PyEvaluator.d(expression);
        if (bl2 != null) {
            return bl2;
        }
        if (expression instanceof PyCallExpression) {
            return this.evaluateCall((PyCallExpression)expression);
        }
        if (expression instanceof PyReferenceExpression) {
            return this.evaluateReference((PyReferenceExpression)expression);
        }
        if (expression instanceof PyStringLiteralExpression) {
            return ((PyStringLiteralExpression)expression).getStringValue();
        }
        if (expression instanceof PyBinaryExpression) {
            return this.a((PyBinaryExpression)expression);
        }
        if (expression instanceof PyNumericLiteralExpression) {
            return PyEvaluator.a((PyNumericLiteralExpression)expression);
        }
        if (expression instanceof PyPrefixExpression) {
            return this.a((PyPrefixExpression)expression);
        }
        return null;
    }

    @Nullable
    private static Object a(@NotNull PyNumericLiteralExpression pyNumericLiteralExpression) {
        BigInteger bigInteger;
        if (pyNumericLiteralExpression == null) {
            PyEvaluator.a(0);
        }
        if (pyNumericLiteralExpression.isIntegerLiteral() && (bigInteger = pyNumericLiteralExpression.getBigIntegerValue()) != null) {
            return PyEvaluator.a(bigInteger);
        }
        return null;
    }

    @Nullable
    private Object a(@NotNull PyBinaryExpression pyBinaryExpression) {
        if (pyBinaryExpression == null) {
            PyEvaluator.a(1);
        }
        PyElementType pyElementType = pyBinaryExpression.getOperator();
        Object object = this.evaluate(pyBinaryExpression.getLeftExpression());
        Object object2 = this.evaluate(pyBinaryExpression.getRightExpression());
        if (pyElementType == PyTokenTypes.PLUS && object != null && object2 != null) {
            return this.applyPlus(object, object2);
        }
        if (object instanceof Number && object2 instanceof Number) {
            BigInteger bigInteger = PyEvaluator.a((Number)object);
            BigInteger bigInteger2 = PyEvaluator.a((Number)object2);
            if (pyElementType == PyTokenTypes.MINUS) {
                return PyEvaluator.a(bigInteger.subtract(bigInteger2));
            }
            if (pyElementType == PyTokenTypes.MULT) {
                return PyEvaluator.a(bigInteger.multiply(bigInteger2));
            }
            if (pyElementType == PyTokenTypes.FLOORDIV) {
                return PyEvaluator.a(bigInteger.divide(bigInteger2));
            }
            if (pyElementType == PyTokenTypes.LT) {
                return bigInteger.compareTo(bigInteger2) < 0;
            }
            if (pyElementType == PyTokenTypes.LE) {
                return bigInteger.compareTo(bigInteger2) <= 0;
            }
            if (pyElementType == PyTokenTypes.GT) {
                return bigInteger.compareTo(bigInteger2) > 0;
            }
            if (pyElementType == PyTokenTypes.GE) {
                return bigInteger.compareTo(bigInteger2) >= 0;
            }
            if (pyElementType == PyTokenTypes.EQEQ) {
                return bigInteger.compareTo(bigInteger2) == 0;
            }
            if (pyElementType == PyTokenTypes.NE) {
                return bigInteger.compareTo(bigInteger2) != 0;
            }
        } else if (object instanceof Boolean && object2 instanceof Boolean) {
            Boolean bl2 = (Boolean)object;
            Boolean bl3 = (Boolean)object2;
            if (pyElementType == PyTokenTypes.AND_KEYWORD) {
                return bl2 != false && bl3 != false;
            }
            if (pyElementType == PyTokenTypes.OR_KEYWORD) {
                return bl2 != false || bl3 != false;
            }
        }
        return null;
    }

    @Nullable
    private static Boolean d(@NotNull PyExpression pyExpression) {
        long l2 = j ^ 0x7A9507E4A2B4L;
        if (pyExpression == null) {
            PyEvaluator.a(2);
        }
        if (pyExpression instanceof PyBoolLiteralExpression) {
            return ((PyBoolLiteralExpression)pyExpression).getValue();
        }
        if (pyExpression instanceof PyReferenceExpression && LanguageLevel.forElement((PsiElement)pyExpression).isPython2()) {
            String string = ((PyQualifiedExpression)pyExpression).getReferencedName();
            if ("True".equals(string)) {
                return true;
            }
            if ("False".equals(string)) {
                return false;
            }
        }
        return null;
    }

    @Nullable
    private Object a(@NotNull PyPrefixExpression pyPrefixExpression) {
        Boolean bl2;
        if (pyPrefixExpression == null) {
            PyEvaluator.a(3);
        }
        if (pyPrefixExpression.getOperator() == PyTokenTypes.NOT_KEYWORD && (bl2 = PyUtil.as(this.evaluate(pyPrefixExpression.getOperand()), Boolean.class)) != null) {
            return bl2 == false;
        }
        return null;
    }

    @NotNull
    protected Object evaluateSequence(@NotNull PySequenceExpression expression) {
        if (expression == null) {
            PyEvaluator.a(4);
        }
        if (expression instanceof PyDictLiteralExpression) {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (PyKeyValueExpression pyKeyValueExpression : ((PyDictLiteralExpression)expression).getElements()) {
                this.a(hashMap, pyKeyValueExpression.getKey(), pyKeyValueExpression.getValue());
            }
            HashMap<Object, Object> hashMap2 = hashMap;
            if (hashMap2 == null) {
                PyEvaluator.a(5);
            }
            return hashMap2;
        }
        List list2 = ContainerUtil.map((Object[])expression.getElements(), pyExpression -> this.e ? this.evaluate((PyExpression)pyExpression) : pyExpression);
        if (list2 == null) {
            PyEvaluator.a(6);
        }
        return list2;
    }

    @Nullable
    public Object applyPlus(@Nullable Object lhs, @Nullable Object rhs) {
        if (lhs instanceof String && rhs instanceof String) {
            return (String)lhs + rhs;
        }
        if (lhs instanceof List && rhs instanceof List) {
            return ContainerUtil.concat((List)((List)lhs), (List)((List)rhs));
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            BigInteger bigInteger = PyEvaluator.a((Number)lhs);
            BigInteger bigInteger2 = PyEvaluator.a((Number)rhs);
            return PyEvaluator.a(bigInteger.add(bigInteger2));
        }
        return null;
    }

    @Nullable
    protected Object evaluateReference(@NotNull PyReferenceExpression expression) {
        if (expression == null) {
            PyEvaluator.a(7);
        }
        if (!expression.isQualified()) {
            if (this.c != null) {
                return this.c.get(expression.getReferencedName());
            }
            if (!this.f) {
                return null;
            }
            ResolveResult[] resolveResultArray = expression.getReference(PyResolveContext.noImplicits()).multiResolve(false);
            if (resolveResultArray.length != 1) {
                return null;
            }
            Object object = resolveResultArray[0].getElement();
            if (object instanceof PyTargetExpression) {
                object = ((PyTargetExpression)object).findAssignedValue();
            }
            if (object instanceof PyExpression) {
                return this.evaluate((PyExpression)object);
            }
        }
        return null;
    }

    @Nullable
    protected Object evaluateCall(@NotNull PyCallExpression expression) {
        Object object2;
        Object object3;
        Object object4;
        long l2 = j ^ 0xC61CC65F3C0L;
        if (expression == null) {
            PyEvaluator.a(8);
        }
        PyExpression[] pyExpressionArray = expression.getArguments();
        if (expression.isCalleeText("replace") && pyExpressionArray.length == 2 && (object4 = expression.getCallee()) instanceof PyQualifiedExpression && (object3 = this.evaluate(((PyQualifiedExpression)object4).getQualifier())) instanceof String) {
            object2 = this.evaluate(pyExpressionArray[0]);
            Object object = this.evaluate(pyExpressionArray[1]);
            if (object2 instanceof String && object instanceof String) {
                return ((String)object3).replace((String)object2, (String)object);
            }
        }
        if (this.f && expression.isCallee(PythonFQDNNames.DICT_CLASS)) {
            object4 = PsiTreeUtil.findChildrenOfType((PsiElement)expression, PyTupleExpression.class);
            if (!object4.isEmpty()) {
                object3 = new HashMap();
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    PyTupleExpression pyTupleExpression = (PyTupleExpression)object2.next();
                    PsiElement[] psiElementArray = pyTupleExpression.getChildren();
                    if (psiElementArray.length != 2) {
                        return null;
                    }
                    PyExpression pyExpression = PyUtil.as(psiElementArray[0], PyExpression.class);
                    PyExpression pyExpression2 = PyUtil.as(psiElementArray[1], PyExpression.class);
                    if (pyExpression == null) continue;
                    this.a((Map<Object, Object>)object3, pyExpression, pyExpression2);
                }
                return object3;
            }
            object3 = expression.getArguments();
            if (((PyExpression[])object3).length > 0) {
                object2 = new HashMap();
                for (PyExpression pyExpression : object3) {
                    PyKeywordArgument pyKeywordArgument;
                    String string;
                    if (!(pyExpression instanceof PyKeywordArgument) || (string = (pyKeywordArgument = (PyKeywordArgument)pyExpression).getKeyword()) == null) continue;
                    this.a((Map<Object, Object>)object2, string, pyKeywordArgument.getValueExpression());
                }
                return object2;
            }
        }
        return null;
    }

    private void a(@NotNull Map<Object, Object> map2, @NotNull PyExpression pyExpression, @Nullable PyExpression pyExpression2) {
        if (map2 == null) {
            PyEvaluator.a(9);
        }
        if (pyExpression == null) {
            PyEvaluator.a(10);
        }
        map2.put(this.a ? this.evaluate(pyExpression) : pyExpression, this.e ? this.b(pyExpression2) : pyExpression2);
    }

    private void a(@NotNull Map<Object, Object> map2, @NotNull String string, @Nullable PyExpression pyExpression) {
        if (map2 == null) {
            PyEvaluator.a(11);
        }
        if (string == null) {
            PyEvaluator.a(12);
        }
        map2.put(string, this.e ? this.b(pyExpression) : pyExpression);
    }

    @NotNull
    private static BigInteger a(@NotNull Number number) {
        if (number == null) {
            PyEvaluator.a(13);
        }
        BigInteger bigInteger = number instanceof Integer ? BigInteger.valueOf(((Integer)number).intValue()) : (number instanceof Long ? BigInteger.valueOf((Long)number) : (BigInteger)number);
        if (bigInteger == null) {
            PyEvaluator.a(14);
        }
        return bigInteger;
    }

    @NotNull
    private static Number a(@NotNull BigInteger bigInteger) {
        int n2;
        if (bigInteger == null) {
            PyEvaluator.a(15);
        }
        if (BigInteger.valueOf(n2 = bigInteger.intValue()).equals(bigInteger)) {
            Integer n3 = n2;
            if (n3 == null) {
                PyEvaluator.a(16);
            }
            return n3;
        }
        long l2 = bigInteger.longValue();
        if (BigInteger.valueOf(l2).equals(bigInteger)) {
            Long l3 = l2;
            if (l3 == null) {
                PyEvaluator.a(17);
            }
            return l3;
        }
        BigInteger bigInteger2 = bigInteger;
        if (bigInteger2 == null) {
            PyEvaluator.a(18);
        }
        return bigInteger2;
    }

    @Nullable
    public static <T> T evaluate(@Nullable PyExpression expression, @NotNull Class<T> resultType) {
        if (resultType == null) {
            PyEvaluator.a(19);
        }
        return PyUtil.as(new PyEvaluator().evaluate(expression), resultType);
    }

    @Nullable
    public static <T> T evaluateNoResolve(@Nullable PyExpression expression, @NotNull Class<T> resultType) {
        if (resultType == null) {
            PyEvaluator.a(20);
        }
        PyEvaluator pyEvaluator = new PyEvaluator();
        pyEvaluator.enableResolve(false);
        return PyUtil.as(pyEvaluator.evaluate(expression), resultType);
    }

    @Nullable
    public static Boolean evaluateAsBoolean(@Nullable PyExpression expression) {
        return PyEvaluator.a(PyEvaluator.a(true), expression);
    }

    @Nullable
    public static Boolean evaluateAsBooleanNoResolve(@Nullable PyExpression expression) {
        return PyEvaluator.a(PyEvaluator.a(false), expression);
    }

    public static boolean evaluateAsBoolean(@Nullable PyExpression expression, boolean defaultValue) {
        return (Boolean)ObjectUtils.notNull((Object)PyEvaluator.evaluateAsBoolean(expression), (Object)defaultValue);
    }

    public static boolean evaluateAsBooleanNoResolve(@Nullable PyExpression expression, boolean defaultValue) {
        return (Boolean)ObjectUtils.notNull((Object)PyEvaluator.evaluateAsBooleanNoResolve(expression), (Object)defaultValue);
    }

    @NotNull
    private static PyEvaluator a(boolean bl2) {
        PyEvaluator pyEvaluator = new PyEvaluator();
        pyEvaluator.setEvaluateCollectionItems(false);
        pyEvaluator.setEvaluateKeys(false);
        pyEvaluator.enableResolve(bl2);
        PyEvaluator pyEvaluator2 = pyEvaluator;
        if (pyEvaluator2 == null) {
            PyEvaluator.a(21);
        }
        return pyEvaluator2;
    }

    @Nullable
    private static Boolean a(@NotNull PyEvaluator pyEvaluator, @Nullable PyExpression pyExpression) {
        Object object;
        if (pyEvaluator == null) {
            PyEvaluator.a(22);
        }
        if ((object = pyEvaluator.evaluate(pyExpression)) instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Integer) {
            return (Integer)object != 0;
        }
        if (object instanceof String) {
            return !((String)object).isEmpty();
        }
        if (object instanceof Collection) {
            return !((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return !((Map)object).isEmpty();
        }
        return null;
    }

    @Nullable
    private Object b(@Nullable PyExpression pyExpression) {
        Object object = this.evaluate(pyExpression);
        if (object != null) {
            return object;
        }
        return this.d ? pyExpression : null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = j ^ 0x478F9C76B414L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyEvaluator";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyEvaluator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSequence";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toBigInteger";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "fromBigInteger";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareEvaluatorForBoolean";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNumeric";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "evaluateBinary";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "evaluateBoolean";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePrefix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSequence";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "evaluateReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCall";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addRecordFromDict";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toBigInteger";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fromBigInteger";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNoResolve";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAsBoolean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

