/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorProvider;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyDynamicallyEvaluatedType;
import com.jetbrains.python.psi.types.PyFunctionTypeImpl;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import icons.PythonIcons;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFunctionImpl
extends PyBaseElementImpl<PyFunctionStub>
implements PyFunction {
    private static final Key<CachedValue<List<PyAssignmentStatement>>> c;
    @NotNull
    private final CachedStructuredDocStringProvider b = new CachedStructuredDocStringProvider();
    @Nullable
    private volatile Boolean a;
    private static final long f;

    public PyFunctionImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyFunctionImpl(PyFunctionStub stub) {
        this(stub, (IStubElementType)PyElementTypes.FUNCTION_DECLARATION);
    }

    public PyFunctionImpl(PyFunctionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Nullable
    public String getName() {
        PyFunctionStub pyFunctionStub = (PyFunctionStub)this.getStub();
        if (pyFunctionStub != null) {
            return pyFunctionStub.getName();
        }
        ASTNode aSTNode = this.getNameNode();
        return aSTNode != null ? aSTNode.getText() : null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode aSTNode = this.getNameNode();
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PyFunctionImpl.a(0);
        }
        ASTNode aSTNode = PyUtil.createNewName(this, name);
        ASTNode aSTNode2 = this.getNameNode();
        if (aSTNode2 != null) {
            this.getNode().replaceChild(aSTNode2, aSTNode);
        }
        PyFunctionImpl pyFunctionImpl = this;
        if (pyFunctionImpl == null) {
            PyFunctionImpl.a(1);
        }
        return pyFunctionImpl;
    }

    public Icon getIcon(int flags) {
        PyPsiUtils.assertValid(this);
        Property property = this.getProperty();
        if (property != null) {
            if (property.getGetter().valueOrNull() == this) {
                return PythonIcons.Python.PropertyGetter;
            }
            if (property.getSetter().valueOrNull() == this) {
                return PythonIcons.Python.PropertySetter;
            }
            if (property.getDeleter().valueOrNull() == this) {
                return PythonIcons.Python.PropertyDeleter;
            }
            return PlatformIcons.PROPERTY_ICON;
        }
        if (this.getContainingClass() != null) {
            return PlatformIcons.METHOD_ICON;
        }
        return AllIcons.Nodes.Function;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        ASTNode aSTNode;
        ASTNode aSTNode2 = this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
        if (aSTNode2 == null && (aSTNode = this.getNode().findChildByType(TokenType.ERROR_ELEMENT)) != null) {
            aSTNode2 = aSTNode.findChildByType(PythonDialectsTokenSetProvider.INSTANCE.getKeywordTokens());
        }
        return aSTNode2;
    }

    @Override
    @NotNull
    public PyParameterList getParameterList() {
        PyParameterList pyParameterList = (PyParameterList)this.getRequiredStubOrPsiChild(PyElementTypes.PARAMETER_LIST);
        if (pyParameterList == null) {
            PyFunctionImpl.a(2);
        }
        return pyParameterList;
    }

    @Override
    @NotNull
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionImpl.a(3);
        }
        List list2 = Optional.ofNullable(context.getType(this)).filter(PyCallableType.class::isInstance).map(PyCallableType.class::cast).map(pyCallableType -> pyCallableType.getParameters(context)).orElseGet(() -> ContainerUtil.map((Object[])this.getParameterList().getParameters(), PyCallableParameterImpl::psi));
        if (list2 == null) {
            PyFunctionImpl.a(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public PyStatementList getStatementList() {
        long l2 = f ^ 0x423E42A1C6DFL;
        PyStatementList pyStatementList = (PyStatementList)this.childToPsi(PyElementTypes.STATEMENT_LIST);
        assert (pyStatementList != null) : "Statement list missing for function " + this.getText();
        PyStatementList pyStatementList2 = pyStatementList;
        if (pyStatementList2 == null) {
            PyFunctionImpl.a(5);
        }
        return pyStatementList2;
    }

    @Override
    @Nullable
    public PyClass getContainingClass() {
        PyFunctionStub pyFunctionStub = (PyFunctionStub)this.getStub();
        if (pyFunctionStub != null) {
            StubElement stubElement = pyFunctionStub.getParentStub();
            if (stubElement instanceof PyClassStub) {
                return (PyClass)((PyClassStub)stubElement).getPsi();
            }
            return null;
        }
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)this, StubBasedPsiElement.class);
        if (psiElement instanceof PyClass) {
            return (PyClass)psiElement;
        }
        return null;
    }

    @Override
    @Nullable
    public PyDecoratorList getDecoratorList() {
        return (PyDecoratorList)this.getStubOrPsiChild(PyElementTypes.DECORATOR_LIST);
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyFunctionImpl.a(6);
        }
        if (key == null) {
            PyFunctionImpl.a(7);
        }
        for (Ref<? extends PyType> ref : PyTypeProvider.EP_NAME.getExtensionList()) {
            Ref<PyType> ref2 = ref.getReturnType((PyCallable)this, context);
            if (ref2 == null) continue;
            return PyFunctionImpl.a(ref2, ref);
        }
        Object object = null;
        if (context.allowReturnTypes(this)) {
            Ref<? extends PyType> ref;
            ref = this.a(context);
            object = ref != null ? (PyType)ref.get() : this.getReturnStatementType(context);
        }
        if (this.getProperty() == null && PyKnownDecoratorUtil.hasUnknownOrChangingReturnTypeDecorator(this, context)) {
            object = PyUnionType.createWeakType(object);
        }
        return PyTypingTypeProvider.toAsyncIfNeeded(this, object);
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        Object object;
        Object object22;
        if (context == null) {
            PyFunctionImpl.a(8);
        }
        if (callSite == null) {
            PyFunctionImpl.a(9);
        }
        for (Object object22 : PyTypeProvider.EP_NAME.getExtensionList()) {
            object = object22.getCallType(this, callSite, context);
            if (object == null) continue;
            return PyFunctionImpl.a(object, (PyTypeProvider)object22);
        }
        PyExpression pyExpression = callSite.getReceiver(this);
        object22 = PyCallExpressionHelper.mapArguments(callSite, this, context);
        object = ((PyCallExpression.PyArgumentsMapping)object22).getMappedParameters();
        LinkedHashMap<PyExpression, PyCallableParameter> linkedHashMap = new LinkedHashMap<PyExpression, PyCallableParameter>();
        PyCallableParameter pyCallableParameter = (PyCallableParameter)ContainerUtil.getFirstItem(((PyCallExpression.PyArgumentsMapping)object22).getImplicitParameters());
        if (pyExpression != null && pyCallableParameter != null) {
            linkedHashMap.put(pyExpression, pyCallableParameter);
        }
        linkedHashMap.putAll((Map<PyExpression, PyCallableParameter>)object);
        return this.getCallType(pyExpression, linkedHashMap, context);
    }

    @Nullable
    private static PyType a(@NotNull Ref<PyType> ref, @NotNull PyTypeProvider pyTypeProvider) {
        PyType pyType;
        if (ref == null) {
            PyFunctionImpl.a(10);
        }
        if (pyTypeProvider == null) {
            PyFunctionImpl.a(11);
        }
        if ((pyType = (PyType)ref.get()) != null) {
            pyType.assertValid(pyTypeProvider.toString());
        }
        return pyType;
    }

    @Override
    @Nullable
    public PyType getCallType(@Nullable PyExpression receiver, @NotNull Map<PyExpression, PyCallableParameter> parameters, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            PyFunctionImpl.a(12);
        }
        if (context == null) {
            PyFunctionImpl.a(13);
        }
        return this.a(PyUtil.getReturnTypeToAnalyzeAsCallType(this, context), receiver, parameters, context);
    }

    @Nullable
    private PyType a(@Nullable PyType pyType, @Nullable PyExpression pyExpression, @NotNull Map<PyExpression, PyCallableParameter> map2, @NotNull TypeEvalContext typeEvalContext) {
        if (map2 == null) {
            PyFunctionImpl.a(14);
        }
        if (typeEvalContext == null) {
            PyFunctionImpl.a(15);
        }
        if (PyTypeChecker.hasGenerics(pyType, typeEvalContext)) {
            Map<PyGenericType, PyType> map3 = PyTypeChecker.unifyGenericCall(pyExpression, map2, typeEvalContext);
            pyType = map3 != null ? PyTypeChecker.substitute(pyType, map3, typeEvalContext) : null;
        }
        if (pyExpression != null) {
            pyType = this.a(pyType, pyExpression, typeEvalContext);
        }
        if (pyType != null && PyFunctionImpl.a(map2.values(), typeEvalContext)) {
            pyType = PyUnionType.createWeakType(pyType);
        }
        return pyType;
    }

    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this){
            private static final long b = com.jetbrains.python.psi.c.a(-6814588764435831643L, -3195978690389919545L, MethodHandles.lookup().lookupClass()).a(48489996461701L);

            @Override
            @NotNull
            public String getPresentableText() {
                long l2 = b ^ 0x7AC95DCDDC89L;
                String string = StringUtil.notNullize((String)PyFunctionImpl.this.getName(), (String)"<unnamed>") + PyFunctionImpl.this.getParameterList().getPresentableText(true);
                if (string == null) {
                    1.b(0);
                }
                return string;
            }

            @Override
            @Nullable
            public String getLocationString() {
                long l2 = b ^ 0x6C6FB02AB16FL;
                PyClass pyClass = PyFunctionImpl.this.getContainingClass();
                String string = 1.getPackageForFile(PyFunctionImpl.this.getContainingFile());
                if (pyClass != null && string != null) {
                    return String.format("(%s in %s)", pyClass.getName(), string);
                }
                return super.getLocationString();
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = b ^ 0x6CD4C4E0C1AAL;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionImpl$1", "getPresentableText"));
            }
        };
    }

    @Nullable
    private PyType a(@Nullable PyType pyType, @Nullable PyExpression pyExpression, @NotNull TypeEvalContext typeEvalContext) {
        if (typeEvalContext == null) {
            PyFunctionImpl.a(16);
        }
        return this.a(pyType, pyExpression, typeEvalContext, true);
    }

    @Nullable
    private PyType a(@Nullable PyType pyType2, @Nullable PyExpression pyExpression, @NotNull TypeEvalContext typeEvalContext, boolean bl2) {
        if (typeEvalContext == null) {
            PyFunctionImpl.a(17);
        }
        if (pyExpression != null) {
            if (pyType2 instanceof PyClassType) {
                PyClassType pyClassType = (PyClassType)pyType2;
                if (pyClassType.getPyClass() == this.getContainingClass()) {
                    PyClassType pyClassType2;
                    PyType pyType3 = typeEvalContext.getType(pyExpression);
                    if (pyType3 instanceof PyClassType && (pyClassType2 = (PyClassType)pyType3).getPyClass() != pyClassType.getPyClass() && PyTypeChecker.match(pyClassType.toClass(), pyClassType2.toClass(), typeEvalContext)) {
                        return pyClassType.isDefinition() ? pyClassType2.toClass() : pyClassType2.toInstance();
                    }
                } else if (bl2 && pyType2 instanceof PyCollectionType && PyTypingTypeProvider.coroutineOrGeneratorElementType(pyType2) != null) {
                    List list2 = ContainerUtil.map(((PyCollectionType)pyType2).getElementTypes(), pyType -> this.a((PyType)pyType, pyExpression, typeEvalContext, false));
                    return new PyCollectionTypeImpl(pyClassType.getPyClass(), pyClassType.isDefinition(), list2);
                }
            } else if (pyType2 instanceof PyUnionType) {
                Collection<PyType> collection = ((PyUnionType)pyType2).getMembers();
                return PyUnionType.union(ContainerUtil.map(collection, pyType -> this.a((PyType)pyType, pyExpression, typeEvalContext, true)));
            }
        }
        return pyType2;
    }

    private static boolean a(@NotNull Collection<PyCallableParameter> collection, @NotNull TypeEvalContext typeEvalContext) {
        if (collection == null) {
            PyFunctionImpl.a(18);
        }
        if (typeEvalContext == null) {
            PyFunctionImpl.a(19);
        }
        for (PyCallableParameter pyCallableParameter : collection) {
            PyType pyType = pyCallableParameter.getType(typeEvalContext);
            if (!(pyType instanceof PyDynamicallyEvaluatedType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Ref<? extends PyType> a(final @NotNull TypeEvalContext typeEvalContext) {
        if (typeEvalContext == null) {
            PyFunctionImpl.a(20);
        }
        final PyBuiltinCache pyBuiltinCache = PyBuiltinCache.getInstance(this);
        PyStatementList pyStatementList = this.getStatementList();
        final LinkedHashSet<PyType> linkedHashSet = new LinkedHashSet<PyType>();
        pyStatementList.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyYieldExpression(PyYieldExpression node) {
                PyType pyType;
                PyExpression pyExpression = node.getExpression();
                PyType pyType2 = pyType = pyExpression != null ? typeEvalContext.getType(pyExpression) : null;
                if (node.isDelegating()) {
                    if (pyType instanceof PyCollectionType) {
                        linkedHashSet.add(((PyCollectionType)pyType).getIteratedItemType());
                    } else if (ArrayUtil.contains((Object)pyType, (Object[])new PyType[]{pyBuiltinCache.getListType(), pyBuiltinCache.getDictType(), pyBuiltinCache.getSetType(), pyBuiltinCache.getTupleType()})) {
                        linkedHashSet.add(null);
                    } else {
                        linkedHashSet.add(pyType);
                    }
                } else {
                    linkedHashSet.add(pyType);
                }
            }

            @Override
            public void visitPyFunction(PyFunction node) {
            }
        });
        if (!linkedHashSet.isEmpty()) {
            PyType pyType = PyUnionType.union(linkedHashSet);
            PyType pyType2 = this.getReturnStatementType(typeEvalContext);
            return Ref.create((Object)PyTypingTypeProvider.wrapInGeneratorType(pyType, pyType2, this));
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getReturnStatementType(@NotNull TypeEvalContext context) {
        long l2 = f ^ 0x3C7FF3C26116L;
        if (context == null) {
            PyFunctionImpl.a(21);
        }
        ReturnVisitor returnVisitor = new ReturnVisitor(this, context);
        PyStatementList pyStatementList = this.getStatementList();
        pyStatementList.accept(returnVisitor);
        if ((this.d() || PyKnownDecoratorUtil.hasAbstractDecorator(this, context)) && !returnVisitor.c) {
            if ("__init__".equals(this.getName())) {
                return PyNoneType.INSTANCE;
            }
            return null;
        }
        return returnVisitor.result();
    }

    @Override
    @Nullable
    public PyFunction asMethod() {
        if (this.getContainingClass() != null) {
            return this;
        }
        return null;
    }

    @Override
    @Nullable
    public String getDeprecationMessage() {
        PyFunctionStub pyFunctionStub = (PyFunctionStub)this.getStub();
        if (pyFunctionStub != null) {
            return pyFunctionStub.getDeprecationMessage();
        }
        return this.extractDeprecationMessage();
    }

    @Nullable
    public String extractDeprecationMessage() {
        PyStatementList pyStatementList = this.getStatementList();
        return PyFunctionImpl.extractDeprecationMessage(Arrays.asList(pyStatementList.getStatements()));
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyFunctionImpl.a(22);
        }
        if (key == null) {
            PyFunctionImpl.a(23);
        }
        for (PyTypeProvider pyTypeProvider : PyTypeProvider.EP_NAME.getExtensionList()) {
            PyType pyType = pyTypeProvider.getCallableType(this, context);
            if (pyType == null) continue;
            return pyType;
        }
        return new PyFunctionTypeImpl(this);
    }

    @Nullable
    public static String extractDeprecationMessage(List<? extends PyStatement> statements) {
        long l2 = f ^ 0x7C612CBFB73CL;
        for (PyStatement pyStatement : statements) {
            PyReferenceExpression pyReferenceExpression;
            PyCallExpression pyCallExpression;
            PyExpressionStatement pyExpressionStatement;
            if (!(pyStatement instanceof PyExpressionStatement) || !((pyExpressionStatement = (PyExpressionStatement)pyStatement).getExpression() instanceof PyCallExpression) || !(pyCallExpression = (PyCallExpression)pyExpressionStatement.getExpression()).isCalleeText("warn") || (pyReferenceExpression = pyCallExpression.getArgument(1, PyReferenceExpression.class)) == null || !"DeprecationWarning".equals(pyReferenceExpression.getReferencedName()) && !"PendingDeprecationWarning".equals(pyReferenceExpression.getReferencedName())) continue;
            return PyPsiUtils.strValue(pyCallExpression.getArguments()[0]);
        }
        return null;
    }

    @Override
    public String getDocStringValue() {
        PyFunctionStub pyFunctionStub = (PyFunctionStub)this.getStub();
        if (pyFunctionStub != null) {
            return pyFunctionStub.getDocString();
        }
        return DocStringUtil.getDocStringValue(this);
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return (StructuredDocString)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)this.b);
    }

    private boolean d() {
        long l2 = f ^ 0x47D0C7A45C93L;
        VirtualFile virtualFile = this.getContainingFile().getVirtualFile();
        return virtualFile != null && (virtualFile = virtualFile.getParent()) != null && (virtualFile = virtualFile.getParent()) != null && virtualFile.getName().equals("python_stubs");
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyFunction(this);
    }

    public int getTextOffset() {
        ASTNode aSTNode = this.getNameNode();
        return aSTNode != null ? aSTNode.getStartOffset() : super.getTextOffset();
    }

    @Override
    @Nullable
    public PyStringLiteralExpression getDocStringExpression() {
        PyStatementList pyStatementList = this.getStatementList();
        return DocStringUtil.findDocStringExpression(pyStatementList);
    }

    @Override
    public String toString() {
        long l2 = f ^ 0x2E68FC9B225BL;
        return super.toString() + "('" + this.getName() + "')";
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        ControlFlowCache.clear(this);
        this.a = null;
    }

    @Override
    @Nullable
    public Property getProperty() {
        PyClass pyClass = this.getContainingClass();
        if (pyClass != null) {
            return pyClass.findPropertyByCallable(this);
        }
        return null;
    }

    @Override
    public PyAnnotation getAnnotation() {
        return (PyAnnotation)this.getStubOrPsiChild(PyElementTypes.ANNOTATION);
    }

    @Override
    @Nullable
    public String getAnnotationValue() {
        return PyFunctionImpl.getAnnotationContentFromStubOrPsi(this);
    }

    @Override
    @Nullable
    public PsiComment getTypeComment() {
        PsiComment psiComment;
        PsiComment psiComment2 = PyUtil.getCommentOnHeaderLine(this);
        if (psiComment2 != null && PyTypingTypeProvider.getTypeCommentValue(psiComment2.getText()) != null) {
            return psiComment2;
        }
        PyStatementList pyStatementList = this.getStatementList();
        if (pyStatementList.getStatements().length != 0 && (psiComment = PyUtil.as(pyStatementList.getFirstChild(), PsiComment.class)) != null && PyTypingTypeProvider.getTypeCommentValue(psiComment.getText()) != null) {
            return psiComment;
        }
        return null;
    }

    @Override
    @Nullable
    public String getTypeCommentAnnotation() {
        return PyFunctionImpl.getTypeCommentAnnotationFromStubOrPsi(this);
    }

    @NotNull
    public SearchScope getUseScope() {
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(this);
        if (scopeOwner instanceof PyFunction) {
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)scopeOwner);
            if (localSearchScope == null) {
                PyFunctionImpl.a(24);
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            PyFunctionImpl.a(25);
        }
        return searchScope;
    }

    @Override
    @Nullable
    public PyFunction.Modifier getModifier() {
        Object object;
        Object object2;
        long l2 = f ^ 0x1D5B14F028C9L;
        String string2 = this.c();
        if ("classmethod".equals(string2)) {
            return PyFunction.Modifier.CLASSMETHOD;
        }
        if ("staticmethod".equals(string2)) {
            return PyFunction.Modifier.STATICMETHOD;
        }
        String string3 = this.getName();
        PyClass pyClass = this.getContainingClass();
        if (pyClass != null) {
            if ("__new__".equals(string3) && pyClass.isNewStyleClass(null)) {
                return PyFunction.Modifier.STATICMETHOD;
            }
            object2 = LanguageLevel.forElement(this);
            if ("__init_subclass__".equals(string3) && ((LanguageLevel)((Object)object2)).isAtLeast(LanguageLevel.PYTHON36)) {
                return PyFunction.Modifier.CLASSMETHOD;
            }
            if ("__class_getitem__".equals(string3) && ((LanguageLevel)((Object)object2)).isAtLeast(LanguageLevel.PYTHON37)) {
                return PyFunction.Modifier.CLASSMETHOD;
            }
            object = TypeEvalContext.codeInsightFallback(this.getProject());
            for (PyKnownDecoratorUtil.KnownDecorator knownDecorator : PyKnownDecoratorUtil.getKnownDecorators(this, (TypeEvalContext)object)) {
                if (knownDecorator == PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTCLASSMETHOD) {
                    return PyFunction.Modifier.CLASSMETHOD;
                }
                if (knownDecorator != PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTSTATICMETHOD) continue;
                return PyFunction.Modifier.STATICMETHOD;
            }
        }
        if ((object2 = (PyFunctionStub)this.getStub()) != null) {
            return PyFunctionImpl.a((PyFunctionStub)object2);
        }
        if (string3 != null) {
            object = (PyAssignmentStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)this, PyAssignmentStatement.class);
            while (object != null) {
                String string4 = object.getTargetsToValuesMapping().stream().filter(pair -> pair.getFirst() instanceof PyTargetExpression && string3.equals(((PyExpression)pair.getFirst()).getName())).filter(pair -> pair.getSecond() instanceof PyCallExpression).map(pair -> PyCallExpressionHelper.interpretAsModifierWrappingCall((PyCallExpression)pair.getSecond())).filter(pair -> pair != null && pair.getSecond() == this).map(pair -> (String)pair.getFirst()).filter(string -> {
                    long l2 = f ^ 0x74B28F43BA70L;
                    return "classmethod".equals(string) || "staticmethod".equals(string);
                }).findAny().orElse(null);
                if ("classmethod".equals(string4)) {
                    return PyFunction.Modifier.CLASSMETHOD;
                }
                if ("staticmethod".equals(string4)) {
                    return PyFunction.Modifier.STATICMETHOD;
                }
                object = (PyAssignmentStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)object, PyAssignmentStatement.class);
            }
        }
        return null;
    }

    @Override
    public boolean isGenerator() {
        PyFunctionStub pyFunctionStub = (PyFunctionStub)this.getStub();
        if (pyFunctionStub != null) {
            return pyFunctionStub.isGenerator();
        }
        Boolean bl2 = this.a;
        if (bl2 == null) {
            final Ref ref = Ref.create((Object)false);
            this.getStatementList().accept(new PyRecursiveElementVisitor(){

                @Override
                public void visitPyYieldExpression(PyYieldExpression node) {
                    ref.set((Object)true);
                }

                @Override
                public void visitPyFunction(PyFunction node) {
                }

                @Override
                public void visitElement(PsiElement element) {
                    if (!((Boolean)ref.get()).booleanValue()) {
                        super.visitElement(element);
                    }
                }
            });
            this.a = bl2 = (Boolean)ref.get();
        }
        return bl2;
    }

    @Override
    public boolean isAsync() {
        PyFunctionStub pyFunctionStub = (PyFunctionStub)this.getStub();
        if (pyFunctionStub != null) {
            return pyFunctionStub.isAsync();
        }
        return this.getNode().findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD) != null;
    }

    @Override
    public boolean isAsyncAllowed() {
        long l2 = f ^ 0x23175FC4A309L;
        LanguageLevel languageLevel = LanguageLevel.forElement(this);
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON35)) {
            return false;
        }
        String string = this.getName();
        if (string == null || ArrayUtil.contains((String)string, (String[])new String[]{"__aiter__", "__anext__", "__aenter__", "__aexit__", "__call__"})) {
            return true;
        }
        ImmutableMap<String, PyNames.BuiltinDescription> immutableMap = this.asMethod() != null ? PyNames.getBuiltinMethods(languageLevel) : PyNames.getModuleBuiltinMethods(languageLevel);
        return !immutableMap.containsKey((Object)string);
    }

    @Override
    public boolean onlyRaisesNotImplementedError() {
        PyFunctionStub pyFunctionStub = (PyFunctionStub)this.getStub();
        if (pyFunctionStub != null) {
            return pyFunctionStub.onlyRaisesNotImplementedError();
        }
        PyStatement[] pyStatementArray = this.getStatementList().getStatements();
        return pyStatementArray.length == 1 && PyFunctionImpl.a(pyStatementArray[0]) || pyStatementArray.length == 2 && PyUtil.isStringLiteral(pyStatementArray[0]) && PyFunctionImpl.a(pyStatementArray[1]);
    }

    private static boolean a(@NotNull PyStatement pyStatement) {
        PyExpression pyExpression;
        PyExpression pyExpression2;
        long l2 = f ^ 0x16694AA82B88L;
        if (pyStatement == null) {
            PyFunctionImpl.a(26);
        }
        return (pyExpression2 = (PyExpression)Optional.ofNullable(PyUtil.as(pyStatement, PyRaiseStatement.class)).map(PyRaiseStatement::getExpressions).filter(pyExpressionArray -> ((PyExpression[])pyExpressionArray).length == 1).map(pyExpressionArray -> pyExpressionArray[0]).orElse(null)) instanceof PyCallExpression ? (pyExpression = ((PyCallExpression)pyExpression2).getCallee()) != null && pyExpression.getText().equals("NotImplementedError") : pyExpression2 != null && pyExpression2.getText().equals("NotImplementedError");
    }

    @Nullable
    private static PyFunction.Modifier a(@NotNull PyFunctionStub pyFunctionStub) {
        if (pyFunctionStub == null) {
            PyFunctionImpl.a(27);
        }
        return (PyFunction.Modifier)((Object)JBIterable.of((Object)pyFunctionStub.getParentStub()).flatMap(stubElement -> stubElement.getChildrenStubs()).skipWhile(stubElement -> !pyFunctionStub.equals(stubElement)).transform(stubElement -> PyUtil.as(stubElement, PyTargetExpressionStub.class)).filter(Objects::nonNull).filter(pyTargetExpressionStub -> pyTargetExpressionStub.getInitializerType() == PyTargetExpressionStub.InitializerType.CallExpression && Objects.equals(pyFunctionStub.getName(), pyTargetExpressionStub.getName())).transform(PyTargetExpressionStub::getInitializer).transform(qualifiedName -> {
            long l2 = f ^ 0x778882C16552L;
            if (qualifiedName == null) {
                return null;
            }
            if (qualifiedName.matches(new String[]{"classmethod"})) {
                return PyFunction.Modifier.CLASSMETHOD;
            }
            if (qualifiedName.matches(new String[]{"staticmethod"})) {
                return PyFunction.Modifier.STATICMETHOD;
            }
            return null;
        }).find(Objects::nonNull));
    }

    @Nullable
    private String c() {
        PyDecorator[] pyDecoratorArray;
        long l2 = f ^ 0x697D529B1FE0L;
        PyDecoratorList pyDecoratorList = this.getDecoratorList();
        if (pyDecoratorList != null && (pyDecoratorArray = pyDecoratorList.getDecorators()).length > 0) {
            for (int i10 = pyDecoratorArray.length - 1; i10 >= 0; --i10) {
                PyDecorator pyDecorator = pyDecoratorArray[i10];
                String string = pyDecorator.getName();
                if ("classmethod".equals(string) || "staticmethod".equals(string)) {
                    return string;
                }
                for (PyKnownDecoratorProvider pyKnownDecoratorProvider : PyUtil.KnownDecoratorProviderHolder.KNOWN_DECORATOR_PROVIDERS) {
                    String string2 = pyKnownDecoratorProvider.toKnownDecorator(string);
                    if (string2 == null) continue;
                    return string2;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return QualifiedNameFinder.getQualifiedName(this);
    }

    @Override
    @NotNull
    public List<PyAssignmentStatement> findAttributes() {
        List list2 = (List)CachedValuesManager.getManager((Project)this.getProject()).getCachedValue((UserDataHolder)this, c, () -> {
            List<PyAssignmentStatement> list2 = PyFunctionImpl.a(this);
            return CachedValueProvider.Result.create(list2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
        if (list2 == null) {
            PyFunctionImpl.a(28);
        }
        return list2;
    }

    @NotNull
    private static List<PyAssignmentStatement> a(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PyFunctionImpl.a(29);
        }
        ArrayList<PyAssignmentStatement> arrayList = new ArrayList<PyAssignmentStatement>();
        for (PyAssignmentStatement pyAssignmentStatement : new PsiQuery<PsiElement>(psiElement).siblings(PyAssignmentStatement.class).getElements()) {
            for (PyQualifiedExpression pyQualifiedExpression : new PsiQuery<PyExpression[]>(pyAssignmentStatement.getTargets()).filter(new PsiQuery.PsiFilter<PyQualifiedExpression>(PyQualifiedExpression.class)).getElements()) {
                PsiReference psiReference;
                PyExpression pyExpression = pyQualifiedExpression.getQualifier();
                if (pyExpression == null || (psiReference = pyExpression.getReference()) == null || !psiReference.isReferenceTo(psiElement)) continue;
                arrayList.add(pyAssignmentStatement);
            }
        }
        ArrayList<PyAssignmentStatement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PyFunctionImpl.a(30);
        }
        return arrayList2;
    }

    @Override
    @NotNull
    public PyFunction.ProtectionLevel getProtectionLevel() {
        int n2 = PyUtil.getInitialUnderscores(this.getName());
        for (PyFunction.ProtectionLevel protectionLevel : PyFunction.ProtectionLevel.values()) {
            if (protectionLevel.getUnderscoreLevel() != n2) continue;
            PyFunction.ProtectionLevel protectionLevel2 = protectionLevel;
            if (protectionLevel2 == null) {
                PyFunctionImpl.a(31);
            }
            return protectionLevel2;
        }
        PyFunction.ProtectionLevel protectionLevel = PyFunction.ProtectionLevel.PRIVATE;
        if (protectionLevel == null) {
            PyFunctionImpl.a(32);
        }
        return protectionLevel;
    }

    static {
        f = com.jetbrains.python.psi.c.a(-6083246285962881512L, -1749707919479133755L, MethodHandles.lookup().lookupClass()).a(143221625516846L);
        long l2 = f ^ 0x6FDAFA3E724AL;
        c = Key.create((String)"attributes");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x1F74F1E0F0A2L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyFunctionImpl";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRef";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProvider";
                break;
            }
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyFunctionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementList";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttributes";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttributesStatic";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtectionLevel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "derefType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "analyzeCallType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceSelf";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicallyEvaluated";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getYieldStatementType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReturnStatementType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isRaiseNotImplementedError";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getModifierFromStub";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findAttributesStatic";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReturnVisitor
    extends PyRecursiveElementVisitor {
        private final PyFunction e;
        private final TypeEvalContext b;
        private PyType d = null;
        private boolean c = false;
        private boolean a = false;

        private ReturnVisitor(PyFunction function, TypeEvalContext context) {
            this.e = function;
            this.b = context;
        }

        @Override
        public void visitPyReturnStatement(PyReturnStatement node) {
            if (ScopeUtil.getScopeOwner((PsiElement)node) == this.e) {
                PyNoneType pyNoneType;
                PyExpression pyExpression = node.getExpression();
                PyType pyType = pyNoneType = pyExpression == null ? PyNoneType.INSTANCE : this.b.getType(pyExpression);
                if (!this.c) {
                    this.d = pyNoneType;
                    this.c = true;
                } else {
                    this.d = PyUnionType.union(this.d, pyNoneType);
                }
            }
        }

        @Override
        public void visitPyRaiseStatement(PyRaiseStatement node) {
            this.a = true;
        }

        @Nullable
        PyType result() {
            return this.c || this.a ? this.d : PyNoneType.INSTANCE;
        }
    }

    private class CachedStructuredDocStringProvider
    implements CachedValueProvider<StructuredDocString> {
        private CachedStructuredDocStringProvider() {
        }

        @Nullable
        public CachedValueProvider.Result<StructuredDocString> compute() {
            PyFunctionImpl pyFunctionImpl = PyFunctionImpl.this;
            return CachedValueProvider.Result.create((Object)DocStringUtil.getStructuredDocString(pyFunctionImpl), (Object[])new Object[]{pyFunctionImpl});
        }
    }
}

