/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.typing.PyStubPackages;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.PyResolveResultRater;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.PointInImport;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveImportUtil {
    private static final ThreadLocal<Set<String>> a;
    private static final long b;

    private ResolveImportUtil() {
    }

    public static boolean isAbsoluteImportEnabledFor(PsiElement foothold) {
        PsiFile psiFile;
        if (foothold != null && (psiFile = foothold.getContainingFile()) instanceof PyFile) {
            PyFile pyFile = (PyFile)psiFile;
            if (pyFile.getLanguageLevel().isPy3K()) {
                return true;
            }
            return pyFile.hasImportFromFuture(FutureFeature.ABSOLUTE_IMPORT);
        }
        return false;
    }

    @Nullable
    public static PsiDirectory stepBackFrom(PsiFile base, int depth) {
        if (depth == 0) {
            return base.getContainingDirectory();
        }
        if (base != null) {
            base = base.getOriginalFile();
            PsiDirectory psiDirectory = base.getContainingDirectory();
            int n2 = 1;
            while (psiDirectory != null && PyUtil.isPackage(psiDirectory, (PsiElement)base)) {
                if (n2 >= depth) {
                    return psiDirectory;
                }
                psiDirectory = psiDirectory.getParentDirectory();
                ++n2;
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static PsiElement resolveImportElement(PyImportElement importElement, @NotNull QualifiedName qName) {
        List<RatedResolveResult> list2;
        if (qName == null) {
            ResolveImportUtil.a(0);
        }
        return (list2 = RatedResolveResult.sorted(ResolveImportUtil.multiResolveImportElement(importElement, qName))).size() > 0 ? list2.get(0).getElement() : null;
    }

    @NotNull
    public static List<RatedResolveResult> multiResolveImportElement(PyImportElement importElement, @NotNull QualifiedName qName) {
        if (qName == null) {
            ResolveImportUtil.a(1);
        }
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid((PsiElement)importElement));
        PyStatement pyStatement = importElement.getContainingImportStatement();
        if (pyStatement instanceof PyFromImportStatement) {
            List<RatedResolveResult> list2 = ResolveImportUtil.resolveNameInFromImport((PyFromImportStatement)pyStatement, qName);
            if (list2 == null) {
                ResolveImportUtil.a(2);
            }
            return list2;
        }
        List<RatedResolveResult> list3 = ResolveImportUtil.resolveNameInImportStatement(importElement, qName);
        if (list3 == null) {
            ResolveImportUtil.a(3);
        }
        return list3;
    }

    @NotNull
    public static List<RatedResolveResult> resolveNameInImportStatement(PyImportElement importElement, @NotNull QualifiedName qName) {
        if (qName == null) {
            ResolveImportUtil.a(4);
        }
        PsiFile psiFile = importElement.getContainingFile().getOriginalFile();
        boolean bl2 = ResolveImportUtil.isAbsoluteImportEnabledFor((PsiElement)importElement);
        List<PsiElement> list2 = ResolveImportUtil.resolveModule(qName, psiFile, bl2, 0);
        ResolveResultList resolveResultList = ResolveImportUtil.rateResults(list2);
        if (resolveResultList == null) {
            ResolveImportUtil.a(5);
        }
        return resolveResultList;
    }

    @NotNull
    public static List<RatedResolveResult> resolveNameInFromImport(PyFromImportStatement importStatement, @NotNull QualifiedName qName) {
        long l2 = b ^ 0x67A8A8C4920AL;
        if (qName == null) {
            ResolveImportUtil.a(6);
        }
        PsiFile psiFile = importStatement.getContainingFile().getOriginalFile();
        String string = (String)qName.getComponents().get(0);
        ArrayList<RatedResolveResult> arrayList = new ArrayList<RatedResolveResult>();
        List<PsiElement> list2 = importStatement.resolveImportSourceCandidates();
        for (PsiElement psiElement : list2) {
            if (!psiElement.isValid()) {
                throw new PsiInvalidElementAccessException(psiElement, "Got an invalid candidate from resolveImportSourceCandidates(): " + psiElement.getClass());
            }
            if (psiElement instanceof PsiDirectory) {
                psiElement = PyUtil.getPackageElement((PsiDirectory)psiElement, (PsiElement)importStatement);
            }
            arrayList.addAll(ResolveImportUtil.resolveChildren(psiElement, string, psiFile, false, true, false, false));
        }
        List<RatedResolveResult> list3 = ResolveImportUtil.a(PyStubPackages.removeRuntimeModulesForWhomStubModulesFound(arrayList));
        if (list3 == null) {
            ResolveImportUtil.a(7);
        }
        return list3;
    }

    @NotNull
    public static List<PsiElement> resolveFromImportStatementSource(@NotNull PyFromImportStatement fromImportStatement, @Nullable QualifiedName qName) {
        if (fromImportStatement == null) {
            ResolveImportUtil.a(8);
        }
        boolean bl2 = ResolveImportUtil.isAbsoluteImportEnabledFor((PsiElement)fromImportStatement);
        PsiFile psiFile = fromImportStatement.getContainingFile();
        List<PsiElement> list2 = ResolveImportUtil.resolveModule(qName, psiFile, bl2, fromImportStatement.getRelativeLevel());
        if (list2 == null) {
            ResolveImportUtil.a(9);
        }
        return list2;
    }

    @NotNull
    public static List<PsiElement> resolveModule(@Nullable QualifiedName qualifiedName, @Nullable PsiFile sourceFile, boolean importIsAbsolute, int relativeLevel) {
        if (qualifiedName == null || sourceFile == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                ResolveImportUtil.a(10);
            }
            return list2;
        }
        ResolveModuleParams resolveModuleParams = new ResolveModuleParams(qualifiedName, sourceFile, importIsAbsolute, relativeLevel);
        List list3 = (List)PyUtil.getParameterizedCachedValue((PsiElement)sourceFile, resolveModuleParams, ResolveImportUtil::a);
        if (list3 == null) {
            ResolveImportUtil.a(11);
        }
        return list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<PsiElement> a(@NotNull ResolveModuleParams resolveModuleParams) {
        if (resolveModuleParams == null) {
            ResolveImportUtil.a(12);
        }
        QualifiedName qualifiedName = resolveModuleParams.getName();
        int n2 = resolveModuleParams.getLevel();
        PsiFile psiFile = resolveModuleParams.getFile();
        boolean bl2 = resolveModuleParams.isAbsolute();
        String string = qualifiedName + "#" + n2;
        Set<String> set = a.get();
        if (set.contains(string)) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                ResolveImportUtil.a(13);
            }
            return list2;
        }
        set.add(string);
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext = PyResolveImportUtil.fromFoothold((PsiElement)psiFile);
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext2 = n2 > 0 ? pyQualifiedNameResolveContext.copyWithRelative(n2).copyWithoutRoots() : (bl2 ? pyQualifiedNameResolveContext : pyQualifiedNameResolveContext.copyWithRelative(0));
        List<PsiElement> list3 = PyResolveImportUtil.resolveQualifiedName(qualifiedName, pyQualifiedNameResolveContext2);
        List<PsiElement> list4 = list3;
        if (list4 == null) {
            ResolveImportUtil.a(14);
        }
        return list4;
        finally {
            set.remove(string);
        }
    }

    @NotNull
    public static List<PsiElement> multiResolveModuleInRoots(@NotNull QualifiedName moduleQualifiedName, @Nullable PsiElement foothold) {
        if (moduleQualifiedName == null) {
            ResolveImportUtil.a(15);
        }
        if (foothold == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                ResolveImportUtil.a(16);
            }
            return list2;
        }
        List<PsiElement> list3 = PyResolveImportUtil.resolveQualifiedName(moduleQualifiedName, PyResolveImportUtil.fromFoothold(foothold));
        if (list3 == null) {
            ResolveImportUtil.a(17);
        }
        return list3;
    }

    @Deprecated
    @Nullable
    public static PsiElement resolveModuleInRoots(@NotNull QualifiedName moduleQualifiedName, @Nullable PsiElement foothold) {
        if (moduleQualifiedName == null) {
            ResolveImportUtil.a(18);
        }
        List<PsiElement> list2 = ResolveImportUtil.multiResolveModuleInRoots(moduleQualifiedName, foothold);
        return (PsiElement)ContainerUtil.getFirstItem(list2);
    }

    @Nullable
    static PythonPathCache getPathCache(PsiElement foothold) {
        PythonPathCache pythonPathCache = null;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)foothold);
        if (module2 != null) {
            pythonPathCache = PythonModulePathCache.getInstance(module2);
        } else {
            Sdk sdk = PyBuiltinCache.findSdkForFile((PsiFileSystemItem)foothold.getContainingFile());
            if (sdk != null) {
                pythonPathCache = PythonSdkPathCache.getInstance(foothold.getProject(), sdk);
            }
        }
        return pythonPathCache;
    }

    @Deprecated
    @Nullable
    public static PsiElement resolveChild(@Nullable PsiElement parent, @NotNull String referencedName, @Nullable PsiFile containingFile, boolean fileOnly, boolean checkForPackage, boolean withoutStubs) {
        List<RatedResolveResult> list2;
        if (referencedName == null) {
            ResolveImportUtil.a(19);
        }
        return (list2 = ResolveImportUtil.resolveChildren(parent, referencedName, containingFile, fileOnly, checkForPackage, withoutStubs, false)).isEmpty() ? null : RatedResolveResult.sorted(list2).get(0).getElement();
    }

    @NotNull
    public static List<RatedResolveResult> resolveChildren(@Nullable PsiElement parent, @NotNull String referencedName, @Nullable PsiFile containingFile, boolean fileOnly, boolean checkForPackage, boolean withoutStubs, boolean withoutForeign) {
        if (referencedName == null) {
            ResolveImportUtil.a(20);
        }
        if (parent == null) {
            List<RatedResolveResult> list2 = Collections.emptyList();
            if (list2 == null) {
                ResolveImportUtil.a(21);
            }
            return list2;
        }
        if (parent instanceof PyFile) {
            List<RatedResolveResult> list3 = ResolveImportUtil.a((PyFile)parent, referencedName, containingFile, fileOnly, checkForPackage, withoutStubs, withoutForeign);
            if (list3 == null) {
                ResolveImportUtil.a(22);
            }
            return list3;
        }
        if (parent instanceof PsiDirectory) {
            List<RatedResolveResult> list4 = ResolveImportUtil.a(parent, referencedName, containingFile, fileOnly, checkForPackage, withoutStubs, withoutForeign);
            if (list4 == null) {
                ResolveImportUtil.a(23);
            }
            return list4;
        }
        List<RatedResolveResult> list5 = ResolveImportUtil.a(parent, referencedName);
        if (list5 == null) {
            ResolveImportUtil.a(24);
        }
        return list5;
    }

    @NotNull
    private static List<RatedResolveResult> a(@NotNull PyFile pyFile, @NotNull String string, @Nullable PsiFile psiFile, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (pyFile == null) {
            ResolveImportUtil.a(25);
        }
        if (string == null) {
            ResolveImportUtil.a(26);
        }
        List<RatedResolveResult> list2 = ResolveImportUtil.a(pyFile, string);
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        for (RatedResolveResult ratedResolveResult : list2) {
            PsiElement psiElement = ratedResolveResult.getElement();
            if (bl2 && !PsiTreeUtil.instanceOf((Object)psiElement, (Class[])new Class[]{PsiFile.class, PsiDirectory.class})) continue;
            arrayList2.add(ratedResolveResult);
            if (psiElement == null || ResolveImportUtil.a(psiElement)) continue;
            arrayList.add(ratedResolveResult);
        }
        if (!arrayList.isEmpty()) {
            ArrayList arrayList3 = arrayList;
            if (arrayList3 == null) {
                ResolveImportUtil.a(27);
            }
            return arrayList3;
        }
        List<RatedResolveResult> list3 = ResolveImportUtil.a((PsiElement)pyFile, string, psiFile, bl2, bl3, bl4, bl5);
        if (!list3.isEmpty()) {
            List<RatedResolveResult> list4 = list3;
            if (list4 == null) {
                ResolveImportUtil.a(28);
            }
            return list4;
        }
        ArrayList arrayList4 = arrayList2;
        if (arrayList4 == null) {
            ResolveImportUtil.a(29);
        }
        return arrayList4;
    }

    private static boolean a(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ResolveImportUtil.a(30);
        }
        return PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)psiElement, PyExceptPart.class) != null || PsiTreeUtil.instanceOf((Object)psiElement, (Class[])new Class[]{PsiFile.class, PsiDirectory.class}) || ResolveImportUtil.b(psiElement);
    }

    @NotNull
    private static List<RatedResolveResult> a(@NotNull PyFile pyFile, @NotNull String string) {
        PyResolveContext pyResolveContext;
        PyModuleType pyModuleType;
        List<? extends RatedResolveResult> list2;
        if (pyFile == null) {
            ResolveImportUtil.a(31);
        }
        if (string == null) {
            ResolveImportUtil.a(32);
        }
        if ((list2 = (pyModuleType = new PyModuleType(pyFile)).resolveMember(string, null, AccessDirection.READ, pyResolveContext = PyResolveContext.defaultContext())) == null) {
            List<RatedResolveResult> list3 = Collections.emptyList();
            if (list3 == null) {
                ResolveImportUtil.a(33);
            }
            return list3;
        }
        ArrayList arrayList = Lists.newArrayList(list2);
        if (arrayList == null) {
            ResolveImportUtil.a(34);
        }
        return arrayList;
    }

    @NotNull
    private static List<RatedResolveResult> a(@Nullable PsiElement psiElement, @NotNull String string, @Nullable PsiFile psiFile, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        PsiElement psiElement2;
        if (string == null) {
            ResolveImportUtil.a(35);
        }
        if ((psiElement2 = PyUtil.turnInitIntoDir(psiElement)) instanceof PsiDirectory) {
            Object object;
            PsiElement psiElement3;
            List<RatedResolveResult> list2 = ResolveImportUtil.a(string, psiFile, (PsiDirectory)psiElement2, bl2, bl3, bl4);
            if (!list2.isEmpty()) {
                psiElement3 = list2.iterator();
                while (psiElement3.hasNext()) {
                    object = psiElement3.next();
                    if (((RatedResolveResult)object).getRate() <= -1000) continue;
                    List<RatedResolveResult> list3 = list2;
                    if (list3 == null) {
                        ResolveImportUtil.a(36);
                    }
                    return list3;
                }
            }
            if (!bl5 && psiElement instanceof PsiFile && (psiElement3 = ResolveImportUtil.a((PsiFile)psiElement, string)) != null) {
                object = new ResolveResultList();
                ((ArrayList)object).addAll(list2);
                ((ResolveResultList)object).poke(psiElement3, 0);
                Object object2 = object;
                if (object2 == null) {
                    ResolveImportUtil.a(37);
                }
                return object2;
            }
            List<RatedResolveResult> list4 = list2;
            if (list4 == null) {
                ResolveImportUtil.a(38);
            }
            return list4;
        }
        List<RatedResolveResult> list5 = Collections.emptyList();
        if (list5 == null) {
            ResolveImportUtil.a(39);
        }
        return list5;
    }

    @Nullable
    private static PsiElement a(@NotNull PsiFile psiFile, @NotNull String string) {
        if (psiFile == null) {
            ResolveImportUtil.a(40);
        }
        if (string == null) {
            ResolveImportUtil.a(41);
        }
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext = PyResolveImportUtil.fromFoothold((PsiElement)psiFile).copyWithoutRoots();
        List<PsiElement> list2 = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)string), pyQualifiedNameResolveContext);
        return !list2.isEmpty() ? list2.get(0) : null;
    }

    @NotNull
    private static List<RatedResolveResult> a(@NotNull PsiElement psiElement, @NotNull String string) {
        List<? extends RatedResolveResult> list2;
        PyResolveContext pyResolveContext;
        Ref<PyType> ref;
        if (psiElement == null) {
            ResolveImportUtil.a(42);
        }
        if (string == null) {
            ResolveImportUtil.a(43);
        }
        if ((ref = PyReferenceExpressionImpl.getReferenceTypeFromProviders(psiElement, (pyResolveContext = PyResolveContext.defaultContext()).getTypeEvalContext(), null)) != null && !ref.isNull() && (list2 = ((PyType)ref.get()).resolveMember(string, null, AccessDirection.READ, pyResolveContext)) != null) {
            ArrayList arrayList = Lists.newArrayList(list2);
            if (arrayList == null) {
                ResolveImportUtil.a(44);
            }
            return arrayList;
        }
        List<RatedResolveResult> list3 = Collections.emptyList();
        if (list3 == null) {
            ResolveImportUtil.a(45);
        }
        return list3;
    }

    private static boolean b(@NotNull PsiElement psiElement) {
        long l2 = b ^ 0x3B9A5AE0910DL;
        if (psiElement == null) {
            ResolveImportUtil.a(46);
        }
        return psiElement instanceof PyElement && "__all__".equals(((PyElement)psiElement).getName());
    }

    @NotNull
    private static List<RatedResolveResult> a(@NotNull String string, @Nullable PsiFile psiFile, PsiDirectory psiDirectory, boolean bl2, boolean bl3, boolean bl4) {
        PsiElement psiElement;
        PsiFile psiFile2;
        PsiDirectory psiDirectory2;
        if (string == null) {
            ResolveImportUtil.a(47);
        }
        ResolveResultList resolveResultList = new ResolveResultList();
        PsiDirectory psiDirectory3 = psiDirectory.findSubdirectory(string);
        if (psiDirectory3 != null && psiDirectory3.getName().equals(string) && (!bl3 || PyUtil.isPackage(psiDirectory3, (PsiElement)psiFile))) {
            resolveResultList.add(new RatedResolveResult(0, (PsiElement)PyStubPackages.transferStubPackageMarker(psiDirectory, psiDirectory3)));
        }
        if ((psiDirectory2 = PyStubPackages.findStubPackage(psiDirectory, string, bl3, bl4)) != null) {
            resolveResultList.add(new RatedResolveResult(0, (PsiElement)psiDirectory2));
        }
        if ((psiFile2 = ResolveImportUtil.a(psiDirectory, string, bl4)) != null) {
            resolveResultList.add(new RatedResolveResult(0, (PsiElement)PyStubPackages.transferStubPackageMarker(psiDirectory, psiFile2)));
        }
        if (!bl2 && (psiElement = PyUtil.getPackageElement(psiDirectory, (PsiElement)psiFile)) != psiFile && psiElement instanceof PyFile) {
            resolveResultList.addAll(((PyFile)psiElement).multiResolveName(string));
        }
        ResolveResultList resolveResultList2 = resolveResultList;
        if (resolveResultList2 == null) {
            ResolveImportUtil.a(48);
        }
        return resolveResultList2;
    }

    @Nullable
    private static PsiFile a(PsiDirectory psiDirectory, String string, boolean bl2) {
        long l2 = b ^ 0x2AC0231AC9A2L;
        PsiFile psiFile = null;
        if (!bl2) {
            psiFile = psiDirectory.findFile(string + ".pyi");
        }
        if (psiFile == null) {
            psiFile = psiDirectory.findFile(string + ".py");
        }
        if (psiFile == null) {
            FileNameMatcher fileNameMatcher;
            List list2 = FileTypeManager.getInstance().getAssociations((FileType)PythonFileType.INSTANCE);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext() && (!((fileNameMatcher = (FileNameMatcher)iterator.next()) instanceof ExtensionFileNameMatcher) || (psiFile = psiDirectory.findFile(string + "." + ((ExtensionFileNameMatcher)fileNameMatcher).getExtension())) == null)) {
            }
        }
        if (psiFile != null && FileUtilRt.getNameWithoutExtension((String)psiFile.getName()).equals(string)) {
            return psiFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static ResolveResultList rateResults(List<? extends PsiElement> targets) {
        ResolveResultList resolveResultList = new ResolveResultList();
        for (PsiElement psiElement : targets) {
            void psiElement2;
            if (psiElement instanceof PsiDirectory) {
                PsiElement psiElement3 = PyUtil.getPackageElement((PsiDirectory)psiElement, null);
            }
            if (psiElement2 == null) continue;
            int n2 = 1000;
            if (psiElement2 instanceof PyFile) {
                for (PyResolveResultRater pyResolveResultRater : PyResolveResultRater.EP_NAME.getExtensionList()) {
                    n2 += pyResolveResultRater.getImportElementRate((PsiElement)psiElement2);
                }
            } else if (ResolveImportUtil.b((PsiElement)psiElement2)) {
                n2 = 0;
            }
            resolveResultList.poke((PsiElement)psiElement2, n2);
        }
        return resolveResultList;
    }

    @NotNull
    private static List<RatedResolveResult> a(@NotNull List<? extends RatedResolveResult> list2) {
        if (list2 == null) {
            ResolveImportUtil.a(49);
        }
        if (list2.isEmpty()) {
            List<RatedResolveResult> list3 = Collections.emptyList();
            if (list3 == null) {
                ResolveImportUtil.a(50);
            }
            return list3;
        }
        ResolveResultList resolveResultList = new ResolveResultList();
        for (RatedResolveResult ratedResolveResult : list2) {
            PsiElement psiElement = ratedResolveResult.getElement();
            if (psiElement instanceof PsiDirectory) {
                psiElement = PyUtil.getPackageElement((PsiDirectory)psiElement, psiElement);
            }
            if (psiElement == null) continue;
            int n2 = 0;
            for (PyResolveResultRater pyResolveResultRater : PyResolveResultRater.EP_NAME.getExtensionList()) {
                n2 += pyResolveResultRater.getImportElementRate(psiElement);
            }
            resolveResultList.poke(psiElement, ratedResolveResult.getRate() + n2);
        }
        ResolveResultList resolveResultList2 = resolveResultList;
        if (resolveResultList2 == null) {
            ResolveImportUtil.a(51);
        }
        return resolveResultList2;
    }

    @NotNull
    public static PointInImport getPointInImport(@NotNull PsiElement element) {
        PsiElement psiElement;
        if (element == null) {
            ResolveImportUtil.a(52);
        }
        if ((psiElement = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PyImportElement.class, PyFromImportStatement.class})) instanceof PyFromImportStatement) {
            PointInImport pointInImport = PointInImport.AS_MODULE;
            if (pointInImport == null) {
                ResolveImportUtil.a(53);
            }
            return pointInImport;
        }
        if (psiElement instanceof PyImportElement) {
            PsiElement psiElement2 = psiElement.getParent();
            if (psiElement2 instanceof PyImportStatement) {
                PointInImport pointInImport = PointInImport.AS_MODULE;
                if (pointInImport == null) {
                    ResolveImportUtil.a(54);
                }
                return pointInImport;
            }
            if (psiElement2 instanceof PyFromImportStatement) {
                PointInImport pointInImport = PointInImport.AS_NAME;
                if (pointInImport == null) {
                    ResolveImportUtil.a(55);
                }
                return pointInImport;
            }
        }
        PointInImport pointInImport = PointInImport.NONE;
        if (pointInImport == null) {
            ResolveImportUtil.a(56);
        }
        return pointInImport;
    }

    static {
        b = c.a(58697675049538485L, -9127517319223986565L, MethodHandles.lookup().lookupClass()).a(63399929030262L);
        a = ThreadLocal.withInitial(() -> new HashSet());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x645A861C63A1L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/ResolveImportUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromImportStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleQualifiedName";
                break;
            }
            case 19: 
            case 20: 
            case 26: 
            case 32: 
            case 35: 
            case 41: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedName";
                break;
            }
            case 25: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 46: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/ResolveImportUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveImportElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNameInImportStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNameInFromImport";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFromImportStatementSource";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModule";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateResolveModule";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveModuleInRoots";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveChildren";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInPackageModule";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleMember";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInPackageDirectory";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMemberFromReferenceTypeProviders";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInDirectory";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "updateRatedResults";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointInImport";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveImportElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveImportElement";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameInImportStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameInFromImport";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromImportStatementSource";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateResolveModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveModuleInRoots";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleInRoots";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveChild";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveChildren";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveInPackageModule";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "preferResolveInDirectoryOverModule";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleMember";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "resolveInPackageDirectory";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolveForeignImports";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberFromReferenceTypeProviders";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isDunderAll";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "resolveInDirectory";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "updateRatedResults";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getPointInImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ResolveModuleParams {
        @NotNull
        private final QualifiedName a;
        @NotNull
        private final PsiFile c;
        private final boolean d;
        private final int b;
        private static final long e = com.jetbrains.python.psi.c.a(8090679974887150988L, -1904892030874975009L, MethodHandles.lookup().lookupClass()).a(255117513933917L);

        ResolveModuleParams(@NotNull QualifiedName qualifiedName, @NotNull PsiFile file, boolean importIsAbsolute, int relativeLevel) {
            if (qualifiedName == null) {
                ResolveModuleParams.a(0);
            }
            if (file == null) {
                ResolveModuleParams.a(1);
            }
            this.a = qualifiedName;
            this.c = file;
            this.d = importIsAbsolute;
            this.b = relativeLevel;
        }

        @NotNull
        public QualifiedName getName() {
            QualifiedName qualifiedName = this.a;
            if (qualifiedName == null) {
                ResolveModuleParams.a(2);
            }
            return qualifiedName;
        }

        public boolean isAbsolute() {
            return this.d;
        }

        public int getLevel() {
            return this.b;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.c;
            if (psiFile == null) {
                ResolveModuleParams.a(3);
            }
            return psiFile;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            ResolveModuleParams resolveModuleParams = (ResolveModuleParams)o2;
            if (this.d != resolveModuleParams.d) {
                return false;
            }
            if (this.b != resolveModuleParams.b) {
                return false;
            }
            if (!this.a.equals((Object)resolveModuleParams.a)) {
                return false;
            }
            return this.c.equals(resolveModuleParams.c);
        }

        public int hashCode() {
            int n2 = this.a.hashCode();
            n2 = 31 * n2 + this.c.hashCode();
            n2 = 31 * n2 + (this.d ? 1 : 0);
            n2 = 31 * n2 + this.b;
            return n2;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x1C233F507EE6L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/resolve/ResolveImportUtil$ResolveModuleParams";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/resolve/ResolveImportUtil$ResolveModuleParams";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

