/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.findUsages.PyFindUsagesHandlerFactory;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.refactoring.NameSuggesterUtil;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRefactoringUtil {
    private static final long a = c.a(2850640508283171156L, -8620877516384387458L, MethodHandles.lookup().lookupClass()).a(219620046039311L);

    private PyRefactoringUtil() {
    }

    @NotNull
    public static List<PsiElement> getOccurrences(final @NotNull PsiElement pattern, @Nullable PsiElement context) {
        if (pattern == null) {
            PyRefactoringUtil.a(0);
        }
        if (context == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                PyRefactoringUtil.a(1);
            }
            return list2;
        }
        final ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        PyElementVisitor pyElementVisitor = new PyElementVisitor(){
            private static final long a = c.a(-2812345896706258541L, 5156440951197933813L, MethodHandles.lookup().lookupClass()).a(26203498448046L);

            public void visitElement(@NotNull PsiElement element) {
                Pair pair;
                if (element == null) {
                    1.a(0);
                }
                if (element instanceof PyParameter) {
                    return;
                }
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)pattern)) {
                    arrayList.add(element);
                    return;
                }
                if (element instanceof PyStringLiteralExpression && (pair = (Pair)pattern.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE)) != null) {
                    int n2;
                    String string = ((TextRange)pair.getSecond()).substring(pattern.getText());
                    PyStringLiteralExpression pyStringLiteralExpression = (PyStringLiteralExpression)element;
                    String string2 = element.getText();
                    if (string2 != null && pyStringLiteralExpression.getStringNodes().size() == 1 && (n2 = string2.indexOf(string)) >= 0) {
                        element.putUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE, (Object)Pair.create((Object)element, (Object)TextRange.from((int)n2, (int)string.length())));
                        arrayList.add(element);
                        return;
                    }
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x7B40C2C8F9DFL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/PyRefactoringUtil$1", "visitElement"));
            }
        };
        context.acceptChildren((PsiElementVisitor)pyElementVisitor);
        ArrayList<PsiElement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PyRefactoringUtil.a(2);
        }
        return arrayList2;
    }

    @Nullable
    public static PyExpression getSelectedExpression(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement psiElement;
        long l2 = a ^ 0x7A4E22BF6E05L;
        if (project == null) {
            PyRefactoringUtil.a(3);
        }
        if (file == null) {
            PyRefactoringUtil.a(4);
        }
        if (element1 == null) {
            PyRefactoringUtil.a(5);
        }
        if (element2 == null) {
            PyRefactoringUtil.a(6);
        }
        if ((psiElement = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2)) != null && !(psiElement instanceof PyElement)) {
            psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyElement.class);
        }
        if (psiElement == null) {
            return null;
        }
        if (!(psiElement instanceof PyExpression)) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{PyImportStatement.class, PyFromImportStatement.class}) != null) {
            return null;
        }
        if (element1 == PsiTreeUtil.getDeepestFirst((PsiElement)psiElement) && element2 == PsiTreeUtil.getDeepestLast((PsiElement)psiElement)) {
            return (PyExpression)psiElement;
        }
        if (psiElement instanceof PyBinaryExpression) {
            LanguageLevel languageLevel;
            String string = file.getText().substring(element1.getTextOffset(), element2.getTextOffset() + element2.getTextLength());
            PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(project);
            PyExpression pyExpression = pyElementGenerator.createFromText(languageLevel = LanguageLevel.forElement(element1), PyAssignmentStatement.class, "z=" + string).getAssignedValue();
            if (!(pyExpression instanceof PyBinaryExpression) || PsiUtilCore.hasErrorElementChild((PsiElement)pyExpression)) {
                return null;
            }
            String string2 = psiElement.getText();
            int n2 = element1.getTextOffset() - psiElement.getTextOffset() - 1;
            if (n2 < 0) {
                return null;
            }
            int n3 = element2.getTextOffset() + element2.getTextLength() - psiElement.getTextOffset();
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n3);
            TextRange textRange = TextRange.from((int)n2, (int)(n3 - n2));
            PyExpression pyExpression2 = pyElementGenerator.createExpressionFromText(languageLevel, string3 + "python" + string4);
            if (PsiUtilCore.hasErrorElementChild((PsiElement)pyExpression2)) {
                return null;
            }
            pyExpression.putUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE, Pair.create((Object)psiElement, (Object)textRange));
            return pyExpression;
        }
        return null;
    }

    @NotNull
    public static Collection<String> collectUsedNames(@Nullable PsiElement scope) {
        if (!(scope instanceof PyClass || scope instanceof PyFile || scope instanceof PyFunction)) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                PyRefactoringUtil.a(7);
            }
            return list2;
        }
        final HashSet<String> hashSet = new HashSet<String>(){

            @Override
            public boolean add(String s2) {
                return s2 != null && super.add(s2);
            }
        };
        scope.acceptChildren((PsiElementVisitor)new PyRecursiveElementVisitor(){
            private static final long a = c.a(8090898239277486581L, 2432111381231483143L, MethodHandles.lookup().lookupClass()).a(166886510497664L);

            @Override
            public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
                if (node == null) {
                    3.a(0);
                }
                hashSet.add(node.getName());
            }

            @Override
            public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
                if (node == null) {
                    3.a(1);
                }
                hashSet.add(node.getName());
            }

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                if (!node.isQualified()) {
                    hashSet.add(node.getReferencedName());
                } else {
                    super.visitPyReferenceExpression(node);
                }
            }

            @Override
            public void visitPyFunction(@NotNull PyFunction node) {
                if (node == null) {
                    3.a(2);
                }
                hashSet.add(node.getName());
            }

            @Override
            public void visitPyClass(@NotNull PyClass node) {
                if (node == null) {
                    3.a(3);
                }
                hashSet.add(node.getName());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x214A24F87462L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/jetbrains/python/refactoring/PyRefactoringUtil$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyTargetExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyNamedParameter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyFunction";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        HashSet<String> hashSet2 = hashSet;
        if (hashSet2 == null) {
            PyRefactoringUtil.a(8);
        }
        return hashSet2;
    }

    @Nullable
    public static PsiElement findExpressionInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            PyRefactoringUtil.a(9);
        }
        PsiElement psiElement = file.findElementAt(startOffset);
        PsiElement psiElement2 = file.findElementAt(endOffset - 1);
        if (psiElement instanceof PsiWhiteSpace) {
            startOffset = psiElement.getTextRange().getEndOffset();
            psiElement = file.findElementAt(startOffset);
        }
        if (psiElement2 instanceof PsiWhiteSpace) {
            endOffset = psiElement2.getTextRange().getStartOffset();
            psiElement2 = file.findElementAt(endOffset - 1);
        }
        if (psiElement == null || psiElement2 == null) {
            return null;
        }
        return PyRefactoringUtil.getSelectedExpression(file.getProject(), file, psiElement, psiElement2);
    }

    @NotNull
    public static PsiElement[] findStatementsInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            PyRefactoringUtil.a(10);
        }
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        PsiElement psiElement = file.findElementAt(startOffset);
        PsiElement psiElement2 = file.findElementAt(endOffset - 1);
        PsiElement psiElement3 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (psiElement instanceof PsiWhiteSpace) {
            startOffset = psiElement.getTextRange().getEndOffset();
            psiElement = file.findElementAt(startOffset);
            bl2 = true;
        }
        if (psiElement2 instanceof PsiWhiteSpace) {
            psiElement2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)psiElement2);
            bl3 = true;
        }
        while (psiElement2 instanceof PsiComment) {
            psiElement3 = psiElement2;
            psiElement2 = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)psiElement2);
            bl3 = true;
        }
        while (psiElement instanceof PsiComment) {
            arrayList.add(psiElement);
            psiElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)psiElement);
            bl2 = true;
        }
        if (psiElement == null || psiElement2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.a(11);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement psiElement4 = PsiTreeUtil.findCommonParent((PsiElement)psiElement, (PsiElement)psiElement2);
        if (psiElement4 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.a(12);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (true) {
            if (psiElement4 instanceof PyStatement) {
                psiElement4 = psiElement4.getParent();
                break;
            }
            if (psiElement4 instanceof PyStatementList) break;
            if (psiElement4 == null || psiElement4 instanceof PsiFile) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    PyRefactoringUtil.a(13);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            psiElement4 = psiElement4.getParent();
        }
        if (!psiElement4.equals(psiElement)) {
            while (!psiElement4.equals(psiElement.getParent())) {
                psiElement = psiElement.getParent();
            }
        }
        if (startOffset != psiElement.getTextRange().getStartOffset() && !bl2) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.a(14);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (!psiElement4.equals(psiElement2)) {
            while (!psiElement4.equals(psiElement2.getParent())) {
                psiElement2 = psiElement2.getParent();
            }
        }
        if (endOffset != psiElement2.getTextRange().getEndOffset() && !bl3) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.a(15);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (psiElement instanceof PyFunction || psiElement instanceof PyClass) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.a(16);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (psiElement2 instanceof PyFunction || psiElement2 instanceof PyClass) {
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.a(17);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = psiElement4.getChildren();
        boolean bl4 = false;
        for (PsiElement psiElement5 : psiElementArray) {
            if (psiElement5.equals(psiElement)) {
                bl4 = true;
            }
            if (bl4 && !(psiElement5 instanceof PsiWhiteSpace)) {
                arrayList.add(psiElement5);
            }
            if (psiElement5.equals(psiElement2)) break;
        }
        while (psiElement3 instanceof PsiComment) {
            arrayList.add(psiElement3);
            psiElement3 = PsiTreeUtil.skipWhitespacesForward((PsiElement)psiElement3);
        }
        for (PsiElement psiElement6 : arrayList) {
            if (psiElement6 instanceof PyStatement || psiElement6 instanceof PsiWhiteSpace || psiElement6 instanceof PsiComment) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                PyRefactoringUtil.a(18);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray2 = PsiUtilCore.toPsiElementArray(arrayList);
        if (psiElementArray2 == null) {
            PyRefactoringUtil.a(19);
        }
        return psiElementArray2;
    }

    public static boolean areConflictingMethods(PyFunction pyFunction, PyFunction pyFunction1) {
        String string;
        PyParameter[] pyParameterArray = pyFunction.getParameterList().getParameters();
        PyParameter[] pyParameterArray2 = pyFunction1.getParameterList().getParameters();
        String string2 = pyFunction.getName();
        return Comparing.strEqual((String)string2, (String)(string = pyFunction1.getName())) && pyParameterArray.length == pyParameterArray2.length;
    }

    @NotNull
    public static List<UsageInfo> findUsages(@NotNull PsiNamedElement element, boolean forHighlightUsages) {
        if (element == null) {
            PyRefactoringUtil.a(20);
        }
        ArrayList<UsageInfo> arrayList = new ArrayList<UsageInfo>();
        FindUsagesHandler findUsagesHandler = new PyFindUsagesHandlerFactory().createFindUsagesHandler((PsiElement)element, forHighlightUsages);
        assert (findUsagesHandler != null);
        ArrayList arrayList2 = new ArrayList();
        Collections.addAll(arrayList2, findUsagesHandler.getPrimaryElements());
        Collections.addAll(arrayList2, findUsagesHandler.getSecondaryElements());
        for (PsiElement psiElement : arrayList2) {
            findUsagesHandler.processElementUsages(psiElement, usageInfo -> {
                if (!usageInfo.isNonCodeUsage) {
                    arrayList.add((UsageInfo)usageInfo);
                }
                return true;
            }, FindUsagesHandler.createFindUsagesOptions((Project)element.getProject(), null));
        }
        ArrayList<UsageInfo> arrayList3 = arrayList;
        if (arrayList3 == null) {
            PyRefactoringUtil.a(21);
        }
        return arrayList3;
    }

    @NotNull
    public static String selectUniqueNameFromType(@NotNull String typeName, @NotNull PsiElement scopeAnchor) {
        if (typeName == null) {
            PyRefactoringUtil.a(22);
        }
        if (scopeAnchor == null) {
            PyRefactoringUtil.a(23);
        }
        String string = PyRefactoringUtil.a(typeName, true, scopeAnchor, PyRefactoringUtil::isValidNewName);
        if (string == null) {
            PyRefactoringUtil.a(24);
        }
        return string;
    }

    @NotNull
    public static String selectUniqueName(@NotNull String templateName, @NotNull PsiElement scopeAnchor) {
        if (templateName == null) {
            PyRefactoringUtil.a(25);
        }
        if (scopeAnchor == null) {
            PyRefactoringUtil.a(26);
        }
        String string = PyRefactoringUtil.a(templateName, false, scopeAnchor, PyRefactoringUtil::isValidNewName);
        if (string == null) {
            PyRefactoringUtil.a(27);
        }
        return string;
    }

    @NotNull
    public static String selectUniqueName(@NotNull String templateName, @NotNull PsiElement scopeAnchor, @NotNull BiPredicate<String, PsiElement> isValid) {
        if (templateName == null) {
            PyRefactoringUtil.a(28);
        }
        if (scopeAnchor == null) {
            PyRefactoringUtil.a(29);
        }
        if (isValid == null) {
            PyRefactoringUtil.a(30);
        }
        String string = PyRefactoringUtil.a(templateName, false, scopeAnchor, isValid);
        if (string == null) {
            PyRefactoringUtil.a(31);
        }
        return string;
    }

    @NotNull
    private static String a(@NotNull String string, boolean bl2, @NotNull PsiElement psiElement, @NotNull BiPredicate<String, PsiElement> biPredicate) {
        if (string == null) {
            PyRefactoringUtil.a(32);
        }
        if (psiElement == null) {
            PyRefactoringUtil.a(33);
        }
        if (biPredicate == null) {
            PyRefactoringUtil.a(34);
        }
        Collection<String> collection = bl2 ? NameSuggesterUtil.generateNamesByType(string) : NameSuggesterUtil.generateNames(string);
        for (String string2 : collection) {
            if (!biPredicate.test(string2, psiElement)) continue;
            String string3 = string2;
            if (string3 == null) {
                PyRefactoringUtil.a(35);
            }
            return string3;
        }
        String string4 = (String)ContainerUtil.getFirstItem(collection);
        String string5 = PyRefactoringUtil.appendNumberUntilValid(string4, psiElement, biPredicate);
        if (string5 == null) {
            PyRefactoringUtil.a(36);
        }
        return string5;
    }

    @NotNull
    public static String appendNumberUntilValid(@NotNull String name, @NotNull PsiElement scopeAnchor, @NotNull BiPredicate<String, PsiElement> predicate) {
        if (name == null) {
            PyRefactoringUtil.a(37);
        }
        if (scopeAnchor == null) {
            PyRefactoringUtil.a(38);
        }
        if (predicate == null) {
            PyRefactoringUtil.a(39);
        }
        int n2 = 1;
        String string = name;
        while (!predicate.test(string, scopeAnchor)) {
            string = name + n2;
            ++n2;
        }
        String string2 = string;
        if (string2 == null) {
            PyRefactoringUtil.a(40);
        }
        return string2;
    }

    public static boolean isValidNewName(@NotNull String name, @NotNull PsiElement scopeAnchor) {
        if (name == null) {
            PyRefactoringUtil.a(41);
        }
        if (scopeAnchor == null) {
            PyRefactoringUtil.a(42);
        }
        return !IntroduceValidator.isDefinedInScope(name, scopeAnchor) && !PyNames.isReserved(name);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x527FFC170F83L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 35: 
            case 36: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 35: 
            case 36: 
            case 40: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 35: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/PyRefactoringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 23: 
            case 26: 
            case 29: 
            case 33: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeAnchor";
                break;
            }
            case 25: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isValid";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/PyRefactoringUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsedNames";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findStatementsInRange";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "selectUniqueNameFromType";
                break;
            }
            case 27: 
            case 31: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "selectUniqueName";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "appendNumberUntilValid";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 35: 
            case 36: 
            case 40: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionInRange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findStatementsInRange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "selectUniqueNameFromType";
                break;
            }
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "selectUniqueName";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "appendNumberUntilValid";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isValidNewName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 35: 
            case 36: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

