/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyContainingFileRenamerFactory
implements AutomaticRenamerFactory {
    private static final long a = c.a(-2237057000934898224L, 7906534383680764703L, MethodHandles.lookup().lookupClass()).a(59419408058206L);

    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            PyContainingFileRenamerFactory.a(0);
        }
        if (!(element instanceof PyClass)) {
            return false;
        }
        ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeOwner.class);
        if (scopeOwner instanceof PyFile) {
            String string = ((PyClass)element).getName();
            String string2 = FileUtilRt.getNameWithoutExtension((String)scopeOwner.getName());
            return string2.equalsIgnoreCase(string);
        }
        return false;
    }

    public String getOptionName() {
        long l2 = a ^ 0x35E67E3F5A67L;
        return "Rename containing file";
    }

    public boolean isEnabled() {
        return PyCodeInsightSettings.getInstance().RENAME_CLASS_CONTAINING_FILE;
    }

    public void setEnabled(boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_CLASS_CONTAINING_FILE = enabled;
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        PyContainingFileRenamer pyContainingFileRenamer = new PyContainingFileRenamer((PyClass)element, newName);
        if (pyContainingFileRenamer == null) {
            PyContainingFileRenamerFactory.a(1);
        }
        return pyContainingFileRenamer;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x469661119BF3L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/rename/PyContainingFileRenamerFactory";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/rename/PyContainingFileRenamerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PyContainingFileRenamer
    extends AutomaticRenamer {
        private final PyClass a;
        private static final long b = c.a(-7386507740860677429L, -4890154892535160592L, MethodHandles.lookup().lookupClass()).a(34174726687892L);

        public PyContainingFileRenamer(PyClass element, String newName) {
            this.a = element;
            this.myElements.add(element.getContainingFile());
            this.suggestAllNames(element.getName(), newName);
        }

        public String getDialogTitle() {
            long l2 = b ^ 0x750DF5C7E21L;
            return "Rename Containing File";
        }

        public String getDialogDescription() {
            long l2 = b ^ 0x4D531F077195L;
            return "Rename containing file with the following name to: ";
        }

        public String entityName() {
            long l2 = b ^ 0x41D6CDF0AF05L;
            return "Containing File";
        }

        protected String nameToCanonicalName(@NonNls String name, PsiNamedElement element) {
            return FileUtilRt.getNameWithoutExtension((String)name);
        }

        protected String canonicalNameToName(@NonNls String canonicalName, PsiNamedElement element) {
            return canonicalName + "." + FileUtilRt.getExtension((String)this.a.getContainingFile().getName());
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        protected String suggestNameForElement(PsiNamedElement element, NameSuggester suggester, String newClassName, String oldClassName) {
            long l2 = b ^ 0x2C41BC86500BL;
            if (element instanceof PyFile && element.getName().equals(StringUtil.toLowerCase((String)oldClassName) + ".py")) {
                return StringUtil.toLowerCase((String)newClassName) + ".py";
            }
            return super.suggestNameForElement(element, suggester, newClassName, oldClassName);
        }
    }
}

