/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.resourceRoots;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.ContentFolderBaseImpl;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.module.PyContentEntriesEditor;
import com.jetbrains.python.module.PyRootTypeProvider;
import com.jetbrains.python.psi.c;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceRootProvider
extends PyRootTypeProvider {
    private final MultiMap<ContentEntry, VirtualFilePointer> a = new MultiMap();
    private static final long b = c.a(4578579698822175552L, 8842563608698712458L, MethodHandles.lookup().lookupClass()).a(61452516809487L);

    @Override
    public void reset(@NotNull Disposable disposable, PyContentEntriesEditor editor2, @NotNull Module module2) {
        if (disposable == null) {
            ResourceRootProvider.b(0);
        }
        if (module2 == null) {
            ResourceRootProvider.b(1);
        }
        this.a.clear();
        MultiMap<String, String> multiMap = this.getResourceRoots(module2);
        if (multiMap == null) {
            return;
        }
        for (String string : multiMap.keySet()) {
            ContentEntry contentEntry = ResourceRootProvider.a(string, editor2);
            if (contentEntry == null) continue;
            for (String string2 : multiMap.get((Object)string)) {
                this.a.putValue((Object)contentEntry, (Object)VirtualFilePointerManager.getInstance().create(string2, disposable, this.DUMMY_LISTENER));
            }
        }
    }

    @Override
    public void apply(Module module2) {
        MultiMap<String, String> multiMap = this.a();
        this.setResourceRoots(multiMap, module2);
    }

    @Override
    @Nullable
    public CustomShortcutSet getShortcut() {
        return new CustomShortcutSet(KeyStroke.getKeyStroke(82, 8));
    }

    @Override
    public boolean isModified(Module module2) {
        MultiMap<String, String> multiMap = this.getResourceRoots(module2);
        if (multiMap != null) {
            MultiMap<String, String> multiMap2 = this.a();
            if (!Comparing.haveEqualElements((Collection)multiMap.keySet(), (Collection)multiMap2.keySet())) {
                return true;
            }
            for (String string : multiMap.keySet()) {
                if (Comparing.haveEqualElements((Collection)multiMap.get((Object)string), (Collection)multiMap2.get((Object)string))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMine(ContentFolder folder) {
        return folder instanceof ResourceRootFolder;
    }

    @Override
    public MultiMap<ContentEntry, VirtualFilePointer> getRoots() {
        return this.a;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Modules.ResourcesRoot;
    }

    @Override
    public String getName() {
        long l2 = b ^ 0xE94CF41C060L;
        return "Resource";
    }

    @Override
    public Color getColor() {
        return JBColor.ORANGE;
    }

    @Override
    public ContentEntryEditingAction createRootEntryEditingAction(JTree tree, Disposable disposable, PyContentEntriesEditor editor2, ModifiableRootModel model) {
        return new PyRootTypeProvider.RootEntryEditingAction(this, tree, disposable, editor2, model);
    }

    @Override
    public ContentFolder[] createFolders(ContentEntry contentEntry) {
        ArrayList<ResourceRootFolder> arrayList = new ArrayList<ResourceRootFolder>(this.a.size());
        for (VirtualFilePointer virtualFilePointer : this.a.get((Object)contentEntry)) {
            arrayList.add(new ResourceRootFolder(virtualFilePointer, (ContentEntryImpl)contentEntry));
        }
        return arrayList.toArray(new ContentFolder[0]);
    }

    private MultiMap<String, String> a() {
        MultiMap multiMap = new MultiMap();
        for (ContentEntry contentEntry : this.a.keySet()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VirtualFilePointer virtualFilePointer : this.a.get((Object)contentEntry)) {
                arrayList.add(virtualFilePointer.getUrl());
            }
            multiMap.put((Object)contentEntry.getUrl(), arrayList);
        }
        return multiMap;
    }

    @NotNull
    public static Set<String> getAllResourceRoots(@NotNull Module module2) {
        if (module2 == null) {
            ResourceRootProvider.b(2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        ImmutableList immutableList = FluentIterable.from((Object[])PyRootTypeProvider.EP_NAME.getExtensions()).filter(ResourceRootProvider.class).toList();
        for (ResourceRootProvider resourceRootProvider : immutableList) {
            MultiMap<String, String> multiMap = resourceRootProvider.getResourceRoots(module2);
            if (multiMap == null) continue;
            hashSet.addAll(multiMap.values().stream().map(VfsUtilCore::urlToPath).collect(Collectors.toSet()));
        }
        HashSet<String> hashSet2 = hashSet;
        if (hashSet2 == null) {
            ResourceRootProvider.b(3);
        }
        return hashSet2;
    }

    @Nullable
    private static ContentEntry a(String string, PyContentEntriesEditor pyContentEntriesEditor) {
        for (ContentEntry contentEntry : pyContentEntriesEditor.getContentEntries()) {
            if (!contentEntry.getUrl().equals(string)) continue;
            return contentEntry;
        }
        return null;
    }

    @Nullable
    protected abstract MultiMap<String, String> getResourceRoots(Module var1);

    protected abstract void setResourceRoots(MultiMap<String, String> var1, Module var2);

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x2A4F254E79C5L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/resourceRoots/ResourceRootProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/resourceRoots/ResourceRootProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceRoots";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllResourceRoots";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResourceRootFolder
    extends ContentFolderBaseImpl {
        private static final long a = c.a(4525561595398972918L, -6164479141441911669L, MethodHandles.lookup().lookupClass()).a(1780367285014L);

        protected ResourceRootFolder(@NotNull VirtualFilePointer filePointer, @NotNull ContentEntryImpl contentEntry) {
            if (filePointer == null) {
                ResourceRootFolder.a(0);
            }
            if (contentEntry == null) {
                ResourceRootFolder.a(1);
            }
            super(filePointer, contentEntry);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x553F9A9C92AL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePointer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contentEntry";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/resourceRoots/ResourceRootProvider$ResourceRootFolder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

