/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.BlockingSet;
import com.intellij.util.concurrency.EdtExecutorService;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.awt.Component;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkUpdater
implements StartupActivity {
    private static final Logger d;
    public static final int INITIAL_ACTIVITY_DELAY = 3000;
    private static final Object a;
    private static final Set<String> b;
    private static final BlockingSet<String> c;
    private static final long e;

    public void runActivity(final @NotNull Project project) {
        Application application;
        if (project == null) {
            PythonSdkUpdater.a(0);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode()) {
            return;
        }
        EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
            long l2 = e ^ 0x2446C87B6F59L;
            if (project.isDisposed()) {
                return;
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Updating Python Paths", false){
                private static final long a = com.jetbrains.python.psi.c.a(-1322341414686322519L, 8559068358674863961L, MethodHandles.lookup().lookupClass()).a(24869812776620L);

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.a(0);
                    }
                    for (Sdk sdk : PythonSdkUpdater.a(project)) {
                        PythonSdkUpdater.update(sdk, null, project, null);
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x7300EDA0B313L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/sdk/PythonSdkUpdater$1", "run"));
                }
            });
        }, 3000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean update(@NotNull Sdk sdk, @Nullable SdkModificator sdkModificator, @Nullable Project project, @Nullable Component ownerComponent) {
        Object object;
        long l2 = e ^ 0x24C792D167C0L;
        if (sdk == null) {
            PythonSdkUpdater.a(1);
        }
        Application application = ApplicationManager.getApplication();
        assert (!application.isWriteAccessAllowed()) : "Can't update SDK under write action, not allowed in background";
        String string = PythonSdkType.getSdkKey(sdk);
        Object object2 = a;
        synchronized (object2) {
            b.add(string);
        }
        object2 = sdk.getHomePath();
        if (object2 != null && (PythonSdkType.isVirtualEnv((String)object2) || PythonSdkType.isConda(sdk))) {
            object = application.executeOnPooledThread(() -> PythonSdkType.activateVirtualEnv(sdk));
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    object.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw new AssertionError("Exception thrown while synchronizing with sdk updater ", exception);
                }
            }
        }
        PythonSdkUpdater.a(sdk, sdkModificator);
        if (!PythonSdkUpdater.a(sdk, sdkModificator, project)) {
            return false;
        }
        if (project == null) {
            return true;
        }
        if (application.isUnitTestMode()) {
            return true;
        }
        object = new Throwable();
        application.invokeLater(() -> PythonSdkUpdater.a(string, project, sdk, ownerComponent, (Throwable)object), ModalityState.NON_MODAL);
        return true;
    }

    public static void updateOrShowError(@NotNull Sdk sdk, @Nullable SdkModificator sdkModificator, @Nullable Project project, @Nullable Component ownerComponent) {
        boolean bl2;
        long l2 = e ^ 0x588BC358BCCL;
        if (sdk == null) {
            PythonSdkUpdater.a(2);
        }
        if (!(bl2 = PythonSdkUpdater.update(sdk, sdkModificator, project, ownerComponent))) {
            Messages.showErrorDialog((Project)project, (String)PyBundle.message("MSG.cant.setup.sdk.$0", PythonSdkUpdater.c(sdk)), (String)PyBundle.message("MSG.title.bad.sdk", new Object[0]));
        }
    }

    private static void a(@NotNull Sdk sdk, @Nullable SdkModificator sdkModificator2) {
        if (sdk == null) {
            PythonSdkUpdater.a(3);
        }
        if (!PythonSdkType.isRemote(sdk)) {
            SdkModificator sdkModificator3 = sdkModificator2 != null ? sdkModificator2 : sdk.getSdkModificator();
            String string = sdk.getSdkType().getVersionString(sdk);
            if (!StringUtil.equals((CharSequence)string, (CharSequence)sdkModificator3.getVersionString())) {
                PythonSdkUpdater.a(sdk, sdkModificator2, (Processor<SdkModificator>)((Processor)sdkModificator -> {
                    sdkModificator.setVersionString(string);
                    return true;
                }));
            }
        }
    }

    private static boolean a(@NotNull Sdk sdk, @Nullable SdkModificator sdkModificator, @Nullable Project project) {
        if (sdk == null) {
            PythonSdkUpdater.a(4);
        }
        if (!PythonSdkType.isRemote(sdk)) {
            List<VirtualFile> list2;
            boolean bl2 = PythonSdkUpdater.f(sdk);
            try {
                list2 = PythonSdkUpdater.c(sdk, project);
            }
            catch (InvalidSdkException invalidSdkException) {
                if (!PythonSdkType.isInvalid(sdk)) {
                    d.error((Throwable)invalidSdkException);
                }
                return false;
            }
            PythonSdkUpdater.a(sdk, sdkModificator, list2, bl2);
        }
        return true;
    }

    private static void b(@NotNull Sdk sdk, @Nullable Project project) {
        if (sdk == null) {
            PythonSdkUpdater.a(5);
        }
        if (PythonSdkType.isRemote(sdk)) {
            boolean bl2 = PythonSdkUpdater.f(sdk);
            List<VirtualFile> list2 = PythonSdkUpdater.a(sdk, project);
            PythonSdkUpdater.a(sdk, null, list2, bl2);
        }
    }

    private static boolean f(Sdk sdk) {
        String string = PythonSdkUpdater.a(sdk.getHomePath());
        return string != null && new File(string).mkdirs();
    }

    @NotNull
    private static List<VirtualFile> c(@NotNull Sdk sdk, @Nullable Project project) throws InvalidSdkException {
        if (sdk == null) {
            PythonSdkUpdater.a(6);
        }
        ImmutableList immutableList = ImmutableList.builder().addAll(PythonSdkUpdater.filterRootPaths(sdk, PythonSdkUpdater.a(sdk), project)).addAll(PythonSdkUpdater.b(sdk)).addAll(PythonSdkUpdater.d(sdk)).addAll(PyTypeShed.INSTANCE.findRootsForSdk(sdk)).build();
        if (immutableList == null) {
            PythonSdkUpdater.a(7);
        }
        return immutableList;
    }

    @NotNull
    private static List<VirtualFile> a(@NotNull Sdk sdk, @Nullable Project project) {
        if (sdk == null) {
            PythonSdkUpdater.a(8);
        }
        ImmutableList immutableList = ImmutableList.builder().addAll(PythonSdkUpdater.d(sdk, project)).addAll(PythonSdkUpdater.b(sdk)).addAll(PythonSdkUpdater.d(sdk)).addAll(PyTypeShed.INSTANCE.findRootsForSdk(sdk)).build();
        if (immutableList == null) {
            PythonSdkUpdater.a(9);
        }
        return immutableList;
    }

    @NotNull
    private static List<VirtualFile> d(@NotNull Sdk sdk) {
        SdkAdditionalData sdkAdditionalData;
        PythonSdkAdditionalData pythonSdkAdditionalData;
        if (sdk == null) {
            PythonSdkUpdater.a(10);
        }
        ArrayList arrayList = (pythonSdkAdditionalData = PyUtil.as(sdkAdditionalData = sdk.getSdkAdditionalData(), PythonSdkAdditionalData.class)) != null ? Lists.newArrayList(pythonSdkAdditionalData.getAddedPathFiles()) : Collections.emptyList();
        if (arrayList == null) {
            PythonSdkUpdater.a(11);
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> d(@NotNull Sdk sdk, @Nullable Project project) {
        SdkAdditionalData sdkAdditionalData;
        if (sdk == null) {
            PythonSdkUpdater.a(12);
        }
        if ((sdkAdditionalData = sdk.getSdkAdditionalData()) instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase = (PyRemoteSdkAdditionalDataBase)sdkAdditionalData;
            ArrayList arrayList = Lists.newArrayList();
            for (PathMappingSettings.PathMapping pathMapping : pyRemoteSdkAdditionalDataBase.getPathMappings().getPathMappings()) {
                arrayList.add(pathMapping.getLocalRoot());
            }
            List<VirtualFile> list2 = PythonSdkUpdater.filterRootPaths(sdk, arrayList, project);
            if (list2 == null) {
                PythonSdkUpdater.a(13);
            }
            return list2;
        }
        List<VirtualFile> list3 = Collections.emptyList();
        if (list3 == null) {
            PythonSdkUpdater.a(14);
        }
        return list3;
    }

    @NotNull
    public static List<VirtualFile> filterRootPaths(@NotNull Sdk sdk, @NotNull List<String> paths, @Nullable Project project) {
        VirtualFile virtualFile;
        PythonSdkAdditionalData pythonSdkAdditionalData;
        long l2 = e ^ 0x62843C6F8772L;
        if (sdk == null) {
            PythonSdkUpdater.a(15);
        }
        if (paths == null) {
            PythonSdkUpdater.a(16);
        }
        Collection<Object> collection = (pythonSdkAdditionalData = PyUtil.as(sdk.getSdkAdditionalData(), PythonSdkAdditionalData.class)) != null ? pythonSdkAdditionalData.getExcludedPathFiles() : Collections.emptyList();
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>();
        if (project != null) {
            for (VirtualFile virtualFile2 : virtualFile = ModuleManager.getInstance((Project)project).getModules()) {
                hashSet.addAll(PyUtil.getSourceRoots((Module)virtualFile2));
            }
        }
        virtualFile = Lists.newArrayList();
        VirtualFile virtualFile3 = PythonSdkType.isConda(sdk) ? PyCondaPackageManagerImpl.getCondaDirectory(sdk) : null;
        for (String string : paths) {
            VirtualFile virtualFile4;
            VirtualFile virtualFile2;
            if (!(string == null || FileUtilRt.extensionEquals((String)string, (String)"egg-info") || (virtualFile2 = StandardFileSystems.local().refreshAndFindFileByPath(string)) == null || virtualFile2.equals(virtualFile3) || collection.contains(virtualFile4 = PythonSdkType.getSdkRootVirtualFile(virtualFile2)) || hashSet.contains(virtualFile4))) {
                virtualFile.add(virtualFile4);
                continue;
            }
            d.info("Bogus sys.path entry " + string);
        }
        VirtualFile virtualFile5 = virtualFile;
        if (virtualFile5 == null) {
            PythonSdkUpdater.a(17);
        }
        return virtualFile5;
    }

    @NotNull
    private static List<VirtualFile> b(@NotNull Sdk sdk) {
        VirtualFile virtualFile;
        long l2 = e ^ 0x1228B73B914L;
        if (sdk == null) {
            PythonSdkUpdater.a(18);
        }
        ArrayList arrayList = Lists.newArrayList();
        String string = PythonSdkUpdater.a(sdk.getHomePath());
        if (string != null && (virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(string)) != null) {
            arrayList.add(virtualFile);
            d.info("Binary skeletons directory for SDK " + PythonSdkUpdater.c(sdk) + "): " + virtualFile.getPath());
        }
        if ((virtualFile = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) != null) {
            arrayList.add(virtualFile);
            d.info("User skeletons directory for SDK " + PythonSdkUpdater.c(sdk) + "): " + virtualFile.getPath());
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            PythonSdkUpdater.a(19);
        }
        return arrayList2;
    }

    @NotNull
    private static String c(@NotNull Sdk sdk) {
        long l2 = e ^ 0x7FB4E858EE0FL;
        if (sdk == null) {
            PythonSdkUpdater.a(20);
        }
        String string = sdk.getHomePath();
        String string2 = sdk.getName();
        String string3 = string != null ? string2 + " (" + string + ")" : string2;
        if (string3 == null) {
            PythonSdkUpdater.a(21);
        }
        return string3;
    }

    @Nullable
    private static String a(@Nullable String string) {
        return string != null ? PythonSdkType.getSkeletonsPath(PathManager.getSystemPath(), string) : null;
    }

    @NotNull
    private static List<String> a(@NotNull Sdk sdk) throws InvalidSdkException {
        long l2 = e ^ 0x6F3F686582FBL;
        if (sdk == null) {
            PythonSdkUpdater.a(22);
        }
        if (PythonSdkType.isRemote(sdk)) {
            throw new IllegalArgumentException("Cannot evaluate sys.path for remote Python interpreter " + sdk);
        }
        long l3 = System.currentTimeMillis();
        List<String> list2 = PythonSdkType.getSysPath(sdk.getHomePath());
        d.info("Updating sys.path took " + (System.currentTimeMillis() - l3) + " ms");
        List<String> list3 = list2;
        if (list3 == null) {
            PythonSdkUpdater.a(23);
        }
        return list3;
    }

    private static void a(@NotNull Sdk sdk, @Nullable SdkModificator sdkModificator2, @NotNull List<VirtualFile> list2, boolean bl2) {
        if (sdk == null) {
            PythonSdkUpdater.a(24);
        }
        if (list2 == null) {
            PythonSdkUpdater.a(25);
        }
        SdkModificator sdkModificator3 = sdkModificator2 != null ? sdkModificator2 : sdk.getSdkModificator();
        List<VirtualFile> list3 = Arrays.asList(sdkModificator3.getRoots(OrderRootType.CLASSES));
        if (bl2 || !Sets.newHashSet(list2).equals(Sets.newHashSet(list3))) {
            PythonSdkUpdater.a(sdk, sdkModificator2, (Processor<SdkModificator>)((Processor)sdkModificator -> {
                sdkModificator.removeAllRoots();
                for (VirtualFile virtualFile : list2) {
                    sdkModificator.addRoot(PythonSdkType.getSdkRootVirtualFile(virtualFile), OrderRootType.CLASSES);
                }
                return true;
            }));
        }
    }

    private static void a(@NotNull Sdk sdk, @Nullable SdkModificator sdkModificator, @NotNull Processor<SdkModificator> processor2) {
        if (sdk == null) {
            PythonSdkUpdater.a(26);
        }
        if (processor2 == null) {
            PythonSdkUpdater.a(27);
        }
        String string = PythonSdkType.getSdkKey(sdk);
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            SdkModificator sdkModificator2;
            Sdk sdk2 = PythonSdkType.findSdkByKey(string);
            SdkModificator sdkModificator3 = sdkModificator != null ? sdkModificator : (sdkModificator2 = sdk2 != null ? sdk2.getSdkModificator() : sdk.getSdkModificator());
            if (processor2.process((Object)sdkModificator2)) {
                sdkModificator2.commitChanges();
            }
        });
    }

    @NotNull
    private static Set<Sdk> a(@NotNull Project project) {
        if (project == null) {
            PythonSdkUpdater.a(28);
        }
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk = PythonSdkType.findPythonSdk(module2);
            if (sdk == null || !(sdk.getSdkType() instanceof PythonSdkType)) continue;
            linkedHashSet.add(sdk);
        }
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        if (linkedHashSet2 == null) {
            PythonSdkUpdater.a(29);
        }
        return linkedHashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void a(final String string, Project project, final Sdk sdk, final Component component, final Throwable throwable) {
        long l2 = e ^ 0x1DA9F15087C6L;
        Object object = a;
        synchronized (object) {
            if (!b.contains(string)) {
                return;
            }
            b.remove(string);
        }
        if (project.isDisposed()) {
            return;
        }
        if (PythonSdkType.findSdkByKey(string) == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, PyBundle.message("sdk.gen.updating.interpreter", new Object[0]), false){
            private static final long a = com.jetbrains.python.psi.c.a(101516531546660808L, -5945131006464058099L, MethodHandles.lookup().lookupClass()).a(156477206966187L);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                block18: {
                    long l2 = a ^ 0x7521E3B321F0L;
                    if (indicator == null) {
                        2.a(0);
                    }
                    Project project = this.getProject();
                    Sdk sdk2 = PythonSdkType.findSdkByKey(string);
                    if (sdk2 != null) {
                        c.put((Object)string);
                        try {
                            String string3 = PythonSdkUpdater.a(sdk.getHomePath());
                            try {
                                if (PythonSdkType.isRemote(sdk2) && project == null && component == null) {
                                    d.error("For refreshing skeletons of remote SDK, either project or owner component must be specified");
                                }
                                String string2 = PythonSdkUpdater.c(sdk);
                                d.info("Performing background update of skeletons for SDK " + string2);
                                indicator.setText("Updating skeletons...");
                                PySkeletonRefresher.refreshSkeletonsOfSdk(project, component, string3, sdk2);
                                PythonSdkUpdater.b(sdk2, this.getProject());
                                indicator.setIndeterminate(true);
                                indicator.setText("Scanning installed packages...");
                                indicator.setText2("");
                                d.info("Performing background scan of packages for SDK " + string2);
                                try {
                                    PyPackageManager.getInstance(sdk2).refreshAndGetPackages(true);
                                }
                                catch (com.intellij.execution.ExecutionException executionException) {
                                    if (d.isDebugEnabled()) {
                                        executionException.initCause(throwable);
                                        d.debug((Throwable)executionException);
                                        break block18;
                                    }
                                    d.warn(executionException.getMessage());
                                }
                            }
                            catch (InvalidSdkException invalidSdkException) {
                                if (PythonSdkType.isRemote(sdk2)) {
                                    PythonSdkType.notifyRemoteSdkSkeletonsFail(invalidSdkException, () -> {
                                        Sdk sdk2 = PythonSdkType.findSdkByKey(string);
                                        if (sdk2 != null) {
                                            PythonSdkUpdater.update(sdk2, null, project, component);
                                        }
                                    });
                                } else if (!PythonSdkType.isInvalid(sdk2)) {
                                    d.error((Throwable)invalidSdkException);
                                }
                            }
                        }
                        finally {
                            try {
                                c.remove((Object)string);
                            }
                            catch (IllegalStateException illegalStateException) {
                                d.error((Throwable)illegalStateException);
                            }
                        }
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x69953E7BA097L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/sdk/PythonSdkUpdater$2", "run"));
            }
        });
    }

    static {
        e = com.jetbrains.python.psi.c.a(-5503174268557929167L, 3745055814230801995L, MethodHandles.lookup().lookupClass()).a(151516589637277L);
        long l2 = e ^ 0x2ECE755DE168L;
        d = Logger.getInstance((String)"#com.jetbrains.python.sdk.PythonSdkUpdater");
        a = new Object();
        b = Sets.newHashSet();
        c = new BlockingSet();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x2B68D1EE89D8L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUpdater";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPaths";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalSdkPaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkPaths";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAddedPaths";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkMappedPaths";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRootPaths";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPaths";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPresentableName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSysPath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonSdks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateOrShowError";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalSdkVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalSdkPaths";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateRemoteSdkPaths";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSdkPaths";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUserAddedPaths";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkMappedPaths";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterRootPaths";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSkeletonsPaths";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSdkPresentableName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSysPath";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "commitSdkPathsIfChanged";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "changeSdkModificator";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPythonSdks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

