/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinRegistryService;
import com.jetbrains.python.sdk.flavors.WindowsStoreServiceKt;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WinPythonSdkFlavor
extends CPythonSdkFlavor {
    private static final String[] c;
    private static final Map<String, String> f;
    private static volatile Set<String> d;
    @NotNull
    private final WinRegistryService e;
    private static final long i;

    WinPythonSdkFlavor(@NotNull WinRegistryService winRegistryService) {
        if (winRegistryService == null) {
            WinPythonSdkFlavor.c(0);
        }
        this.e = winRegistryService;
    }

    @Override
    public Collection<String> suggestHomePaths(@Nullable Module module2) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        long l2 = i ^ 0x66FCA4FEF92DL;
        TreeSet<String> treeSet = new TreeSet<String>();
        this.a(treeSet, "python.exe", "jython.bat", "pypy.exe");
        WinPythonSdkFlavor.a(treeSet, "python.exe", PythonHelpersLocator.getHelpersRoot().getParent());
        if (SystemInfo.isWin10OrNewer && (virtualFile2 = WindowsStoreServiceKt.findInstallLocationForPackage("Python")) != null && (virtualFile = virtualFile2.findChild("python.exe")) != null) {
            treeSet.add(virtualFile.getPath());
        }
        return treeSet;
    }

    private void a(Set<String> set, String ... stringArray) {
        long l2 = i ^ 0x50C9788992DL;
        for (String string : stringArray) {
            WinPythonSdkFlavor.a(set, string, "C:\\", "C:\\Program Files\\");
            WinPythonSdkFlavor.findInPath(set, string);
            this.findInRegistry(set);
        }
    }

    @Override
    public boolean isValidSdkHome(@NotNull String path) {
        if (path == null) {
            WinPythonSdkFlavor.c(1);
        }
        if (super.isValidSdkHome(path)) {
            return true;
        }
        File file = new File(path);
        return WinPythonSdkFlavor.a(file) && this.isValidSdkPath(file);
    }

    private static boolean a(@NotNull File file) {
        long l2 = i ^ 0x1EF43FBE5403L;
        if (file == null) {
            WinPythonSdkFlavor.c(2);
        }
        if (!SystemInfo.isWin10OrNewer) {
            return false;
        }
        String string = System.getenv("LOCALAPPDATA");
        if (string == null) {
            return false;
        }
        File file2 = new File(string);
        if (!FileUtil.isAncestor((File)file2, (File)file, (boolean)true)) {
            return false;
        }
        File file3 = file.getParentFile();
        if (file3 == null) {
            return false;
        }
        Object[] objectArray = file3.listFiles();
        return objectArray != null && ArrayUtil.contains((Object)file, (Object[])objectArray);
    }

    void findInRegistry(@NotNull Collection<String> candidates) {
        if (candidates == null) {
            WinPythonSdkFlavor.c(3);
        }
        WinPythonSdkFlavor.a(this.e);
        candidates.addAll(d);
    }

    private static void a(Set<String> set, String string, String ... stringArray) {
        for (String string2 : stringArray) {
            WinPythonSdkFlavor.a(set, string2, FileUtilRt.getNameWithoutExtension((String)string), string);
        }
    }

    public static void findInPath(Collection<? super String> candidates, String exeName) {
        long l2 = i ^ 0x61409BAAD41CL;
        String string = System.getenv("PATH");
        if (string == null) {
            return;
        }
        for (String string2 : StringUtil.split((String)string, (String)";")) {
            File file;
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                if (string2.length() < 2) continue;
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (!(file = new File(string2, exeName)).exists()) continue;
            candidates.add(FileUtil.toSystemDependentName((String)file.getPath()));
        }
    }

    private static void a(@NotNull WinRegistryService winRegistryService) {
        long l2 = i ^ 0x39944990F87EL;
        if (winRegistryService == null) {
            WinPythonSdkFlavor.c(4);
        }
        if (d != null) {
            return;
        }
        d = new HashSet<String>();
        for (String string : c) {
            for (Map.Entry<String, String> entry : f.entrySet()) {
                String string2 = entry.getKey();
                String string3 = entry.getValue();
                String string4 = String.format("%s\\SOFTWARE\\%s", string, string2);
                String string5 = String.format("%s\\SOFTWARE\\Wow6432Node\\%s", string, string2);
                for (String string6 : new String[]{string4, string5}) {
                    List<String> list2 = winRegistryService.listBranches(string6);
                    for (String string7 : list2) {
                        String string8 = string6 + '\\' + string7;
                        List<String> list3 = winRegistryService.listBranches(string8);
                        for (String string9 : list3) {
                            File file;
                            String string10 = winRegistryService.getDefaultKey(string8 + '\\' + string9 + "\\InstallPath");
                            if (string10 == null || !(file = new File(string10, string3)).exists()) continue;
                            d.add(FileUtil.toSystemDependentName((String)file.getPath()));
                        }
                    }
                }
            }
        }
    }

    private static void a(Collection<String> collection, String string, String string2, String string3) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
        if (virtualFile != null) {
            if (virtualFile instanceof NewVirtualFile) {
                ((NewVirtualFile)virtualFile).markDirty();
            }
            virtualFile.refresh(true, false);
            for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
                VirtualFile virtualFile3;
                if (!virtualFile2.isDirectory() || !StringUtil.toLowerCase((String)virtualFile2.getName()).startsWith(string2) || (virtualFile3 = virtualFile2.findChild(string3)) == null) continue;
                collection.add(FileUtil.toSystemDependentName((String)virtualFile3.getPath()));
            }
        }
    }

    static {
        i = com.jetbrains.python.psi.c.a(6233163613388169836L, 3728415663993400569L, MethodHandles.lookup().lookupClass()).a(160215825294388L);
        long l2 = i ^ 0x24219C19D3D4L;
        c = new String[]{"HKEY_LOCAL_MACHINE", "HKEY_CURRENT_USER"};
        f = ImmutableMap.of((Object)"Python", (Object)"python.exe", (Object)"IronPython", (Object)"ipy.exe");
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = i ^ 0x1C333F9B5E7FL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "winRegistryService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registryService";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/sdk/flavors/WinPythonSdkFlavor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidSdkHome";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mayBeAppXReparsePoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findInRegistry";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fillRegistryCache";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

