/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class SkeletonVersionChecker {
    private static final Logger c;
    static final Pattern ONE_LINE;
    public static final int PREGENERATED_VERSION = -1;
    @NonNls
    static final String REQUIRED_VERSION_FNAME = "required_gen_version";
    @NonNls
    static final String DEFAULT_NAME = "(default)";
    @NonNls
    public static final String BUILTIN_NAME = "(built-in)";
    @NonNls
    public static final String PREGENERATED = "(pre-generated)";
    private final TreeMap<QualifiedName, Integer> a;
    private Integer d;
    private Integer b;
    private static final long e;

    public SkeletonVersionChecker(int defaultVersion) {
        this.a = SkeletonVersionChecker.b();
        this.d = defaultVersion;
        this.a();
    }

    public boolean isPregenerated() {
        return this.d == -1;
    }

    private static TreeMap<QualifiedName, Integer> b() {
        return new TreeMap<QualifiedName, Integer>((qualifiedName, qualifiedName2) -> {
            Iterator iterator = qualifiedName.getComponents().iterator();
            Iterator iterator2 = qualifiedName2.getComponents().iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                int n2 = ((String)iterator.next()).compareTo((String)iterator2.next());
                if (n2 == 0) continue;
                return n2;
            }
            if (iterator.hasNext()) {
                return 1;
            }
            if (iterator2.hasNext()) {
                return -1;
            }
            return 0;
        });
    }

    SkeletonVersionChecker(TreeMap<QualifiedName, Integer> explicit, Integer builtins) {
        this.a = explicit;
        this.b = builtins;
    }

    public SkeletonVersionChecker withDefaultVersionIfUnknown(int version) {
        SkeletonVersionChecker skeletonVersionChecker = new SkeletonVersionChecker(this.a, this.b);
        skeletonVersionChecker.d = this.d != 0 ? this.d : version;
        return skeletonVersionChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        block11: {
            long l2 = e ^ 0x447E7D54DF01L;
            File file = PythonHelpersLocator.getHelperFile(REQUIRED_VERSION_FNAME);
            try {
                if (!file.canRead()) break block11;
                FileReader fileReader = new FileReader(file);
                try (LineNumberReader lineNumberReader = new LineNumberReader(fileReader);){
                    String string;
                    do {
                        if ((string = lineNumberReader.readLine()) == null) continue;
                        Matcher matcher = ONE_LINE.matcher(string);
                        if (matcher.matches()) {
                            String string2 = matcher.group(1);
                            String string3 = matcher.group(2);
                            if (string2 == null) continue;
                            int n2 = SkeletonVersionChecker.fromVersionString(string3);
                            if (DEFAULT_NAME.equals(string2)) {
                                if (this.d == -1) continue;
                                this.d = n2;
                                continue;
                            }
                            if (BUILTIN_NAME.equals(string2)) {
                                this.b = n2;
                                continue;
                            }
                            this.a.put(QualifiedName.fromDottedString((String)string2), n2);
                            continue;
                        }
                        c.warn("required_gen_version:" + lineNumberReader.getLineNumber() + " Incorrect line, ignored");
                    } while (string != null);
                    if (this.b == null) {
                        this.b = this.d;
                        c.warn("Assuming default version for built-ins");
                    }
                    assert (this.d != null) : "Default version not known somehow!";
                }
            }
            catch (IOException iOException) {
                throw new LoadException(iOException);
            }
        }
    }

    public int getRequiredVersion(String package_name) {
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)package_name);
        Map.Entry<QualifiedName, Integer> entry = this.a.floorEntry(qualifiedName);
        if (entry != null && qualifiedName.matchesPrefix(entry.getKey())) {
            return entry.getValue();
        }
        return this.d;
    }

    public int getBuiltinVersion() {
        if (this.b == null) {
            this.b = this.d;
        }
        return this.b;
    }

    public static int fromVersionString(String input) {
        int n2 = input.indexOf(46);
        try {
            if (n2 > 0) {
                int n3 = Integer.parseInt(input.substring(0, n2));
                int n4 = Integer.parseInt(input.substring(n2 + 1));
                return (n3 << 8) + n4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public static String toVersionString(int input) {
        int n2 = input >> 8;
        int n3 = input - (n2 << 8);
        return n2 + "." + n3;
    }

    static {
        e = com.jetbrains.python.psi.c.a(8830333637185014960L, 8087756539304534310L, MethodHandles.lookup().lookupClass()).a(273492529275831L);
        long l2 = e ^ 0x6FB2EAF51148L;
        c = Logger.getInstance((String)"#com.jetbrains.python.sdk.PythonSdkType.SkeletonVersionChecker");
        ONE_LINE = Pattern.compile("^(?:(\\w+(?:\\.\\w+)*|\\(built-in\\)|\\(default\\))\\s+(\\d+\\.\\d+))?\\s*(?:#.*)?$");
    }

    public static class LoadException
    extends RuntimeException {
        public LoadException(Throwable e10) {
            super(e10);
        }
    }
}

