/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.jetbrains.cython.CythonFileType;
import com.jetbrains.jinja2.Jinja2FileType;
import com.jetbrains.mako.MakoFileType;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.templateLanguages.PyTemplateFileTypeConfigurable;
import com.jetbrains.python.templateLanguages.PyTemplatesServiceImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class PyTemplateFileTypesPanel
extends JPanel
implements PyTemplateFileTypeConfigurable {
    private final JList d;
    private PyTemplateFileTypeConfigurable e;
    private final CommonActionsPanel f;
    private List<FileType> b;
    private final Set<FileType> c;
    private final Set<FileType> a;
    private static final long g = com.jetbrains.python.psi.c.a(7303292624433514335L, -6320405665874749866L, MethodHandles.lookup().lookupClass()).a(272734342336533L);

    PyTemplateFileTypesPanel() {
        long l2 = g ^ 0xC5F5AECABEL;
        super(new BorderLayout());
        this.c = Sets.newHashSet();
        this.a = Sets.newHashSet();
        this.d = new JBList(new DefaultListModel());
        this.d.setSelectionMode(0);
        this.d.setCellRenderer(new FileTypeRenderer(() -> {
            ArrayList<FileType> arrayList = new ArrayList<FileType>();
            for (int i10 = 0; i10 < this.d.getModel().getSize(); ++i10) {
                arrayList.add((FileType)this.d.getModel().getElementAt(i10));
            }
            return arrayList;
        }));
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)this.d).setAddAction(anActionButton -> this.e.addFileType()).setRemoveAction(anActionButton -> this.e.removeFileType()).setRemoveActionUpdater(anActionEvent -> PyTemplateFileTypesPanel.b(this.getSelectedFileType())).disableUpDownActions();
        this.add((Component)toolbarDecorator.createPanel(), "Center");
        this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Template file types", (boolean)false));
        this.f = toolbarDecorator.getActionsPanel();
        new ListSpeedSearch(this.d){

            protected String getElementText(Object element) {
                if (element instanceof FileType) {
                    return ((FileType)element).getDescription();
                }
                return super.getElementText(element);
            }
        };
        this.attachActions(this);
    }

    public CommonActionsPanel getActionsPanel() {
        return this.f;
    }

    private static boolean b(FileType fileType) {
        return !PyTemplatesServiceImpl.BASIC_TEMPLATE_TYPES.contains(fileType);
    }

    public void attachActions(PyTemplateFileTypeConfigurable controller) {
        this.e = controller;
    }

    public FileType getSelectedFileType() {
        return (FileType)this.d.getSelectedValue();
    }

    public JComponent getComponent() {
        return this;
    }

    public void setFileTypes(FileType[] types) {
        DefaultListModel defaultListModel = (DefaultListModel)this.d.getModel();
        defaultListModel.clear();
        for (FileType fileType : types) {
            if (fileType == FileTypes.UNKNOWN) continue;
            defaultListModel.addElement(fileType);
        }
        ScrollingUtil.ensureSelectionExists((JList)this.d);
    }

    public int getSelectedIndex() {
        return this.d.getSelectedIndex();
    }

    public void setSelectionIndex(int selectedIndex) {
        this.d.setSelectedIndex(selectedIndex);
    }

    public void selectFileType(FileType fileType) {
        this.d.setSelectedValue(fileType, true);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.d, true));
    }

    @Override
    public void addFileType() {
        long l2 = g ^ 0x59D5BC0EEAF6L;
        BaseListPopupStep<FileType> baseListPopupStep = new BaseListPopupStep<FileType>("Select File Type", this.c()){
            private static final long a = com.jetbrains.python.psi.c.a(4945853875310868149L, 5280623720854506285L, MethodHandles.lookup().lookupClass()).a(10042418926697L);

            public Icon getIconFor(FileType aValue) {
                return aValue.getIcon();
            }

            @NotNull
            public String getTextFor(FileType value) {
                String string = value.getDescription();
                if (string == null) {
                    2.a(0);
                }
                return string;
            }

            public PopupStep onChosen(FileType fileType, boolean finalChoice) {
                PyTemplateFileTypesPanel.this.a(fileType);
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0xA48DF10AAFAL;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/templateLanguages/PyTemplateFileTypesPanel$2", "getTextFor"));
            }
        };
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)baseListPopupStep);
        listPopup.show(this.getActionsPanel().getAnActionButton(CommonActionsPanel.Buttons.ADD).getPreferredPopupPoint());
    }

    private void a(FileType fileType) {
        this.b.add(fileType);
        if (!this.a.contains(fileType)) {
            this.c.add(fileType);
        } else {
            this.a.remove(fileType);
        }
        this.b();
        this.selectFileType(fileType);
    }

    private FileType[] c() {
        FileType[] fileTypeArray = this.d();
        PyTemplatesServiceImpl.sortTypes(fileTypeArray);
        return fileTypeArray;
    }

    private FileType[] d() {
        FileType[] fileTypeArray = FileTypeManager.getInstance().getRegisteredFileTypes();
        ArrayList<FileType> arrayList = new ArrayList<FileType>();
        HashSet hashSet = Sets.newHashSet((Object[])new FileType[]{Jinja2FileType.INSTANCE, MakoFileType.INSTANCE, PythonFileType.INSTANCE, CythonFileType.INSTANCE, ArchiveFileType.INSTANCE});
        hashSet.addAll(this.b);
        for (FileType fileType : fileTypeArray) {
            if (fileType.isBinary() || fileType.isReadOnly() || hashSet.contains(fileType)) continue;
            arrayList.add(fileType);
        }
        return arrayList.toArray(FileType.EMPTY_ARRAY);
    }

    @Override
    public void removeFileType() {
        FileType fileType = this.getSelectedFileType();
        if (fileType == null) {
            return;
        }
        this.b.remove(fileType);
        if (!this.c.contains(fileType)) {
            this.a.add(fileType);
        } else {
            this.c.remove(fileType);
        }
        this.b();
    }

    private void b() {
        FileType[] fileTypeArray = this.b.toArray(FileType.EMPTY_ARRAY);
        PyTemplatesServiceImpl.sortTypes(fileTypeArray);
        this.setFileTypes(fileTypeArray);
    }

    public void setFileTypes(List<String> fileTypes) {
        ArrayList arrayList = Lists.newArrayList();
        HashMap hashMap = Maps.newHashMap();
        for (FileType fileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
            hashMap.put(fileType.getName(), fileType);
        }
        for (String string : fileTypes) {
            if (!hashMap.containsKey(string)) continue;
            arrayList.add(hashMap.get(string));
        }
        this.b = arrayList;
        for (FileType fileType : PyTemplatesServiceImpl.BASIC_TEMPLATE_TYPES) {
            if (this.b.contains(fileType)) continue;
            this.b.add(fileType);
        }
        this.b();
    }

    public boolean isModified() {
        return !this.c.isEmpty() || !this.a.isEmpty();
    }

    public List<String> getFileTypeNames() {
        ArrayList arrayList = Lists.newArrayList();
        for (FileType fileType : this.b) {
            arrayList.add(fileType.getName());
        }
        return arrayList;
    }
}

