/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringReferenceProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.EpydocString;
import com.jetbrains.python.documentation.docstrings.SphinxDocString;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.validation.PyAnnotator;
import java.lang.invoke.MethodHandles;

public class DocStringAnnotator
extends PyAnnotator {
    private static final long c = com.jetbrains.python.psi.c.a(-1236107800455364789L, 5835333683129779586L, MethodHandles.lookup().lookupClass()).a(34596675926656L);

    @Override
    public void visitPyFile(PyFile node) {
        this.a(DocStringUtil.findDocStringExpression(node));
    }

    @Override
    public void visitPyFunction(PyFunction node) {
        this.a(DocStringUtil.findDocStringExpression(node.getStatementList()));
    }

    @Override
    public void visitPyClass(PyClass node) {
        this.a(DocStringUtil.findDocStringExpression(node.getStatementList()));
    }

    @Override
    public void visitPyAssignmentStatement(PyAssignmentStatement node) {
        PyExpression pyExpression;
        long l2 = c ^ 0x64F77B8E8EFL;
        if (node.isAssignmentTo("__doc__") && (pyExpression = node.getAssignedValue()) instanceof PyStringLiteralExpression) {
            Annotation annotation = this.getHolder().createInfoAnnotation((PsiElement)pyExpression, null);
            annotation.setTextAttributes(PyHighlighter.PY_DOC_COMMENT);
            this.a((PyStringLiteralExpression)pyExpression);
        }
    }

    @Override
    public void visitPyExpressionStatement(PyExpressionStatement node) {
        if (node.getExpression() instanceof PyStringLiteralExpression && DocStringUtil.isVariableDocString((PyStringLiteralExpression)node.getExpression())) {
            this.a((PyStringLiteralExpression)node.getExpression());
        }
    }

    private void a(PyStringLiteralExpression pyStringLiteralExpression) {
        if (pyStringLiteralExpression != null) {
            TextRange textRange;
            String[] stringArray;
            DocStringFormat docStringFormat = DocStringUtil.getConfiguredDocStringFormat(pyStringLiteralExpression);
            if (docStringFormat == DocStringFormat.EPYTEXT) {
                stringArray = EpydocString.ALL_TAGS;
            } else if (docStringFormat == DocStringFormat.REST) {
                stringArray = SphinxDocString.ALL_TAGS;
            } else {
                return;
            }
            int n2 = 0;
            while ((textRange = DocStringReferenceProvider.findNextTag(pyStringLiteralExpression.getText(), n2, stringArray)) != null) {
                Annotation annotation = this.getHolder().createInfoAnnotation(textRange.shiftRight(pyStringLiteralExpression.getTextRange().getStartOffset()), null);
                annotation.setTextAttributes(PyHighlighter.PY_DOC_COMMENT_TAG);
                n2 = textRange.getEndOffset();
            }
        }
    }
}

