/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby;

import com.intellij.psi.PsiElement;
import java.nio.charset.StandardCharsets;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RRegexpLiteral;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.util.ByteList;

public class JoniUtil {
    public static Regex regex(String regex) {
        return JoniUtil.regex(regex, 0);
    }

    public static Regex regex(String regex, int option) {
        byte[] byArray = regex.getBytes(StandardCharsets.UTF_8);
        return new Regex(byArray, 0, byArray.length, option, (Encoding)UTF8Encoding.INSTANCE);
    }

    public static Regex regex(RRegexpLiteral key) {
        String string = key.getContent();
        PsiElement psiElement = key.getLastChild();
        String string2 = psiElement != null && psiElement.getNode().getElementType() == RubyTokenTypes.tREGEXP_END ? psiElement.getText() : "";
        int n2 = 0;
        if (string2.contains("m")) {
            n2 |= 4;
        }
        if (string2.contains("i")) {
            n2 |= 1;
        }
        if (string2.contains("x")) {
            n2 |= 2;
        }
        return JoniUtil.regex(string, n2);
    }

    private static ByteList a(String string) {
        return new ByteList(string.getBytes(StandardCharsets.UTF_8), (Encoding)UTF8Encoding.INSTANCE);
    }

    public static boolean search(Regex pattern, String string) {
        ByteList byteList = JoniUtil.a(string);
        int n2 = byteList.getRealSize();
        int n3 = byteList.getBegin();
        Matcher matcher = pattern.matcher(byteList.getUnsafeBytes(), n3, n3 + n2);
        int n4 = matcher.search(n3, n3 + n2, 0);
        return n4 >= 0;
    }

    @Nullable
    public static String gsubBang(String string, Regex pattern, String replacement, LanguageLevel languageLevel) {
        return JoniUtil.a(string, pattern, replacement);
    }

    @Nullable
    private static String a(String string, Regex regex, String string2) {
        int n2;
        ByteList byteList = JoniUtil.a(string);
        int n3 = byteList.getBegin();
        int n4 = byteList.getRealSize();
        int n5 = n3 + n4;
        byte[] byArray = byteList.getUnsafeBytes();
        Matcher matcher = regex.matcher(byArray, n3, n5);
        int n6 = matcher.search(n3, n5, 0);
        if (n6 < 0) {
            return null;
        }
        int n7 = n4 + 30;
        ByteList byteList2 = new ByteList(n7);
        byteList2.setRealSize(n7);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = n3;
        while (n6 >= 0) {
            n2 = matcher.getBegin();
            int n12 = matcher.getEnd();
            String string3 = JoniUtil.a(string2, string, matcher, (Encoding)UTF8Encoding.INSTANCE);
            ByteList byteList3 = JoniUtil.a(string3);
            int n13 = n10 - n9 + (n6 - n8) + byteList3.getRealSize() + 3;
            if (n7 < n13) {
                while (n7 < n13) {
                    n7 <<= 1;
                }
                n13 = n10 - n9;
                byteList2.realloc(n7);
                byteList2.setRealSize(n7);
                n10 = n9 + n13;
            }
            n13 = n6 - n8;
            System.arraycopy(byArray, n11, byteList2.getUnsafeBytes(), n10, n13);
            System.arraycopy(byteList3.getUnsafeBytes(), byteList3.getBegin(), byteList2.getUnsafeBytes(), n10 += n13, byteList3.getRealSize());
            n10 += byteList3.getRealSize();
            n8 = n12;
            if (n2 == n12) {
                if (n4 <= n12) break;
                n13 = UTF8Encoding.INSTANCE.length(byArray, n3 + n12, n5);
                System.arraycopy(byArray, n3 + n12, byteList2.getUnsafeBytes(), n10, n13);
                n10 += n13;
                n8 = n12 + n13;
            }
            n11 = n3 + n8;
            if (n8 > n4) break;
            n6 = matcher.search(n11, n5, 0);
        }
        if (n4 > n8) {
            n2 = n10 - n9;
            if (n7 - n2 < n4 - n8) {
                n7 = n2 + n4 - n8;
                byteList2.realloc(n7);
                n10 = n9 + n2;
            }
            System.arraycopy(byArray, n11, byteList2.getUnsafeBytes(), n10, n4 - n8);
            n10 += n4 - n8;
        }
        byteList2.setRealSize(n10 - n9);
        return byteList2.toString();
    }

    private static String a(String string, String string2, Matcher matcher, Encoding encoding) {
        int n2;
        Region region = matcher.getRegion();
        int n3 = -1;
        ByteList byteList = JoniUtil.a(string);
        int n4 = n2 = byteList.getBegin();
        int n5 = n2 + byteList.getRealSize();
        byte[] byArray = byteList.getUnsafeBytes();
        ByteList byteList2 = JoniUtil.a(string2);
        ByteList byteList3 = null;
        block8: while (n4 < n5) {
            int n6;
            int n7 = n4;
            int n8 = byArray[n4] & 0xFF;
            if ((n6 = encoding.length(byArray, n4++, n5)) != 1) {
                n4 += n6 - 1;
                continue;
            }
            if (n8 != 92 || n4 == n5) continue;
            if (byteList3 == null) {
                byteList3 = new ByteList(n7 - n2);
            }
            byteList3.append(byArray, n2, n7 - n2);
            n8 = byArray[n4++] & 0xFF;
            n2 = n4;
            switch (n8) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    n3 = n8 - 48;
                    break;
                }
                case 38: {
                    n3 = 0;
                    break;
                }
                case 96: {
                    byteList3.append(byteList2.getUnsafeBytes(), byteList2.getBegin(), matcher.getBegin());
                    continue block8;
                }
                case 39: {
                    byteList3.append(byteList2.getUnsafeBytes(), byteList2.getBegin() + matcher.getEnd(), byteList2.getRealSize() - matcher.getEnd());
                    continue block8;
                }
                case 43: {
                    if (region == null) {
                        if (matcher.getBegin() != -1) break;
                        n3 = 0;
                        continue block8;
                    }
                    for (n3 = region.numRegs - 1; region.beg[n3] == -1 && n3 > 0; --n3) {
                    }
                    if (n3 != 0) break;
                    continue block8;
                }
                case 92: {
                    byteList3.append(byArray, n4 - 1, 1);
                    continue block8;
                }
                default: {
                    byteList3.append(byArray, n4 - 2, 2);
                    continue block8;
                }
            }
            if (region != null) {
                if (n3 < 0 || n3 >= region.numRegs || region.beg[n3] == -1) continue;
                byteList3.append(byteList2.getUnsafeBytes(), byteList2.getBegin() + region.beg[n3], region.end[n3] - region.beg[n3]);
                continue;
            }
            if (n3 != 0 || matcher.getBegin() == -1) continue;
            byteList3.append(byteList2.getUnsafeBytes(), byteList2.getBegin() + matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
        }
        if (n2 < n5) {
            if (byteList3 == null) {
                return byteList.makeShared(n2 - byteList.getBegin(), n5 - n2).toString();
            }
            byteList3.append(byArray, n2, n5 - n2);
        }
        if (byteList3 == null) {
            return string;
        }
        return byteList3.toString();
    }
}

