/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.psi.c;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.IrbUtil;
import org.jetbrains.plugins.ruby.console.RubyCodeExecutor;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public final class LoadInIrbConsoleAction
extends AnAction {
    private static final long a = c.a(-235234733258871200L, -7802492666085708739L, MethodHandles.lookup().lookupClass()).a(66076952708583L);

    public void update(@NotNull AnActionEvent e10) {
        if (e10 == null) {
            LoadInIrbConsoleAction.a(0);
        }
        Presentation presentation = e10.getPresentation();
        DataContext dataContext = e10.getDataContext();
        Module module2 = RModuleUtil.getInstance().getModule(dataContext);
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        boolean bl2 = module2 != null && RModuleUtil.getInstance().hasRubySupport(module2);
        boolean bl3 = bl2 && RubyVirtualFileScanner.isRubyFile(virtualFile) && !LoadInIrbConsoleAction.a(module2).isEmpty();
        presentation.setEnabled(bl3);
        presentation.setVisible(PlatformUtils.isRubyMine() ? bl2 : bl3);
    }

    public void actionPerformed(@NotNull AnActionEvent e10) {
        long l2 = a ^ 0x212661E69E35L;
        if (e10 == null) {
            LoadInIrbConsoleAction.a(1);
        }
        DataContext dataContext = e10.getDataContext();
        Module module2 = RModuleUtil.getInstance().getModule(dataContext);
        assert (module2 != null);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        assert (editor2 != null);
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        assert (virtualFile != null);
        Collection<RunContentDescriptor> collection = LoadInIrbConsoleAction.a(module2);
        Project project = e10.getProject();
        assert (project != null);
        ExecutionHelper.selectContentDescriptor((DataContext)e10.getDataContext(), (Project)project, collection, (String)"Select console to load to", runContentDescriptor -> {
            long l2 = a ^ 0xE25B53CDDF3L;
            if (runContentDescriptor == null) {
                Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
                if (sdk == null) {
                    LoadInIrbConsoleAction.a(RBundle.message("sdk.no.specified"));
                } else {
                    String string = IrbUtil.getIRBExecutable(sdk);
                    if (string == null) {
                        LoadInIrbConsoleAction.a(RBundle.message("irb.console.actions.load.text.error.running.not.found"));
                    } else {
                        LoadInIrbConsoleAction.a(RBundle.message("irb.console.actions.load.text.error.irb.isnt.running", string));
                    }
                }
                return;
            }
            ExecutionConsole executionConsole = runContentDescriptor.getExecutionConsole();
            if (executionConsole instanceof RubyCodeExecutor) {
                try {
                    ((RubyCodeExecutor)executionConsole).executeCode(module2, editor2, virtualFile);
                }
                catch (IOException iOException) {
                    String string = iOException.getMessage();
                    LoadInIrbConsoleAction.a("Unable load to console." + (string != null ? "(" + string + ")" : ""));
                }
            }
        });
    }

    private static void a(String string) {
        long l2 = a ^ 0x5BF522DBE53AL;
        Messages.showErrorDialog((String)string, (String)RBundle.message("irb.console.actions.load.text.title"));
    }

    private static Collection<RunContentDescriptor> a(@NotNull Module module2) {
        String string;
        Sdk sdk;
        if (module2 == null) {
            LoadInIrbConsoleAction.a(2);
        }
        if ((sdk = RModuleUtil.getInstance().findRubySdkForModule(module2)) != null && (string = IrbUtil.getIRBExecutable(sdk)) != null) {
            return ExecutionHelper.findRunningConsole((Project)module2.getProject(), runContentDescriptor -> {
                ProcessHandler processHandler = runContentDescriptor.getProcessHandler();
                if (processHandler == null || processHandler.isProcessTerminated()) {
                    return false;
                }
                ExecutionConsole executionConsole = runContentDescriptor.getExecutionConsole();
                return executionConsole instanceof RubyCodeExecutor && ((RubyCodeExecutor)executionConsole).isIrbConsole(module2, string);
            });
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x436ABB751B7FL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/console/LoadInIrbConsoleAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findRunningIrbOrRailsConsole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

