/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.duplocator;

import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.TreeHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.duplocator.RubyDuplocatorSettings;
import org.jetbrains.plugins.ruby.duplocator.RubyTreeHasher;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUntilStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhileStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RIfModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUnlessModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUntilModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RWhileModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public class RubySpecificHasher
extends NodeSpecificHasher {
    private final TreeHasher b;
    private final RubyDuplocatorSettings a;
    private static final long c = com.jetbrains.python.psi.c.a(6017927761497109999L, 188904450839325853L, MethodHandles.lookup().lookupClass()).a(97836326346692L);

    public RubySpecificHasher(@NotNull RubyDuplocatorSettings settings, @NotNull FragmentsCollector callback, boolean forIndexing) {
        if (settings == null) {
            RubySpecificHasher.b(0);
        }
        if (callback == null) {
            RubySpecificHasher.b(1);
        }
        this.a = settings;
        this.b = new RubyTreeHasher(callback, settings, forIndexing);
    }

    @Override
    public int getNodeCost(PsiElement node) {
        if (node instanceof RPseudoConstant || node instanceof RGroupedExpression || node instanceof RCompoundStatement || node instanceof RBodyStatement || node instanceof RCodeBlock || node instanceof RListOfExpressions || node instanceof RContainer) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getNodeHash(PsiElement node) {
        RIdentifier rIdentifier;
        if (node instanceof RBinaryExpression) {
            return ((RBinaryExpression)node).getOperationType().toString().hashCode();
        }
        if (node instanceof RUnaryExpression) {
            return ((RUnaryExpression)node).getOperationName().hashCode();
        }
        if (node instanceof RAssignmentExpression) {
            IElementType iElementType = ((RAssignmentExpression)node).getOperationType();
            return iElementType != null ? iElementType.toString().hashCode() : 0;
        }
        if (node instanceof RSymbol) {
            String string = ((RSymbol)node).getValue();
            return string != null ? string.hashCode() : 0;
        }
        if (node instanceof RLiteral) {
            if (!this.a.DISTINGUISH_LITERALS) {
                return 0;
            }
            return ((RLiteral)node).getContent().hashCode();
        }
        if (node instanceof RGlobalVariable || node instanceof RConstant) {
            if (!this.a.DISTINGUISH_VARIABLES) {
                return 0;
            }
            return node.getText().hashCode();
        }
        if (node instanceof RField) {
            if (!this.a.DISTINGUISH_FIELDS) {
                return 0;
            }
            return node.getText().hashCode();
        }
        if (node instanceof RIdentifier && ((rIdentifier = (RIdentifier)node).isParameterDeclaration() || rIdentifier.isLocalVariable())) {
            if (!this.a.DISTINGUISH_VARIABLES) {
                return 0;
            }
            return node.getText().hashCode();
        }
        if (node instanceof RMethod) {
            int n2 = ((RMethod)node).getPresentableName(false).hashCode();
            for (ArgumentInfo argumentInfo : ((RMethod)node).getArgumentInfos()) {
                n2 = n2 * 31 + argumentInfo.getType().ordinal();
                if (!this.a.DISTINGUISH_VARIABLES) continue;
                n2 = n2 * 31 + argumentInfo.getName().hashCode();
            }
            return n2;
        }
        if (node instanceof RContainer) {
            return ((RContainer)node).getFQN().hashCode();
        }
        return 0;
    }

    @Override
    public List<PsiElement> getNodeChildren(final PsiElement node) {
        if (node == null) {
            return Collections.emptyList();
        }
        final ArrayList arrayList = new ArrayList();
        node.accept((PsiElementVisitor)new RubyElementVisitor(){

            @Override
            public void visitRIfStatement(RIfStatement ifStatement) {
                arrayList.add(ifStatement.getCondition());
                arrayList.addAll(ifStatement.getThenBlock().getStatements());
                arrayList.addAll(ifStatement.getElsifBlocks());
                arrayList.add(ifStatement.getElseBlock());
            }

            @Override
            public void visitRIfModStatement(RIfModStatement ifModStatement) {
                this.a(ifModStatement);
            }

            @Override
            public void visitRUnlessStatement(RUnlessStatement unlessStatement) {
                arrayList.add(unlessStatement.getCondition());
                arrayList.addAll(unlessStatement.getThenBlock().getStatements());
                arrayList.add(unlessStatement.getElseBlock());
            }

            @Override
            public void visitRUnlessModStatement(RUnlessModStatement unlessModStatement) {
                this.a(unlessModStatement);
            }

            @Override
            public void visitRWhileStatement(RWhileStatement whileStatement) {
                arrayList.add(whileStatement.getCondition());
                arrayList.addAll(whileStatement.getLoopBody().getStatements());
            }

            @Override
            public void visitRWhileModStatement(RWhileModStatement whileModStatement) {
                this.a(whileModStatement);
            }

            @Override
            public void visitRUntilStatement(RUntilStatement untilStatement) {
                arrayList.add(untilStatement.getCondition());
                arrayList.addAll(untilStatement.getLoopBody().getStatements());
            }

            @Override
            public void visitRUntilModStatement(RUntilModStatement untilModStatement) {
                this.a(untilModStatement);
            }

            private void a(RModifierStatement rModifierStatement) {
                arrayList.add(rModifierStatement.getCondition());
                arrayList.add(rModifierStatement.getCommand());
            }

            public void visitElement(PsiElement element) {
                arrayList.addAll(RubyPsiUtil.getChildrenByFilter(node, RPsiElement.class));
            }
        });
        return RubyPsiUtil.collectNotNull(arrayList);
    }

    private static boolean a(PsiElement psiElement, PsiElement psiElement2) {
        if ((psiElement instanceof RIfStatement || psiElement instanceof RIfModStatement) && (psiElement2 instanceof RIfStatement || psiElement2 instanceof RIfModStatement)) {
            return true;
        }
        if ((psiElement instanceof RUnlessStatement || psiElement instanceof RUnlessModStatement) && (psiElement2 instanceof RUnlessStatement || psiElement2 instanceof RUnlessModStatement)) {
            return true;
        }
        if ((psiElement instanceof RWhileStatement || psiElement instanceof RWhileModStatement) && (psiElement2 instanceof RWhileStatement || psiElement2 instanceof RWhileModStatement)) {
            return true;
        }
        return !(!(psiElement instanceof RUntilStatement) && !(psiElement instanceof RUntilModStatement) || !(psiElement2 instanceof RUntilStatement) && !(psiElement2 instanceof RUntilModStatement));
    }

    @Override
    public boolean areNodesEqual(@NotNull PsiElement node1, @NotNull PsiElement node2) {
        if (node1 == null) {
            RubySpecificHasher.b(2);
        }
        if (node2 == null) {
            RubySpecificHasher.b(3);
        }
        if (RubySpecificHasher.a(node1, node2)) {
            return true;
        }
        if (node1.getClass().equals(node2.getClass())) {
            Object object;
            if (node1 instanceof RBinaryExpression && ((RBinaryExpression)node1).getOperationType() != ((RBinaryExpression)node2).getOperationType()) {
                return false;
            }
            if (node1 instanceof RUnaryExpression && ((RUnaryExpression)node1).getOperationName().equals(((RUnaryExpression)node2).getOperationName())) {
                return false;
            }
            if (node1 instanceof RAssignmentExpression && ((RAssignmentExpression)node1).getOperationType() != ((RAssignmentExpression)node2).getOperationType()) {
                return false;
            }
            if (node1 instanceof RSymbol && !Objects.equals(((RSymbol)node1).getValue(), ((RSymbol)node2).getValue())) {
                return false;
            }
            if (node1 instanceof RLiteral && this.a.DISTINGUISH_LITERALS && !((RLiteral)node1).getContent().equals(((RLiteral)node2).getContent())) {
                return false;
            }
            if ((node1 instanceof RGlobalVariable || node1 instanceof RConstant) && this.a.DISTINGUISH_VARIABLES && !node1.getText().equals(node2.getText())) {
                return false;
            }
            if (node1 instanceof RField && this.a.DISTINGUISH_FIELDS && !node1.getText().equals(node2.getText())) {
                return false;
            }
            if (node1 instanceof RIdentifier && ((object = (RIdentifier)node1).isParameterDeclaration() || object.isLocalVariable()) && this.a.DISTINGUISH_VARIABLES && !node1.getText().equals(node2.getText())) {
                return false;
            }
            if (node1 instanceof RMethod) {
                if (!((RMethod)node1).getPresentableName(false).equals(((RMethod)node2).getPresentableName(false))) {
                    return false;
                }
                object = ((RMethod)node1).getArgumentInfos();
                List<ArgumentInfo> list2 = ((RMethod)node2).getArgumentInfos();
                if (object.size() != list2.size()) {
                    return false;
                }
                Iterator iterator = object.iterator();
                Iterator<ArgumentInfo> iterator2 = list2.iterator();
                while (iterator.hasNext()) {
                    ArgumentInfo argumentInfo = (ArgumentInfo)iterator.next();
                    ArgumentInfo argumentInfo2 = iterator2.next();
                    if (argumentInfo.getType() != argumentInfo2.getType()) {
                        return false;
                    }
                    if (!this.a.DISTINGUISH_VARIABLES || argumentInfo.getName().equals(argumentInfo2.getName())) continue;
                    return false;
                }
            }
            return !(node1 instanceof RContainer) || ((RContainer)node1).getFQN().equals(((RContainer)node2).getFQN());
        }
        return false;
    }

    @Override
    public boolean checkDeep(PsiElement node1, PsiElement node2) {
        return true;
    }

    @Override
    public void visitNode(@NotNull PsiElement node) {
        PsiFile psiFile;
        if (node == null) {
            RubySpecificHasher.b(4);
        }
        if ((psiFile = node.getContainingFile().getViewProvider().getPsi((Language)RubyLanguage.INSTANCE)) instanceof RFile) {
            for (RPsiElement rPsiElement : ((RFile)psiFile).getStatements()) {
                this.b.hash((PsiElement)rPsiElement, this);
            }
        }
    }

    @Override
    public void hashingFinished() {
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x71ECE9795C3EL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/duplocator/RubySpecificHasher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "areNodesEqual";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

