/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.highlighting;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import org.jetbrains.plugins.ruby.erb.ERbLanguage;
import org.jetbrains.plugins.ruby.erb.highlighting.ERbHighlighter;
import org.jetbrains.plugins.ruby.erb.psi.ERbTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;

public class ERbEditorHighlighter
extends LayeredLexerEditorHighlighter {
    private final Project a;
    private final VirtualFile b;
    private Language c;

    public ERbEditorHighlighter(EditorColorsScheme scheme, Project project, VirtualFile file) {
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((Language)ERbLanguage.RHTML, (Project)project, (VirtualFile)file), scheme);
        this.a = project;
        this.b = file;
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)RubyLanguage.INSTANCE, (Project)project, (VirtualFile)file);
        LayerDescriptor layerDescriptor = new LayerDescriptor(syntaxHighlighter, "\n", ERbHighlighter.RHTML_SCRIPTING_BACKGROUND);
        this.registerLayer(ERbTokenTypes.RUBY_CODE_CHARACTERS, layerDescriptor);
    }

    protected boolean updateLayers() {
        Language language = this.getCurrentTemplateLanguageAndPrefixes();
        if (!Comparing.equal((Object)this.c, (Object)language)) {
            this.unregisterLayer(ERbTokenTypes.TEMPLATE_CHARACTERS_IN_RHTML);
            this.c = language;
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.c, (Project)this.a, (VirtualFile)this.b);
            this.registerLayer(ERbTokenTypes.TEMPLATE_CHARACTERS_IN_RHTML, new LayerDescriptor(syntaxHighlighter, "", null));
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public Language getCurrentTemplateLanguageAndPrefixes() {
        FileViewProvider fileViewProvider;
        if (this.a == null) {
            return HTMLLanguage.INSTANCE;
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)this.a, (VirtualFile)this.b);
        if (language == null) {
            return HTMLLanguage.INSTANCE;
        }
        if (language.equals((Object)ERbLanguage.RHTML) && (fileViewProvider = PsiManager.getInstance((Project)this.a).findViewProvider(this.b)) instanceof TemplateLanguageFileViewProvider) {
            return ((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage();
        }
        return HTMLLanguage.INSTANCE;
    }
}

