/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemDependencyResolver;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGitLockReader;
import org.jetbrains.plugins.ruby.gem.module.GemInfrastructure;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemDependencyResolver;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class BundlerGemInfrastructure
extends GemInfrastructure {
    private static final Key<Boolean> b;
    public static final String GEMFILE_HAS_MISSING_GEMS_ID = "GEMFILE_HAS_MISSING_GEMS";
    private static final Logger a;
    private static final long c;

    @Override
    public boolean isApplicable(Module module2) {
        return BundlerUtil.hasGemfile(module2);
    }

    @Override
    public GemDependencyResolver getDependencyResolver(@NotNull Module module2, Collection<GemInfo> sdkGems, Set<GemDependency> dependencies) {
        BundlerGitLockReader bundlerGitLockReader;
        if (module2 == null) {
            BundlerGemInfrastructure.b(0);
        }
        if (!(bundlerGitLockReader = BundlerGitLockReader.getInstance(module2)).isLocked()) {
            return super.getDependencyResolver(module2, sdkGems, dependencies);
        }
        HashMap<String, GemDependency> hashMap = new HashMap<String, GemDependency>();
        for (GemDependency object : dependencies) {
            hashMap.put(object.getName(), object);
        }
        for (Map.Entry entry : bundlerGitLockReader.getDependencies().entrySet()) {
            if (hashMap.containsKey(entry.getKey())) continue;
            hashMap.put((String)entry.getKey(), (GemDependency)entry.getValue());
        }
        return new BundlerGemDependencyResolver(module2, sdkGems, new HashSet<GemDependency>(hashMap.values()));
    }

    @Override
    protected void runInstall(Module module2, Sdk sdk, Collection<GemDependency> dependencies, Runnable callback) {
        long l2 = c ^ 0x1A29B4635A50L;
        if (BundlerUtil.hasGemfile(module2)) {
            int n2;
            GemInfo gemInfo = GemSearchUtil.findGem(module2, sdk, "bundler");
            if (!BundlerUtil.isNewBundler(gemInfo) && (n2 = Messages.showYesNoDialog((Project)module2.getProject(), (String)"No bundler gem found, but Gemfile is present. \nWould you like to install bundler and use it to install missing gems?", (String)"No Bundler Gem Found", (Icon)Messages.getQuestionIcon())) == 0 && !BundlerUtil.installBundler(module2, sdk)) {
                return;
            }
            AnAction anAction = ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.gem.bundler.actions.RunBundlerInstallAction");
            AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)anAction, null, (String)"unknown", (DataContext)SimpleDataContext.getSimpleContext((String)LangDataKeys.MODULE.getName(), (Object)module2));
            anAction.beforeActionPerformedUpdate(anActionEvent);
            anAction.update(anActionEvent);
            if (anActionEvent.getPresentation().isEnabled() && anActionEvent.getPresentation().isVisible()) {
                anAction.actionPerformed(anActionEvent);
            }
        }
    }

    @Override
    public Boolean hasMissingGems(@Nullable Sdk sdk, @NotNull Module module2, boolean inspectionMode) {
        Sdk sdk2;
        Application application;
        boolean bl2;
        long l2 = c ^ 0x1324EBD0AC84L;
        if (module2 == null) {
            BundlerGemInfrastructure.b(1);
        }
        if (!(bl2 = (application = ApplicationManager.getApplication()).isHeadlessEnvironment())) {
            a.assertTrue(application.isDispatchThread() || !application.isReadAccessAllowed(), (Object)"invokeAndWait ahead, do not take read actions!");
        }
        VirtualFile virtualFile = BundlerUtil.getGemfile(module2);
        String string = (String)ReadAction.compute(() -> BundlerUtil.getBundlerScriptPath(sdk, module2));
        if (string == null || virtualFile == null) {
            return super.hasMissingGems(sdk, module2, inspectionMode);
        }
        if (!inspectionMode) {
            application.invokeAndWait(() -> application.runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments()));
        }
        if ((sdk2 = RModuleUtil.getInstance().findRubySdkForModule(module2)) == null || !RubySdkUtil.isRubyInterpreterExist(sdk) || !sdk2.equals(sdk)) {
            return null;
        }
        String string2 = (String)ReadAction.compute(() -> BundlerGemInfrastructure.a(module2, virtualFile));
        try {
            boolean bl3;
            RubyGemExecutionContext rubyGemExecutionContext = (RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, "bundler").withGemScriptName("bundle").withModule(module2)).withWorkingDirPath(string2)).withExecutionMode((ExecutionMode)new ExecutionModes.SameThreadMode(false, "", 30))).withArguments("check")).withExecutionID(GEMFILE_HAS_MISSING_GEMS_ID);
            BundlerUtil.addBundlerEnvironment(rubyGemExecutionContext.getAdditionalEnvs(), sdk, module2, virtualFile);
            ProcessOutput processOutput = rubyGemExecutionContext.executeScript();
            if (!inspectionMode) {
                application.invokeAndWait(() -> application.runWriteAction(() -> {
                    if (module2.isDisposed()) {
                        return;
                    }
                    VirtualFile virtualFile = BundlerUtil.getGemfileLockWithRefresh(module2);
                    if (virtualFile != null) {
                        virtualFile.refresh(false, false);
                    }
                }));
            }
            boolean bl4 = bl3 = processOutput != null && !processOutput.getStdout().contains("dependencies are satisfied");
            if (bl3) {
                a.debug("Gems are missing because bundler said so: [exitCode = " + processOutput.getExitCode() + "; stdout = " + processOutput.getStdout() + "; stderr = " + processOutput.getStderr() + "]");
            }
            ApplicationManager.getApplication().invokeLater(() -> BundlerGemInfrastructure.a(virtualFile, bl3));
            return bl3;
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    private static void a(@NotNull VirtualFile virtualFile, boolean bl2) {
        if (virtualFile == null) {
            BundlerGemInfrastructure.b(2);
        }
        virtualFile.putUserData(b, (Object)bl2);
    }

    public static boolean hasMissingGems(@NotNull VirtualFile virtualFile) {
        Boolean bl2;
        if (virtualFile == null) {
            BundlerGemInfrastructure.b(3);
        }
        return (bl2 = (Boolean)b.get((UserDataHolder)virtualFile)) != null && bl2 != false;
    }

    @Override
    public String getMissingGemMessage(Module module2) {
        long l2 = c ^ 0x6C98C1229EE7L;
        BundlerGitLockReader bundlerGitLockReader = BundlerGitLockReader.getInstance(module2);
        if (!bundlerGitLockReader.isLocked()) {
            return super.getMissingGemMessage(module2);
        }
        return RBundle.message("gems.not.activated.bundler");
    }

    @Nullable
    private static String a(@NotNull Module module2, @NotNull VirtualFile virtualFile) {
        if (module2 == null) {
            BundlerGemInfrastructure.b(4);
        }
        if (virtualFile == null) {
            BundlerGemInfrastructure.b(5);
        }
        if (module2.isDisposed()) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.getParent();
        String string = virtualFile2 != null ? VfsUtilCore.urlToPath((String)virtualFile2.getUrl()) : null;
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (string == null && virtualFileArray.length > 0) {
            string = virtualFileArray[0].getPath();
        }
        return string;
    }

    static {
        c = com.jetbrains.python.psi.c.a(5541312974282838404L, 8884860307807679423L, MethodHandles.lookup().lookupClass()).a(49550719017791L);
        long l2 = c ^ 0x263FB8C4EC87L;
        b = Key.create((String)GEMFILE_HAS_MISSING_GEMS_ID);
        a = Logger.getInstance(BundlerGemInfrastructure.class);
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x65ACF878F7B7L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundlerGemInfrastructure";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDependencyResolver";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMissingGems";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setHasMissingGems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getBundleCheckPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

