/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.gem;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.gem.a;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;

public class GemCompatibilityUtil {
    private static final Logger b;
    private static final MultiMap<String, Constraint> a;
    private static final long c;

    @NotNull
    public static List<GemDependency> createDependency(@NotNull Sdk sdk, @NotNull String gemName) {
        String string;
        if (sdk == null) {
            GemCompatibilityUtil.a(0);
        }
        if (gemName == null) {
            GemCompatibilityUtil.a(1);
        }
        Pair pair = (string = GemCompatibilityUtil.getTopCompatibleVersion(sdk, gemName)) == null ? GemDependency.BOUND_ANY : Pair.create((Object)((Object)GemDependency.Bound.LESS_OR_EQUAL), (Object)string);
        List<GemDependency> list2 = Collections.singletonList(GemDependency.any(gemName, (Pair<GemDependency.Bound, String>)pair));
        if (list2 == null) {
            GemCompatibilityUtil.a(2);
        }
        return list2;
    }

    @Nullable
    public static String getTopCompatibleVersion(@NotNull Sdk sdk, @NotNull String gemName) {
        String string;
        if (sdk == null) {
            GemCompatibilityUtil.a(3);
        }
        if (gemName == null) {
            GemCompatibilityUtil.a(4);
        }
        if ((string = sdk.getVersionString()) == null) {
            return null;
        }
        return GemCompatibilityUtil.getTopCompatibleVersion(RubyVersionUtil.getShortVersion(string), gemName);
    }

    @VisibleForTesting
    @Nullable
    public static String getTopCompatibleVersion(@NotNull String rubyVersion, @NotNull String gemName) {
        long l2 = c ^ 0x503C9C5DFD20L;
        if (rubyVersion == null) {
            GemCompatibilityUtil.a(5);
        }
        if (gemName == null) {
            GemCompatibilityUtil.a(6);
        }
        b.debug("Detecting compatibility for " + gemName + "; ruby version " + rubyVersion);
        String string = null;
        boolean bl2 = false;
        for (Constraint constraint : a.get((Object)gemName)) {
            if (!constraint.a(rubyVersion)) {
                bl2 = true;
                continue;
            }
            if (string != null && VersionComparatorUtil.compare((String)string, (String)constraint.b) >= 0) continue;
            string = constraint.b;
        }
        return !bl2 || string == null ? null : string;
    }

    static {
        c = com.jetbrains.python.psi.c.a(2499611736197391078L, 2218902118014944535L, MethodHandles.lookup().lookupClass()).a(243556671480704L);
        long l2 = c ^ 0x1A834718348AL;
        b = Logger.getInstance(GemCompatibilityUtil.class);
        a = new MultiMap();
        a.putValue((Object)"bundler", (Object)new Constraint(">=", "0", "1.0.22", null));
        a.putValue((Object)"bundler", (Object)new Constraint(">=", "1.8.7", "1.17.3", null));
        a.putValue((Object)"bundler", (Object)new Constraint(">=", "2.3.0", "2.0.1", null));
        a.putValue((Object)"rake", (Object)new Constraint(">=", "0", "0.9.2", null));
        a.putValue((Object)"rake", (Object)new Constraint(">=", "1.8.6", "10.1.1", null));
        a.putValue((Object)"rake", (Object)new Constraint(">=", "1.9", "10.2.1", null));
        a.putValue((Object)"rake", (Object)new Constraint(">=", "1.8.7", "10.5.0", null));
        a.putValue((Object)"rake", (Object)new Constraint(">=", "1.9.3", "12.2.1", null));
        a.putValue((Object)"rake", (Object)new Constraint(">=", "2.0.0", "12.3.2", null));
        a.putValue((Object)"rails", (Object)new Constraint(">=", "0", "2.3.18", null));
        a.putValue((Object)"rails", (Object)new Constraint(">=", "1.8.7", "3.2.22.5", null));
        a.putValue((Object)"rails", (Object)new Constraint(">=", "1.9.3", "4.2.11.1", null));
        a.putValue((Object)"rails", (Object)new Constraint(">=", "2.2.2", "5.2.3", null));
        a.putValue((Object)"rails", (Object)new Constraint(">=", "2.5.0", "6.0.0", null));
        a.putValue((Object)"rubocop", (Object)new Constraint(">=", "0", "0.5.0", null));
        a.putValue((Object)"rubocop", (Object)new Constraint(">=", "1.9.2", "0.24.1", null));
        a.putValue((Object)"rubocop", (Object)new Constraint(">=", "1.9.3", "0.41.2", null));
        a.putValue((Object)"rubocop", (Object)new Constraint(">=", "2.0.0", "0.50.0", null));
        a.putValue((Object)"rubocop", (Object)new Constraint(">=", "2.1.0", "0.57.2", null));
        a.putValue((Object)"rubocop", (Object)new Constraint(">=", "2.2.0", "0.64.0", null));
        a.putValue((Object)"rubocop", (Object)new Constraint(">=", "2.2.2", "0.68.1", null));
        a.putValue((Object)"rubocop", (Object)new Constraint(">=", "2.3.0", "0.71.0", null));
        a.putValue((Object)"standard", (Object)new Constraint(">=", "0", "0.0.40", null));
        a.putValue((Object)"puppet", (Object)new Constraint(">=", "0", "4.4.2", null));
        a.putValue((Object)"puppet", (Object)new Constraint(">=", "1.9.3", "5.5.14", null));
        a.putValue((Object)"puppet", (Object)new Constraint(">=", "2.3.0", "6.4.2", null));
        a.putValue((Object)"rubygems-update", (Object)new Constraint(">=", "0", "1.0.0", null));
        a.putValue((Object)"rubygems-update", (Object)new Constraint(">", "1.8.2", "1.0.1", null));
        a.putValue((Object)"rubygems-update", (Object)new Constraint(">", "1.8.3", "1.5.0", null));
        a.putValue((Object)"rubygems-update", (Object)new Constraint(">=", "1.8.7", "2.7.9", null));
        a.putValue((Object)"rubygems-update", (Object)new Constraint(">=", "2.3.0", "3.0.3", null));
        a.putValue((Object)"parallel", (Object)new Constraint(">=", "0", "1.3.3.1", null));
        a.putValue((Object)"parallel", (Object)new Constraint(">=", "1.9.3", "1.13.0", null));
        a.putValue((Object)"parallel", (Object)new Constraint(">=", "2.2", "1.17.0", null));
        a.putValue((Object)"rainbow", (Object)new Constraint(">=", "0", "1.99.2", null));
        a.putValue((Object)"rainbow", (Object)new Constraint(">=", "1.9.2", "2.2.2", null));
        a.putValue((Object)"rainbow", (Object)new Constraint(">=", "2.1.0", "3.0.0", null));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x1D1ADFA29B5AL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/gem/GemCompatibilityUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyVersion";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/gem/GemCompatibilityUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependency";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDependency";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTopCompatibleVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Constraint {
        private final GemDependency.Bound c;
        private final String a;
        private final String b;
        private static final long d = com.jetbrains.python.psi.c.a(7754880672626818507L, 1389984326480850139L, MethodHandles.lookup().lookupClass()).a(224559021855003L);

        private Constraint(@NotNull String rubyVersionBound, @NotNull String rubyVersion, @NotNull String maxGemVersion) {
            if (rubyVersionBound == null) {
                Constraint.a(0);
            }
            if (rubyVersion == null) {
                Constraint.a(1);
            }
            if (maxGemVersion == null) {
                Constraint.a(2);
            }
            this.c = GemDependency.Bound.getBound(rubyVersionBound);
            this.a = rubyVersion;
            this.b = maxGemVersion;
        }

        private boolean a(@NotNull String string) {
            if (string == null) {
                Constraint.a(3);
            }
            return GemDependency.compareVersions(string, this.a, this.c);
        }

        /* synthetic */ Constraint(String x0, String x1, String x2, a x3) {
            this(x0, x1, x2);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = d ^ 0x7247D602F4D4L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rubyVersionBound";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rubyVersion";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxGemVersion";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/gem/gem/GemCompatibilityUtil$Constraint";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "satisfies";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

