/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class SdkComparator
implements Comparator<Sdk> {
    public static final SdkComparator SDK_COMPARATOR;
    private static final long a;

    private SdkComparator() {
    }

    @Override
    public int compare(@Nullable Sdk sdk1, @Nullable Sdk sdk2) {
        return SdkComparator.compareSdks(sdk1, sdk2);
    }

    public static int compareSdks(@Nullable Sdk sdk1, @Nullable Sdk sdk2) {
        if (sdk1 == null && sdk2 == null) {
            return 0;
        }
        if (sdk1 == null) {
            return -1;
        }
        if (sdk2 == null) {
            return 1;
        }
        int n2 = -VersionComparatorUtil.compare((String)sdk1.getName(), (String)sdk2.getName());
        if (!RubySdkUtil.isRubySDK(sdk1) && !RubySdkUtil.isRubySDK(sdk2)) {
            return n2;
        }
        if (!RubySdkUtil.isRubySDK(sdk1)) {
            return -1;
        }
        if (!RubySdkUtil.isRubySDK(sdk2)) {
            return 1;
        }
        boolean bl2 = RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk1);
        boolean bl3 = RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk2);
        if (bl2 && bl3) {
            return n2;
        }
        if (bl2) {
            return -1;
        }
        if (bl3) {
            return 1;
        }
        Predicate<Sdk> predicate = JRubySdkUtil::isJRubySDK;
        Function<Sdk, String> function = RbenvGemsetManager::getRbenvGemset;
        Function<Sdk, String> function2 = RVMSupportUtil::getGemsetName;
        Predicate<Sdk> predicate2 = RbenvGemsetManager::isLocalRbenvSdk;
        Predicate<Sdk> predicate3 = RVMSupportUtil::isRVMInterpreter;
        Integer n3 = SdkComparator.a(sdk1, sdk2, function, predicate2, predicate, n2);
        if (n3 != null) {
            return n3;
        }
        n3 = SdkComparator.a(sdk1, sdk2, function2, predicate3, predicate, n2);
        if (n3 != null) {
            return n3;
        }
        return n2;
    }

    @Nullable
    private static Integer a(@NotNull Sdk sdk, @NotNull Sdk sdk2, @NotNull Function<? super Sdk, String> function, @NotNull Predicate<? super Sdk> predicate, @NotNull Predicate<? super Sdk> predicate2, int n2) {
        if (sdk == null) {
            SdkComparator.a(0);
        }
        if (sdk2 == null) {
            SdkComparator.a(1);
        }
        if (function == null) {
            SdkComparator.a(2);
        }
        if (predicate == null) {
            SdkComparator.a(3);
        }
        if (predicate2 == null) {
            SdkComparator.a(4);
        }
        boolean bl2 = predicate.test((Sdk)sdk);
        boolean bl3 = predicate.test((Sdk)sdk2);
        if (bl2 && bl3) {
            boolean bl4 = predicate2.test((Sdk)sdk);
            boolean bl5 = predicate2.test((Sdk)sdk2);
            if (bl4 && bl5) {
                return SdkComparator.a(sdk, sdk2, function, n2);
            }
            if (bl4) {
                return 1;
            }
            if (bl5) {
                return -1;
            }
            return SdkComparator.a(sdk, sdk2, function, n2);
        }
        if (bl2) {
            return 1;
        }
        if (bl3) {
            return -1;
        }
        return null;
    }

    private static Integer a(@NotNull Sdk sdk, @NotNull Sdk sdk2, @NotNull Function<? super Sdk, String> function, int n2) {
        if (sdk == null) {
            SdkComparator.a(5);
        }
        if (sdk2 == null) {
            SdkComparator.a(6);
        }
        if (function == null) {
            SdkComparator.a(7);
        }
        String string = function.apply((Sdk)sdk);
        String string2 = function.apply((Sdk)sdk2);
        if (StringUtil.equals((CharSequence)sdk.getHomePath(), (CharSequence)sdk2.getHomePath())) {
            if (string != null && string2 != null) {
                return StringUtil.compare((String)string, (String)string2, (boolean)true);
            }
            if (string != null) {
                return 1;
            }
            if (string2 != null) {
                return -1;
            }
            return null;
        }
        return n2;
    }

    public static List<Sdk> sortSdks(@NotNull Collection<? extends Sdk> sdks) {
        if (sdks == null) {
            SdkComparator.a(8);
        }
        return sdks.stream().sorted(SDK_COMPARATOR).collect(Collectors.toList());
    }

    static {
        a = c.a(7539856089326366034L, 993664368363237146L, MethodHandles.lookup().lookupClass()).a(140983616228778L);
        SDK_COMPARATOR = new SdkComparator();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x766802EF1B57L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk1";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk2";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getGemset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isVersioned";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isJRuby";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/SdkComparator";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "compareVersionManagerSdks";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "compareGemsets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "sortSdks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

