/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public abstract class InflectorService {
    public static final Topic<Runnable> INFLECTIONS_CHANGED;
    @NonNls
    protected static final String UNCOUNTABLE = "uncountable";
    @NonNls
    protected static final String PLURAL = "plural";
    @NonNls
    protected static final String SINGULAR = "singular";
    @NonNls
    protected static final String IRREGULAR = "irregular";
    @NonNls
    private static final String c = "inflections";
    @NonNls
    private static final String b = "clear";
    protected final Module myModule;
    protected final RailsApp myApp;
    protected final Map<String, String> myClassifyCache = ContainerUtil.newConcurrentMap();
    protected final Map<String, String> myTableizeCache = ContainerUtil.newConcurrentMap();
    protected final Map<String, String> mySingularizeCache = ContainerUtil.newConcurrentMap();
    protected final Map<String, String> myPluralizeCache = ContainerUtil.newConcurrentMap();
    private PsiCallable a = new InflectorCallable();
    private static final long f;

    public InflectorService(Module module2) {
        this.myModule = module2;
        this.myApp = RailsApp.fromModule(this.myModule);
        PsiManager.getInstance((Project)module2.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(3003131976393312947L, 2175299988163999442L, MethodHandles.lookup().lookupClass()).a(262874629241334L);

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(0);
                }
                InflectorService.this.a(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(1);
                }
                InflectorService.this.a(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(2);
                }
                InflectorService.this.a(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(3);
                }
                InflectorService.this.a(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(4);
                }
                InflectorService.this.a(event);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x6D3D72851BCAL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/InflectorService$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myModule);
    }

    @Nullable
    public static InflectorService getInstance(@NotNull Module module2) {
        if (module2 == null) {
            InflectorService.a(0);
        }
        return (InflectorService)ModuleServiceManager.getService((Module)module2, InflectorService.class);
    }

    private void a(PsiTreeChangeEvent psiTreeChangeEvent) {
        String string;
        long l2 = f ^ 0x623222C1C06L;
        PsiFile psiFile = psiTreeChangeEvent.getFile();
        PsiElement psiElement = psiTreeChangeEvent.getChild();
        if (psiFile == null && psiElement instanceof PsiFile) {
            psiFile = (PsiFile)psiElement;
        }
        String string2 = string = psiFile != null ? psiFile.getName() : null;
        if ("environment.rb".equals(string) || "inflections.rb".equals(string)) {
            this.clearCaches();
        }
    }

    public void clearCaches() {
        this.myPluralizeCache.clear();
        this.mySingularizeCache.clear();
        this.myClassifyCache.clear();
        this.myTableizeCache.clear();
        ((Runnable)this.myModule.getMessageBus().syncPublisher(INFLECTIONS_CHANGED)).run();
    }

    @Nullable
    protected static PsiFile getInflections(Module module2, RailsApp app) {
        long l2 = f ^ 0x1317C3A7B091L;
        if (app == null) {
            return null;
        }
        VirtualFile virtualFile = app.getConfigRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.findFileByRelativePath("initializers/inflections.rb");
        return virtualFile2 != null ? PsiManager.getInstance((Project)module2.getProject()).findFile(virtualFile2) : null;
    }

    public abstract boolean isInflectorAvailable();

    @Nullable
    public abstract String classify(String var1);

    @Nullable
    public abstract String tableize(String var1);

    @Nullable
    public abstract String singularize(String var1);

    @Nullable
    public abstract String pluralize(String var1);

    protected void updateInflectionExceptions(@Nullable PsiFile file) {
        if (!(file instanceof RFile)) {
            return;
        }
        this.loadInflectionExceptions((RFile)file);
    }

    protected void loadInflectionExceptions(@NotNull RContainer container) {
        long l2 = f ^ 0x37725C341884L;
        if (container == null) {
            InflectorService.a(1);
        }
        this.a = this.a != null ? this.a : new InflectorCallable();
        RubyPsiInterpreter rubyPsiInterpreter = new RubyPsiInterpreter(true);
        rubyPsiInterpreter.registerCallable(this.a, "Inflector.inflections", "ActiveSupport::Inflector.inflections", "Inflector", "ActiveSupport::Inflector");
        rubyPsiInterpreter.interpret((PsiElement)container, null);
    }

    protected abstract void clearExceptions();

    protected abstract boolean uncountable(String var1);

    protected abstract void plural(RPsiElement var1, RPsiElement var2);

    protected abstract void singular(RPsiElement var1, RPsiElement var2);

    protected abstract void irregular(RPsiElement var1, RPsiElement var2);

    static {
        f = com.jetbrains.python.psi.c.a(-1498996731948187558L, -1847952615740640165L, MethodHandles.lookup().lookupClass()).a(10103604127208L);
        long l2 = f ^ 0x7C75D095FA7CL;
        INFLECTIONS_CHANGED = Topic.create((String)"InflectionsChanged", Runnable.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = f ^ 0x5351B4603825L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/InflectorService";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadInflectionExceptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class InflectorCallable
    implements PsiCallable {
        private static final long a = com.jetbrains.python.psi.c.a(-3111535876286952670L, 8043849949084271419L, MethodHandles.lookup().lookupClass()).a(278866760858963L);

        private InflectorCallable() {
        }

        @Override
        public void processCall(RCallArguments arguments) {
            RPsiElement rPsiElement;
            List<RPsiElement> list2;
            long l2 = a ^ 0x353F7A61C40L;
            if (arguments.hasBlock() && Comparing.strEqual((String)InflectorService.c, (String)arguments.getCommand())) {
                arguments.interpretBlock(this);
                return;
            }
            String string = arguments.getCommand();
            if (Comparing.strEqual((String)InflectorService.b, (String)string)) {
                InflectorService.this.clearExceptions();
            }
            RPsiElement rPsiElement2 = (list2 = arguments.getArguments()).size() > 0 ? list2.get(0) : null;
            RPsiElement rPsiElement3 = rPsiElement = list2.size() > 1 ? list2.get(1) : null;
            if (rPsiElement2 == null) {
                return;
            }
            if (Comparing.strEqual((String)InflectorService.UNCOUNTABLE, (String)string)) {
                ArrayList arrayList = new ArrayList(2);
                for (RPsiElement object : list2) {
                    TextUtil.flattern(object, arrayList);
                }
                for (String string2 : arrayList) {
                    if (StringUtil.isEmpty((String)string2)) continue;
                    InflectorService.this.uncountable(string2);
                }
                return;
            }
            if (rPsiElement == null) {
                return;
            }
            if (Comparing.strEqual((String)InflectorService.PLURAL, (String)string)) {
                InflectorService.this.plural(rPsiElement2, rPsiElement);
            } else if (Comparing.strEqual((String)InflectorService.SINGULAR, (String)string)) {
                InflectorService.this.singular(rPsiElement2, rPsiElement);
            } else if (Comparing.strEqual((String)InflectorService.IRREGULAR, (String)string)) {
                InflectorService.this.irregular(rPsiElement2, rPsiElement);
            }
        }
    }
}

