/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemsRunner;
import org.jetbrains.plugins.ruby.gem.detector.RubyGemDetector;
import org.jetbrains.plugins.ruby.gem.gem.GemCompatibilityUtil;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.gem.gem.actions.QuickInstallGemDialog;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemComparator;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.rails.Rails3Constants;
import org.jetbrains.plugins.ruby.rails.RailsConstants;
import org.jetbrains.plugins.ruby.rails.RakeRunConfigurationSettingsFactory;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.ui.wizard.RailsWizardSettingsHolder;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfigurationType;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunner;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.util.ProjectQueues;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class RailsUtil {
    public static final Key<String> GENERATE_RAILS_VERSION;
    public static final List<Pair<String, String>> RUBY_MAX_RAILS_VERSION;
    private static final String d = "=";
    private static final String g = ">=";
    private static final String b = "<=";
    private static final String a = "~>";
    private static final String[] c;
    private static final Logger e;
    private static final Map<String, String> f;
    private static final long h;

    private RailsUtil() {
    }

    public static void generateRailsApp(Module module2, @NotNull Sdk sdk, @NotNull String applicationHomePath, boolean overwrite, @Nullable String railsVersion, @Nullable String railsTemplate, boolean ignoreUnitTestFiles, boolean generateEngine, boolean generateApi, @Nullable RailsWizardSettingsHolder.RailsJavaScriptLibrary javaScriptLibrary, @Nullable String preConfigureForDBName, RunContentDescriptorFactory descriptorFactory, @Nullable Runnable onDone) {
        Object object;
        long l2 = h ^ 0xC93D3D94DE0L;
        if (sdk == null) {
            RailsUtil.a(0);
        }
        if (applicationHomePath == null) {
            RailsUtil.a(1);
        }
        Project project = module2.getProject();
        String string = module2.getName();
        String string2 = RBundle.message("module.rails.generateapp.progress.title", string);
        String string3 = RBundle.message("execution.error.title.generate.rails.app", string);
        PathMappingSettings pathMappingSettings = RunnerUtil.getRunnerDefaultMappings(sdk, module2);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (railsVersion != null) {
            arrayList.add("_" + railsVersion + "_");
        }
        if (RailsUtil.isRails30OrHigher(railsVersion) && generateEngine) {
            arrayList.add("plugin");
        }
        if (VersionComparatorUtil.compare((String)railsVersion, (String)"3.0.0.beta4") >= 0) {
            arrayList.add("new");
        }
        arrayList.add(pathMappingSettings.convertToRemote(applicationHomePath));
        if (RailsUtil.isRails23OrHigher(railsVersion) && !StringUtil.isEmpty((String)railsTemplate)) {
            arrayList.add("--template");
            arrayList.add(railsTemplate);
        }
        if (RailsUtil.isRails30OrHigher(railsVersion) && ignoreUnitTestFiles) {
            arrayList.add("-T");
        }
        if (RailsUtil.isRails31OrHigher(railsVersion) && javaScriptLibrary != null && javaScriptLibrary != RailsWizardSettingsHolder.RailsJavaScriptLibrary.DEFAULT) {
            if (javaScriptLibrary == RailsWizardSettingsHolder.RailsJavaScriptLibrary.SKIP) {
                arrayList.add("--skip-javascript");
            } else {
                object = StringUtil.toLowerCase((String)javaScriptLibrary.name());
                if (RailsUtil.isRails_5_1_OrHigher(railsVersion)) {
                    arrayList.add("--webpack=" + object);
                } else {
                    arrayList.add("--javascript=" + object);
                }
            }
        }
        if (RailsUtil.isRails30OrHigher(railsVersion) && generateEngine) {
            arrayList.add("--mountable");
        }
        if (RailsUtil.isRails5OrHigher(railsVersion) && generateApi) {
            arrayList.add("--api");
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            arrayList.add("--skip-bundle");
        }
        arrayList.add(overwrite ? "--force" : "--skip");
        if (preConfigureForDBName != null) {
            arrayList.add("--database=" + preConfigureForDBName);
        }
        object = new MergingCommandLineArgumentsProvider(ArrayUtilRt.toStringArray(arrayList), null, null, null, sdk);
        Filter[] filterArray = new Filter[]{new RStackTraceFilter(module2)};
        Runnable runnable = () -> {
            long l2 = h ^ 0x12FCFBD9E4AAL;
            try {
                GeneratorsUtil.openFileInEditor(project, "app/controllers/application.rb", applicationHomePath);
                GeneratorsUtil.openFileInEditor(project, "app/controllers/application_controller.rb", applicationHomePath);
                GeneratorsUtil.openFileInEditor(project, "config/database.yml", applicationHomePath);
                BundlerUtil.openGemFileInEditor(project, applicationHomePath);
            }
            finally {
                if (onDone != null) {
                    onDone.run();
                }
            }
        };
        try {
            GemsRunner.runGemScriptInConsoleAndRefreshModule(module2, sdk, string2, null, ConsoleRunner.ProcessLaunchMode.BACKGROUND_TASK_WITH_PROGRESS, "rails", railsVersion, "rails", applicationHomePath, (RubyCommandLineArgumentsProvider)((Object)object), descriptorFactory, filterArray, runnable, false);
        }
        catch (Exception exception) {
            RunnerUtil.showErrorMessage(project, string3, exception);
        }
    }

    public static boolean containsRailsApp(@Nullable String railsAppHomePath) {
        if (railsAppHomePath == null || !new File(railsAppHomePath).exists()) {
            return false;
        }
        return RailsUtil.b(railsAppHomePath) || RailsUtil.a(railsAppHomePath);
    }

    private static boolean a(@NotNull String string) {
        if (string == null) {
            RailsUtil.a(2);
        }
        return ContainerUtil.find(RailsConstants.RAILS_APP_CORE_FILES, string2 -> !new File(string, (String)string2).exists()) == null;
    }

    private static boolean b(@NotNull String string) {
        File file;
        long l2 = h ^ 0x1C7EB5FBB5EDL;
        if (string == null) {
            RailsUtil.a(3);
        }
        return (file = new File(string, "bin/rails")).exists() && !file.isDirectory();
    }

    public static boolean isRails30App(@Nullable String railsAppHomePath) {
        if (railsAppHomePath == null) {
            return false;
        }
        File file = new File(railsAppHomePath);
        if (!file.exists()) {
            return false;
        }
        for (String string : Rails3Constants.RAILS3_MARKER_FILES) {
            File file2 = new File(railsAppHomePath + File.separatorChar + string);
            if (file2.exists()) continue;
            return false;
        }
        return true;
    }

    public static boolean isYmlFixture(@Nullable VirtualFile file, @NotNull Project project) {
        long l2 = h ^ 0x95ED4D3F604L;
        if (project == null) {
            RailsUtil.a(4);
        }
        if (file != null && file.getFileType().getName().equals("YAML")) {
            VirtualFile virtualFile;
            RailsApp railsApp = RailsApp.fromFile(project, file);
            VirtualFile virtualFile2 = file;
            if (railsApp == null) {
                while (virtualFile2 instanceof LightVirtualFile && (virtualFile = ((LightVirtualFile)virtualFile2).getOriginalFile()) != null && !virtualFile2.equals(virtualFile) && (railsApp = RailsApp.fromFile(project, virtualFile2 = virtualFile)) == null) {
                }
            }
            if (railsApp != null && (virtualFile = railsApp.getUTestsRoot()) != null && FileUtil.isAncestor((String)virtualFile.getPath(), (String)virtualFile2.getPath(), (boolean)true)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssetsOrViewFile(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            RailsUtil.a(5);
        }
        if (file != null) {
            VirtualFile virtualFile;
            RailsApp railsApp = RailsApp.fromFile(project, file);
            VirtualFile virtualFile2 = file;
            if (railsApp == null) {
                while (virtualFile2 instanceof LightVirtualFile && (virtualFile = ((LightVirtualFile)virtualFile2).getOriginalFile()) != null && !virtualFile2.equals(virtualFile) && (railsApp = RailsApp.fromFile(project, virtualFile2 = virtualFile)) == null) {
                }
            }
            if (railsApp != null) {
                virtualFile = railsApp.getAssetsRoot();
                VirtualFile virtualFile3 = railsApp.getViewsRoot();
                if (virtualFile != null && FileUtil.isAncestor((String)virtualFile.getPath(), (String)virtualFile2.getPath(), (boolean)true) || virtualFile3 != null && FileUtil.isAncestor((String)virtualFile3.getPath(), (String)virtualFile2.getPath(), (boolean)true)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasRailsSupportInSDK(@Nullable Sdk sdk) {
        return RailsUtil.hasRailsSupportInSDKOrModule(sdk, null);
    }

    public static boolean isRailsGemAttached(@NotNull Module module2) {
        long l2 = h ^ 0x41B01FAC7E9CL;
        if (module2 == null) {
            RailsUtil.a(6);
        }
        return GemSearchUtil.findGemEx(module2, "rails") != null;
    }

    public static void createRailsRunConfiguration(final Module module2) {
        final Project project = module2.getProject();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            long l2 = h ^ 0x478B2E96F815L;
            ProjectQueues.getInstance(project).queue(RBundle.message("rails.facet.builder.run.configuration.server.creating"), new Task.Backgroundable(project, RBundle.message("rails.facet.builder.run.configuration.server.creating.for", module2.getName()), true){
                private static final long a = com.jetbrains.python.psi.c.a(-8650977249166185076L, -1692233934015119876L, MethodHandles.lookup().lookupClass()).a(96905233803220L);

                public void run(@NotNull ProgressIndicator indicator) {
                    long l2 = a ^ 0x2FEFD64DFF75L;
                    if (indicator == null) {
                        1.a(0);
                    }
                    indicator.setText(RBundle.message("progress.backgnd.indicator.title.please.wait", this.getTitle()));
                    RunManager runManager = RunManager.getInstance((Project)project);
                    ApplicationManager.getApplication().runReadAction(() -> {
                        long l2 = a ^ 0x21FA54D2E237L;
                        RailsUtil.b("test", module2, runManager);
                        RailsUtil.b("spec", module2, runManager);
                        RailsUtil.a("production", module2, runManager);
                        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RailsUtil.a("development", module2, runManager);
                        runManager.setSelectedConfiguration(runnerAndConfigurationSettings);
                    });
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x6B0506FE6497L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/RailsUtil$1", "run"));
                }
            });
        });
    }

    private static RunnerAndConfigurationSettings a(String string, Module module2, RunManager runManager) {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RailsServerRunConfigurationType.getInstance().getWEBrickFactory().createConfigurationSettings(module2, string);
        runManager.addConfiguration(runnerAndConfigurationSettings);
        return runnerAndConfigurationSettings;
    }

    private static RunnerAndConfigurationSettings b(String string, Module module2, RunManager runManager) {
        RakeRunConfigurationSettingsFactory[] rakeRunConfigurationSettingsFactoryArray;
        long l2 = h ^ 0x5B7940C8E380L;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = RailsUtil.getCustomizedRailsEnvironmentFor(string);
        if (string2 != null) {
            hashMap.put("RAILS_ENV", string2);
        }
        if ((rakeRunConfigurationSettingsFactoryArray = (RakeRunConfigurationSettingsFactory[])RakeRunConfigurationSettingsFactory.EP_NAME.getExtensions()).length > 0) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = rakeRunConfigurationSettingsFactoryArray[0].createRakeRunConfigurationSettings(module2, string, hashMap);
            runManager.addConfiguration(runnerAndConfigurationSettings);
            return runnerAndConfigurationSettings;
        }
        throw new IllegalArgumentException("Can't find Rake Configuration");
    }

    @NotNull
    public static Module[] getAllModulesWithRailsSupport(@NotNull Project project) {
        Module[] moduleArray;
        if (project == null) {
            RailsUtil.a(7);
        }
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (Module module2 : moduleArray = ModuleManager.getInstance((Project)project).getModules()) {
            if (!RailsFacetUtil.hasRailsSupport(module2)) continue;
            arrayList.add(module2);
        }
        Module[] moduleArray2 = arrayList.toArray(Module.EMPTY_ARRAY);
        if (moduleArray2 == null) {
            RailsUtil.a(8);
        }
        return moduleArray2;
    }

    @Nullable
    public static String getPathRelativeToRailsApplicationRoot(@NotNull String fileUrl, @NotNull Module module2) {
        if (fileUrl == null) {
            RailsUtil.a(9);
        }
        if (module2 == null) {
            RailsUtil.a(10);
        }
        String string = RailsFacetUtil.getRailsAppHomeDirPathUrl(module2);
        assert (string != null);
        return VirtualFileUtil.getRelativePath(fileUrl, string);
    }

    @Nullable
    public static VirtualFile getHelpersRoot(Module module2) {
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2);
        if (standardRailsPaths == null) {
            return null;
        }
        String string = standardRailsPaths.getHelpersRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getDBFolderRoot(Module module2) {
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2);
        if (standardRailsPaths == null) {
            return null;
        }
        String string = StandardRailsPaths.buildDBUrl(standardRailsPaths.getRailsApplicationHomeURL());
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getTestsStdUnitRoot(Module module2) {
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2);
        if (standardRailsPaths == null) {
            return null;
        }
        String string = standardRailsPaths.getTestsStdUnitRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getApisRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(11);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getApisRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getConfigRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(12);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getConfigRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getAppRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(13);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getAppRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getTestMockEnvironmentRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(14);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getTestMockEnviromentRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getVendorRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(15);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getVendorRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getPluginsRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(16);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getPluginsRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getEdgeRailsRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(17);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getEdgeRailsRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getLibsRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(18);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getLibsRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getModelsRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(19);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getModelsRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getMigrationsRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(20);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getMigrationsRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getDbRoot(@NotNull Module module2) {
        if (module2 == null) {
            RailsUtil.a(21);
        }
        return (VirtualFile)ObjectUtils.doIfNotNull((Object)RailsFacetUtil.getRailsAppPaths(module2), standardRailsPaths -> VirtualFileManager.getInstance().findFileByUrl(standardRailsPaths.getDbRootURL()));
    }

    @Nullable
    public static VirtualFile getServicesRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(22);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getServicesRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getScriptsRoot(@NotNull Module module2) {
        VirtualFile virtualFile;
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(23);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        if (RailsUtil.isRails40OrHigher(module2) && (virtualFile = VirtualFileManager.getInstance().findFileByUrl(standardRailsPaths.getBinRootURL())) != null) {
            return virtualFile;
        }
        return VirtualFileManager.getInstance().findFileByUrl(standardRailsPaths.getScriptsRootURL());
    }

    @Nullable
    public static VirtualFile getControllersRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(24);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getControllerRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getChannelsRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(25);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getChannelsRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getViewsRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(26);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getViewsRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getLayoutsRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(27);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getLayoutsRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getAssetsRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(28);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getAppAssetsRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static VirtualFile getDefaultSharedPartialsRoot(@NotNull Module module2) {
        StandardRailsPaths standardRailsPaths;
        if (module2 == null) {
            RailsUtil.a(29);
        }
        if ((standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2)) == null) {
            return null;
        }
        String string = standardRailsPaths.getDefaultSharedPartialsRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    public static boolean hasRailsSupportInSDKOrModule(@Nullable Sdk sdk, @Nullable Module module2) {
        long l2 = h ^ 0xB6BA715B50DL;
        return RubySdkUtil.isRubySDK(sdk) && (module2 != null && RailsUtil.isRailsGemAttached(module2) || GemSearchUtil.findGem(module2, sdk, "rails") != null);
    }

    public static String[] getAllEnvironments(Module module2) {
        VirtualFile virtualFile;
        long l2 = h ^ 0x1ABD8028C08FL;
        RailsApp railsApp = RailsApp.fromModule(module2);
        if (railsApp != null && (virtualFile = railsApp.getEnvironmentsRoot()) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
                if (virtualFile2.getFileType() != RubyFileType.RUBY) continue;
                arrayList.add(virtualFile2.getNameWithoutExtension());
            }
            if (arrayList.size() > 0) {
                return ArrayUtilRt.toStringArray(arrayList);
            }
        }
        return new String[]{"development", "production", "test"};
    }

    @NotNull
    public static List<? extends RFile> getAllEnvironmentConfigFiles(@Nullable Module module2) {
        RailsApp railsApp = RailsApp.fromModule(module2);
        if (railsApp == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                RailsUtil.a(30);
            }
            return list2;
        }
        VirtualFile virtualFile = railsApp.getConfigRoot();
        if (virtualFile == null) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                RailsUtil.a(31);
            }
            return list3;
        }
        ArrayList arrayList = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile virtualFile2;
            long l2 = h ^ 0x4A2D7F40989DL;
            PsiManager psiManager = PsiManager.getInstance((Project)module2.getProject());
            VirtualFile virtualFile3 = virtualFile.findChild("environment.rb");
            if (virtualFile3 != null && (virtualFile2 = psiManager.findFile(virtualFile3)) instanceof RFile) {
                arrayList.add((RFile)virtualFile2);
            }
            if ((virtualFile2 = railsApp.getEnvironmentsRoot()) != null) {
                for (VirtualFile virtualFile4 : virtualFile2.getChildren()) {
                    PsiFile psiFile;
                    if (virtualFile4.getFileType() != RubyFileType.RUBY || !((psiFile = psiManager.findFile(virtualFile4)) instanceof RFile)) continue;
                    arrayList.add((RFile)psiFile);
                }
            }
        });
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            RailsUtil.a(32);
        }
        return arrayList2;
    }

    public static boolean isAttachedRails_2_3_OrHigher(Module module2) {
        long l2 = h ^ 0x5C1BA273713FL;
        GemInfo gemInfo = module2 == null ? null : GemSearchUtil.findGem(module2, "rails");
        return gemInfo != null && RailsUtil.isRails23OrHigher(gemInfo.getVersion());
    }

    public static boolean isAttachedRails_3_0_OrHigher(Module module2) {
        long l2 = h ^ 0x32B19A5FC256L;
        GemInfo gemInfo = module2 == null ? null : GemSearchUtil.findGem(module2, "rails");
        return gemInfo != null && RailsUtil.isRails30OrHigher(gemInfo.getVersion());
    }

    public static boolean isAttachedRails_Lower_3_0(Module module2) {
        long l2 = h ^ 0x51DC942D14CL;
        GemInfo gemInfo = module2 == null ? null : GemSearchUtil.findGem(module2, "rails");
        return gemInfo != null && RailsUtil.isRailsLower30(gemInfo.getVersion());
    }

    public static boolean isRails23OrHigher(String railsVersion) {
        long l2 = h ^ 0x31BCCEC08610L;
        return VersionComparatorUtil.compare((String)railsVersion, (String)"2.3") >= 0;
    }

    public static boolean isRails30OrHigher(String railsVersion) {
        long l2 = h ^ 0x7BFE6E278AA9L;
        return VersionComparatorUtil.compare((String)railsVersion, (String)"3.0.0.beta") >= 0;
    }

    public static boolean isRails30OrHigher(Module module2) {
        return RailsUtil.isAttachedRails_3_0_OrHigher(module2);
    }

    public static boolean isRails31OrHigher(Module module2) {
        long l2 = h ^ 0x5DB995CDDAFAL;
        GemInfo gemInfo = module2 != null ? GemManager.findGem(module2, "rails") : null;
        return gemInfo != null && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)"3.1.0.beta") >= 0;
    }

    public static boolean isRails32OrHigher(Module module2) {
        long l2 = h ^ 0x217E35B06E04L;
        GemInfo gemInfo = module2 != null ? GemManager.findGem(module2, "rails") : null;
        return gemInfo != null && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)"3.2.0.beta") >= 0;
    }

    public static boolean isRails31OrHigher(String railsVersion) {
        long l2 = h ^ 0x3E6B169D5950L;
        return VersionComparatorUtil.compare((String)railsVersion, (String)"3.1.0.beta") >= 0;
    }

    public static boolean isRails32OrHigher(String railsVersion) {
        long l2 = h ^ 0x5BF3736A9168L;
        return VersionComparatorUtil.compare((String)railsVersion, (String)"3.2.0.beta") >= 0;
    }

    public static boolean isRails40OrHigher(String railsVersion) {
        long l2 = h ^ 0x628450BA366CL;
        return VersionComparatorUtil.compare((String)railsVersion, (String)"4.0.0.beta") >= 0;
    }

    public static boolean isRails_5_1_OrHigher(String railsVersion) {
        long l2 = h ^ 0x7963989DD3F8L;
        return VersionComparatorUtil.compare((String)railsVersion, (String)"5.1.0.beta") >= 0;
    }

    public static boolean isRails40OrHigher(Module module2) {
        long l2 = h ^ 0xF1DFA83E99DL;
        GemInfo gemInfo = module2 != null ? GemManager.findGem(module2, "rails") : null;
        return gemInfo != null && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)"4.0.0.beta") >= 0;
    }

    public static boolean isRails41OrHigher(Module module2) {
        long l2 = h ^ 0x882F66653L;
        GemInfo gemInfo = module2 != null ? GemManager.findGem(module2, "rails") : null;
        return gemInfo != null && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)"4.1.0.beta") >= 0;
    }

    public static boolean isRails42OrHigher(Module module2) {
        long l2 = h ^ 0x6FC21AD8549EL;
        GemInfo gemInfo = module2 != null ? GemManager.findGem(module2, "rails") : null;
        return gemInfo != null && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)"4.2.0.beta") >= 0;
    }

    public static boolean isRails42OrHigher(String version) {
        long l2 = h ^ 0x4B0208F2F401L;
        return VersionComparatorUtil.compare((String)version, (String)"4.2.0.beta") >= 0;
    }

    public static boolean isRails5OrHigher(String railsVersion) {
        long l2 = h ^ 0x65852FE20D9AL;
        return VersionComparatorUtil.compare((String)railsVersion, (String)"5.0.0.alpha") >= 0;
    }

    public static boolean isRails6OrHigher(String railsVersion) {
        long l2 = h ^ 0x1DB297F49E30L;
        return VersionComparatorUtil.compare((String)railsVersion, (String)"6.0.0.alpha") >= 0;
    }

    public static boolean isRails5OrHigher(@Nullable Module module2) {
        long l2 = h ^ 0x80878E0A118L;
        GemInfo gemInfo = module2 != null ? GemManager.findGem(module2, "rails") : null;
        return gemInfo != null && RailsUtil.isRails5OrHigher(gemInfo.getVersion());
    }

    public static boolean isRailsLower30(String railsVersion) {
        long l2 = h ^ 0x29CACB0E6708L;
        return VersionComparatorUtil.compare((String)"3.0.0.beta", (String)railsVersion) > 0;
    }

    public static boolean shouldWarnRailsVersion(String version) {
        long l2 = h ^ 0x2C79147252FL;
        return VersionComparatorUtil.compare((String)version, (String)"6.1.0.beta") >= 0;
    }

    public static boolean shouldWarnSDKVersion(String version, @Nullable Sdk sdk) {
        long l2 = h ^ 0x1B01AADB0912L;
        if (!RailsUtil.isRails30OrHigher(version)) {
            return false;
        }
        if (sdk == null || RubySdkUtil.isIronRuby(sdk) || RubySdkUtil.isMacRuby(sdk) || !RubySdkUtil.isRuby18(sdk) || JRubySdkUtil.isJRubySDK(sdk)) {
            return false;
        }
        String string = sdk.getVersionString();
        e.assertTrue(string != null);
        int n2 = string.indexOf(32);
        String string2 = n2 == -1 ? string : string.substring(0, n2);
        return VersionComparatorUtil.compare((String)"ver.1.8.7", (String)string2) < 0;
    }

    @Nullable
    public static String getRailsScriptExecutablePath(@NotNull Module module2, String scriptRelativePath) {
        String string;
        long l2 = h ^ 0x1078242100F2L;
        if (module2 == null) {
            RailsUtil.a(33);
        }
        if ((string = RailsFacetUtil.getRailsAppHomeDirPathUrl(module2)) == null) {
            return null;
        }
        String string2 = RailsUtil.getPathIfFileExists(string, "/script//" + scriptRelativePath);
        return string2 == null ? RailsUtil.getPathIfFileExists(string, "/bin//" + scriptRelativePath) : string2;
    }

    @Nullable
    public static String getPathIfFileExists(String rorAppHomeDirUrl, String fileRelativePath) {
        String string;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        VirtualFile virtualFile = virtualFileManager.findFileByUrl(string = rorAppHomeDirUrl + '/' + fileRelativePath);
        return VirtualFileUtil.fileExists(virtualFile) ? virtualFile.getPath() : null;
    }

    @Nullable
    public static String getCustomizedRailsEnvironmentFor(String taskFullCmd) {
        return f.get(taskFullCmd);
    }

    @Nullable
    public static RFile getEnvironment(Module module2) {
        long l2 = h ^ 0x7485769CEF3BL;
        VirtualFile virtualFile = RailsUtil.getConfigRoot(module2);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.findChild("environment.rb");
        if (virtualFile2 == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)module2.getProject()).findFile(virtualFile2);
        return psiFile instanceof RFile ? (RFile)psiFile : null;
    }

    @Nullable
    public static String getRailsVersion(Module module2) {
        long l2 = h ^ 0x516DBD045FEL;
        RailsApp railsApp = RailsApp.fromModule(module2);
        if (railsApp != null && railsApp.getApplicationFile() != null) {
            return RailsUtil.a(module2);
        }
        RFile rFile = RailsUtil.getEnvironment(module2);
        if (rFile == null) {
            return null;
        }
        for (PsiElement psiElement : rFile.getStatements()) {
            RPsiElement rPsiElement;
            RPsiElement rPsiElement2;
            RAssignmentExpression rAssignmentExpression = null;
            if (psiElement instanceof RAssignmentExpression) {
                rAssignmentExpression = (RAssignmentExpression)psiElement;
            } else if (psiElement instanceof RModifierStatement && (rPsiElement2 = (rPsiElement = (RModifierStatement)psiElement).getCommand()) instanceof RAssignmentExpression) {
                rAssignmentExpression = (RAssignmentExpression)rPsiElement2;
            }
            if (rAssignmentExpression == null) continue;
            rPsiElement = rAssignmentExpression.getValue();
            rPsiElement2 = rAssignmentExpression.getObject();
            if (rPsiElement == null || !Comparing.strEqual((String)"RAILS_GEM_VERSION", (String)rPsiElement2.getText())) continue;
            return TextUtil.removeQuoting(rPsiElement.getText());
        }
        return "< 3.0.0.beta";
    }

    @Nullable
    private static String a(Module module2) {
        long l2 = h ^ 0x319FC47EEA38L;
        VirtualFile virtualFile = BundlerUtil.getGemfile(module2);
        if (virtualFile == null) {
            return null;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        RubyGemDetector rubyGemDetector = new RubyGemDetector();
        for (GemDependency gemDependency : rubyGemDetector.detect(module2.getProject(), sdk, virtualFile)) {
            if (!"rails".equals(gemDependency.getName())) continue;
            return gemDependency.getVersionString();
        }
        return null;
    }

    public static boolean isUnderVendor(PsiElement element) {
        return (Boolean)ReadAction.compute(() -> {
            Module module2;
            VirtualFile virtualFile;
            if (!element.isValid()) {
                return false;
            }
            PsiFile psiFile = element.getContainingFile();
            if (psiFile != null && psiFile.isValid() && (virtualFile = psiFile.getVirtualFile()) != null && (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null && RailsUtil.isUnderVendor(virtualFile, module2)) {
                return true;
            }
            return false;
        });
    }

    public static boolean isUnderVendor(@NotNull VirtualFile vFile, @NotNull Module module2) {
        VirtualFile virtualFile;
        if (vFile == null) {
            RailsUtil.a(34);
        }
        if (module2 == null) {
            RailsUtil.a(35);
        }
        return (virtualFile = RailsUtil.getVendorRoot(module2)) != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)vFile, (boolean)false);
    }

    public static Pair<GemInfo, List<String>> installRailsSupport(@NotNull Sdk sdk, @Nullable Module module2, @Nullable Pair<GemInfo, List<String>> versionsCache) {
        long l2 = h ^ 0x5F2A37D51FE3L;
        if (sdk == null) {
            RailsUtil.a(36);
        }
        return RailsUtil.installGemSupport(sdk, module2, versionsCache, "rails", GemCompatibilityUtil.getTopCompatibleVersion(sdk, "rails"));
    }

    @Nullable
    public static Pair<GemInfo, List<String>> installGemSupport(@NotNull Sdk sdk, @Nullable Module module2, @Nullable Pair<GemInfo, List<String>> versionsCache, String gemName, String maxVersion) {
        GemInfo gemInfo2;
        List list2;
        Collection<GemInfo> collection;
        if (sdk == null) {
            RailsUtil.a(37);
        }
        HashMap<GemDependency, String> hashMap = new HashMap<GemDependency, String>();
        if (versionsCache == null || versionsCache.first == null) {
            collection = RailsUtil.loadGemsList(module2, gemName, sdk);
            if (collection == null) {
                return versionsCache;
            }
            list2 = ContainerUtil.map(collection, gemInfo -> gemInfo.getVersion());
            gemInfo2 = collection.iterator().next();
            versionsCache = Pair.create((Object)gemInfo2, (Object)list2);
        } else {
            gemInfo2 = (GemInfo)versionsCache.first;
            list2 = (List)versionsCache.second;
        }
        collection = maxVersion != null ? ContainerUtil.filter((Collection)list2, string2 -> VersionComparatorUtil.compare((String)string2, (String)maxVersion) <= 0) : list2;
        Project project = RModuleUtil.getInstance().getProject(module2);
        QuickInstallGemDialog quickInstallGemDialog = new QuickInstallGemDialog(project, gemInfo2, collection);
        if (quickInstallGemDialog.showAndGet()) {
            GemDependency gemDependency = GemDependency.create(gemName, quickInstallGemDialog.getVersion());
            assert (gemDependency != null);
            GemInstallUtil.installGemsDependencies(sdk, null, Collections.singleton(gemDependency), quickInstallGemDialog.installDependencies(), quickInstallGemDialog.generateDocs(), hashMap);
            GemUiUtil.showInstallErrors(project, hashMap);
        }
        return versionsCache;
    }

    @VisibleForTesting
    @Nullable
    public static Set<GemInfo> loadGemsList(final @Nullable Module module2, final @NotNull String gemName, final @NotNull Sdk sdk) {
        long l2 = h ^ 0x3266B004ADF6L;
        if (gemName == null) {
            RailsUtil.a(38);
        }
        if (sdk == null) {
            RailsUtil.a(39);
        }
        final Ref ref = Ref.create((Object)false);
        Project project = module2 == null ? null : module2.getProject();
        final TreeSet<GemInfo> treeSet = new TreeSet<GemInfo>(Collections.reverseOrder(new GemComparator()));
        ProgressManager.getInstance().run((Task)new Task.Modal(project, "Downloading " + gemName + " gems list...", true){
            private static final long a = com.jetbrains.python.psi.c.a(2882087625437499162L, -3513874877072623419L, MethodHandles.lookup().lookupClass()).a(837519652780L);

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.a(0);
                }
                treeSet.addAll(GemRunner.query(module2, sdk, null, () -> {
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    return progressIndicator != null && progressIndicator.isCanceled();
                }, gemName));
            }

            public void onCancel() {
                ref.set((Object)true);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x7F0B0490323EL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/RailsUtil$2", "run"));
            }
        });
        if (((Boolean)ref.get()).booleanValue()) {
            return null;
        }
        if (treeSet.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)RBundle.message("gems.gem.installing.failed", gemName), (String)RBundle.message("gems.gem.installing.failed"));
            return null;
        }
        return treeSet;
    }

    public static boolean isRails3OrNewerApplication(@NotNull Module moduleWithRailsSupport) {
        RailsTools railsTools;
        if (moduleWithRailsSupport == null) {
            RailsUtil.a(40);
        }
        return (railsTools = RailsUtil.getRailsTools(moduleWithRailsSupport)) == RailsTools.RAILS3 || railsTools == RailsTools.RAILS4;
    }

    public static String parseRailsVersion(@Nullable String expression) {
        if (expression == null) {
            return null;
        }
        for (String string : c) {
            if (!expression.startsWith(string)) continue;
            return expression.substring(string.length()).trim();
        }
        return expression;
    }

    public static RailsTools getRailsTools(@NotNull Module moduleWithRailsSupport) {
        boolean bl2;
        boolean bl3;
        String string;
        long l2 = h ^ 0x7112BC33683AL;
        if (moduleWithRailsSupport == null) {
            RailsUtil.a(41);
        }
        e.assertTrue((string = RailsFacetUtil.getRailsAppHomeDirPath(moduleWithRailsSupport)) != null);
        String string2 = (String)moduleWithRailsSupport.getUserData(GENERATE_RAILS_VERSION);
        if (string2 == null) {
            String string3 = (String)ReadAction.compute(() -> RailsUtil.getRailsVersion(moduleWithRailsSupport));
            string2 = RailsUtil.parseRailsVersion(string3);
        }
        if (string2 != null) {
            bl3 = VersionComparatorUtil.compare((String)string2, (String)"3.0.0.beta") >= 0;
            bl2 = VersionComparatorUtil.compare((String)string2, (String)"4.0.0.beta") >= 0;
        } else {
            String string4 = VirtualFileUtil.buildSystemIndependentPath(string, "script/rails");
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)string4));
            bl3 = virtualFile != null;
            String string5 = VirtualFileUtil.buildSystemIndependentPath(string, "bin/rails");
            VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)string5));
            boolean bl4 = bl2 = virtualFile2 != null;
        }
        return bl2 ? RailsTools.RAILS4 : (bl3 ? RailsTools.RAILS3 : RailsTools.RAILS2);
    }

    public static boolean isStrongParameter(RCall call) {
        RailsApp railsApp = RailsApp.fromPsiElement((PsiElement)call);
        return railsApp != null && RailsUtil.isRails40OrHigher(railsApp.getModule());
    }

    public static boolean isUnderChannelClientDirectory(@NotNull PsiFile file) {
        RailsApp railsApp;
        if (file == null) {
            RailsUtil.a(42);
        }
        if ((railsApp = RailsApp.fromFile(file.getProject(), file.getVirtualFile())) == null || !railsApp.isRails5App()) {
            return false;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module2 == null) {
            return false;
        }
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2);
        if (standardRailsPaths == null) {
            return false;
        }
        String string = standardRailsPaths.getChannelClientsRootURL();
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
        if (virtualFile == null || !virtualFile.isDirectory()) {
            return false;
        }
        return FileUtil.isAncestor((String)virtualFile.getPath(), (String)file.getVirtualFile().getPath(), (boolean)true);
    }

    static {
        h = com.jetbrains.python.psi.c.a(-1300181947905456210L, -8288358635780793822L, MethodHandles.lookup().lookupClass()).a(103409275674333L);
        long l2 = h ^ 0x74ADB6237E15L;
        GENERATE_RAILS_VERSION = new Key("org.jetbrains.plugins.ruby.rails.RailsProjectGenerator.railsVersion");
        RUBY_MAX_RAILS_VERSION = new ArrayList<Pair<String, String>>();
        c = new String[]{d, g, b, a};
        e = Logger.getInstance(RailsUtil.class);
        f = new HashMap<String, String>();
        f.put("test", "test");
        f.put("features", "test");
        f.put("cucumber", "test");
        f.put("db:migrate", "development");
        f.put("db:migrate:up", "development");
        f.put("db:migrate:down", "development");
        f.put("db:migrate:redo", "development");
        f.put("db:migrate:reset", "development");
        f.put("db:create", "development");
        f.put("db:drop", "development");
        f.put("db:reset", "development");
        f.put("db:version", "development");
        f.put("db:rollback", "development");
        f.put("db:structure:dump", "development");
        f.put("db:structure:load", "development");
        f.put("db:schema:dump", "development");
        f.put("db:schema:load", "development");
        f.put("db:fixtures:load", "development");
        RUBY_MAX_RAILS_VERSION.add((Pair<String, String>)Pair.create((Object)"1.8.6", (Object)"2.3.99"));
        RUBY_MAX_RAILS_VERSION.add((Pair<String, String>)Pair.create((Object)"1.8.7", (Object)"3.2.99"));
        RUBY_MAX_RAILS_VERSION.add((Pair<String, String>)Pair.create((Object)"1.9.3", (Object)"4.2.99"));
        RUBY_MAX_RAILS_VERSION.add((Pair<String, String>)Pair.create((Object)"2.2.2", (Object)"5.2.99"));
        RUBY_MAX_RAILS_VERSION.add((Pair<String, String>)Pair.create((Object)"2.5.0", null));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x1D2C2D6EA850L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: 
            case 30: 
            case 31: 
            case 32: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationHomePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsAppHomePath";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/RailsUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleWithRailsSupport";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/RailsUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModulesWithRailsSupport";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEnvironmentConfigFiles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateRailsApp";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsAllAppCoreFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsBinRails";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isYmlFixture";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAssetsOrViewFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRailsGemAttached";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllModulesWithRailsSupport";
                break;
            }
            case 8: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToRailsApplicationRoot";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getApisRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConfigRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAppRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTestMockEnvironmentRoot";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVendorRoot";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsRoot";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeRailsRoot";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLibsRoot";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getModelsRoot";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMigrationsRoot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDbRoot";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getServicesRoot";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getScriptsRoot";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getControllersRoot";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getChannelsRoot";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getViewsRoot";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutsRoot";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAssetsRoot";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSharedPartialsRoot";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getRailsScriptExecutablePath";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isUnderVendor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "installRailsSupport";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "installGemSupport";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "loadGemsList";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isRails3OrNewerApplication";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRailsTools";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isUnderChannelClientDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class RailsTools
    extends Enum<RailsTools> {
        public static final /* enum */ RailsTools RAILS2;
        public static final /* enum */ RailsTools RAILS3;
        public static final /* enum */ RailsTools RAILS4;
        private final String c;
        private final String b;
        private static final /* synthetic */ RailsTools[] a;

        public static RailsTools[] values() {
            return (RailsTools[])a.clone();
        }

        public static RailsTools valueOf(String name) {
            return Enum.valueOf(RailsTools.class, name);
        }

        private RailsTools(String server, String generate) {
            this.c = server;
            this.b = generate;
        }

        public Object getGenerateScript() {
            return this.b;
        }

        public String getServerScript() {
            return this.c;
        }

        public String version() {
            return this.name().substring(5);
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(1458710944041451652L, -5902753110819434910L, MethodHandles.lookup().lookupClass()).a(53410308104105L) ^ 0x7858DB17A7A1L;
            RAILS2 = new RailsTools("script/server", "script/generate");
            RAILS3 = new RailsTools("script/rails", "script/rails");
            RAILS4 = new RailsTools("bin/rails", "bin/rails");
            a = new RailsTools[]{RAILS2, RAILS3, RAILS4};
        }
    }
}

