/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators;

import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorOptions;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsExternalizer;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsModuleCache;
import org.jetbrains.plugins.ruby.rails.actions.generators.lexer.GeneratorLexer;
import org.jetbrains.plugins.ruby.rails.actions.generators.lexer._Generators2xLexer;
import org.jetbrains.plugins.ruby.rails.actions.generators.lexer._Generators30Lexer;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusUtil;
import org.jetbrains.plugins.ruby.rails.run.RailsScriptRunner;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.run.BundlerMissingGemsProcessAdapter;
import org.jetbrains.plugins.ruby.ruby.run.CmdlinePreprocessor;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunner;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyScriptExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.settings.RProjectUtil;
import org.jetbrains.plugins.ruby.util.ProjectQueues;

public final class GeneratorsUtil {
    @NonNls
    public static final String GENERATORS_DIR = "generators";
    @NonNls
    public static final String GENERATE_SCRIPT = "script/generate";
    public static final String NIFTY_SCAFFOLD_GENERATOR_NAME = "nifty_scaffold";
    public static final String RSPEC_SCAFFOLD_GENERATOR_NAME = "rspec_scaffold";
    public static final Pattern GEM_NOT_INSTALLED_ERROR_FILTER;
    public static final String GENERATORS_SILENT_UPDATE = "GENERATORS_SILENT_UPDATE";
    private static final Pattern f;
    private static final Pattern e;
    private static final Logger g;
    private static final String[] b;
    private static final String[] d;
    private static final Pattern a;
    private static final String c = "Please choose a generator below";
    private static final long h;

    private GeneratorsUtil() {
    }

    @NotNull
    public static String[] getInstalledGenerators(@NotNull Module module2, @Nullable Sdk sdk, @NotNull String railsApplicationHomeDirPath, @NotNull VirtualFile generateScript, boolean isSilently) {
        Object[] objectArray;
        Object object;
        List<Exception> list2;
        String string;
        String string2;
        Object[] objectArray2;
        ProcessOutput processOutput;
        long l2 = h ^ 0x3BC4C1C5A44CL;
        if (module2 == null) {
            GeneratorsUtil.a(0);
        }
        if (railsApplicationHomeDirPath == null) {
            GeneratorsUtil.a(1);
        }
        if (generateScript == null) {
            GeneratorsUtil.a(2);
        }
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        String string3 = generateScript.getPath();
        if (sdk != null) {
            processOutput = GeneratorsUtil.getGenerateScriptOutput(module2, sdk, railsApplicationHomeDirPath, arrayList, string3, isSilently);
        } else {
            objectArray2 = RBundle.message("progress.dialog.generate.common.help.cannot.fetch.generators.list") + " " + RubySdkUtil.getRubySdkIsntSetOrValideErrorText();
            processOutput = new ProcessOutput();
            processOutput.appendStderr((String)objectArray2);
        }
        Object[] objectArray3 = objectArray2 = RailsUtil.isRails30App(railsApplicationHomeDirPath) ? d : b;
        if (processOutput != null && processOutput.checkSuccess(g)) {
            string2 = processOutput.getStdout();
            string = processOutput.getStderr();
            try {
                list2 = GeneratorsUtil.c(string);
                if (!list2.isEmpty()) {
                    object = RBundle.message("execution.ruby.script.get.available.generators", string);
                    arrayList.addAll(GeneratorsUtil.c((String)object));
                    g.warn((String)object);
                }
                objectArray = !StringUtil.isEmpty((String)string2) ? GeneratorsUtil.parseScriptGenerateOutput(string2) : objectArray2;
            }
            catch (IOException iOException) {
                objectArray = objectArray2;
                arrayList.add(iOException);
                g.warn((Throwable)iOException);
            }
            catch (Error error) {
                objectArray = objectArray2;
                Matcher matcher = GEM_NOT_INSTALLED_ERROR_FILTER.matcher(string2);
                object = matcher.matches() ? "Cannot fetch generators list. ERROR occurred:\n" + matcher.group(1) : "Parsing error. Unknown data format.\nstdout:\n[" + string2 + "]\nstderr:\n[" + string + "]\nError message:\n" + error;
                arrayList.addAll(GeneratorsUtil.c((String)object));
                g.warn((String)object);
            }
        } else {
            objectArray = objectArray2;
        }
        if (!arrayList.isEmpty()) {
            string2 = LocalFileSystem.getInstance().findFileByPath(string3);
            string = module2.getProject();
            if (processOutput != null && processOutput.getExitCode() != 0) {
                list2 = arrayList;
                object = Collections.emptyList();
            } else {
                list2 = Collections.emptyList();
                object = arrayList;
            }
            ExecutionHelper.showExceptions((Project)string, list2, object, (String)RBundle.message("execution.error.title.generators.list", module2.getName()), (VirtualFile)string2);
        }
        assert (objectArray != null);
        Arrays.sort(objectArray);
        if (objectArray == null) {
            GeneratorsUtil.a(3);
        }
        return objectArray;
    }

    private static List<Exception> c(String string) {
        String[] stringArray;
        if (StringUtil.isEmpty((String)string)) {
            return Collections.emptyList();
        }
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        for (String string2 : stringArray = string.split("\n")) {
            if (RunnerUtil.isJRubyOpenSSLFirstLine(string2) || RunnerUtil.isJRubyOpenSSLSecondLine(string2) || RunnerUtil.isSpring(string2) || f.matcher(string2).matches() || e.matcher(string2).matches()) continue;
            arrayList.add(new Exception(string2));
        }
        return arrayList;
    }

    public static String[] buildParamsForRailsGenerator(@Nullable String generateScriptPath) {
        String[] stringArray;
        long l2 = h ^ 0xBA0352555EL;
        if (GeneratorsUtil.a(generateScriptPath)) {
            return new String[]{"rails", "generate"};
        }
        if (GeneratorsUtil.b(generateScriptPath) || GeneratorsUtil.isZeusGenerator(generateScriptPath)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "generate";
        } else {
            stringArray = ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        return stringArray;
    }

    private static boolean a(@Nullable String string) {
        long l2 = h ^ 0x44EF4CBB3CFEL;
        return string != null && string.endsWith("spring");
    }

    public static boolean isZeusGenerator(String generateScriptPath) {
        long l2 = h ^ 0x3CF8D618691AL;
        return generateScriptPath.endsWith("zeus");
    }

    private static boolean b(String string) {
        long l2 = h ^ 0x7972F5A40A8DL;
        return string.endsWith("script/rails") || string.endsWith("bin/rails");
    }

    public static String[] parseScriptGenerateOutput(String buff) throws IOException {
        long l2 = h ^ 0x4A1370F8ACC0L;
        boolean bl2 = buff.contains(c);
        GeneratorLexer generatorLexer = bl2 ? new _Generators30Lexer(null) : new _Generators2xLexer(null);
        generatorLexer.reset(buff, 0, buff.length(), 0);
        String string = generatorLexer.advance();
        HashSet<String> hashSet = new HashSet<String>();
        while (string != null) {
            hashSet.add(string);
            string = generatorLexer.advance();
        }
        return ArrayUtilRt.toStringArray(hashSet);
    }

    @Nullable
    public static ProcessOutput getGenerateScriptOutput(@NotNull Module module2, @NotNull Sdk sdk, String workingDir, List<? super Exception> exceptions, String generateScriptPath, boolean isSilently) {
        long l2 = h ^ 0x1C291C181FDEL;
        if (module2 == null) {
            GeneratorsUtil.a(4);
        }
        if (sdk == null) {
            GeneratorsUtil.a(5);
        }
        try {
            ExecutionModes.SameThreadMode sameThreadMode = new ExecutionModes.SameThreadMode(Registry.intValue((String)"command.line.execution.timeout"));
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                sameThreadMode.setShouldCancelFun(() -> true);
            }
            RubyScriptExecutionContext rubyScriptExecutionContext = (RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)RubyScriptExecutionContext.create(generateScriptPath, sdk).withModule(module2)).withWorkingDirPath(workingDir)).withExecutionMode((ExecutionMode)sameThreadMode)).withCommandLinePreprocessor(BundlerUtil.getBundlerPreprocessor(sdk, module2))).withArguments(GeneratorsUtil.buildParamsForRailsGenerator(generateScriptPath))).withExecutionID(isSilently ? GENERATORS_SILENT_UPDATE : null)).withSpringPreloaderEnabled(SpringUtil.getInstance((Project)module2.getProject()).RAILS_SPRING_PRE_LOADER_OPTION);
            Notification notification2 = new Notification("Spring", RBundle.message("module.rails.create.rake.generators.spring.disabling.title"), RBundle.message("module.rails.create.rake.generators.spring.disabling.content"), NotificationType.INFORMATION);
            notification2.addAction((AnAction)NotificationAction.createSimple((String)RBundle.message("module.rails.create.rake.generators.spring.disabling"), () -> {
                SpringUtil.getInstance((Project)module2.getProject()).RAILS_SPRING_PRE_LOADER_OPTION = false;
                GeneratorsModuleCache.getInstance(module2).reloadGenerators(true, sdk, true);
                notification2.expire();
            }));
            rubyScriptExecutionContext.inSameThread(Registry.intValue((String)"rails.generators.loading.timeout"), () -> {
                if (!RubySdkSystemAccessor.notNullFrom(sdk).isWindows() && SpringUtil.getInstance((Project)module2.getProject()).RAILS_SPRING_PRE_LOADER_OPTION) {
                    notification2.notify(module2.getProject());
                }
            });
            return rubyScriptExecutionContext.executeScript();
        }
        catch (Exception exception) {
            exceptions.add(exception);
            return null;
        }
    }

    public static void loadGeneratorsList(boolean forceRegenerate, @NotNull Module module2, @Nullable Sdk sdk, @NotNull GeneratorsModuleCache moduleCache, boolean isSilently) {
        String string;
        if (module2 == null) {
            GeneratorsUtil.a(6);
        }
        if (moduleCache == null) {
            GeneratorsUtil.a(7);
        }
        if ((string = RailsFacetUtil.getRailsAppHomeDirPath(module2)) == null) {
            moduleCache.setGenerators(null);
            return;
        }
        GeneratorsExternalizer generatorsExternalizer = new GeneratorsExternalizer();
        String[] stringArray = generatorsExternalizer.loadGeneratorList(string);
        if ((stringArray == null || forceRegenerate) && !RubySdkUtil.isSDKValid(sdk)) {
            moduleCache.setGenerators(null);
            return;
        }
        GeneratorsUtil.a(module2, sdk, moduleCache, string, generatorsExternalizer, isSilently);
    }

    private static void a(final Module module2, final Sdk sdk, final GeneratorsModuleCache generatorsModuleCache, final String string, final GeneratorsExternalizer generatorsExternalizer, final boolean bl2) {
        long l2 = h ^ 0x3255E1DD8815L;
        Project project = module2.getProject();
        ProjectQueues.getInstance(project).queue(RBundle.message("module.rails.create.rake.generators.title"), new Task.Backgroundable(project, RBundle.message("module.rails.create.rake.generators.for", module2.getName()), true){
            private static final long a = com.jetbrains.python.psi.c.a(2728043577775917020L, 7786689295683866986L, MethodHandles.lookup().lookupClass()).a(58112715379746L);

            public void run(@NotNull ProgressIndicator indicator) {
                VirtualFile virtualFile;
                if (indicator == null) {
                    1.a(0);
                }
                if ((virtualFile = GeneratorsUtil.getGenerateScript(module2, false)) == null) {
                    generatorsModuleCache.setGenerators(null);
                    return;
                }
                String[] stringArray = GeneratorsUtil.getInstalledGenerators(module2, sdk, string, virtualFile, bl2);
                generatorsExternalizer.saveGeneratorList(stringArray, string);
                generatorsModuleCache.setGenerators(stringArray);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x51E78FAE500BL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsUtil$1", "run"));
            }
        });
    }

    @Nullable
    public static VirtualFile getGenerateScript(@NotNull Module module2, boolean canUsePreloadServer) {
        String string;
        String string2;
        long l2 = h ^ 0xA84B6F9E880L;
        if (module2 == null) {
            GeneratorsUtil.a(8);
        }
        if ((string2 = RailsFacetUtil.getRailsAppHomeDirPath(module2)) == null) {
            return null;
        }
        RailsApp railsApp = RailsApp.fromModule(module2);
        assert (railsApp != null) : "Must have rails application here";
        if (canUsePreloadServer && !railsApp.isEngine() && PreLoadUtil.PreLoadServer.Zeus.isRunning(module2)) {
            string = ZeusUtil.getZeusExecutable(module2, RModuleUtil.getInstance().findRubySdkForModule(module2));
        } else if (canUsePreloadServer && !railsApp.isEngine() && SpringUtil.isSpringAvailable(module2)) {
            string = SpringUtil.getSpringExecutable(module2, RModuleUtil.getInstance().findRubySdkForModule(module2));
        } else {
            RailsUtil.RailsTools railsTools = RailsUtil.getRailsTools(module2);
            string = string2 + '/' + railsTools.getGenerateScript();
        }
        if (string == null) {
            return null;
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(string);
    }

    public static void initOptionsCheckBoxes(@NotNull JCheckBox pretendCheckBox, @NotNull JCheckBox forceCheckBox, @NotNull JCheckBox skipCheckBox, @NotNull JCheckBox backtraceCheckBox, @NotNull JCheckBox svnCheckBox, @NotNull JCheckBox gitCheckBox, @NotNull ComboBox environment, @NotNull GeneratorOptions options, @NotNull Module module2) {
        long l2 = h ^ 0x26475781EAFCL;
        if (pretendCheckBox == null) {
            GeneratorsUtil.a(9);
        }
        if (forceCheckBox == null) {
            GeneratorsUtil.a(10);
        }
        if (skipCheckBox == null) {
            GeneratorsUtil.a(11);
        }
        if (backtraceCheckBox == null) {
            GeneratorsUtil.a(12);
        }
        if (svnCheckBox == null) {
            GeneratorsUtil.a(13);
        }
        if (gitCheckBox == null) {
            GeneratorsUtil.a(14);
        }
        if (environment == null) {
            GeneratorsUtil.a(15);
        }
        if (options == null) {
            GeneratorsUtil.a(16);
        }
        if (module2 == null) {
            GeneratorsUtil.a(17);
        }
        pretendCheckBox.setSelected(options.PRETEND);
        forceCheckBox.setSelected(options.FORCE);
        skipCheckBox.setSelected(options.SKIP);
        backtraceCheckBox.setSelected(options.BACK_TRACE);
        environment.setSelectedItem((Object)(StringUtil.isEmpty((String)options.ENVIRONMENT) ? "development" : options.ENVIRONMENT));
        if (!RailsUtil.isRails3OrNewerApplication(module2)) {
            svnCheckBox.setEnabled(options.VCS_SHOW_CONFIRMATION);
            svnCheckBox.setSelected(options.SVN);
            gitCheckBox.setEnabled(options.VCS_SHOW_CONFIRMATION);
            gitCheckBox.setSelected(options.GIT);
        } else {
            svnCheckBox.setVisible(false);
            gitCheckBox.setVisible(false);
        }
    }

    public static void saveSettings(@NotNull JCheckBox pretendCheckBox, @NotNull JCheckBox forceCheckBox, @NotNull JCheckBox skipCheckBox, @NotNull JCheckBox backtraceCheckBox, @NotNull JCheckBox svnCheckBox, @NotNull JCheckBox gitCheckBox, @NotNull ComboBox environment, @NotNull GeneratorOptions options, @NotNull Project project) {
        if (pretendCheckBox == null) {
            GeneratorsUtil.a(18);
        }
        if (forceCheckBox == null) {
            GeneratorsUtil.a(19);
        }
        if (skipCheckBox == null) {
            GeneratorsUtil.a(20);
        }
        if (backtraceCheckBox == null) {
            GeneratorsUtil.a(21);
        }
        if (svnCheckBox == null) {
            GeneratorsUtil.a(22);
        }
        if (gitCheckBox == null) {
            GeneratorsUtil.a(23);
        }
        if (environment == null) {
            GeneratorsUtil.a(24);
        }
        if (options == null) {
            GeneratorsUtil.a(25);
        }
        if (project == null) {
            GeneratorsUtil.a(26);
        }
        options.PRETEND = pretendCheckBox.isSelected();
        options.FORCE = forceCheckBox.isSelected();
        options.SKIP = skipCheckBox.isSelected();
        options.BACK_TRACE = backtraceCheckBox.isSelected();
        options.ENVIRONMENT = (String)environment.getSelectedItem();
        if (RProjectUtil.isVcsAddShowConfirmation(project)) {
            options.SVN = svnCheckBox.isSelected();
            options.GIT = gitCheckBox.isSelected();
        }
    }

    public static String calcGeneralOptionsString(@NotNull JCheckBox backtraceCheckBox, @NotNull JCheckBox forceCheckBox, @NotNull JCheckBox pretendCheckBox, @NotNull JCheckBox skipCheckBox, @NotNull JCheckBox svnCheckBox, @NotNull JCheckBox gitCheckBox) {
        if (backtraceCheckBox == null) {
            GeneratorsUtil.a(27);
        }
        if (forceCheckBox == null) {
            GeneratorsUtil.a(28);
        }
        if (pretendCheckBox == null) {
            GeneratorsUtil.a(29);
        }
        if (skipCheckBox == null) {
            GeneratorsUtil.a(30);
        }
        if (svnCheckBox == null) {
            GeneratorsUtil.a(31);
        }
        if (gitCheckBox == null) {
            GeneratorsUtil.a(32);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (backtraceCheckBox.isSelected()) {
            GeneratorsCmdOption.BACKTRACE_CMD_OPTION.addTo(stringBuilder);
        }
        if (forceCheckBox.isSelected()) {
            GeneratorsCmdOption.FORCE_CMD_OPTION.addTo(stringBuilder);
        }
        if (pretendCheckBox.isSelected()) {
            GeneratorsCmdOption.PRETEND_CMD_OPTION.addTo(stringBuilder);
        }
        if (skipCheckBox.isSelected()) {
            GeneratorsCmdOption.SKIP_CMD_OPTION.addTo(stringBuilder);
        }
        if (svnCheckBox.isSelected()) {
            GeneratorsCmdOption.SVN_CMD_OPTION.addTo(stringBuilder);
        }
        if (gitCheckBox.isSelected()) {
            GeneratorsCmdOption.GIT_CMD_OPTION.addTo(stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static void invokeGenerator(final Module module2, String processTitle, String errorTitle, String[] scriptParameters, @Nullable RunContentDescriptorFactory descFactory, final @Nullable ThrowableRunnable<? extends RuntimeException> nextAction2, @NotNull Sdk sdk, final @Nullable List<? super String> createdFiles, final @NotNull Ref<Integer> filesToOpenCount, @NotNull Map<String, String> envsMap) {
        long l2 = h ^ 0x2A9005D3D606L;
        if (sdk == null) {
            GeneratorsUtil.a(33);
        }
        if (filesToOpenCount == null) {
            GeneratorsUtil.a(34);
        }
        if (envsMap == null) {
            GeneratorsUtil.a(35);
        }
        try {
            FileDocumentManager.getInstance().saveAllDocuments();
            final String string = "Rails generator: " + StringUtil.join((String[])scriptParameters, (int)1, (int)scriptParameters.length, (String)" ");
            final Ref ref = new Ref();
            ProcessAdapter processAdapter = new ProcessAdapter(){
                private final StringBuffer a = new StringBuffer();
                private static final long b = com.jetbrains.python.psi.c.a(7869457782666029927L, 3747490805188166056L, MethodHandles.lookup().lookupClass()).a(89805782666206L);

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.a(0);
                    }
                    ref.set((Object)LocalHistory.getInstance().startAction(string));
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.a(1);
                    }
                    if (createdFiles != null) {
                        String string2 = null;
                        Matcher matcher = a.matcher(this.a.toString());
                        while (matcher.find()) {
                            if (string2 == null) {
                                string2 = matcher.group(1);
                            }
                            if (string2.length() == matcher.group(1).length()) {
                                createdFiles.add(0, matcher.group(2));
                                filesToOpenCount.set((Object)((Integer)filesToOpenCount.get() + 1));
                                continue;
                            }
                            createdFiles.add(matcher.group(2));
                        }
                    }
                    RailsFacetUtil.refreshRailsAppHomeContent(module2);
                    ((LocalHistoryAction)ref.get()).finish();
                    ref.set(null);
                    if (nextAction2 != null) {
                        WriteAction.runAndWait((ThrowableRunnable)nextAction2);
                    }
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        2.a(2);
                    }
                    if (outputType == null) {
                        2.a(3);
                    }
                    this.a.append(event.getText());
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    long l2 = b ^ 0x78F7493A7A3BL;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsUtil$2";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            String string2 = module2.getName() + ": " + processTitle;
            MergingCommandLineArgumentsProvider mergingCommandLineArgumentsProvider = new MergingCommandLineArgumentsProvider(scriptParameters, null, null, envsMap, sdk);
            CmdlinePreprocessor cmdlinePreprocessor = BundlerUtil.getBundlerPreprocessor(sdk, module2);
            RailsScriptRunner.runRailsScriptInConsole(sdk, module2, new BundlerMissingGemsProcessAdapter(module2, null, (ProcessListener)processAdapter), new Filter[]{new RStackTraceFilter(module2)}, null, ConsoleRunner.ProcessLaunchMode.BACKGROUND_TASK_WITH_PROGRESS, string2, mergingCommandLineArgumentsProvider, descFactory, cmdlinePreprocessor);
        }
        catch (Exception exception) {
            RunnerUtil.showErrorMessage(module2.getProject(), errorTitle, exception);
        }
    }

    public static void openFileInEditor(Project project, String relativePath, String railsAppHomeDirPath) {
        File file = new File(railsAppHomeDirPath, relativePath);
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                int n2 = GeneratorsUtil.a(PsiManager.getInstance((Project)project).findFile(virtualFile));
                PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, n2).navigate(true);
            }
        });
    }

    private static int a(PsiFile psiFile) {
        RPsiElement rPsiElement;
        List list2;
        if (psiFile instanceof RFile && !(list2 = ((RFile)psiFile).getStatements()).isEmpty() && (rPsiElement = (RPsiElement)list2.get(0)) instanceof RClass) {
            RClass rClass = (RClass)rPsiElement;
            List list3 = rClass.getStatements();
            if (list3.isEmpty()) {
                PsiElement psiElement = GeneratorsUtil.a(PsiTreeUtil.getChildOfType((PsiElement)rClass, RBodyStatement.class));
                if (psiElement != null) {
                    return psiElement.getTextOffset();
                }
            } else {
                PsiElement psiElement;
                RPsiElement rPsiElement2 = (RPsiElement)list3.get(0);
                if (rPsiElement2 instanceof RMethod && (psiElement = GeneratorsUtil.a(PsiTreeUtil.getChildOfType((PsiElement)rPsiElement2, RBodyStatement.class))) != null) {
                    return psiElement.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Nullable
    private static PsiElement a(PsiElement psiElement) {
        while (psiElement != null && psiElement.getNode().getElementType() != RubyTokenTypes.tEOL) {
            psiElement = psiElement.getPrevSibling();
        }
        return psiElement;
    }

    static {
        h = com.jetbrains.python.psi.c.a(2392010614931369091L, -6673207989400326163L, MethodHandles.lookup().lookupClass()).a(270217705886859L);
        long l2 = h ^ 0x74D5ED82BE39L;
        GEM_NOT_INSTALLED_ERROR_FILTER = Pattern.compile(".*(Could not find gem '.*' in any of the gem sources\\.).*", 32);
        f = Pattern.compile(".*warning\\s*:.*", 2);
        e = Pattern.compile("Expected string default value for .*");
        g = Logger.getInstance(GeneratorsUtil.class);
        b = new String[]{"controller", "integration_test", "mailer", "migration", "model", "observer", "plugin", "resource", "scaffold", "session_migration"};
        d = new String[]{"controller", "generator", "helper", "integration_test", "mailer", "metal", "migration", "model", "model_subclass", "observer", "performance_test", "plugin", "resource", "scaffold", "scaffold_controller", "session_migration", "stylesheets", "active_record:migration", "active_record:model", "active_record:observer", "active_record:session_migration", "erb:controller", "erb:mailer", "erb:scaffold", "test_unit:controller", "test_unit:helper", "test_unit:integration", "test_unit:mailer", "test_unit:model", "test_unit:observer", "test_unit:performance", "test_unit:plugin", "test_unit:scaffold"};
        a = Pattern.compile("create(\\s+)(.+\\.[\\w*]+)");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x3592C1EAE3B2L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsApplicationHomeDirPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generateScript";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsUtil";
                break;
            }
            case 5: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleCache";
                break;
            }
            case 9: 
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pretendCheckBox";
                break;
            }
            case 10: 
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forceCheckBox";
                break;
            }
            case 11: 
            case 20: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipCheckBox";
                break;
            }
            case 12: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backtraceCheckBox";
                break;
            }
            case 13: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svnCheckBox";
                break;
            }
            case 14: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitCheckBox";
                break;
            }
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToOpenCount";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envsMap";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledGenerators";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledGenerators";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGenerateScriptOutput";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadGeneratorsList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGenerateScript";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "initOptionsCheckBoxes";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "calcGeneralOptionsString";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "invokeGenerator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class GeneratorsCmdOption
    extends Enum<GeneratorsCmdOption> {
        public static final /* enum */ GeneratorsCmdOption BACKTRACE_CMD_OPTION;
        public static final /* enum */ GeneratorsCmdOption FORCE_CMD_OPTION;
        public static final /* enum */ GeneratorsCmdOption PRETEND_CMD_OPTION;
        public static final /* enum */ GeneratorsCmdOption SKIP_CMD_OPTION;
        public static final /* enum */ GeneratorsCmdOption SVN_CMD_OPTION;
        public static final /* enum */ GeneratorsCmdOption GIT_CMD_OPTION;
        public static final /* enum */ GeneratorsCmdOption MODEL_SKIP_TIMESTAMPS;
        public static final /* enum */ GeneratorsCmdOption MODEL_SKIP_MIGRATION;
        public static final /* enum */ GeneratorsCmdOption MODEL_SKIP_FIXTURE;
        public static final /* enum */ GeneratorsCmdOption SCAFFOLD_FORCE_PLURAL;
        public static final /* enum */ GeneratorsCmdOption NSCAFFOLD_HAML;
        public static final /* enum */ GeneratorsCmdOption NSCAFFOLD_INVERT;
        public static final /* enum */ GeneratorsCmdOption NSCAFFOLD_SKIP_CONTROLLER;
        public static final /* enum */ GeneratorsCmdOption NSCAFFOLD_SKIP_MODEL;
        private final String a;
        private static final /* synthetic */ GeneratorsCmdOption[] b;

        public static GeneratorsCmdOption[] values() {
            return (GeneratorsCmdOption[])b.clone();
        }

        public static GeneratorsCmdOption valueOf(String name) {
            return Enum.valueOf(GeneratorsCmdOption.class, name);
        }

        private GeneratorsCmdOption(String option) {
            this.a = option;
        }

        public String getValue() {
            return this.a;
        }

        public void addTo(StringBuilder buff) {
            buff.append(" ");
            buff.append(this.getValue());
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(-4378820374709703049L, 4987871188167595929L, MethodHandles.lookup().lookupClass()).a(267402259832088L) ^ 0x61FB9E87B8EFL;
            BACKTRACE_CMD_OPTION = new GeneratorsCmdOption("-t");
            FORCE_CMD_OPTION = new GeneratorsCmdOption("-f");
            PRETEND_CMD_OPTION = new GeneratorsCmdOption("-p");
            SKIP_CMD_OPTION = new GeneratorsCmdOption("-s");
            SVN_CMD_OPTION = new GeneratorsCmdOption("-c");
            GIT_CMD_OPTION = new GeneratorsCmdOption("-g");
            MODEL_SKIP_TIMESTAMPS = new GeneratorsCmdOption("--skip-timestamps");
            MODEL_SKIP_MIGRATION = new GeneratorsCmdOption("--skip-migration");
            MODEL_SKIP_FIXTURE = new GeneratorsCmdOption("--skip-fixture");
            SCAFFOLD_FORCE_PLURAL = new GeneratorsCmdOption("--force-plural");
            NSCAFFOLD_HAML = new GeneratorsCmdOption("--haml");
            NSCAFFOLD_INVERT = new GeneratorsCmdOption("--invert");
            NSCAFFOLD_SKIP_CONTROLLER = new GeneratorsCmdOption("--skip-controller");
            NSCAFFOLD_SKIP_MODEL = new GeneratorsCmdOption("--skip-model");
            b = new GeneratorsCmdOption[]{BACKTRACE_CMD_OPTION, FORCE_CMD_OPTION, PRETEND_CMD_OPTION, SKIP_CMD_OPTION, SVN_CMD_OPTION, GIT_CMD_OPTION, MODEL_SKIP_TIMESTAMPS, MODEL_SKIP_MIGRATION, MODEL_SKIP_FIXTURE, SCAFFOLD_FORCE_PLURAL, NSCAFFOLD_HAML, NSCAFFOLD_INVERT, NSCAFFOLD_SKIP_CONTROLLER, NSCAFFOLD_SKIP_MODEL};
        }
    }
}

