/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.associations;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.containers.hash.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.ruby.associations.AssociatedItem;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.associations.AssociationFactory;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.ruby.RubyPsiManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class AssociationsParser
implements Disposable {
    private final Module c;
    private PsiTreeChangeListener b;
    private Map<AssociatedItem, Set<Association>> a;

    public static AssociationsParser getInstance(Module module2) {
        return (AssociationsParser)ModuleServiceManager.getService((Module)module2, AssociationsParser.class);
    }

    public AssociationsParser(Module module2) {
        this.c = module2;
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(this.c);
        if (standardRailsPaths == null) {
            return;
        }
        String string = standardRailsPaths.getModelsRootURL();
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string);
        if (virtualFile == null) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.c.getProject());
        PsiDirectory psiDirectory = psiManager.findDirectory(virtualFile);
        RubyPsiManager.getInstance(this.c.getProject()).addChangeWatcher((PsiElement)psiDirectory, psiElement -> {
            this.a = null;
        });
    }

    public synchronized Set<Association> getAllAssociations(AssociatedItem model) {
        return this.a(model);
    }

    public synchronized Set<Association> getAllAssociations(RClass rClass) {
        AssociationFactory[] associationFactoryArray;
        HashSet<Association> hashSet = new HashSet<Association>();
        for (AssociationFactory associationFactory : associationFactoryArray = (AssociationFactory[])AssociationFactory.EP_NAME.getExtensions()) {
            AssociatedItem associatedItem = associationFactory.createAssociatedItem(rClass);
            if (associatedItem == null) continue;
            hashSet.addAll(this.getAllAssociations(associatedItem));
        }
        return hashSet;
    }

    private Set<Association> a(AssociatedItem associatedItem) {
        if (this.a == null) {
            this.a = new HashMap();
        }
        this.b(associatedItem);
        return this.a.get(associatedItem);
    }

    private void b(AssociatedItem associatedItem) {
        HashSet<Association> hashSet = new HashSet<Association>();
        List<RContainer> list2 = RubyFQNUtil.getFQNBasedPartialDeclarations(associatedItem.getRClass(), true, null);
        for (RContainer rContainer : list2) {
            if (!(rContainer instanceof RClass)) continue;
            AssociationsParser.a(associatedItem, hashSet);
        }
        this.a.put(associatedItem, hashSet);
    }

    private static void a(AssociatedItem associatedItem, Set<Association> set) {
        List<Association> list2 = associatedItem.getAssociations();
        set.addAll(list2);
    }

    public void dispose() {
        if (this.b != null) {
            PsiManager.getInstance((Project)this.c.getProject()).removePsiTreeChangeListener(this.b);
            this.b = null;
        }
    }
}

