/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.jetbrains.python.psi.c;
import gnu.trove.THashSet;
import icons.RubyIcons;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ControllerActionRefParam;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AliasSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.CreateRubyMethodFix;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class MethodRefParam
extends ParamDefBase {
    protected Visibility minAccess;
    protected LookupItemType itemType;
    protected ParamDependency containerDependency;
    protected String topParent;
    private static final long i = c.a(-1626577521859148079L, 5595833763464505634L, MethodHandles.lookup().lookupClass()).a(279794189537891L);

    public MethodRefParam(String topParent, Visibility minAccess, LookupItemType itemType) {
        this(topParent, minAccess, itemType, null);
    }

    public MethodRefParam(String topParent, Visibility minAccess, LookupItemType itemType, @Nullable ParamDependency containerDependency) {
        this.minAccess = minAccess;
        this.itemType = itemType;
        this.containerDependency = containerDependency;
        this.topParent = topParent;
    }

    public MethodRefParam(String topParent, Visibility minAccess) {
        this(topParent, minAccess, LookupItemType.String);
    }

    @Override
    public InspectionResult warningInspection(ParamContext context, RPsiElement element) {
        String string = this.warningInspectionMessage(element);
        return this.buildResultWithFix(context, string, element);
    }

    protected InspectionResult buildResultWithFix(ParamContext context, String message, RPsiElement element) {
        RContainer rContainer = this.getTargetContainer(context);
        String string = MethodRefParam.elementText(context);
        CreateRubyMethodFix createRubyMethodFix = null;
        if (rContainer != null && TextUtil.isAnyID(string)) {
            createRubyMethodFix = new CreateRubyMethodFix(null, rContainer.getCompoundStatement(), string, Context.INSTANCE, this.minAccess == null ? Visibility.PROTECTED : this.minAccess);
        }
        return InspectionResult.createWarningResultWithFix((PsiElement)element, message, createRubyMethodFix);
    }

    protected String warningInspectionMessage(RPsiElement element) {
        long l2 = i ^ 0x586515FA66AL;
        String string = RBundle.message("inspection.paramdef.method.warning", this.topParent == null ? "" : " " + RBundle.message("inspection.paramdef.method.warning.up.to.part", this.topParent), ParamDef.getTextPresentationForPsiElement(element));
        if (this.minAccess != Visibility.PRIVATE) {
            string = string + " " + RBundle.message("inspection.paramdef.access.warning", this.minAccess.toString());
        }
        return string;
    }

    @Override
    public void processAllVariants(@NotNull ParamContext context, @NotNull Consumer<LookupElement> elementsConsumer) {
        RContainer rContainer;
        if (context == null) {
            MethodRefParam.c(0);
        }
        if (elementsConsumer == null) {
            MethodRefParam.c(1);
        }
        if ((rContainer = this.getTargetContainer(context)) != null) {
            this.processVariantsFromClass(context, rContainer, elementsConsumer);
        }
    }

    @Override
    @Nullable
    public final PsiElement resolveReference(@NotNull ParamContext context) {
        Symbol symbol;
        if (context == null) {
            MethodRefParam.c(2);
        }
        return (symbol = this.resolveReferenceToSymbol(context)) == null ? null : symbol.getPsiElement();
    }

    @Override
    protected PsiElement resolveReferenceForInspectionHook(@NotNull ParamContext context) {
        Symbol symbol;
        if (context == null) {
            MethodRefParam.c(3);
        }
        return (symbol = this.resolveReferenceToSymbol(context)) != null && this.isValidMethod(symbol) ? symbol.getPsiElement() : null;
    }

    @Nullable
    protected Symbol resolveReferenceInContainer(@NotNull String name, @Nullable RContainer container) {
        Symbol symbol;
        if (name == null) {
            MethodRefParam.c(4);
        }
        if ((symbol = SymbolUtil.getSymbolByContainer(container)) == null) {
            return null;
        }
        Symbol symbol2 = SymbolUtil.findMethod(symbol, name, Types.METHODS_LIKE, Context.INSTANCE_PRIVATE.immutable(), (PsiElement)container);
        return this.isValidMethod(symbol2) ? symbol2 : null;
    }

    protected boolean processVariantsFromClass(ParamContext context, RContainer container, @NotNull Consumer<LookupElement> elementConsumer) {
        Symbol symbol;
        if (elementConsumer == null) {
            MethodRefParam.c(5);
        }
        if ((symbol = SymbolUtil.getSymbolByContainer(container)) == null) {
            return false;
        }
        this.processMethodsWithInherited(symbol, context.getValueElement(), (Consumer<PsiElement>)((Consumer)psiElement -> {
            LookupElement lookupElement;
            if (psiElement instanceof PsiNamedElement && (lookupElement = MethodRefParam.createLookupItem(context, ((PsiNamedElement)psiElement).getName(), this.itemType, MethodRefParam.getIcon(psiElement))) != null) {
                elementConsumer.consume((Object)lookupElement);
            }
        }));
        return true;
    }

    protected void processMethodsWithInherited(Symbol symbol, RPsiElement element, @NotNull Consumer<PsiElement> elementConsumer) {
        if (elementConsumer == null) {
            MethodRefParam.c(6);
        }
        THashSet tHashSet = new THashSet();
        while (symbol instanceof ClassModuleSymbol && symbol.getPsiElement() instanceof RContainer) {
            if (FQN.same(symbol.getFQNWithNesting(), this.topParent)) {
                return;
            }
            symbol.getChildren().processSymbolsOfTypes(Type.INSTANCE_METHOD.asSet(), (PsiElement)element, (Consumer<Symbol>)((Consumer)arg_0 -> this.a((Set)tHashSet, elementConsumer, arg_0)));
            symbol.getChildren().processSymbolsOfTypes(Type.ALIAS.asSet(), (PsiElement)element, (Consumer<Symbol>)((Consumer)arg_0 -> this.b((Set)tHashSet, elementConsumer, arg_0)));
            symbol = ((ClassModuleSymbol)symbol).getSuperClassSymbol((PsiElement)element);
        }
    }

    public boolean isValidMethod(@Nullable Symbol methodOrAlias) {
        Symbol symbol = methodOrAlias;
        if (methodOrAlias instanceof AliasSymbol) {
            symbol = SymbolUtil.getMethodSymbolByAlias(methodOrAlias);
        }
        if (symbol == null) {
            return false;
        }
        PsiElement psiElement = symbol.getPsiElement();
        if (!(psiElement instanceof RMethod)) {
            return false;
        }
        Visibility visibility = ((RMethod)psiElement).getVisibility();
        return this.minAccess == Visibility.PUBLIC ? visibility == Visibility.PUBLIC : true;
    }

    @Nullable
    protected RContainer getTargetContainer(ParamContext context) {
        Object object;
        if (this.containerDependency != null && (object = this.containerDependency.getValue(context)) instanceof RContainer) {
            return (RContainer)object;
        }
        object = this.findTargetClass(context);
        return object instanceof RContainer ? (RContainer)object : null;
    }

    @Nullable
    protected PsiNamedElement findTargetClass(ParamContext context) {
        RCall rCall = context.getCall();
        return (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)rCall, (Class[])new Class[]{RClass.class, RModule.class});
    }

    protected static Icon getIcon(PsiElement method) {
        if (!(method instanceof RMethod)) {
            return method.getIcon(0);
        }
        RailsAction railsAction = RailsAction.fromMethod((RMethod)method);
        return railsAction != null ? RubyIcons.Rails.ProjectView.Action_method : AllIcons.Nodes.Method;
    }

    @Nullable
    protected Symbol resolveReferenceToSymbol(@NotNull ParamContext context) {
        RContainer rContainer;
        RPsiElement rPsiElement;
        String string;
        if (context == null) {
            MethodRefParam.c(7);
        }
        if ((string = ControllerActionRefParam.getActionName((PsiElement)(rPsiElement = context.getValueElement()))) == null) {
            string = MethodRefParam.elementText(context);
        }
        return (rContainer = this.getTargetContainer(context)) == null ? null : this.resolveReferenceInContainer(string, rContainer);
    }

    private /* synthetic */ void b(Set set, Consumer consumer, Symbol symbol) {
        Symbol symbol2 = SymbolUtil.getMethodSymbolByAlias(symbol);
        if (this.isValidMethod(symbol2) && set.add(symbol.getName())) {
            consumer.consume((Object)symbol.getPsiElement());
        }
    }

    private /* synthetic */ void a(Set set, Consumer consumer, Symbol symbol) {
        if (this.isValidMethod(symbol) && set.add(symbol.getName())) {
            consumer.consume((Object)symbol.getPsiElement());
        }
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = i ^ 0xAB1B605382AL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementConsumer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/MethodRefParam";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReferenceForInspectionHook";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReferenceInContainer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processVariantsFromClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processMethodsWithInherited";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReferenceToSymbol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

