/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.facet.ui.wizard.ui.tabs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ComparableComparator;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ReloadablePanel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RailsAppSampleProvider
implements ReloadablePanel.DataProvider<Pair<String, String>> {
    private static final Logger a;
    private static final String d = "https://api.github.com/users/RailsApps/repos";
    private static final String c = "rails-apps-repos.json";
    static final String CONNECTION_ERROR_RETRY_MSG = "Connection error. Retry.";
    private final ReloadablePanel<Pair<String, String>> e;
    private ImmutableSortedMap.Builder<String, Integer> f;
    private ImmutableMap.Builder<String, String> b;
    private static final long g;

    RailsAppSampleProvider(@NotNull ReloadablePanel<Pair<String, String>> reloadablePanel) {
        if (reloadablePanel == null) {
            RailsAppSampleProvider.a(0);
        }
        this.e = reloadablePanel;
    }

    private Runnable d() {
        return () -> {
            long l2 = g ^ 0x5E53A33E5944L;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            try {
                Set<Pair<String, String>> set = this.c();
                RailsAppSampleProvider.a(set, "rails-composer");
                RailsAppSampleProvider.a(set, "rails3-application-templates");
                UIUtil.invokeLaterIfNeeded(() -> this.e.onUpdateValues(set));
            }
            catch (IOException iOException) {
                String string = "Sorry, cannot fetch <a href=\"https://api.github.com/users/RailsApps/repos\">RailsApp Samples</a>. Please try later.";
                UIUtil.invokeLaterIfNeeded(() -> {
                    long l2 = g ^ 0x4BEECA2C54F8L;
                    this.e.onUpdateValues(ContainerUtil.set((Object[])new Pair[]{Pair.create((Object)CONNECTION_ERROR_RETRY_MSG, (Object)"Sorry, cannot fetch <a href=\"https://api.github.com/users/RailsApps/repos\">RailsApp Samples</a>. Please try later.")}));
                });
                a.warn("Cannot fetch RailsApp Samples from https://api.github.com/users/RailsApps/repos", (Throwable)iOException);
            }
            catch (GeneratorException generatorException) {
                a.warn("Malformed JSON received from https://api.github.com/users/RailsApps/repos", (Throwable)generatorException);
            }
        };
    }

    private static void a(@NotNull Set<Pair<String, String>> set, @NotNull String string) {
        Pair pair2;
        if (set == null) {
            RailsAppSampleProvider.a(1);
        }
        if (string == null) {
            RailsAppSampleProvider.a(2);
        }
        if ((pair2 = (Pair)ContainerUtil.find(set, pair -> ((String)pair.getFirst()).equals(string))) != null) {
            set.remove(pair2);
        }
    }

    @NotNull
    protected Set<Pair<String, String>> getNameDescriptionPairs() {
        ImmutableSortedMap immutableSortedMap = this.f.build();
        ImmutableList immutableList = RailsAppSampleProvider.a(immutableSortedMap, new ComparableComparator.Descending());
        ImmutableMap immutableMap = this.b.build();
        LinkedHashSet<Pair<String, String>> linkedHashSet = new LinkedHashSet<Pair<String, String>>();
        for (String string : immutableList) {
            linkedHashSet.add((Pair<String, String>)Pair.create((Object)string, (Object)immutableMap.get((Object)string)));
        }
        LinkedHashSet<Pair<String, String>> linkedHashSet2 = linkedHashSet;
        if (linkedHashSet2 == null) {
            RailsAppSampleProvider.a(3);
        }
        return linkedHashSet2;
    }

    private static <K, V> ImmutableList<K> a(final Map<K, V> map2, final Comparator<? super V> comparator) {
        Ordering ordering = new Ordering<K>(){

            public int compare(K left, K right) {
                return comparator.compare(map2.get(left), map2.get(right));
            }
        };
        return ordering.immutableSortedCopy(map2.keySet());
    }

    private Set<Pair<String, String>> c() throws IOException, GeneratorException {
        long l2 = g ^ 0x156AF418789EL;
        File file = RailsAppSampleProvider.e();
        GithubDownloadUtil.downloadAtomically(null, (String)d, (File)file, (String)"RailsApps", (String)"all");
        return this.a(file);
    }

    @NotNull
    private Set<Pair<String, String>> a(@NotNull File file) throws GeneratorException {
        Set<Pair<String, String>> set;
        String string;
        long l2 = g ^ 0x685518483216L;
        if (file == null) {
            RailsAppSampleProvider.a(4);
        }
        try {
            string = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            throw new GeneratorException("Can not read '" + file.getAbsolutePath() + "'!", (Throwable)iOException);
        }
        try {
            set = this.a(string);
        }
        catch (GeneratorException generatorException) {
            a.info("Rails app temaplates file parsing error", (Throwable)generatorException);
            throw generatorException;
        }
        if (set == null) {
            RailsAppSampleProvider.a(5);
        }
        return set;
    }

    @NotNull
    private Set<Pair<String, String>> a(@NotNull String string) throws GeneratorException {
        JsonElement jsonElement;
        long l2 = g ^ 0x4F66B2D6522CL;
        if (string == null) {
            RailsAppSampleProvider.a(6);
        }
        if (string.trim().isEmpty()) {
            throw new GeneratorException("Can not parse fetched rails app templates: got empty response");
        }
        try {
            jsonElement = new JsonParser().parse(string);
        }
        catch (Exception exception) {
            throw new GeneratorException("Can not parse fetched version list: malformed JSON was received");
        }
        Set<Pair<String, String>> set = this.a(jsonElement);
        if (set == null) {
            RailsAppSampleProvider.a(7);
        }
        return set;
    }

    @NotNull
    private Set<Pair<String, String>> a(@NotNull JsonElement jsonElement) throws GeneratorException {
        long l2 = g ^ 0x694686688784L;
        if (jsonElement == null) {
            RailsAppSampleProvider.a(8);
        }
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            this.f = ImmutableSortedMap.naturalOrder();
            this.b = ImmutableMap.builder();
            for (JsonElement jsonElement2 : jsonArray) {
                if (jsonElement2 instanceof JsonObject) {
                    String string = RailsAppSampleProvider.a((JsonObject)jsonElement2, "name");
                    String string2 = RailsAppSampleProvider.a((JsonObject)jsonElement2, "description");
                    String string3 = RailsAppSampleProvider.a((JsonObject)jsonElement2, "stargazers_count");
                    if (string == null) continue;
                    if (string2 != null) {
                        this.b.put((Object)string, (Object)string2);
                    }
                    if (string3 == null) continue;
                    try {
                        this.f.put((Object)string, (Object)Integer.valueOf(string3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        a.warn("Stargazer for " + string + " isn't an integer: " + string3);
                        this.f.put((Object)string, (Object)0);
                    }
                    continue;
                }
                throw new GeneratorException("Unexpected child element " + jsonElement2.getClass().getName());
            }
            Set<Pair<String, String>> set = this.getNameDescriptionPairs();
            if (set == null) {
                RailsAppSampleProvider.a(9);
            }
            return set;
        }
        throw new GeneratorException("jsonElement is expected be instance of " + JsonArray.class.getName());
    }

    @Nullable
    private static String a(@NotNull JsonObject jsonObject, @NotNull String string) {
        if (jsonObject == null) {
            RailsAppSampleProvider.a(10);
        }
        if (string == null) {
            RailsAppSampleProvider.a(11);
        }
        JsonElement jsonElement = jsonObject.get(string);
        String string2 = null;
        if (jsonElement != null) {
            string2 = jsonElement.getAsString();
        }
        return string2;
    }

    @NotNull
    private static File e() {
        long l2 = g ^ 0x24DB55616723L;
        File file = new File(GithubDownloadUtil.getUserCacheDir((String)"RailsApps"), c);
        if (file == null) {
            RailsAppSampleProvider.a(12);
        }
        return file;
    }

    @Nullable
    public Set<Pair<String, String>> getCachedValues() {
        long l2 = g ^ 0x10CBAD4AA2BCL;
        ApplicationManager.getApplication().assertIsDispatchThread();
        File file = RailsAppSampleProvider.e();
        if (file.isFile()) {
            try {
                return this.a(file);
            }
            catch (GeneratorException generatorException) {
                a.warn("Can't read rails app templates cache file " + file.getAbsolutePath(), (Throwable)generatorException);
            }
        }
        return null;
    }

    public void updateValuesAsynchronously() {
        Runnable runnable = this.d();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        }
    }

    static {
        g = com.jetbrains.python.psi.c.a(4444153741391830462L, 6757289512412056955L, MethodHandles.lookup().lookupClass()).a(214066700211388L);
        a = Logger.getInstance(RailsAppSampleProvider.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x321D72D03A6EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloadablePanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameDescriptionPairs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/facet/ui/wizard/ui/tabs/RailsAppSampleProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagFileContent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/facet/ui/wizard/ui/tabs/RailsAppSampleProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameDescriptionPairs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readReposFromFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toReposSet";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRailsAppCacheFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeNotARailsApp";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readReposFromFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toReposSet";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

