/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.inspections.rails3.deprecations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.codeInsight.ActiveRecordType;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsTypeProvider;
import org.jetbrains.plugins.ruby.rails.inspections.rails3.Rails3DeprecatedVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public class ActiveRecordDeprecations {
    static final Set<String> ACTIVE_RECORD_DEPRECATIONS;
    static final Set<String> ACTIVE_RECORD_DEPRECATIONS_MODULES;
    private static final long a;

    private ActiveRecordDeprecations() {
    }

    public static void checkActiveRecord(Rails3DeprecatedVisitor visitor2, RCall call) {
        String string;
        RPsiElement rPsiElement;
        long l2 = a ^ 0x6D1B0751BC1CL;
        PsiElement psiElement = call.getPsiCommand();
        String string2 = null;
        if (psiElement instanceof RDotReference && (rPsiElement = ((RDotReference)psiElement).getValue()) instanceof RIdentifier) {
            string2 = rPsiElement.getName();
        }
        if (!ACTIVE_RECORD_DEPRECATIONS.contains(string2)) {
            return;
        }
        rPsiElement = psiElement.getReference();
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)rPsiElement);
        if (symbol == null) {
            return;
        }
        String string3 = symbol.getFQNWithNesting().getCallerFQN().getFullPath();
        if (!ACTIVE_RECORD_DEPRECATIONS_MODULES.contains(string3)) {
            return;
        }
        List<RPsiElement> list2 = call.getArguments();
        if ("find".equals(string2) && list2.size() > 0 && (":first".equals(string = list2.get(0).getText()) || ":all".equals(string))) {
            visitor2.registerProblem((PsiElement)call, Rails3DeprecatedVisitor.buildDeprecationMessage(RBundle.message("inspection.rails3.find.all.and.first"), "3.2"));
        }
    }

    public static void checkActiveRecord(Rails3DeprecatedVisitor visitor2, RDotReference reference) {
        long l2 = a ^ 0x5746443B7801L;
        PsiReference psiReference = reference.getReference();
        if (psiReference instanceof RPsiPolyVariantReference) {
            String string;
            Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(psiReference);
            String string2 = string = symbol instanceof ActiveRecordType.DynamicFinder ? symbol.getName() : null;
            if (string != null && !string.startsWith("find_by_")) {
                visitor2.registerProblem((PsiElement)reference, Rails3DeprecatedVisitor.buildDeprecationMessage(RBundle.message("inspection.rails4.dynamic.finders"), "5.0"));
            }
        }
    }

    static {
        a = c.a(8669874831615041023L, -5964151348065051154L, MethodHandles.lookup().lookupClass()).a(141326123990241L);
        ACTIVE_RECORD_DEPRECATIONS = new HashSet<String>();
        ACTIVE_RECORD_DEPRECATIONS_MODULES = new HashSet<String>();
        ACTIVE_RECORD_DEPRECATIONS.addAll(RailsTypeProvider.ACTIVE_RECORD_FINDERS);
        ACTIVE_RECORD_DEPRECATIONS.addAll(RailsTypeProvider.ACTIVE_CALCULATIONS);
        ACTIVE_RECORD_DEPRECATIONS.addAll(RailsTypeProvider.ACTIVE_RELATIONS);
        ACTIVE_RECORD_DEPRECATIONS_MODULES.addAll(RailsTypeProvider.ACTIVE_RECORD_FINDERS_MODULES);
        ACTIVE_RECORD_DEPRECATIONS_MODULES.addAll(RailsTypeProvider.ACTIVE_CALCULATIONS_MODULES);
        ACTIVE_RECORD_DEPRECATIONS_MODULES.addAll(RailsTypeProvider.ACTIVE_RELATIONS_MODULES);
    }
}

