/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.migrations;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.ActiveRecordType;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.migrations.MigrationField;
import org.jetbrains.plugins.ruby.rails.migrations.a;
import org.jetbrains.plugins.ruby.ruby.RubyPsiManager;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public class MigrationParser
implements Disposable {
    private static final Logger g;
    public static final String CREATE_TABLE = "create_table";
    private final Object e = new Object();
    private final Module f;
    private VirtualFile c;
    private VirtualFile h;
    private boolean a;
    public static final Pattern MIGRATION_FILE_NAME_WITHOUT_EXT;
    private final Alarm d = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    public static final Topic<MigrationListener> MIGRATIONS_CHANGED_TOPIC;
    private Map<String, TableDefinitionAndFields> b;
    private static final long i;

    public static boolean matchesToMigrationFileNameTemplate(@NotNull VirtualFile file) {
        if (file == null) {
            MigrationParser.a(0);
        }
        return MIGRATION_FILE_NAME_WITHOUT_EXT.matcher(file.getNameWithoutExtension()).matches();
    }

    public static MigrationParser getInstance(Module module2) {
        return (MigrationParser)ModuleServiceManager.getService((Module)module2, MigrationParser.class);
    }

    public MigrationParser(Module module2) {
        this.f = module2;
        Disposer.register((Disposable)module2, (Disposable)this);
        this.parseAllMigrations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupForNextTest() {
        this.a = false;
        Object object = this.e;
        synchronized (object) {
            this.c = null;
            this.h = null;
        }
        object = this;
        synchronized (object) {
            this.b = null;
        }
    }

    public void dispose() {
        this.h = null;
        this.c = null;
    }

    public void parseAllMigrations() {
        PsiDirectory psiDirectory = this.g();
        if (psiDirectory == null) {
            return;
        }
        this.b((PsiElement)psiDirectory);
        this.a = true;
        this.b();
    }

    private void b(PsiElement psiElement2) {
        RubyPsiManager.getInstance(this.f.getProject()).addChangeWatcher(psiElement2, psiElement -> {
            long l2 = i ^ 0x956EC9DD7FCL;
            boolean bl2 = false;
            if (psiElement instanceof PsiDirectory) {
                bl2 = true;
            } else {
                PsiFile psiFile = psiElement.getContainingFile();
                String string = psiFile.getName();
                if (psiFile instanceof RFile && RubyVirtualFileScanner.isRubyFile(string)) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if ("schema.rb".equals(string) || virtualFile != null && MigrationParser.matchesToMigrationFileNameTemplate(virtualFile)) {
                        bl2 = true;
                    }
                }
            }
            if (bl2) {
                this.e();
            }
        });
    }

    private void e() {
        if (this.d.isDisposed()) {
            return;
        }
        this.d.cancelAllRequests();
        Runnable runnable = () -> {
            this.b();
            ((MigrationListener)this.f.getMessageBus().syncPublisher(MIGRATIONS_CHANGED_TOPIC)).migrationsChanged(this.f);
        };
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.d.addRequest(runnable, 500);
        } else {
            runnable.run();
        }
    }

    private void b() {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object;
            PsiDirectory psiDirectory;
            RFile rFile3;
            Object object2;
            long l2 = i ^ 0x12BB46754E41L;
            if (this.f.isDisposed()) {
                return;
            }
            Object object3 = this.e;
            synchronized (object3) {
                if (this.c == null || !this.c.isValid()) {
                    this.c = this.h();
                }
                if (this.h == null || !this.h.isValid()) {
                    this.h = this.a();
                }
                object2 = PsiManager.getInstance((Project)this.f.getProject());
                rFile3 = this.h != null ? (RFile)ObjectUtils.tryCast((Object)object2.findFile(this.h), RFile.class) : null;
                psiDirectory = this.c != null ? object2.findDirectory(this.c) : null;
            }
            if (rFile3 != null) {
                if (!this.a((PsiElement)rFile3)) {
                    return;
                }
                object3 = MigrationParser.b(rFile3);
            } else {
                object3 = null;
            }
            object2 = new ArrayList();
            if (psiDirectory != null) {
                for (PsiElement object4 : psiDirectory.getChildren()) {
                    String string;
                    if (!(object4 instanceof RFile)) continue;
                    object = ((RFile)object4).getVirtualFile();
                    assert (object != null);
                    if (!MigrationParser.matchesToMigrationFileNameTemplate(object) || (string = MigrationParser.getMigrationVersion(object)) == null || object3 != null && VersionComparatorUtil.compare((String)object3, (String)string) >= 0) continue;
                    if (this.a(object4)) {
                        object2.add((RFile)object4);
                        continue;
                    }
                    return;
                }
            }
            long l3 = System.currentTimeMillis();
            MigrationParser migrationParser = this;
            synchronized (migrationParser) {
                this.b = new HashMap<String, TableDefinitionAndFields>();
                Collections.sort(object2, (rFile, rFile2) -> VersionComparatorUtil.compare((String)rFile.getName(), (String)rFile2.getName()));
                if (object3 != null) {
                    this.a(rFile3);
                }
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (RFile)iterator.next();
                    this.d((RFile)object);
                }
            }
            long l4 = System.currentTimeMillis() - l3;
            g.debug("Reparsed " + object2.size() + " migration files" + (object3 != null ? " and schema.rb (vers." + (String)object3 + ")" : "") + " in " + l4 + " ms");
        });
    }

    @Nullable
    public static String getMigrationVersion(VirtualFile migrationFile) {
        String string;
        String string2 = migrationFile.getName();
        int n2 = string2.indexOf(95);
        if (n2 > 0 && TextUtil.isInteger(string = string2.substring(0, n2))) {
            return string;
        }
        return null;
    }

    private boolean a(PsiElement psiElement) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)psiElement.getProject());
        Document document = psiDocumentManager.getCachedDocument((PsiFile)((RFile)psiElement));
        if (document != null && psiDocumentManager.isUncommited(document)) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    psiDocumentManager.commitDocument(document);
                    this.e();
                });
            }
            return false;
        }
        return true;
    }

    private void d(RFile rFile) {
        List list2 = rFile.getStructureElements();
        for (RPsiStructureElement rPsiStructureElement : list2) {
            if (!(rPsiStructureElement instanceof RClass)) continue;
            this.a((RClass)rPsiStructureElement);
        }
    }

    private void a(RFile rFile) {
        RBlockCall rBlockCall = MigrationParser.c(rFile);
        if (rBlockCall != null) {
            this.a(rBlockCall);
        }
    }

    @Nullable
    private static String b(RFile rFile) {
        long l2 = i ^ 0x79F6CD68487EL;
        RBlockCall rBlockCall = MigrationParser.c(rFile);
        if (rBlockCall == null) {
            return null;
        }
        RPossibleCall rPossibleCall = rBlockCall.getCall();
        List<RPsiElement> list2 = rPossibleCall.getArguments();
        for (RPsiElement rPsiElement : list2) {
            RAssoc rAssoc;
            if (!(rPsiElement instanceof RAssoc) || !StringUtil.equals((CharSequence)"version", (CharSequence)(rAssoc = (RAssoc)rPsiElement).getKeyText())) continue;
            RPsiElement rPsiElement2 = rAssoc.getValue();
            if (rPsiElement2 != null) {
                String string = StringUtil.notNullize((String)RubyPsiUtil.getElementText((PsiElement)rPsiElement2)).replaceAll("_", "");
                if (TextUtil.isInteger(string)) {
                    return string;
                }
                g.warn("Schema version number expected but found: " + string);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static RBlockCall c(RFile rFile) {
        long l2 = i ^ 0x15448D12F275L;
        List list2 = rFile.getStructureElements();
        for (RPsiElement rPsiElement : list2) {
            String string;
            RBlockCall rBlockCall;
            if (rPsiElement instanceof RBlockCall) {
                rBlockCall = (RBlockCall)rPsiElement;
            } else {
                if (!(rPsiElement.getParent() instanceof RBlockCall)) continue;
                rBlockCall = (RBlockCall)rPsiElement.getParent();
            }
            if ((string = rBlockCall.getCommand()) == null || !string.endsWith(".define")) continue;
            return rBlockCall;
        }
        return null;
    }

    private void a(RBlockCall rBlockCall) {
        RCodeBlock rCodeBlock = rBlockCall.getBlock();
        new RubyPsiInterpreter(true).interpret((PsiElement)rCodeBlock, new MigrationCallable(null));
    }

    private void a(RClass rClass) {
        long l2 = i ^ 0x252B55AA703FL;
        List list2 = rClass.getStructureElements();
        RMethod rMethod = null;
        RMethod rMethod2 = null;
        RMethod rMethod3 = null;
        for (RPsiStructureElement rPsiStructureElement : list2) {
            if (!(rPsiStructureElement instanceof RMethod)) continue;
            RMethod rMethod4 = (RMethod)rPsiStructureElement;
            if ("up".equals(rMethod4.getName())) {
                rMethod = rMethod4;
            } else if ("down".equals(rMethod4.getName())) {
                rMethod2 = rMethod4;
            }
            if (!"change".equals(rMethod4.getName())) continue;
            rMethod3 = rMethod4;
        }
        if (rMethod != null && rMethod2 != null) {
            this.a(rMethod);
        } else if (rMethod3 != null) {
            this.a(rMethod3);
        }
    }

    private static void c(RCallArguments rCallArguments) {
        rCallArguments.interpretBlock(new PsiCallable[0]);
    }

    private void a(String string, String string2, RCallArguments rCallArguments) {
        long l2 = i ^ 0x151B465FF36BL;
        if ("timestamps".equals(string2)) {
            TableDefinitionAndFields tableDefinitionAndFields = this.b.get(string);
            if (tableDefinitionAndFields != null) {
                tableDefinitionAndFields.addField(new MigrationField("created_at", "timestamp", rCallArguments.getRCallElement()));
                tableDefinitionAndFields.addField(new MigrationField("updated_at", "timestamp", rCallArguments.getRCallElement()));
            }
        } else if ("column".equals(string2)) {
            this.d(new ColumnCallParser(rCallArguments, null).withTableName(string));
        } else if (ActiveRecordType.COLUMN_TYPES_SET.contains(string2)) {
            this.d(new ColumnCallParser(rCallArguments, null).withTableName(string).withDataType(string2));
        } else if ("belongs_to".equals(string2) || "references".equals(string2)) {
            RPsiElement rPsiElement;
            for (int i10 = 0; i10 < rCallArguments.getArguments().size() && ((rPsiElement = rCallArguments.getArguments().get(i10)) instanceof RSymbol || rPsiElement instanceof RBaseString); ++i10) {
                TableDefinitionAndFields tableDefinitionAndFields;
                String string3 = rCallArguments.evaluateArgument(i10);
                if (string3 == null || (tableDefinitionAndFields = this.b.get(string)) == null) continue;
                tableDefinitionAndFields.addField(new MigrationField(string3 + "_id", "integer", rCallArguments.getRCallElement()));
                if (rCallArguments.getOptionValue("polymorphic") == null) continue;
                tableDefinitionAndFields.addField(new MigrationField(string3 + "_type", "string", rCallArguments.getRCallElement()));
            }
        }
    }

    private void a(RMethod rMethod) {
        new RubyPsiInterpreter(true).interpret((PsiElement)rMethod, new MigrationCallable(null));
    }

    private void d(RCallArguments rCallArguments) {
        String string = rCallArguments.evaluateArgument(0);
        if (string != null) {
            this.a(string, rCallArguments);
            rCallArguments.interpretBlock(new TableCallable(string, null));
        }
    }

    private void a(String string, @NonNls RCallArguments rCallArguments) {
        long l2 = i ^ 0x4F2464AEAF99L;
        boolean bl2 = "false".equals(rCallArguments.getOptionValue("id"));
        String string2 = rCallArguments.getOptionValue("primary_key", "id");
        if (!this.b.containsKey(string)) {
            TableDefinitionAndFields tableDefinitionAndFields = new TableDefinitionAndFields(rCallArguments.getArguments().get(0));
            if (!bl2) {
                tableDefinitionAndFields.addField(new MigrationField(string2, "integer", rCallArguments.getRCallElement()));
            }
            this.b.put(string, tableDefinitionAndFields);
        }
    }

    private void a(RCallArguments rCallArguments) {
        TableDefinitionAndFields tableDefinitionAndFields;
        String string = rCallArguments.evaluateArgument(0);
        String string2 = rCallArguments.evaluateArgument(1);
        if (string != null && string2 != null && (tableDefinitionAndFields = this.b.get(string)) != null) {
            this.b.remove(string);
            this.b.put(string2, tableDefinitionAndFields);
        }
    }

    private void b(RCallArguments rCallArguments) {
        String string = rCallArguments.evaluateArgument(0);
        if (string != null) {
            rCallArguments.interpretBlock(new ChangeTableCallable(string, null));
        }
    }

    private void d(ColumnCallParser columnCallParser) {
        String string = columnCallParser.getTableName();
        TableDefinitionAndFields tableDefinitionAndFields = this.b.get(string);
        if (tableDefinitionAndFields == null) {
            return;
        }
        String string2 = columnCallParser.a();
        String string3 = columnCallParser.getDataType();
        tableDefinitionAndFields.addField(new MigrationField(string2, string3, columnCallParser.getCall()));
    }

    private void a(ColumnCallParser columnCallParser) {
        String string = columnCallParser.getTableName();
        String string2 = columnCallParser.a();
        String string3 = columnCallParser.a();
        MigrationField migrationField = this.a(string, string2);
        if (migrationField != null) {
            migrationField.setName(string3);
            migrationField.addDeclaration(columnCallParser.getCall());
        }
    }

    private void b(ColumnCallParser columnCallParser) {
        List<MigrationField> list2;
        long l2 = i ^ 0x49DD07108B7AL;
        String string = columnCallParser.getTableName();
        TableDefinitionAndFields tableDefinitionAndFields = this.b.get(string);
        List<MigrationField> list3 = list2 = tableDefinitionAndFields != null ? tableDefinitionAndFields.getFields() : null;
        if (list2 != null) {
            String string2 = columnCallParser.a();
            while (string2 != null) {
                Iterator<MigrationField> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    MigrationField migrationField = iterator.next();
                    if (!Comparing.equal((String)migrationField.getName(), (String)string2)) continue;
                    iterator.remove();
                    break;
                }
                string2 = columnCallParser.a();
            }
        } else {
            g.info("Could not find list of fields for table " + string);
        }
    }

    private void c(ColumnCallParser columnCallParser) {
        String string = columnCallParser.getTableName();
        String string2 = columnCallParser.a();
        String string3 = columnCallParser.a();
        MigrationField migrationField = this.a(string, string2);
        if (migrationField != null) {
            migrationField.setDataType(string3);
            migrationField.addDeclaration(columnCallParser.getCall());
        }
    }

    @Nullable
    private MigrationField a(String string, String string2) {
        long l2 = i ^ 0x6DCEB532A3D5L;
        if (string2 == null) {
            return null;
        }
        TableDefinitionAndFields tableDefinitionAndFields = this.b.get(string);
        if (tableDefinitionAndFields != null) {
            return tableDefinitionAndFields.findFieldByName(string2);
        }
        g.info("Could not find list of fields for table " + string);
        return null;
    }

    @Nullable
    public Collection<MigrationField> getFieldsByTableName(String tableName) {
        return MigrationParser.b(tableName, this.f());
    }

    @Nullable
    public PsiElement getTableDef(@NotNull String tableName) {
        if (tableName == null) {
            MigrationParser.a(1);
        }
        return MigrationParser.a(tableName, this.f());
    }

    @Nullable
    private static Collection<MigrationField> b(String string, Map<String, TableDefinitionAndFields> map2) {
        if (map2 == null) {
            return null;
        }
        TableDefinitionAndFields tableDefinitionAndFields = map2.get(string);
        if (tableDefinitionAndFields == null) {
            return null;
        }
        return new ArrayList<MigrationField>(tableDefinitionAndFields.getFields());
    }

    @Nullable
    private static PsiElement a(String string, Map<String, TableDefinitionAndFields> map2) {
        if (map2 == null) {
            return null;
        }
        TableDefinitionAndFields tableDefinitionAndFields = map2.get(string);
        return tableDefinitionAndFields != null ? tableDefinitionAndFields.getTableDef() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, TableDefinitionAndFields> f() {
        boolean bl2;
        MigrationParser migrationParser = this;
        synchronized (migrationParser) {
            bl2 = this.b == null;
        }
        if (bl2) {
            if (this.a) {
                this.b();
            } else {
                this.parseAllMigrations();
            }
        }
        migrationParser = this;
        synchronized (migrationParser) {
            return this.b;
        }
    }

    public Map<String, TableDefinitionAndFields> getTable2FieldsMap() {
        return this.f();
    }

    @NotNull
    public String[] getAllTables() {
        Map<String, TableDefinitionAndFields> map2 = this.f();
        if (map2 == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                MigrationParser.a(2);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        Set<String> set = map2.keySet();
        String[] stringArray = ArrayUtilRt.toStringArray(set);
        if (stringArray == null) {
            MigrationParser.a(3);
        }
        return stringArray;
    }

    public boolean containsTable(@Nullable String tableName) {
        if (tableName == null) {
            return false;
        }
        Map<String, TableDefinitionAndFields> map2 = this.f();
        return map2 != null && map2.keySet().contains(tableName);
    }

    public Map<String, MigrationField> getFieldMap(String tableName) {
        HashMap<String, MigrationField> hashMap = new HashMap<String, MigrationField>();
        if (tableName != null) {
            List<MigrationField> list2;
            TableDefinitionAndFields tableDefinitionAndFields = this.f().get(tableName);
            List<MigrationField> list3 = list2 = tableDefinitionAndFields != null ? tableDefinitionAndFields.getFields() : null;
            if (list2 != null) {
                for (MigrationField migrationField : list2) {
                    hashMap.put(migrationField.getName(), migrationField);
                }
            }
        }
        return hashMap;
    }

    @Nullable
    private VirtualFile h() {
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(this.f);
        if (standardRailsPaths == null) {
            return null;
        }
        String string = standardRailsPaths.getMigrationsRootURL();
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string);
        if (virtualFile != null && virtualFile.isDirectory()) {
            return virtualFile;
        }
        return null;
    }

    @Nullable
    private VirtualFile a() {
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(this.f);
        if (standardRailsPaths == null) {
            return null;
        }
        String string = StandardRailsPaths.buildDBSchemaUrl(standardRailsPaths.getRailsApplicationHomeURL());
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string);
        if (virtualFile != null && virtualFile.getFileType() == RubyFileType.RUBY) {
            return virtualFile;
        }
        return null;
    }

    @Nullable
    private PsiDirectory g() {
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(this.f);
        if (standardRailsPaths == null) {
            return null;
        }
        String string = StandardRailsPaths.buildDBFolderUrl(standardRailsPaths.getRailsApplicationHomeURL());
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string);
        if (virtualFile != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.f.getProject());
            return psiManager.findDirectory(virtualFile);
        }
        return null;
    }

    static {
        i = com.jetbrains.python.psi.c.a(-9126528307220193023L, -5452402871784805296L, MethodHandles.lookup().lookupClass()).a(278528979121936L);
        long l2 = i ^ 0x5DF47085192DL;
        g = Logger.getInstance(MigrationParser.class);
        MIGRATION_FILE_NAME_WITHOUT_EXT = Pattern.compile("\\d+_\\w+");
        MIGRATIONS_CHANGED_TOPIC = Topic.create((String)"migrations changed", MigrationListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x312C416C395EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/migrations/MigrationParser";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/migrations/MigrationParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTables";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchesToMigrationFileNameTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTableDef";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TableDefinitionAndFields {
        private final List<MigrationField> a;
        private final SmartPsiElementPointer b;
        private static final long c = com.jetbrains.python.psi.c.a(4532436706453559699L, -7737679792579200395L, MethodHandles.lookup().lookupClass()).a(137398870271905L);

        public TableDefinitionAndFields(@NotNull RPsiElement createTableCall) {
            if (createTableCall == null) {
                TableDefinitionAndFields.a(0);
            }
            this.a = new ArrayList<MigrationField>();
            this.b = MigrationField.createPointerFor((PsiElement)createTableCall);
        }

        public void addField(@NotNull MigrationField migrationField) {
            if (migrationField == null) {
                TableDefinitionAndFields.a(1);
            }
            this.a.add(migrationField);
        }

        @Nullable
        public MigrationField findFieldByName(@NotNull String name) {
            if (name == null) {
                TableDefinitionAndFields.a(2);
            }
            if (this.a != null) {
                for (MigrationField migrationField : this.a) {
                    if (!name.equals(migrationField.getName())) continue;
                    return migrationField;
                }
            }
            return null;
        }

        @NotNull
        public List<MigrationField> getFields() {
            List<MigrationField> list2 = this.a;
            if (list2 == null) {
                TableDefinitionAndFields.a(3);
            }
            return list2;
        }

        @Nullable
        public PsiElement getTableDef() {
            return this.b.getElement();
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x3C62B45F855AL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "createTableCall";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migrationField";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/migrations/MigrationParser$TableDefinitionAndFields";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/migrations/MigrationParser$TableDefinitionAndFields";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFields";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addField";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findFieldByName";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ColumnCallParser {
        private int b = 0;
        private String c;
        private String d;
        private final RCallArguments a;

        private ColumnCallParser(RCallArguments arguments) {
            this.a = arguments;
        }

        ColumnCallParser withTableName(String tableName) {
            this.c = tableName;
            return this;
        }

        ColumnCallParser withDataType(String dataType) {
            this.d = dataType;
            return this;
        }

        public PsiElement getCall() {
            return this.a.getRCallElement();
        }

        @Nullable
        String getTableName() {
            if (this.c != null) {
                return this.c;
            }
            return this.a();
        }

        @Nullable
        String getDataType() {
            if (this.d != null) {
                return this.d;
            }
            return this.a();
        }

        @Nullable
        private String a() {
            return this.a.evaluateArgument(this.b++);
        }

        /* synthetic */ ColumnCallParser(RCallArguments x0, a x1) {
            this(x0);
        }
    }

    private class ChangeTableCallable
    implements PsiCallable {
        private final String a;
        private static final long b = com.jetbrains.python.psi.c.a(8303388776167063979L, 2947962101372801189L, MethodHandles.lookup().lookupClass()).a(231364190041132L);

        private ChangeTableCallable(String tableName) {
            this.a = tableName;
        }

        @Override
        public void processCall(RCallArguments arguments) {
            long l2 = b ^ 0x5C9783C35072L;
            String string = arguments.getCommand();
            if ("rename".equals(string)) {
                MigrationParser.this.a(new ColumnCallParser(arguments, null).withTableName(this.a));
            } else if ("remove".equals(string)) {
                MigrationParser.this.b(new ColumnCallParser(arguments, null).withTableName(this.a));
            } else if ("change".equals(string)) {
                MigrationParser.this.c(new ColumnCallParser(arguments, null).withTableName(this.a));
            } else {
                MigrationParser.this.a(this.a, string, arguments);
            }
        }

        /* synthetic */ ChangeTableCallable(String x1, a x2) {
            this(x1);
        }
    }

    private class TableCallable
    implements PsiCallable {
        private final String a;

        private TableCallable(String tableName) {
            this.a = tableName;
        }

        @Override
        public void processCall(RCallArguments arguments) {
            String string = arguments.getCommand();
            MigrationParser.this.a(this.a, string, arguments);
        }

        /* synthetic */ TableCallable(String x1, a x2) {
            this(x1);
        }
    }

    private class MigrationCallable
    implements PsiCallable {
        private static final long a = com.jetbrains.python.psi.c.a(6128830071014251628L, 3861207349998057204L, MethodHandles.lookup().lookupClass()).a(90011350996611L);

        private MigrationCallable() {
        }

        @Override
        public void processCall(RCallArguments arguments) {
            long l2 = a ^ 0x1699480CC592L;
            String string = arguments.getCommand();
            if (string.equals(MigrationParser.CREATE_TABLE)) {
                MigrationParser.this.d(arguments);
            } else if (string.equals("change_table")) {
                MigrationParser.this.b(arguments);
            } else if (string.equals("rename_table")) {
                MigrationParser.this.a(arguments);
            } else if (string.equals("add_column")) {
                MigrationParser.this.d(new ColumnCallParser(arguments, null));
            } else if (string.equals("rename_column")) {
                MigrationParser.this.a(new ColumnCallParser(arguments, null));
            } else if (string.equals("remove_column") || string.equals("remove_columns")) {
                MigrationParser.this.b(new ColumnCallParser(arguments, null));
            } else if (string.equals("change_column")) {
                MigrationParser.this.c(new ColumnCallParser(arguments, null));
            } else if (string.equals("transaction")) {
                MigrationParser.c(arguments);
            }
        }

        /* synthetic */ MigrationCallable(a x1) {
            this();
        }
    }

    public static interface MigrationListener {
        public void migrationsChanged(Module var1);
    }
}

