/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.spring;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringDebugConfigDialog;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

@State(name="SpringUtil", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class SpringUtil
implements PersistentStateComponent<Element> {
    @NonNls
    public static final String SPRING_BINARY_NAME = "spring";
    @NonNls
    private static final String h = ".spring.rb";
    @NonNls
    private static final String f = "spring.debug.patch.denied";
    @NonNls
    private static final String l = "spring.rb";
    @NonNls
    private static final String a = "Spring.after_fork do\n  if ENV['DEBUGGER_STORED_RUBYLIB']\n    starter = ENV['BUNDLER_ORIG_RUBYOPT'][2..-1]\n    load(starter + '.rb')\n  end\nend";
    @NonNls
    private static final String d = "Spring.after_fork do\n  if ENV['DEBUGGER_STORED_RUBYLIB']\n    ENV['DEBUGGER_STORED_RUBYLIB'].split(File::PATH_SEPARATOR).each do |path|\n      next unless path =~ /ruby-debug-ide/\n      load path + '/ruby-debug-ide/multiprocess/starter.rb'\n    end\n  end\nend";
    @NonNls
    public static final String SPRING_PRE_LOADER_OPTION_FIELD = "SPRING_PRE_LOADER_OPTION";
    @NonNls
    public static final String RAKE_SPRING_PRE_LOADER_OPTION_FIELD = "RAKE_SPRING_PRE_LOADER_OPTION";
    @NonNls
    public static final String RAILS_SPRING_PRE_LOADER_OPTION_FIELD = "RAILS_SPRING_PRE_LOADER_OPTION";
    private static final int i = 104;
    public boolean SPRING_PRE_LOADER_OPTION = true;
    public boolean RAKE_SPRING_PRE_LOADER_OPTION = true;
    public boolean RAILS_SPRING_PRE_LOADER_OPTION = true;
    public static final String SPRING_TMP_PATH_VARIABLE = "SPRING_TMP_PATH";
    public static final String SPRING_SERVER_COMMAND_ENV = "SPRING_SERVER_COMMAND";
    public static final String SPRING_SERVER_COMMAND = "spring server";
    private static final Logger k;
    @NonNls
    private static final String e = "spring";
    @NonNls
    private static final String c = "DISABLE_SPRING";
    private static final int g = 0;
    private static final int b = 1;
    private static final int j = 2;
    private static final long m;

    public Element getState() {
        long l2 = m ^ 0x317F6D3D5387L;
        Element element = new Element("state");
        element.setAttribute(SPRING_PRE_LOADER_OPTION_FIELD, Boolean.toString(this.SPRING_PRE_LOADER_OPTION));
        element.setAttribute(RAKE_SPRING_PRE_LOADER_OPTION_FIELD, Boolean.toString(this.RAKE_SPRING_PRE_LOADER_OPTION));
        element.setAttribute(RAILS_SPRING_PRE_LOADER_OPTION_FIELD, Boolean.toString(this.RAILS_SPRING_PRE_LOADER_OPTION));
        return element;
    }

    public void loadState(@NotNull Element state2) {
        long l2 = m ^ 0x1DC4ABAAAB8AL;
        if (state2 == null) {
            SpringUtil.a(0);
        }
        this.SPRING_PRE_LOADER_OPTION = Boolean.parseBoolean(state2.getAttributeValue(SPRING_PRE_LOADER_OPTION_FIELD));
        this.RAKE_SPRING_PRE_LOADER_OPTION = Boolean.parseBoolean(state2.getAttributeValue(RAKE_SPRING_PRE_LOADER_OPTION_FIELD));
        this.RAILS_SPRING_PRE_LOADER_OPTION = Boolean.parseBoolean(state2.getAttributeValue(RAILS_SPRING_PRE_LOADER_OPTION_FIELD));
    }

    public static SpringUtil getInstance(Project project) {
        return (SpringUtil)ServiceManager.getService((Project)project, SpringUtil.class);
    }

    public static boolean isSpringAvailable(@Nullable Module module2) {
        if (module2 == null || !SpringUtil.getInstance((Project)module2.getProject()).SPRING_PRE_LOADER_OPTION) {
            return false;
        }
        return SpringUtil.a(module2);
    }

    private static boolean a(@Nullable Module module2) {
        long l2 = m ^ 0xA68CD7BC563L;
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        return module2 != null && SpringUtil.a(sdk) && GemSearchUtil.findGem(module2, "spring") != null;
    }

    private static boolean a(@Nullable Sdk sdk) {
        return sdk != null && RubySdkUtil.isMRISdk(sdk) && !RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor().isWindows() && !ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public static void disableSpring(@NotNull Map<String, String> env, @Nullable Module module2) {
        if (env == null) {
            SpringUtil.a(1);
        }
        SpringUtil.disableSpring(env);
    }

    public static void disableSpring(@NotNull Map<String, String> env) {
        long l2 = m ^ 0x5D89D01654CCL;
        if (env == null) {
            SpringUtil.a(2);
        }
        env.put(c, "true");
    }

    public static void customizeSpring(@Nullable Module module2, @NotNull Map<String, String> env) {
        long l2 = m ^ 0x439F415DCD2L;
        if (env == null) {
            SpringUtil.a(3);
        }
        if (module2 != null && !module2.getProject().isDisposed() && !SpringUtil.isSpringAvailable(module2)) {
            SpringUtil.disableSpring(env);
            return;
        }
        String string = module2 != null ? FileUtil.getTempDirectory() + File.separator + Integer.toHexString(module2.getProject().hashCode()) : FileUtil.getTempDirectory() + "/RMSpring";
        if (string.length() <= 104) {
            k.debug("Moving Spring to " + string);
            env.putIfAbsent(SPRING_TMP_PATH_VARIABLE, string);
        }
        k.debug("Setup 'spring server' mode");
        env.putIfAbsent(SPRING_SERVER_COMMAND_ENV, SPRING_SERVER_COMMAND);
    }

    public static boolean isSpringDebugPatchDenied() {
        long l2 = m ^ 0x6A08B038CD90L;
        return PropertiesComponent.getInstance().getBoolean(f);
    }

    public static void setSpringDebugPatchDenied(boolean enabled) {
        long l2 = m ^ 0x4A894ACDD555L;
        PropertiesComponent.getInstance().setValue(f, enabled);
    }

    @Nullable
    public static String getSpringExecutable(@Nullable Module module2, @Nullable Sdk sdk) {
        long l2 = m ^ 0xB301262D3BAL;
        if (module2 != null && !SpringUtil.getInstance((Project)module2.getProject()).SPRING_PRE_LOADER_OPTION) {
            return null;
        }
        return RubyGemExecutionContext.getScriptPath(sdk, module2, "spring", "spring");
    }

    public static boolean isTestFrameworkEnabled(@Nullable Module module2, @NotNull SupportedTestFramework framework) {
        if (framework == null) {
            SpringUtil.a(4);
        }
        if (module2 == null) {
            return false;
        }
        if (!SpringUtil.isSpringAvailable(module2)) {
            return false;
        }
        return GemSearchUtil.findGem(module2, SpringUtil.a(framework)) != null;
    }

    @NotNull
    private static String a(@NotNull SupportedTestFramework supportedTestFramework) {
        long l2 = m ^ 0x6CD0AF9E0AE0L;
        if (supportedTestFramework == null) {
            SpringUtil.a(5);
        }
        switch (supportedTestFramework) {
            case TEST_UNIT: 
            case SHOULDA: {
                if ("spring-commands-testunit" == null) {
                    SpringUtil.a(6);
                }
                return "spring-commands-testunit";
            }
            case RSPEC: {
                if ("spring-commands-rspec" == null) {
                    SpringUtil.a(7);
                }
                return "spring-commands-rspec";
            }
            case CUCUMBER: {
                if ("spring-commands-cucumber" == null) {
                    SpringUtil.a(8);
                }
                return "spring-commands-cucumber";
            }
        }
        throw new IllegalArgumentException("Unexpected test framework " + (Object)((Object)supportedTestFramework));
    }

    public static void stopSpring(@NotNull Module module2, boolean isModal) {
        Sdk sdk;
        long l2 = m ^ 0x75EEEDE6596BL;
        if (module2 == null) {
            SpringUtil.a(9);
        }
        if ((sdk = RModuleUtil.getInstance().findRubySdkForModule(module2)) == null || !SpringUtil.a(sdk)) {
            return;
        }
        VirtualFile virtualFile = RailsFacetUtil.getRailsAppHomeDir(module2);
        if (virtualFile != null) {
            final Runnable runnable = () -> {
                long l2 = m ^ 0x7A1BF6136EACL;
                try {
                    ((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, "spring").withModule(module2)).withGemScriptName("spring").withWorkingDir(virtualFile)).withExecutionMode((ExecutionMode)new ExecutionModes.BackGroundMode(RBundle.message("rails.spring.stop.title")))).withArguments("stop")).executeScript();
                }
                catch (ExecutionException executionException) {
                    k.warn("Cannot stop spring; " + executionException.getMessage());
                }
            };
            if (isModal) {
                ProgressManager.getInstance().run((Task)new Task.Modal(module2.getProject(), RBundle.message("rails.spring.stop.title"), true){
                    private static final long a = com.jetbrains.python.psi.c.a(-115995708212637193L, -8185772052333281338L, MethodHandles.lookup().lookupClass()).a(274928296120691L);

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.a(0);
                        }
                        runnable.run();
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x392A8E0712F2L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/preload/spring/SpringUtil$1", "run"));
                    }
                });
            } else {
                BackgroundTaskUtil.executeOnPooledThread((Disposable)module2, (Runnable)runnable);
            }
        }
    }

    private static void a(@NotNull VirtualFile virtualFile, @NotNull String string, boolean bl2) throws IOException {
        long l2 = m ^ 0xC468DA9A25EL;
        if (virtualFile == null) {
            SpringUtil.a(10);
        }
        if (string == null) {
            SpringUtil.a(11);
        }
        if (!virtualFile.isWritable()) {
            Notifications.Bus.notify((Notification)new Notification("spring.debug", RBundle.message("spring.debug.config.modification.write.access.title"), RBundle.message("spring.debug.config.modification.write.access"), NotificationType.ERROR));
            k.warn(virtualFile.getCanonicalPath() + " directory is not writable");
            return;
        }
        VirtualFile virtualFile2 = (VirtualFile)WriteAction.compute(() -> virtualFile.findOrCreateChildData(null, string));
        String string2 = VfsUtilCore.loadText((VirtualFile)virtualFile2);
        string2 = StringUtil.replace((String)string2, (String)a, (String)"");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        if (bl2) {
            if (!string2.isEmpty() && !string2.endsWith("\n")) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(d);
        }
        WriteAction.run(() -> VfsUtil.saveText((VirtualFile)virtualFile2, (String)stringBuilder.toString()));
        Notifications.Bus.notify((Notification)new Notification("spring.debug", RBundle.message("spring.debug.config.modification.title"), RBundle.message("spring.debug.config.modification", virtualFile2.getPath()), NotificationType.INFORMATION));
    }

    private static boolean a(@NotNull VirtualFile virtualFile, @NotNull String string) throws IOException {
        if (virtualFile == null) {
            SpringUtil.a(12);
        }
        if (string == null) {
            SpringUtil.a(13);
        }
        return StringUtil.contains((CharSequence)VfsUtilCore.loadText((VirtualFile)virtualFile), (CharSequence)string);
    }

    private static boolean a(@NotNull VirtualFile virtualFile, @NotNull String string, @NotNull String string2) {
        VirtualFile virtualFile2;
        long l2 = m ^ 0x14A4C5F29F1BL;
        if (virtualFile == null) {
            SpringUtil.a(14);
        }
        if (string == null) {
            SpringUtil.a(15);
        }
        if (string2 == null) {
            SpringUtil.a(16);
        }
        if ((virtualFile2 = virtualFile.findChild(string)) == null) {
            return false;
        }
        try {
            return SpringUtil.a(virtualFile2, string2);
        }
        catch (IOException iOException) {
            k.warn("unable to load spring config file context", (Throwable)iOException);
            return false;
        }
    }

    private static boolean a(@NotNull String string) {
        VirtualFile virtualFile;
        long l2 = m ^ 0x798FE6DCAB40L;
        if (string == null) {
            SpringUtil.a(17);
        }
        if ((virtualFile = VfsUtil.getUserHomeDir()) == null) {
            return false;
        }
        return SpringUtil.a(virtualFile, h, string);
    }

    private static boolean a(@NotNull Module module2, @NotNull String string) {
        RailsApp railsApp;
        long l2 = m ^ 0x6DA4F7140F2FL;
        if (module2 == null) {
            SpringUtil.a(18);
        }
        if (string == null) {
            SpringUtil.a(19);
        }
        if ((railsApp = RailsApp.fromModule(module2)) == null) {
            return false;
        }
        VirtualFile virtualFile = railsApp.getConfigRoot();
        if (virtualFile == null) {
            return false;
        }
        return SpringUtil.a(virtualFile, l, string);
    }

    private static void a(boolean bl2) throws IOException {
        long l2 = m ^ 0x394032140F25L;
        VirtualFile virtualFile = VfsUtil.getUserHomeDir();
        if (virtualFile != null) {
            SpringUtil.a(virtualFile, h, bl2);
        } else {
            k.warn("unable to find user home directory");
        }
    }

    private static void a(@NotNull Module module2, boolean bl2) throws IOException {
        RailsApp railsApp;
        long l2 = m ^ 0x312A45165409L;
        if (module2 == null) {
            SpringUtil.a(20);
        }
        if ((railsApp = RailsApp.fromModule(module2)) != null) {
            VirtualFile virtualFile = railsApp.getConfigRoot();
            if (virtualFile != null) {
                SpringUtil.a(virtualFile, l, bl2);
            } else {
                k.warn("unable to find config directory for project: " + railsApp.getProjectName());
            }
        } else {
            k.warn("unable to find rails application for module: " + module2.getName());
        }
    }

    public static void configureSpringForDebug(@NotNull Map<String, String> env, @Nullable Module module2) {
        long l2 = m ^ 0x10252EF40EA1L;
        if (env == null) {
            SpringUtil.a(21);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (module2 == null || module2.isDisposed() || !SpringUtil.a(module2)) {
            return;
        }
        Project project = module2.getProject();
        if (SpringUtil.isSpringDebugPatchDenied()) {
            SpringUtil.disableSpring(env);
            return;
        }
        boolean bl2 = SpringUtil.a(module2, a);
        boolean bl3 = SpringUtil.a(a);
        if (bl2 || bl3) {
            int n2 = Messages.showYesNoDialog((Project)module2.getProject(), (String)RBundle.message("spring.debug.config.deprecated.patch"), (String)RBundle.message("spring.debug.config.deprecated.patch.title"), (Icon)Messages.getQuestionIcon());
            if (n2 == 0) {
                try {
                    if (bl2) {
                        SpringUtil.a(module2, true);
                        SpringUtil.a(false);
                    }
                    if (bl3) {
                        SpringUtil.a(true);
                        SpringUtil.a(module2, false);
                    }
                }
                catch (IOException iOException) {
                    k.warn("unable to update deprecated patch in spring config file", (Throwable)iOException);
                }
            }
            return;
        }
        if (SpringUtil.a(d) || SpringUtil.a(module2, d)) {
            return;
        }
        SpringDebugConfigDialog springDebugConfigDialog = new SpringDebugConfigDialog(project, RBundle.message("spring.debug.config.modification.request"), RBundle.message("spring.debug.config.modification.request.title"), new String[]{RBundle.message("spring.debug.config.modification.system"), RBundle.message("spring.debug.config.modification.project"), RBundle.message("spring.debug.config.modification.disable")}, 0, 0, Messages.getQuestionIcon());
        springDebugConfigDialog.show();
        int n3 = springDebugConfigDialog.getExitCode();
        try {
            if (n3 == 0) {
                SpringUtil.a(true);
            }
            if (n3 == 1) {
                SpringUtil.a(module2, true);
            }
        }
        catch (IOException iOException) {
            k.warn("unable to append to spring config file", (Throwable)iOException);
        }
        if (n3 == 2) {
            SpringUtil.setSpringDebugPatchDenied(true);
            SpringUtil.disableSpring(env);
        }
    }

    static {
        m = com.jetbrains.python.psi.c.a(8249191792568398183L, -4456174348427850658L, MethodHandles.lookup().lookupClass()).a(145970548535415L);
        k = Logger.getInstance(SpringUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = m ^ 0x1CDD54034625L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/preload/spring/SpringUtil";
                break;
            }
            case 9: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFileParentDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFileName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/preload/spring/SpringUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestCommandSupportGemName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "disableSpring";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSpring";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTestFrameworkEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTestCommandSupportGemName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stopSpring";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateConfig";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkFilePatchedForDebug";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkSpringConfigInDir";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSystemSpringConfigDebugPatched";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isProjectSpringConfigDebugPatched";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "patchProjectConfigForDebug";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "configureSpringForDebug";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

