/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.rails.refactoring.rename.RenameByRailsActionProcessor;
import org.jetbrains.plugins.ruby.rails.rspec.model.RailsRSpecViewTest;
import org.jetbrains.plugins.ruby.ruby.lang.rename.RenameProcessor;

public class RenameByRailsViewFileProcessor
extends RenameProcessor {
    private static final long a = c.a(6140497256479509004L, -8347916821033918287L, MethodHandles.lookup().lookupClass()).a(174533801984198L);

    @Override
    public boolean canProcessElement(PsiElement element) {
        return element instanceof PsiFile && RailsView.fromFile((PsiFile)element) != null;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newFileName, Map<PsiElement, String> allRenames) {
        super.prepareRenaming(element, newFileName, allRenames);
        RailsView railsView = RailsView.fromFile((PsiFile)element);
        assert (railsView != null);
        RenameByRailsViewFileProcessor.addElementsToRenameByView(railsView, newFileName, allRenames);
    }

    public static void addElementsToRenameByView(@NotNull RailsView railsView, @NotNull String newViewFileName, @NotNull Map<PsiElement, String> allRenames) {
        if (railsView == null) {
            RenameByRailsViewFileProcessor.a(0);
        }
        if (newViewFileName == null) {
            RenameByRailsViewFileProcessor.a(1);
        }
        if (allRenames == null) {
            RenameByRailsViewFileProcessor.a(2);
        }
        PsiFile psiFile = railsView.getPsiFile();
        if (!railsView.isPartial() && ViewsConventions.isPartialViewName(newViewFileName)) {
            return;
        }
        RailsAction railsAction = railsView.getAction();
        if (railsAction != null) {
            String string = ViewsConventions.getViewOrLayoutNameByFileName(FileUtilRt.getNameWithoutExtension((String)newViewFileName));
            if (!StringUtil.isEmpty((String)string) && railsAction.getController().getRClass().findMethodByName(string) == null) {
                allRenames.put((PsiElement)railsAction.getMethod(), string);
            }
            List<RailsView> list2 = railsAction.getViews();
            for (RailsView railsView2 : list2) {
                RailsRSpecViewTest railsRSpecViewTest;
                PsiFile psiFile2 = railsView2.getPsiFile();
                if (psiFile2 == null) continue;
                VirtualFile virtualFile = railsView2.getFile().getParent();
                String string2 = RenameByRailsActionProcessor.getNewViewNameBy(string, railsAction.getName(), psiFile2);
                if (!psiFile2.equals(psiFile)) {
                    RenameByRailsViewFileProcessor.a(virtualFile, string2, psiFile2, allRenames);
                    allRenames.put((PsiElement)psiFile2, string2);
                }
                if ((railsRSpecViewTest = railsView2.getSpecTest()) == null) continue;
                RenameByRailsViewFileProcessor.a(railsAction.getApp().getSpecTestsViewsRoot(), RailsRSpecViewTest.getFileNameBy(psiFile2.equals(psiFile) ? newViewFileName : string2), railsRSpecViewTest.getPsiFile(), allRenames);
            }
        }
    }

    private static void a(@NotNull VirtualFile virtualFile, @NotNull String string, @Nullable PsiFile psiFile, Map<PsiElement, String> map2) {
        if (virtualFile == null) {
            RenameByRailsViewFileProcessor.a(3);
        }
        if (string == null) {
            RenameByRailsViewFileProcessor.a(4);
        }
        if (psiFile != null && virtualFile.findChild(string) == null) {
            map2.put((PsiElement)psiFile, string);
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x48635D648060L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newViewFileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/refactoring/rename/RenameByRailsViewFileProcessor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addElementsToRenameByView";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addIfFileDoesntExist";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

