/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.DocumentationMethod;
import org.jetbrains.plugins.ruby.rdoc.lexer.RDocLexer;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDParser;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.MethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDAttributeDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDMethodDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.base.YARDSubMethodDirective;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class YARDUtil {
    private static final long a = c.a(-2886864381372062358L, -5270734373407208323L, MethodHandles.lookup().lookupClass()).a(52472682968140L);

    @Nullable
    public static RPsiElement getContainerByYARDComment(PsiElement element) {
        ASTNode aSTNode = element.getNode();
        if (aSTNode == null) {
            return null;
        }
        if (aSTNode.getElementType() != RubyTokenTypes.TLINE_COMMENT) {
            return null;
        }
        RPsiElement rPsiElement = (RPsiElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)element, RPsiElement.class);
        if (rPsiElement instanceof RCompoundStatement || rPsiElement instanceof RBodyStatement) {
            List<RPsiElement> list2;
            List<RPsiElement> list3 = list2 = rPsiElement instanceof RCompoundStatement ? ((RCompoundStatement)rPsiElement).getStatements() : ((RBodyStatement)rPsiElement).getCompoundStatement().getStatements();
            if (!list2.isEmpty()) {
                rPsiElement = list2.get(0);
            }
        }
        if (rPsiElement instanceof RMethod || rPsiElement instanceof RAssignmentExpression || rPsiElement instanceof RBlockArgumentList || rPsiElement instanceof RCall) {
            return rPsiElement;
        }
        return null;
    }

    @Nullable
    public static YARDTag getDocContainerByYARDComment(PsiElement element) {
        long l2 = a ^ 0x475669D6B2B7L;
        ASTNode aSTNode = element.getNode();
        if (aSTNode == null) {
            return null;
        }
        if (aSTNode.getElementType() != RubyTokenTypes.TLINE_COMMENT) {
            return null;
        }
        while (!(aSTNode instanceof RPsiElement)) {
            ASTNode aSTNode2 = aSTNode.getTreePrev();
            if (aSTNode2 == null) {
                return null;
            }
            if (aSTNode2.getElementType() == RubyTokenTypes.TLINE_COMMENT && aSTNode2.getText().contains("@!")) {
                PsiComment psiComment = (PsiComment)aSTNode2.getPsi();
                List<YARDTag> list2 = YARDParser.parse(Collections.singletonList(psiComment));
                for (YARDTag yARDTag : list2) {
                    if (!(yARDTag instanceof YARDMethodDirective) && !(yARDTag instanceof YARDAttributeDirective)) continue;
                    return yARDTag;
                }
                return null;
            }
            aSTNode = aSTNode2;
        }
        return null;
    }

    @Nullable
    public static YARDSubMethodDirective recreateTagByFakeMethodName(@NotNull MethodNameFakePsiElement element) {
        DocumentationMethod documentationMethod;
        if (element == null) {
            YARDUtil.a(0);
        }
        if ((documentationMethod = element.getDocumentationMethod()) != null && documentationMethod.getPsiElement() != null) {
            YARDTag yARDTag = YARDUtil.recreateTagByFakeElement((RangeInDocumentFakePsiElement)documentationMethod.getPsiElement());
            return (YARDSubMethodDirective)ObjectUtils.tryCast((Object)yARDTag, YARDSubMethodDirective.class);
        }
        return null;
    }

    @Nullable
    public static YARDTag recreateTagByFakeElement(@NotNull RangeInDocumentFakePsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            YARDUtil.a(1);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            return null;
        }
        PsiElement psiElement = psiFile.findElementAt(element.getTextRange().getStartOffset());
        if (!(psiElement instanceof PsiComment)) {
            return null;
        }
        int n2 = element.getTextRange().getEndOffset();
        ArrayList<PsiComment> arrayList = new ArrayList<PsiComment>();
        while (psiElement != null && psiElement.getTextRange().getEndOffset() <= n2) {
            if (psiElement instanceof PsiComment) {
                arrayList.add((PsiComment)psiElement);
            }
            psiElement = psiElement.getNextSibling();
        }
        List<YARDTag> list2 = YARDParser.parse(arrayList);
        if (list2.size() != 1) {
            return null;
        }
        return list2.iterator().next();
    }

    public static int findTokenIndexBeforeCaret(List<? extends Pair<IElementType, TextRange>> lexerInfo, int offset) {
        for (int i10 = 0; i10 < lexerInfo.size(); ++i10) {
            Pair<IElementType, TextRange> pair = lexerInfo.get(i10);
            if (((TextRange)pair.getSecond()).getEndOffset() < offset) continue;
            return i10;
        }
        return lexerInfo.size() - 1;
    }

    public static List<Pair<IElementType, TextRange>> getLexerInfo(String text2) {
        IElementType iElementType;
        RDocLexer rDocLexer = new RDocLexer(false, false);
        rDocLexer.start(text2);
        ArrayList<Pair<IElementType, TextRange>> arrayList = new ArrayList<Pair<IElementType, TextRange>>();
        while ((iElementType = rDocLexer.getTokenType()) != null) {
            arrayList.add((Pair<IElementType, TextRange>)Pair.create((Object)iElementType, (Object)new TextRange(rDocLexer.getTokenStart(), rDocLexer.getTokenEnd())));
            rDocLexer.advance();
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiComment> getCommentsWithoutYARD(@NotNull List<PsiComment> comments, @NotNull List<YARDTag> yardTags) {
        if (comments == null) {
            YARDUtil.a(2);
        }
        if (yardTags == null) {
            YARDUtil.a(3);
        }
        LinkedHashSet<PsiComment> linkedHashSet = new LinkedHashSet<PsiComment>(comments);
        for (YARDTag yARDTag : yardTags) {
            PsiElement psiElement;
            PsiElement psiElement2 = yARDTag.getPsiElement();
            if (!(psiElement2 instanceof RangeInDocumentFakePsiElement)) continue;
            PsiElement psiElement3 = psiElement2.getParent();
            if (psiElement3 instanceof PsiComment) {
                linkedHashSet.remove(psiElement3);
                continue;
            }
            PsiElement psiElement4 = psiElement3.findElementAt(psiElement2.getStartOffsetInParent() + psiElement2.getTextLength());
            if (psiElement == null) continue;
            for (psiElement = psiElement3.findElementAt(psiElement2.getStartOffsetInParent()); psiElement != psiElement4; psiElement = psiElement.getNextSibling()) {
                linkedHashSet.remove(psiElement);
            }
            linkedHashSet.remove(psiElement4);
        }
        ArrayList<PsiComment> arrayList = new ArrayList<PsiComment>(linkedHashSet);
        if (arrayList == null) {
            YARDUtil.a(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x99109F0519AL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yardTags";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/YARDUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/YARDUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentsWithoutYARD";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recreateTagByFakeMethodName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "recreateTagByFakeElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsWithoutYARD";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

