/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.OutboundSemiGraph;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.ResolveAncestor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AnonymousClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;

public class HierarchyPresentationUtil {
    private static final long a = c.a(5373363882799735163L, 8924019184484529080L, MethodHandles.lookup().lookupClass()).a(139976155690055L);

    public static OutboundSemiGraph<Symbol> getHierarchyGraph(@NotNull Symbol symbol2, @Nullable PsiElement invocationPoint) {
        if (symbol2 == null) {
            HierarchyPresentationUtil.a(0);
        }
        final List list2 = SymbolScopeUtil.getAncestorsCaching(symbol2, invocationPoint).stream().map(ResolveAncestor::getSymbol).collect(Collectors.toList());
        ContainerUtil.removeDuplicates(list2);
        final Map map2 = StreamEx.of(list2).toMap(symbol -> SymbolScopeUtil.getAncestorsCaching(symbol, invocationPoint).stream().map(ResolveAncestor::getSymbol).collect(Collectors.toSet()));
        OutboundSemiGraph<Symbol> outboundSemiGraph = new OutboundSemiGraph<Symbol>(){
            private static final long a = c.a(5378194800119225180L, 806558407260363117L, MethodHandles.lookup().lookupClass()).a(5765900865997L);

            @NotNull
            public Collection<Symbol> getNodes() {
                List list22 = list2;
                if (list22 == null) {
                    1.a(0);
                }
                return list22;
            }

            @NotNull
            public Iterator<Symbol> getOut(Symbol n2) {
                Iterator<Symbol> iterator = ((Set)map2.get(n2)).iterator();
                if (iterator == null) {
                    1.a(1);
                }
                return iterator;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x6F35972326CDL;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/util/HierarchyPresentationUtil$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOut";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        DFSTBuilder dFSTBuilder = new DFSTBuilder((OutboundSemiGraph)outboundSemiGraph);
        for (Symbol symbol3 : ContainerUtil.reverse((List)dFSTBuilder.getSortedNodes())) {
            ((Set)map2.get(symbol3)).remove(symbol3);
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
            for (Symbol symbol4 : (Set)map2.get(symbol3)) {
                Set set = (Set)map2.get(symbol4);
                if (set != null) {
                    arrayList.addAll(set);
                    continue;
                }
                arrayList.add(symbol4);
            }
            ((Set)map2.get(symbol3)).removeAll(arrayList);
        }
        return outboundSemiGraph;
    }

    @NotNull
    public static String toDot(@NotNull OutboundSemiGraph<Pair<Symbol, Context>> graph) {
        long l2 = a ^ 0x56FFC5E3A830L;
        if (graph == null) {
            HierarchyPresentationUtil.a(1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        ObjectIntHashMap objectIntHashMap = new ObjectIntHashMap();
        AtomicInteger atomicInteger = new AtomicInteger();
        graph.getNodes().forEach(pair -> objectIntHashMap.put(pair, atomicInteger.getAndIncrement()));
        stringBuilder.append("digraph {");
        for (Pair pair2 : graph.getNodes()) {
            stringBuilder.append("V").append(n2).append("[label=\"").append(HierarchyPresentationUtil.symbolToString((Symbol)pair2.first)).append(" ").append(((Context)pair2.second).getAccess().getMask()).append("\"]").append(System.lineSeparator());
            int n3 = n2++;
            graph.getOut((Object)pair2).forEachRemaining(pair -> {
                long l2 = a ^ 0x465455FE0B1L;
                stringBuilder.append("V").append(n3).append(" -> ").append("V").append(objectIntHashMap.get(pair)).append(System.lineSeparator());
            });
        }
        stringBuilder.append("}");
        String string = stringBuilder.toString();
        if (string == null) {
            HierarchyPresentationUtil.a(2);
        }
        return string;
    }

    public static String symbolToString(Symbol symbol) {
        long l2 = a ^ 0x7BD0A6776523L;
        if (symbol instanceof SingletonClassSymbol) {
            return "S[" + symbol.getParentSymbol().getName() + "]";
        }
        if (symbol instanceof AnonymousClassModuleSymbol) {
            return "A[" + symbol.getParentSymbol().getName() + "]";
        }
        if (Objects.equals(symbol.getName(), "ClassMethods")) {
            return "CM[" + symbol.getParentSymbol().getName() + "]";
        }
        return symbol.getName();
    }

    public static void toSvgFile(@NotNull String outSvgFile, @NotNull OutboundSemiGraph<Pair<Symbol, Context>> graph) {
        long l2 = a ^ 0xEC1A5535401L;
        if (outSvgFile == null) {
            HierarchyPresentationUtil.a(3);
        }
        if (graph == null) {
            HierarchyPresentationUtil.a(4);
        }
        try {
            String string = SystemInfo.isUnix ? "dot" : "dot.exe";
            File file = PathEnvironmentVariableUtil.findInPath((String)string);
            if (file == null) {
                throw new FileNotFoundException("Cannot find dot utility in path");
            }
            File file2 = FileUtil.createTempFile((String)"inheritance", (String)".dot", (boolean)true);
            FileUtil.writeToFile((File)file2, (String)HierarchyPresentationUtil.toDot(graph));
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{file.getAbsolutePath()}).withInput(file2.getAbsoluteFile()).withParameters(new String[]{"-Tsvg", "-o" + outSvgFile, file2.getAbsolutePath()}).withRedirectErrorStream(true);
            ExecUtil.execAndGetOutput((GeneralCommandLine)generalCommandLine);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x48C34477AF8AL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/util/HierarchyPresentationUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outSvgFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/util/HierarchyPresentationUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toDot";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchyGraph";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toDot";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toSvgFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

