/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger;

import com.google.common.collect.Sets;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.RControlFlowBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public class RubyDebuggerSupportUtils {
    private static final long a = c.a(5224753339077553290L, -2650216118622383356L, MethodHandles.lookup().lookupClass()).a(120804406949461L);

    private RubyDebuggerSupportUtils() {
    }

    @NotNull
    public static String getRubyValuePresentationString(@NotNull RubyValue value) {
        String string;
        if (value == null) {
            RubyDebuggerSupportUtils.a(0);
        }
        if ((string = value.getValueString()).length() > 1000) {
            String string2 = string.substring(0, 1000);
            if (string2 == null) {
                RubyDebuggerSupportUtils.a(1);
            }
            return string2;
        }
        String string3 = string;
        if (string3 == null) {
            RubyDebuggerSupportUtils.a(2);
        }
        return string3;
    }

    public static void setFullValueEvaluatorIfNeeded(@NotNull RubyValue value, @NotNull XValueNode node) {
        String string;
        if (value == null) {
            RubyDebuggerSupportUtils.a(3);
        }
        if (node == null) {
            RubyDebuggerSupportUtils.a(4);
        }
        if ((string = value.getValueString()).length() > 1000) {
            node.setFullValueEvaluator((XFullValueEvaluator)new ImmediateFullValueEvaluator(string));
        }
    }

    public static Document createDocument(@NotNull String text2, @NotNull Project project, @Nullable VirtualFile contextVirtualFile, int contextOffset) {
        if (text2 == null) {
            RubyDebuggerSupportUtils.a(5);
        }
        if (project == null) {
            RubyDebuggerSupportUtils.a(6);
        }
        RPsiElement rPsiElement = null;
        if (contextVirtualFile != null) {
            rPsiElement = RubyDebuggerSupportUtils.getContextElement(contextVirtualFile, contextOffset, project);
        }
        RubyExpressionCodeFragment rubyExpressionCodeFragment = RubyElementFactory.createExpressionCodeFragment(project, text2, (PsiElement)rPsiElement, true);
        return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)rubyExpressionCodeFragment);
    }

    @Nullable
    public static RPsiElement getContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project) {
        if (virtualFile == null) {
            RubyDebuggerSupportUtils.a(7);
        }
        if (project == null) {
            RubyDebuggerSupportUtils.a(8);
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        FileViewProvider fileViewProvider = PsiManager.getInstance((Project)project).findViewProvider(virtualFile);
        if (fileViewProvider == null) {
            return null;
        }
        PsiFile psiFile = fileViewProvider.getPsi((Language)RubyLanguage.INSTANCE);
        if (psiFile == null) {
            return null;
        }
        if (offset >= 0 && offset < document.getTextLength()) {
            int n2 = document.getLineEndOffset(document.getLineNumber(offset));
            do {
                PsiElement psiElement;
                if ((psiElement = psiFile.findElementAt(offset)) != null) {
                    if (!(psiElement instanceof PsiWhiteSpace) && !(psiElement instanceof PsiComment) && psiElement.getNode().getElementType() instanceof RubyElementType) {
                        return RControlFlowBuilder.getControlFlowNodeElement(psiElement);
                    }
                } else {
                    return null;
                }
                offset = psiElement.getTextRange().getEndOffset() + 1;
            } while (offset < n2);
        }
        return null;
    }

    @Nullable
    public static TextRange getExpressionAtOffset(@NotNull Project project, @NotNull Document document, int offset) {
        RIdentifier rIdentifier;
        PsiFile psiFile;
        if (project == null) {
            RubyDebuggerSupportUtils.a(9);
        }
        if (document == null) {
            RubyDebuggerSupportUtils.a(10);
        }
        if ((psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null) {
            return null;
        }
        RExpression rExpression = RubyPsiUtil.getCoveringExpression(psiFile.findElementAt(offset));
        if (rExpression == null) {
            return null;
        }
        if (rExpression instanceof RIdentifier && ((rIdentifier = (RIdentifier)rExpression).isParameterDeclaration() || rIdentifier.isLocalVariable())) {
            return rIdentifier.getTextRange();
        }
        if (rExpression instanceof RField || rExpression instanceof RGlobalVariable) {
            return rExpression.getTextRange();
        }
        if (TextUtil.isCIDOrColonQualifiedReference(rExpression.getText())) {
            return rExpression.getTextRange();
        }
        return null;
    }

    public static void addRubyVariablesToNode(Project project, XSourcePosition position, @NotNull XCompositeNode node, @NotNull RubyVariable[] variables, @NotNull RubyStackFrame frame, boolean canEvaluate) {
        if (node == null) {
            RubyDebuggerSupportUtils.a(11);
        }
        if (variables == null) {
            RubyDebuggerSupportUtils.a(12);
        }
        if (frame == null) {
            RubyDebuggerSupportUtils.a(13);
        }
        RubyDebuggerSupportUtils.addRubyVariablesToNode(project, position, node, variables, frame, canEvaluate, false);
    }

    public static void addRubyVariablesToNode(Project project, XSourcePosition position, @NotNull XCompositeNode node, @NotNull RubyVariable[] variables, @NotNull RubyStackFrame frame, boolean canEvaluate, boolean alreadySorted) {
        if (node == null) {
            RubyDebuggerSupportUtils.a(14);
        }
        if (variables == null) {
            RubyDebuggerSupportUtils.a(15);
        }
        if (frame == null) {
            RubyDebuggerSupportUtils.a(16);
        }
        RubyDebuggerSupportUtils.addRubyVariablesToNode(project, position, node, variables, frame, canEvaluate, alreadySorted, true);
    }

    public static void addRubyVariablesToNode(Project project, XSourcePosition position, @NotNull XCompositeNode node, @NotNull RubyVariable[] variables, @NotNull RubyStackFrame frame, boolean canEvaluate, boolean alreadySorted, boolean isLastChildren) {
        if (node == null) {
            RubyDebuggerSupportUtils.a(17);
        }
        if (variables == null) {
            RubyDebuggerSupportUtils.a(18);
        }
        if (frame == null) {
            RubyDebuggerSupportUtils.a(19);
        }
        if (node.isObsolete()) {
            return;
        }
        XValueChildrenList xValueChildrenList = new XValueChildrenList();
        node.setAlreadySorted(alreadySorted);
        for (RubyVariable rubyVariable : variables) {
            String string = RubyDebuggerSupportUtils.convertToIdeEncoding(rubyVariable.getName());
            if (StringUtil.isEmptyOrSpaces((String)string)) continue;
            xValueChildrenList.add(string, RubyDebugValueFactory.create(project, position, frame, string, rubyVariable, canEvaluate));
        }
        node.addChildren(xValueChildrenList, isLastChildren);
    }

    public static void collectFieldsMentionedInContext(@NotNull RContainer scope, final @NotNull List<? super String> collector) {
        if (scope == null) {
            RubyDebuggerSupportUtils.a(20);
        }
        if (collector == null) {
            RubyDebuggerSupportUtils.a(21);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final HashSet hashSet = Sets.newHashSet();
        scope.acceptChildren(new RubyDebuggerScopeVisitor(scope){

            @Override
            public void visitRClassVariable(RClassVariable rClassVariable) {
                String string = rClassVariable.getText();
                if (hashSet.add(string)) {
                    collector.add(string);
                }
            }

            @Override
            public void visitRInstanceVariable(RInstanceVariable rInstanceVariable) {
                String string = rInstanceVariable.getText();
                if (hashSet.add(string)) {
                    collector.add(string);
                }
            }
        });
    }

    public static Set<String> addGlobalsMentionedInContext(@NotNull RContainer scope, final @NotNull List<? super String> collector) {
        if (scope == null) {
            RubyDebuggerSupportUtils.a(22);
        }
        if (collector == null) {
            RubyDebuggerSupportUtils.a(23);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final HashSet hashSet = Sets.newHashSet();
        scope.acceptChildren(new RubyRecursiveElementVisitor(){

            @Override
            public void visitRGlobalVariable(RGlobalVariable rGlobalVariable) {
                String string = rGlobalVariable.getText();
                if (hashSet.add(string)) {
                    collector.add(string);
                }
            }
        });
        return hashSet;
    }

    public static void collectContextInfoFromProviders(@NotNull RContainer scope, XSourcePosition xSourcePosition, @NotNull List<? super String> collector) {
        if (scope == null) {
            RubyDebuggerSupportUtils.a(24);
        }
        if (collector == null) {
            RubyDebuggerSupportUtils.a(25);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashSet hashSet = Sets.newHashSet();
        for (ContextInfoProvider contextInfoProvider : (ContextInfoProvider[])ContextInfoProvider.EP_NAME.getExtensions()) {
            List<String> list2 = contextInfoProvider.getEvaluateExpression(scope, xSourcePosition);
            for (String string : list2) {
                if (!hashSet.add(string)) continue;
                collector.add(string);
            }
        }
    }

    public static void collectConstantsMentionedInContext(@NotNull RContainer scope, final @NotNull List<? super String> collector) {
        if (scope == null) {
            RubyDebuggerSupportUtils.a(26);
        }
        if (collector == null) {
            RubyDebuggerSupportUtils.a(27);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final HashSet hashSet = Sets.newHashSet();
        scope.acceptChildren(new RubyDebuggerScopeVisitor(scope){

            @Override
            public void visitRReference(RReference reference) {
                String string = this.a(reference);
                if (string != null) {
                    if (hashSet.add(string)) {
                        collector.add(string);
                    }
                    return;
                }
                RPsiElement rPsiElement = reference.getReceiver();
                if (rPsiElement != null) {
                    rPsiElement.accept(this);
                }
            }

            @Override
            public void visitRConstant(RConstant rConstant) {
                String string = rConstant.getText();
                if (hashSet.add(string)) {
                    collector.add(string);
                }
            }

            @Nullable
            private String a(RReference rReference) {
                FQN fQN = RNameUtilCore.getPath((PsiElement)rReference);
                for (String string : fQN.asList()) {
                    if (TextUtil.isConstId(string)) continue;
                    return null;
                }
                return fQN.getFullPath();
            }
        });
    }

    public static String convertToIdeEncoding(String value) {
        return new String(value.getBytes(StandardCharsets.UTF_8), EncodingManager.getInstance().getDefaultCharset());
    }

    public static void invalidateSessionFrames(XDebugSession session) {
        XStackFrame xStackFrame;
        if (session != null && (xStackFrame = session.getCurrentStackFrame()) instanceof RubyStackFrame) {
            ((RubyStackFrame)xStackFrame).getRubyThread().invalidateFrames();
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x52AED7D19702L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebuggerSupportUtils";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebuggerSupportUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyValuePresentationString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRubyValuePresentationString";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFullValueEvaluatorIfNeeded";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContextElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAtOffset";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addRubyVariablesToNode";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldsMentionedInContext";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addGlobalsMentionedInContext";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectContextInfoFromProviders";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectConstantsMentionedInContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class RubyDebuggerScopeVisitor
    extends RubyRecursiveElementVisitor {
        private final RContainer a;

        RubyDebuggerScopeVisitor(RContainer scope) {
            this.a = scope;
        }

        @Override
        public void visitRClass(RClass rClass) {
            if (rClass != this.a) {
                return;
            }
            super.visitRClass(rClass);
        }

        @Override
        public void visitRModule(RModule rModule) {
            if (rModule != this.a) {
                return;
            }
            super.visitRModule(rModule);
        }
    }

    public static interface ContextInfoProvider {
        public static final ExtensionPointName<ContextInfoProvider> EP_NAME;

        @NotNull
        public List<String> getEvaluateExpression(RContainer var1, XSourcePosition var2);

        static {
            long l2 = c.a(-63517946547594466L, -6648129668286545206L, MethodHandles.lookup().lookupClass()).a(28225556192233L) ^ 0x30EB3EAC5E64L;
            EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.ruby.debug.infoProvider");
        }
    }
}

