/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference.MethodDescriptor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RLambdaCall;

public final class RubyBlockToMethodReferenceUtil {
    private static final long a = c.a(-6824551298385807418L, -1652062533159861623L, MethodHandles.lookup().lookupClass()).a(153143105919941L);

    private RubyBlockToMethodReferenceUtil() {
    }

    @Nullable
    public static MethodDescriptor getBlockMethodDescriptor(@NotNull RBlockCall blockCall) {
        RCodeBlock rCodeBlock;
        RPsiElement rPsiElement;
        if (blockCall == null) {
            RubyBlockToMethodReferenceUtil.a(0);
        }
        if ((rPsiElement = RubyBlockToMethodReferenceUtil.c(rCodeBlock = blockCall.getBlock())) == null) {
            return null;
        }
        List<String> list2 = RubyBlockToMethodReferenceUtil.b(rCodeBlock);
        if (list2 == null) {
            return null;
        }
        MethodDescriptor methodDescriptor = MethodDescriptor.fromElement((PsiElement)rPsiElement);
        if (methodDescriptor == null || !list2.equals(methodDescriptor.getArguments())) {
            return null;
        }
        return methodDescriptor;
    }

    public static void replaceBlock(@NotNull RBlockCall blockCall, @NotNull String reference) {
        RPossibleCall rPossibleCall;
        RPossibleCall rPossibleCall2;
        RListOfExpressions rListOfExpressions;
        if (blockCall == null) {
            RubyBlockToMethodReferenceUtil.a(1);
        }
        if (reference == null) {
            RubyBlockToMethodReferenceUtil.a(2);
        }
        if ((rListOfExpressions = RubyBlockToMethodReferenceUtil.a(rPossibleCall2 = blockCall.getCall())) != null) {
            rPossibleCall = (RPossibleCall)RubyElementFactory.createElementFromText((PsiElement)blockCall, rPossibleCall2.getText());
            RListOfExpressions rListOfExpressions2 = RubyBlockToMethodReferenceUtil.a(rPossibleCall);
            assert (rListOfExpressions2 != null);
            rListOfExpressions2.add((PsiElement)RubyElementFactory.createArgumentToBlockFromText((PsiElement)blockCall, reference));
        } else {
            rPossibleCall = (RPossibleCall)RubyElementFactory.createElementFromText((PsiElement)blockCall, rPossibleCall2.getText() + "(" + reference + ")");
        }
        blockCall.replace((PsiElement)rPossibleCall);
    }

    @Nullable
    private static RPsiElement c(@NotNull RCodeBlock rCodeBlock) {
        if (rCodeBlock == null) {
            RubyBlockToMethodReferenceUtil.a(3);
        }
        if (RubyBlockToMethodReferenceUtil.a(rCodeBlock)) {
            return null;
        }
        RCompoundStatement rCompoundStatement = rCodeBlock.getCompoundStatement();
        List<RPsiElement> list2 = rCompoundStatement.getStatements();
        if (list2.size() != 1) {
            return null;
        }
        return list2.get(0);
    }

    @Nullable
    private static List<String> b(@NotNull RCodeBlock rCodeBlock) {
        RBlockArgumentList rBlockArgumentList;
        if (rCodeBlock == null) {
            RubyBlockToMethodReferenceUtil.a(4);
        }
        if ((rBlockArgumentList = rCodeBlock.getBlockArguments()) == null) {
            return Collections.emptyList();
        }
        List<ArgumentInfo> list2 = rBlockArgumentList.getArgumentInfos();
        if (list2.stream().anyMatch(argumentInfo -> argumentInfo.getType() != ArgumentInfo.Type.SIMPLE)) {
            return null;
        }
        return ContainerUtil.map(list2, ArgumentInfo::getName);
    }

    private static boolean a(@NotNull RCodeBlock rCodeBlock) {
        RBodyStatement rBodyStatement;
        if (rCodeBlock == null) {
            RubyBlockToMethodReferenceUtil.a(5);
        }
        if ((rBodyStatement = rCodeBlock.getBodyStatement()) == null) {
            return false;
        }
        if (!rBodyStatement.getRescueBlocks().isEmpty() || rBodyStatement.getEnsureBlock() != null || rBodyStatement.getElseBlock() != null) {
            return true;
        }
        return Arrays.stream(rBodyStatement.getCompoundStatement().getChildren()).anyMatch(psiElement -> psiElement instanceof OuterLanguageElement);
    }

    @Nullable
    private static RListOfExpressions a(@NotNull RPossibleCall rPossibleCall) {
        if (rPossibleCall == null) {
            RubyBlockToMethodReferenceUtil.a(6);
        }
        if (rPossibleCall instanceof RCall) {
            return ((RCall)rPossibleCall).getCallArguments();
        }
        if (rPossibleCall instanceof RLambdaCall) {
            return ((RLambdaCall)rPossibleCall).getCallArguments();
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x5567CA8B9BDBL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/blocktoreference/RubyBlockToMethodReferenceUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockMethodDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSimpleBlockParameterNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isComplexCodeBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getListOfExpressions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

