/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.f;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public class RubyParameterNamingConventionInspection
extends ConventionInspection {
    public boolean m_ignoreBlockParameters = true;
    public boolean m_ignoreRescueParameters = true;
    public boolean m_ignoreLambdaParameters = true;
    private static final int c = 1;
    private static final int b = 20;
    private static final long d = com.jetbrains.python.psi.c.a(5360433759534934994L, -3457612212592787102L, MethodHandles.lookup().lookupClass()).a(258694248966711L);

    @Override
    protected String getDefaultRegex() {
        return TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern();
    }

    @Override
    protected String getMotionDefaultRegex() {
        long l2 = d ^ 0x69DD90885141L;
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 20;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = d ^ 0x3570344EFB3EL;
        if ("Parameter naming convention" == null) {
            RubyParameterNamingConventionInspection.d(0);
        }
        return "Parameter naming convention";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        long l2 = d ^ 0x3EB52B8F2B25L;
        String string = (String)args[0];
        if (string.length() < this.getMinLength()) {
            if ("Parameter name '#ref' is too short" == null) {
                RubyParameterNamingConventionInspection.d(1);
            }
            return "Parameter name '#ref' is too short";
        }
        if (string.length() > this.getMaxLength()) {
            if ("Parameter name '#ref' is too long" == null) {
                RubyParameterNamingConventionInspection.d(2);
            }
            return "Parameter name '#ref' is too long";
        }
        String string2 = "Parameter name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string2 == null) {
            RubyParameterNamingConventionInspection.d(3);
        }
        return string2;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor(null);
    }

    @Override
    public Collection<? extends JComponent> createExtraOptions() {
        long l2 = d ^ 0x554D48A10635L;
        return Arrays.asList(new CheckBox("Ignore for block parameters", (InspectionProfileEntry)this, "m_ignoreBlockParameters"), new CheckBox("Ignore for lambda parameters", (InspectionProfileEntry)this, "m_ignoreLambdaParameters"), new CheckBox("Ignore for rescue parameters", (InspectionProfileEntry)this, "m_ignoreRescueParameters"));
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        long l2 = d ^ 0x5353B19DC322L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyParameterNamingConventionInspection";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitRIdentifier(RIdentifier identifier) {
            if (!UsageAnalyzer.isParameter(identifier)) {
                return;
            }
            if (RubyParameterNamingConventionInspection.this.m_ignoreBlockParameters && (UsageAnalyzer.isBlockCallLocalDeclaration(identifier) || UsageAnalyzer.isBlockParameter(identifier))) {
                return;
            }
            if (RubyParameterNamingConventionInspection.this.m_ignoreLambdaParameters && UsageAnalyzer.isLambdaParameter(identifier)) {
                return;
            }
            if (RubyParameterNamingConventionInspection.this.m_ignoreRescueParameters && UsageAnalyzer.isRescueParameter(identifier)) {
                return;
            }
            String string = identifier.getName();
            if (RubyParameterNamingConventionInspection.this.isValid(string, (PsiElement)identifier)) {
                return;
            }
            this.registerVariableError(identifier, string);
        }

        /* synthetic */ NamingConventionsVisitor(f x1) {
            this();
        }
    }
}

