/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.nilanalysis;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;

public class RubyRedundantSafeNavigationInspection
extends RubyInspection {
    private static final long a = c.a(5307231947786434505L, -8481109489744247900L, MethodHandles.lookup().lookupClass()).a(128493583381084L);

    @NotNull
    public String getDisplayName() {
        long l2 = a ^ 0x1FCF61ECD580L;
        String string = RBundle.message("inspection.redundant.safe.navigation.name");
        if (string == null) {
            RubyRedundantSafeNavigationInspection.b(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        long l2 = a ^ 0x36471BDCD3D2L;
        if ("RubyRedundantSafeNavigation" == null) {
            RubyRedundantSafeNavigationInspection.b(1);
        }
        return "RubyRedundantSafeNavigation";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyRedundantSafeNavigationInspection.b(2);
        }
        RubyInspectionVisitor rubyInspectionVisitor = new RubyInspectionVisitor(holder){
            private static final long b = c.a(4172438409204072027L, -3659015367723297428L, MethodHandles.lookup().lookupClass()).a(68430651043976L);

            @Override
            public void visitRDotReference(RDotReference rDotReference) {
                long l2 = b ^ 0x5D2E9452FF5CL;
                if (!rDotReference.isSafeNavigation()) {
                    return;
                }
                RPsiElement rPsiElement = rDotReference.getReceiver();
                if (!(rPsiElement instanceof RExpression) || rDotReference.getPsiCommand() == null) {
                    return;
                }
                ControlFlowHolder controlFlowHolder = TypeInferenceContext.getControlFlowHolder((RExpression)rPsiElement);
                if (controlFlowHolder == null) {
                    return;
                }
                if (NilAnalysisUtil.getCanBeNil(rPsiElement, controlFlowHolder) == ThreeState.NO) {
                    this.registerProblem((PsiElement)rDotReference, RBundle.message("inspection.redundant.safe.navigation.warning"), new RubyRedundantSafeNavigationFix());
                }
            }
        };
        if (rubyInspectionVisitor == null) {
            RubyRedundantSafeNavigationInspection.b(3);
        }
        return rubyInspectionVisitor;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            RubyRedundantSafeNavigationInspection.b(4);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x435B24E3D5AEL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/nilanalysis/RubyRedundantSafeNavigationInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/nilanalysis/RubyRedundantSafeNavigationInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RubyRedundantSafeNavigationFix
    extends RubyFix {
        private static final long a = c.a(163343081919175715L, 7265606343219744869L, MethodHandles.lookup().lookupClass()).a(48201761582051L);

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                RubyRedundantSafeNavigationFix.b(0);
            }
            if (descriptor2 == null) {
                RubyRedundantSafeNavigationFix.b(1);
            }
            RDotReference rDotReference = (RDotReference)descriptor2.getPsiElement();
            RDotReference rDotReference2 = RubyRedundantSafeNavigationFix.a(rDotReference);
            rDotReference.replace((PsiElement)rDotReference2);
        }

        @NotNull
        public String getFamilyName() {
            long l2 = a ^ 0x24AE6B59DE22L;
            String string = RBundle.message("inspection.redundant.safe.navigation.message");
            if (string == null) {
                RubyRedundantSafeNavigationFix.b(2);
            }
            return string;
        }

        @NotNull
        private static RDotReference a(@NotNull RDotReference rDotReference) {
            if (rDotReference == null) {
                RubyRedundantSafeNavigationFix.b(3);
            }
            RPsiElement rPsiElement = rDotReference.getReceiver();
            RPsiElement rPsiElement2 = (RPsiElement)rDotReference.getPsiCommand();
            assert (rPsiElement != null);
            assert (rPsiElement2 != null);
            String string = rPsiElement.getText() + "." + rPsiElement2.getText();
            RDotReference rDotReference2 = (RDotReference)RubyElementFactory.createElementFromText((PsiElement)rDotReference, string);
            if (rDotReference2 == null) {
                RubyRedundantSafeNavigationFix.b(4);
            }
            return rDotReference2;
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x64F77894A4B8L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/nilanalysis/RubyRedundantSafeNavigationInspection$RubyRedundantSafeNavigationFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/nilanalysis/RubyRedundantSafeNavigationInspection$RubyRedundantSafeNavigationFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deleteSafeNavigation";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteSafeNavigation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

