/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.ColorUtil;
import com.jetbrains.python.psi.c;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.rdoc.lexer.RDocLexer;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyHelpUtil;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;
import org.jetbrains.plugins.ruby.utils.MarkupConstants;

public class RubyDocumentationMarkupUtil
implements MarkupConstants {
    @NonNls
    private static final String a = "</font>";
    private static final Pattern c;
    private static final Pattern b;
    private static final long d;

    @Contract(value="null->null; !null->!null")
    @Nullable
    public static String unsharpText(@Nullable String originalText) {
        long l2 = d ^ 0x57BA1C95B253L;
        if (originalText == null) {
            return null;
        }
        String string = originalText.trim();
        string = string.replaceAll("^##+\\n", "");
        return string.replaceAll("(^#)|((?<=\\n)#)", "");
    }

    public static String processCodeDocumentation(@Nullable Symbol target, @NonNls @NotNull String text2) {
        IElementType iElementType;
        long l2 = d ^ 0x751A0074894DL;
        if (text2 == null) {
            RubyDocumentationMarkupUtil.a(0);
        }
        text2 = RubyDocumentationMarkupUtil.d(RubyDocumentationMarkupUtil.unsharpText(text2));
        text2 = text2.replaceAll("<", "&lt;");
        text2 = text2.replaceAll(">", "&gt;");
        text2 = RubyDocumentationMarkupUtil.g(text2);
        Colorer colorer = new Colorer();
        StringBuilder stringBuilder = new StringBuilder();
        RDocLexer rDocLexer = new RDocLexer(true, true);
        rDocLexer.start(text2);
        IElementType iElementType2 = null;
        IElementType iElementType3 = null;
        boolean bl2 = false;
        while ((iElementType = rDocLexer.getTokenType()) != null) {
            if (bl2) {
                if (iElementType == RDocTokenTypes.COMMENT_ENABLE) {
                    bl2 = false;
                }
                rDocLexer.advance();
                continue;
            }
            if (iElementType == RDocTokenTypes.COMMENT_DISABLE) {
                bl2 = true;
                rDocLexer.advance();
                continue;
            }
            String string = rDocLexer.getTokenText();
            if (iElementType == RDocTokenTypes.HEADINGS) {
                RubyDocumentationMarkupUtil.a(stringBuilder, string);
            } else if (iElementType == RDocTokenTypes.RULE) {
                stringBuilder.append("<hr>");
            } else if (iElementType == RDocTokenTypes.ITALIC) {
                stringBuilder.append("<em>").append(Matcher.quoteReplacement(string.substring(1, string.length() - 1))).append("</em>");
            } else if (iElementType == RDocTokenTypes.BOLD) {
                stringBuilder.append("<b>").append(Matcher.quoteReplacement(string.substring(1, string.length() - 1))).append("</b>");
            } else if (iElementType == RDocTokenTypes.TYPE_WRITER) {
                stringBuilder.append("<code>").append(Matcher.quoteReplacement(string.substring(1, string.length() - 1))).append("</code>");
            } else if (iElementType == RDocTokenTypes.DIRECTIVE) {
                stringBuilder.append(colorer.g()).append(Matcher.quoteReplacement(string.substring(1, string.length() - 1))).append(a);
            } else if (iElementType == RDocTokenTypes.INTEGER || iElementType == RDocTokenTypes.FLOAT) {
                stringBuilder.append("<em>").append("<code>").append(colorer.a()).append(string).append(a).append("</code>").append("</em>");
            } else if (iElementType == RDocTokenTypes.STRING) {
                stringBuilder.append("<b>").append("<code>").append(colorer.d()).append(string).append(a).append("</code>").append("</b>");
            } else if (iElementType == RDocTokenTypes.VAR) {
                stringBuilder.append("<b>").append("<em>").append("<code>").append(colorer.c()).append(string).append(a).append("</code>").append("</em>").append("</b>");
            } else if (iElementType == RDocTokenTypes.GVAR) {
                stringBuilder.append("<b>").append("<code>").append(colorer.f()).append(string).append(a).append("</code>").append("</b>");
            } else if (iElementType == RDocTokenTypes.SYMBOL) {
                stringBuilder.append("<b>").append("<code>").append(colorer.e()).append(string).append(a).append("</code>").append("</b>");
            } else if (iElementType == RDocTokenTypes.RESWORD || iElementType == RDocTokenTypes.PARAM || iElementType == RDocTokenTypes.RETURN) {
                stringBuilder.append("<b>").append("<code>").append(colorer.b()).append(string).append(a).append("</code>").append("</b>");
            } else if (iElementType == RDocTokenTypes.URL) {
                stringBuilder.append(Matcher.quoteReplacement("<a href=\"" + string + "\">" + string + "</a>"));
            } else if (iElementType == RDocTokenTypes.EMAIL) {
                stringBuilder.append(Matcher.quoteReplacement("<a href=\"mailto:" + string + "\">" + string + "</a>"));
            } else if (target != null && (iElementType == RDocTokenTypes.TYPE || iElementType == RDocTokenTypes.CID)) {
                boolean bl3 = iElementType3 != RDocTokenTypes.CID || iElementType2 != RDocTokenTypes.HASH;
                boolean bl4 = Character.isUpperCase(string.charAt(0));
                Symbol symbol = RubyDocumentationMarkupUtil.a(target, string, bl4);
                if (symbol != null) {
                    stringBuilder.append(RubyHelpUtil.createRefText(symbol, !bl3 ? symbol.getName() : RContainerPresentationUtil.getPresentableSymbolName(symbol, symbol.getPsiElement())));
                } else {
                    stringBuilder.append(string);
                }
            } else {
                stringBuilder.append(string);
            }
            rDocLexer.advance();
            iElementType3 = iElementType2;
            iElementType2 = iElementType;
        }
        text2 = RubyDocumentationMarkupUtil.b(stringBuilder.toString());
        text2 = RubyDocumentationMarkupUtil.c(text2);
        text2 = RubyDocumentationMarkupUtil.a(text2);
        return text2.replaceAll("\\n", "<br>").replaceAll("--", "&ndash;");
    }

    @Nullable
    private static Symbol a(Symbol symbol, String string, boolean bl2) {
        PsiElement psiElement = symbol.getPsiElement();
        if (!(psiElement instanceof RPsiElement)) {
            return null;
        }
        Symbol symbol2 = SymbolUtil.getScopeContext(symbol);
        if (symbol2 == null) {
            return null;
        }
        FQN fQN = FQN.Builder.fromString(string);
        return bl2 ? SymbolUtil.lookupConstant(symbol2, (RPsiElement)psiElement, fQN, Types.MODULE_OR_CLASS, psiElement) : SymbolUtil.lookupMethod(symbol2, fQN, Types.MODULE_OR_CLASS, Context.INSTANCE_PRIVATE, psiElement);
    }

    private static void a(StringBuilder stringBuilder, String string) {
        int n2;
        long l2 = d ^ 0x5926B9DAB45CL;
        String string2 = string.trim();
        for (n2 = 0; n2 < string2.length() && string2.charAt(n2) == '='; ++n2) {
        }
        stringBuilder.append("<h" + (n2 + 1) + ">" + Matcher.quoteReplacement(string2.substring(n2).trim()) + "</h" + (n2 + 1) + ">");
    }

    public static String processGemDocumentation(@NonNls @NotNull String text2) {
        if (text2 == null) {
            RubyDocumentationMarkupUtil.a(1);
        }
        return RubyDocumentationMarkupUtil.processCodeDocumentation(null, text2);
    }

    private static String a(String string) {
        long l2 = d ^ 0x128A5C0F9B3FL;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        ArrayList<String> arrayList = RubyDocumentationMarkupUtil.f(string);
        for (String string2 : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            if (StringUtil.isEmptyOrSpaces((String)string2)) {
                stringBuilder.append(string2);
                continue;
            }
            if (string2.startsWith("  ")) {
                if (!bl2) {
                    stringBuilder.append("<pre><code>");
                    bl2 = true;
                }
                stringBuilder.append(string2.substring(2));
                continue;
            }
            if (bl2) {
                stringBuilder.append("</code></pre>");
                bl2 = false;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static String d(String string) {
        long l2 = d ^ 0x16948E5B7DFAL;
        string = string.replaceAll("<b>", "\fB_OPEN_TAG\f");
        string = string.replaceAll("</b>", "\fB_CLOSE_TAG\f");
        string = string.replaceAll("<em>", "\fEM_OPEN_TAG\f");
        string = string.replaceAll("</em>", "\fEM_CLOSE_TAG\f");
        string = string.replaceAll("<i>", "\fEM_OPEN_TAG\f");
        string = string.replaceAll("</i>", "\fEM_CLOSE_TAG\f");
        string = string.replaceAll("<tt>", "\fTT_OPEN_TAG\f");
        string = string.replaceAll("</tt>", "\fTT_CLOSE_TAG\f");
        string = string.replaceAll("<code>", "\fCODE_OPEN_TAG\f");
        string = string.replaceAll("</code>", "\fCODE_CLOSE_TAG\f");
        string = string.replaceAll("<h1>", "\fH_OPEN_TAG_ONE\f");
        string = string.replaceAll("</h1>", "\fH_CLOSE_TAG_ONE\f");
        string = string.replaceAll("<h2>", "\fH_OPEN_TAG_TWO\f");
        string = string.replaceAll("</h2>", "\fH_CLOSE_TAG_TWO\f");
        string = string.replaceAll("<h3>", "\fH_OPEN_TAG_THREE\f");
        string = string.replaceAll("</h3>", "\fH_CLOSE_TAG_THREE\f");
        string = string.replaceAll("<h4>", "\fH_OPEN_TAG_FOUR\f");
        string = string.replaceAll("</h4>", "\fH_CLOSE_TAG_FOUR\f");
        return string;
    }

    private static String b(String string) {
        long l2 = d ^ 0x257022FA7AD2L;
        string = string.replaceAll("\fB_OPEN_TAG\f", "<b>");
        string = string.replaceAll("\fB_CLOSE_TAG\f", "</b>");
        string = string.replaceAll("\fEM_OPEN_TAG\f", "<em>");
        string = string.replaceAll("\fEM_CLOSE_TAG\f", "</em>");
        string = string.replaceAll("\fTT_OPEN_TAG\f", "<tt>");
        string = string.replaceAll("\fTT_CLOSE_TAG\f", "</tt>");
        string = string.replaceAll("\fCODE_OPEN_TAG\f", "<code>");
        string = string.replaceAll("\fCODE_CLOSE_TAG\f", "</code>");
        string = string.replaceAll("\fH_OPEN_TAG_ONE\f", "<h1>");
        string = string.replaceAll("\fH_CLOSE_TAG_ONE\f", "</h1>");
        string = string.replaceAll("\fH_OPEN_TAG_TWO\f", "<h2>");
        string = string.replaceAll("\fH_CLOSE_TAG_TWO\f", "</h2>");
        string = string.replaceAll("\fH_OPEN_TAG_THREE\f", "<h3>");
        string = string.replaceAll("\fH_CLOSE_TAG_THREE\f", "</h3>");
        string = string.replaceAll("\fH_OPEN_TAG_FOUR\f", "<h4>");
        string = string.replaceAll("\fH_CLOSE_TAG_FOUR\f", "</h4>");
        return string;
    }

    private static String c(String string) {
        long l2 = d ^ 0x7E179BEA0877L;
        ArrayList<String> arrayList = RubyDocumentationMarkupUtil.f(string);
        if (arrayList.size() == 1) {
            return string;
        }
        int n2 = -1;
        String string2 = " ";
        String string3 = "     ";
        for (int i10 = 0; i10 < arrayList.size(); ++i10) {
            String string4 = arrayList.get(i10);
            if (StringUtil.isEmptyOrSpaces((String)string4)) continue;
            if (string4.startsWith("     ")) {
                if (n2 != -1) continue;
                n2 = i10;
                continue;
            }
            if (n2 != -1) {
                return string;
            }
            if (string4.startsWith(" ")) continue;
            return string;
        }
        if (n2 == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<h3>").append(RBundle.message("ruby.doc.usage")).append(":</h3>");
        for (int i11 = 0; i11 < arrayList.size(); ++i11) {
            if (i11 == n2) {
                stringBuilder.append("<h3>").append(RBundle.message("ruby.doc.description")).append(":</h3>");
            } else if (i11 > 0) {
                stringBuilder.append("\n");
            }
            String string5 = arrayList.get(i11);
            if (StringUtil.isEmptyOrSpaces((String)string5)) {
                stringBuilder.append(string5);
                continue;
            }
            if (i11 < n2) {
                stringBuilder.append(string5);
                continue;
            }
            stringBuilder.append(string5.substring(4));
        }
        return stringBuilder.toString();
    }

    private static String g(String string) {
        long l2 = d ^ 0x4722433E296AL;
        ArrayList<String> arrayList = RubyDocumentationMarkupUtil.f(string);
        if (arrayList.size() == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        int n2 = 0;
        for (String string3 : arrayList) {
            Pair<String, String> pair;
            if (bl2) {
                if (StringUtil.isEmptyOrSpaces((String)string3)) {
                    stringBuilder.append(string3);
                    continue;
                }
                if (string2 == null && string3.startsWith(" ")) {
                    string2 = StringUtil.commonPrefix((String)string3, (String)"             ");
                    n2 = string2.length();
                    stringBuilder.append(string3.substring(n2));
                    continue;
                }
                if (string2 != null && string3.startsWith(string2)) {
                    stringBuilder.append("\n");
                    stringBuilder.append(string3.substring(n2));
                    continue;
                }
            }
            if ((pair = RubyDocumentationMarkupUtil.e(string3)) != null) {
                string2 = (String)pair.getSecond();
                String string4 = (String)pair.getFirst();
                if (bl2) {
                    stringBuilder.append(bl3 ? "</li>" : "</dd>");
                } else {
                    bl2 = true;
                    bl3 = string4.equals("*");
                    stringBuilder.append(bl3 ? "<ul>" : "<dl>");
                }
                if (bl3) {
                    stringBuilder.append("<li>");
                } else {
                    stringBuilder.append("<dt>").append(string4).append("</dt><dd>");
                }
                if (string2 == null) continue;
                n2 = string2.length();
                stringBuilder.append(string3.substring(n2));
                continue;
            }
            if (bl2) {
                stringBuilder.append(bl3 ? "</li></ul>" : "</dd></dl>");
                bl2 = false;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(string3);
        }
        if (bl2) {
            stringBuilder.append(bl3 ? "</li></ul>" : "</dd></dl>");
        }
        return stringBuilder.toString();
    }

    @Nullable
    private static Pair<String, String> e(String string) {
        long l2 = d ^ 0x251DD5EB773CL;
        Matcher matcher = b.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(2);
            if (string2.endsWith("::")) {
                string2 = StringUtil.trimEnd((String)string2, (String)"::");
            } else if (string2.startsWith("[")) {
                string2 = StringUtil.trimStart((String)StringUtil.trimEnd((String)string2, (String)"]"), (String)"[");
            }
            String string3 = matcher.group();
            if (string2.equals("*") && !string3.endsWith(" ")) {
                return null;
            }
            boolean bl2 = string.length() > string3.length();
            return Pair.create((Object)string2, bl2 ? string3.replaceAll("\\S", " ") : null);
        }
        return null;
    }

    private static ArrayList<String> f(String string) {
        int n2;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n2 = string.indexOf(10, n3)) != -1) {
            arrayList.add(string.substring(n3, n2));
            n3 = n2 + 1;
        }
        arrayList.add(string.substring(n3));
        return arrayList;
    }

    public static void appendBold(@NotNull StringBuilder builder, @Nullable String s2) {
        long l2 = d ^ 0x62DEB4BA47B2L;
        if (builder == null) {
            RubyDocumentationMarkupUtil.a(2);
        }
        builder.append("<b>").append(s2).append("</b>");
    }

    public static void appendCode(@NotNull StringBuilder builder, @Nullable String s2) {
        long l2 = d ^ 0x3F43CA998F9CL;
        if (builder == null) {
            RubyDocumentationMarkupUtil.a(3);
        }
        builder.append("<code>").append(s2).append("</code>");
    }

    public static void appendBoldCode(@NotNull StringBuilder builder, @Nullable String s2) {
        long l2 = d ^ 0x570B08224A64L;
        if (builder == null) {
            RubyDocumentationMarkupUtil.a(4);
        }
        builder.append("<b>").append("<code>").append(s2).append("</code>").append("</b>");
    }

    static {
        d = com.jetbrains.python.psi.c.a(-1669254498766276107L, -1873117861484820801L, MethodHandles.lookup().lookupClass()).a(115897755912848L);
        long l2 = d ^ 0x47D360562909L;
        c = Pattern.compile("(^[ ]{2,})|((?<=\\n)[ ]{2,})");
        b = Pattern.compile("^([ ]*(\\*|\\[[^]]+\\]|[^:]+::)(?:[ ]+|$))");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = d ^ 0x34B58B9B82CL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyDocumentationMarkupUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processCodeDocumentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processGemDocumentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendBold";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendCode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendBoldCode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Colorer {
        private final String f;
        private final String c;
        private final String b;
        private final String d;
        private final String e;
        private final String g;
        private final String a;
        private static final long h = com.jetbrains.python.psi.c.a(-413288475142741458L, 6601709745310374133L, MethodHandles.lookup().lookupClass()).a(63063782998475L);

        private static String a(TextAttributesKey textAttributesKey) {
            long l2 = h ^ 0x6CA272400CC7L;
            Color color = textAttributesKey.getDefaultAttributes().getForegroundColor();
            return color != null ? "<font color=#" + ColorUtil.toHex((Color)color) + ">" : "";
        }

        Colorer() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.f = "<font color=#0000FF>";
                this.c = "<font color=#000066>";
                this.b = "<font color=#0000FF>";
                this.d = "<font color=#006600>";
                this.e = "<font color=#0099FF>";
                this.g = "<font color=#9900FF>";
                this.a = "<font color=#000000>";
            } else {
                this.f = Colorer.a(RubyHighlighter.NUMBER);
                this.c = Colorer.a(RubyHighlighter.KEYWORD);
                this.b = Colorer.a(RubyHighlighter.NUMBER);
                this.d = Colorer.a(RubyHighlighter.SIMPLE_STRING);
                this.e = Colorer.a(RubyHighlighter.SYMBOL);
                this.g = Colorer.a(RubyHighlighter.IVAR);
                this.a = Colorer.a(RubyHighlighter.GVAR);
            }
        }

        private String g() {
            return this.f;
        }

        private String b() {
            return this.c;
        }

        private String a() {
            return this.b;
        }

        private String d() {
            return this.d;
        }

        private String e() {
            return this.e;
        }

        private String c() {
            return this.g;
        }

        private String f() {
            return this.a;
        }
    }
}

