/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.lexer.managers;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.managers.AbstractRubyLexer;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.managers.ContentManager;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.managers.StatesManager;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.managers.state.Expr;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.ruby19.Ruby19TokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;

public class TokensManager
implements RubyTokenTypes {
    private final StatesManager d;
    private boolean c;
    private final ContentManager a;
    private final AbstractRubyLexer b;

    public TokensManager(AbstractRubyLexer lexer) {
        this.b = lexer;
        this.d = lexer.getStatesManager();
        this.a = lexer.getContentManager();
    }

    public void reset() {
        this.c = false;
    }

    public boolean reswordAllowed() {
        return !this.isFnameAllowed() && (!this.b.isRuby19Enabled() || this.a.safeReadAt(this.b.yylength()) != ':');
    }

    public boolean afterDotOrColon() {
        return this.d.getExpr() == Expr.DOT_OR_COLON;
    }

    public boolean isAssignOpAllowed() {
        return this.d.getExpr() == Expr.FNAME;
    }

    public boolean isFnameAllowed() {
        Expr expr = this.d.getExpr();
        return expr == Expr.FNAME || expr == Expr.DOT_OR_COLON || expr == Expr.CMD_BRACE && TokenBNF.tCALL.contains(this.d.getLastTokenType());
    }

    public boolean isColon2Allowed() {
        Expr expr = this.d.getExpr();
        return expr == Expr.END || expr == Expr.CMD_ARG || expr == Expr.ARG && !this.c || expr == Expr.CMD_BRACE && this.d.isPipeSeen() && !this.c;
    }

    public boolean isSymBegAllowed(boolean followCharIsWhiteSpaceOrEol) {
        if (this.d.isInAlias() || this.d.isInUndef()) {
            return true;
        }
        return this.unaryAllowed(followCharIsWhiteSpaceOrEol);
    }

    public boolean stringAllowed() {
        return this.stringAllowed(false);
    }

    public boolean stringAllowed(boolean followCharIsWhiteSpaceOrEol) {
        Expr expr = this.d.getExpr();
        return !this.isFnameAllowed() && (expr == Expr.BEG || expr == Expr.CMD_BRACE || expr == Expr.MID || expr == Expr.ARG && this.c && !followCharIsWhiteSpaceOrEol);
    }

    public boolean unaryAllowed(boolean followCharIsWhiteSpaceOrEol) {
        if (this.isFnameAllowed()) {
            return false;
        }
        Expr expr = this.d.getExpr();
        if (expr == Expr.BEG || expr == Expr.MID || expr == Expr.CMD_ARG) {
            return true;
        }
        if (expr == Expr.ARG && !followCharIsWhiteSpaceOrEol) {
            return this.c || this.d.getLastTokenType() == Ruby19TokenTypes.tARROW;
        }
        if (this.d.isPipeSeen()) {
            IElementType iElementType = this.d.getLastTokenType();
            return (iElementType == tPIPE || iElementType == tCOMMA || this.c) && !followCharIsWhiteSpaceOrEol;
        }
        return expr == Expr.CMD_BRACE;
    }

    public boolean isHeredocAllowed() {
        return this.d.getExpr() != Expr.CLASS && this.unaryAllowed(false);
    }

    public IElementType process(IElementType type) {
        if (type != tLINE_CONTINUATION) {
            this.c = type == tWHITE_SPACE;
        }
        this.d.process(type);
        return type;
    }

    public boolean ignoreEOL() {
        Expr expr = this.d.getExpr();
        if (this.d.isInDefState() && !this.d.isIgnoreEol()) {
            return false;
        }
        if (this.d.getInKwArg() > 0 && this.d.isMaybeAfterLabel()) {
            return false;
        }
        return !this.d.isAfterHeredoc() && (expr == Expr.BEG || expr == Expr.MID || expr == Expr.CMD_BRACE && this.d.isIgnoreEol() || expr == Expr.DOT_OR_COLON || expr == Expr.CLASS || expr == Expr.FNAME);
    }

    public boolean isFTokenAllowed() {
        return !this.c && this.isExprEnd();
    }

    public boolean isArgTokenAllowed() {
        return this.c && this.d.getExpr() == Expr.ARG;
    }

    public boolean isExprEnd() {
        Expr expr = this.d.getExpr();
        return expr == Expr.END || expr == Expr.ARG;
    }
}

