/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.AbstractMemberInfoStorage;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubySuperClassesCollector;

public class RubyMemberInfoStorage
extends AbstractMemberInfoStorage<RPsiElement, RContainer, RubyMemberInfo> {
    private static final TypeSet b = new TypeSet(Type.CLASS_METHOD, Type.INSTANCE_METHOD);
    private Set<RContainer> a;
    private Set<RContainer> c;

    public RubyMemberInfoStorage(RContainer aClass) {
        this(aClass, (MemberInfoBase.Filter<RPsiElement>)new MemberInfoBase.EmptyFilter());
    }

    private RubyMemberInfoStorage(RContainer aClass, MemberInfoBase.Filter<RPsiElement> memberInfoFilter) {
        super((PsiElement)aClass, memberInfoFilter);
    }

    protected boolean isInheritor(RContainer baseClass, RContainer aClass) {
        return this.getSubclasses((PsiElement)baseClass).contains(aClass);
    }

    protected void buildSubClassesMap(RContainer aClass) {
        this.a(aClass, new HashSet<RContainer>());
    }

    private void a(RContainer rContainer, Set<RContainer> set) {
        set.add(rContainer);
        if (this.a == null) {
            this.a = new HashSet<RContainer>();
            this.c = new HashSet<RContainer>();
        }
        Map<RContainer, Context> map2 = RubySuperClassesCollector.getSuperClassesAndAllModules(rContainer, true);
        this.a(rContainer, set, map2);
    }

    private void a(RContainer rContainer, Set<RContainer> set, Map<RContainer, Context> map2) {
        for (Map.Entry<RContainer, Context> entry : map2.entrySet()) {
            RContainer rContainer2 = entry.getKey();
            this.getSubclasses((PsiElement)rContainer2).add(rContainer);
            Access access = entry.getValue().getAccess();
            if (!access.acceptInstance() || rContainer2 instanceof RClass) {
                this.c.add(rContainer2);
            }
            if (access.acceptInstance()) {
                this.a.add(rContainer2);
            }
            if (set.contains(rContainer2)) continue;
            this.a(rContainer2, set);
        }
    }

    protected void extractClassMembers(RContainer aClass, ArrayList<RubyMemberInfo> temp) {
        Symbol symbol = SymbolUtil.getSymbolByContainer(aClass);
        if (symbol == null) {
            return;
        }
        for (Symbol symbol2 : symbol.getChildren(b, (PsiElement)aClass)) {
            PsiElement psiElement = symbol2.getPsiElement();
            if (psiElement instanceof RCall) {
                RCall rCall = (RCall)psiElement;
                for (RPsiElement rPsiElement : rCall.getCallArguments().getElements()) {
                    RubyMemberInfoStorage.a(temp, (PsiElement)rPsiElement);
                }
                continue;
            }
            if (!(psiElement instanceof RPsiElement)) continue;
            RubyMemberInfoStorage.a(temp, psiElement);
        }
        if (symbol instanceof ClassModuleSymbol) {
            RubyMemberInfoStorage.a(temp, ((ClassModuleSymbol)symbol).getIncludeSymbols((PsiElement)aClass));
            RubyMemberInfoStorage.a(temp, ((ClassModuleSymbol)symbol).getExtendSymbols((PsiElement)aClass));
        }
    }

    private static void a(ArrayList<RubyMemberInfo> arrayList, List<Symbol> list2) {
        for (Symbol symbol : list2) {
            PsiElement psiElement = symbol.getPsiElement();
            if (!(psiElement instanceof RPsiElement)) continue;
            RubyMemberInfoStorage.a(arrayList, psiElement);
        }
    }

    private static void a(ArrayList<RubyMemberInfo> arrayList, PsiElement psiElement) {
        for (RubyMemberInfo rubyMemberInfo : arrayList) {
            if (rubyMemberInfo.getMember() != psiElement) continue;
            return;
        }
        arrayList.add(new RubyMemberInfo((RPsiElement)psiElement));
    }

    protected boolean memberConflict(RPsiElement member1, RPsiElement member) {
        return member1 instanceof RMethod && member instanceof RMethod && RubyRefactoringUtil.areConflictingMethods((RMethod)member, (RMethod)member1);
    }

    public Set<RContainer> getInstanceClasses() {
        return this.a;
    }

    public Set<RContainer> getStaticClasses() {
        return this.c;
    }
}

