/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.extractSuperclass;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.python.psi.c;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersRefactoringSupport;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassRefactoringHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractSuperclass.ExtractSuperclassDialog;

public class RubyExtractSuperclassHandler
extends RubyClassRefactoringHandlerBase {
    private static final Logger a;
    private static final long b;

    protected void showDialog(Project project, PsiElement element, Editor editor2, PsiFile file, DataContext dataContext) {
        RClass rClass = RubyPsiUtil.getContainingRClass(element);
        if (rClass == null) {
            String string = RefactoringBundle.getCannotRefactorMessage((String)this.getInvalidPositionMessage());
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)string, (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        RubyMemberInfoStorage rubyMemberInfoStorage = RubyClassMembersRefactoringSupport.getSelectedMemberInfos(rClass, element);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ExtractSuperclassDialog extractSuperclassDialog = new ExtractSuperclassDialog(project, rClass, rubyMemberInfoStorage);
        if (extractSuperclassDialog.showAndGet()) {
            RubyExtractSuperclassHandler.extractSuperclass(rClass, extractSuperclassDialog.getSelectedMemberInfos(), extractSuperclassDialog.getSuperBaseName(), extractSuperclassDialog.getTargetDirectory());
        }
    }

    static void extractSuperclass(RClass clazz, Collection<RubyMemberInfo> selectedMemberInfos, String superBaseName, VirtualFile targetDirectory) {
        long l2 = b ^ 0x146FD01068DAL;
        Project project = clazz.getProject();
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> {
            try {
                RubyExtractSuperclassHandler.navigate((PsiElement)RubyExtractSuperclassHandler.a(clazz, selectedMemberInfos, superBaseName, targetDirectory));
            }
            catch (IOException iOException) {
                a.error((Throwable)iOException);
            }
        })), RefactoringBundle.message((String)"extract.superclass.command.name", (Object[])new Object[]{superBaseName, DescriptiveNameUtil.getDescriptiveName((PsiElement)clazz)}), null);
    }

    private static PsiElement a(RClass rClass, Collection<RubyMemberInfo> collection, String string, VirtualFile virtualFile) throws IOException {
        long l2 = b ^ 0x5AC5D6CA86D7L;
        Project project = rClass.getProject();
        Pair<String, RFile> pair = RubyExtractSuperclassHandler.a(rClass);
        String string2 = RubyClassMembersPsiHelper.prepareContainerStatements(string, collection, "class", false);
        RFile rFile = RubyClassMembersPsiHelper.createTargetFile(project, virtualFile, RubyRefactoringUtil.getNewFileName(string), string2);
        RubyClassMembersPsiHelper.removeMembers(collection);
        RubyClassMembersPsiHelper.insertRequire(rClass.getContainingFile(), rFile);
        RClass rClass2 = (RClass)RubyClassMembersPsiHelper.findPrepared(rFile, string);
        RubyExtractSuperclassHandler.b(rClass);
        if (pair.first != null) {
            RubyExtractSuperclassHandler.a(rClass2, (String)pair.first);
        }
        if (pair.second != null) {
            RubyClassMembersPsiHelper.insertRequire(rFile, (RFile)pair.second);
        }
        RubyExtractSuperclassHandler.a(rClass, string);
        return rClass2;
    }

    private static void b(RClass rClass) {
        RSuperClass rSuperClass = rClass.getPsiSuperClass();
        if (rSuperClass == null) {
            return;
        }
        List<PsiElement> list2 = RubyExtractSuperclassHandler.a(rSuperClass);
        RubyPsiUtil.removeElements(list2.toArray(PsiElement.EMPTY_ARRAY));
    }

    private static void a(RClass rClass, String string) {
        long l2 = b ^ 0x6CB7DCD412B2L;
        String string2 = "class Foo < " + string + "\nend";
        RClass rClass2 = (RClass)RubyElementFactory.createElementFromText((PsiElement)rClass, string2);
        List<PsiElement> list2 = RubyExtractSuperclassHandler.a(rClass2.getPsiSuperClass());
        RubyPsiUtil.addBeforeInParent(rClass.getClassName().getNextSibling(), list2.toArray(PsiElement.EMPTY_ARRAY));
    }

    private static List<PsiElement> a(RPsiElement rPsiElement) {
        if (rPsiElement == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        arrayList.add((PsiElement)rPsiElement);
        for (PsiElement psiElement = rPsiElement.getPrevSibling(); psiElement != null && (psiElement instanceof PsiWhiteSpace || "<".equals(psiElement.getText())); psiElement = psiElement.getPrevSibling()) {
            arrayList.add(0, psiElement);
        }
        return arrayList;
    }

    private static Pair<String, RFile> a(RClass rClass) {
        PsiElement psiElement;
        ClassModuleSymbol classModuleSymbol = (ClassModuleSymbol)SymbolUtil.getSymbolByContainer(rClass);
        assert (classModuleSymbol != null);
        Symbol symbol = classModuleSymbol.getSuperClassSymbol((PsiElement)rClass);
        PsiElement psiElement2 = psiElement = symbol != null && !symbol.getFQNWithNesting().equals(RClassBase.OBJECT_FQN) ? symbol.getPsiElement() : null;
        if (psiElement == null) {
            RSuperClass rSuperClass = rClass.getPsiSuperClass();
            return Pair.create((Object)(rSuperClass != null ? rSuperClass.getText() : null), null);
        }
        return Pair.create((Object)symbol.getFQNWithNesting().getFullPath(), (Object)((RFile)psiElement.getContainingFile()));
    }

    protected String getHelpId() {
        long l2 = b ^ 0x22BEDA6FE141L;
        return "refactoring.extractSuperclass";
    }

    protected String getTitle() {
        long l2 = b ^ 0x7256570D88F1L;
        return RefactoringBundle.message((String)"extract.superclass.title");
    }

    protected String getInvalidPositionMessage() {
        long l2 = b ^ 0x5A2C14F4DE2FL;
        return RefactoringBundle.message((String)"error.wrong.caret.position.class");
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof RClass;
    }

    static {
        b = c.a(6374159727224588409L, -6945145081372986720L, MethodHandles.lookup().lookupClass()).a(19965341740740L);
        a = Logger.getInstance(RubyExtractSuperclassHandler.class);
    }
}

