/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.introduce;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.IntroduceValidator;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.NamesSuggestor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceDialog;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceSettings;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementElement;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementSubstringElement;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;

public abstract class RubyIntroduceHandlerBase
implements RefactoringActionHandler {
    private static final Logger a;
    private static final long c;

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file, DataContext dataContext) {
        if (project == null) {
            RubyIntroduceHandlerBase.a(0);
        }
        this.performAction(project, editor2, file, null, false, 0);
    }

    @NotNull
    protected String getDefaultName() {
        long l2 = c ^ 0x378E68F28211L;
        if ("var" == null) {
            RubyIntroduceHandlerBase.a(1);
        }
        return "var";
    }

    protected void performAction(Project project, Editor editor2, PsiFile file, @Nullable String name, boolean replaceAll, int position) {
        RubyReplacementBase rubyReplacementBase;
        long l2 = c ^ 0x3A17C08109CFL;
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            this.smartIntroduce(project, file, editor2, name, replaceAll, position);
            return;
        }
        Pair<PsiElement, PsiElement> pair = RefactoringPsiHelper.getSelectedElements(editor2, file);
        PsiElement psiElement = (PsiElement)pair.first;
        PsiElement psiElement2 = (PsiElement)pair.second;
        if (psiElement == null || psiElement2 == null || !RubyPsiUtil.isBefore(psiElement, psiElement2)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)RBundle.message("refactoring.introduce.selection.error"), (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        PsiElement psiElement3 = psiElement.getParent();
        if (TokenBNF.tSTRING_LIKE_CONTENTS.contains(psiElement.getNode().getElementType()) && psiElement == psiElement2 && RubyRefactoringUtil.isInterpolationAllowed(psiElement3)) {
            int n2 = psiElement3.getTextRange().getStartOffset();
            int n3 = selectionModel.getSelectionStart() - n2;
            int n4 = selectionModel.getSelectionEnd() - n2;
            rubyReplacementBase = new RubyReplacementSubstringElement(psiElement, (RPsiElement)psiElement3, this.getSearchScope(psiElement3), selectionModel.getSelectedText(), new TextRange(n3, n4));
        } else {
            Object object = RefactoringPsiHelper.getSelectedExpression(project, file, psiElement, psiElement2, true, this.getHelpId());
            if (object == null || object instanceof String && StringUtil.isEmpty((String)((String)object))) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)RBundle.message("refactoring.introduce.selection.error"), (String)this.getTitle(), (String)this.getHelpId());
                return;
            }
            if (object instanceof String) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)((String)object), (String)this.getTitle(), (String)this.getHelpId());
                return;
            }
            rubyReplacementBase = new RubyReplacementElement(psiElement, (RPsiElement)object, this.getSearchScope((PsiElement)((RPsiElement)object)));
            if (rubyReplacementBase.getExpression() == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)RBundle.message("refactoring.introduce.variable.changed.error"), (String)this.getTitle(), (String)this.getHelpId());
                return;
            }
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureID());
        this.performActionOnElement(project, editor2, rubyReplacementBase, name, replaceAll);
    }

    protected void performActionOnElement(final Project project, final Editor editor2, final RubyReplacementBase elementToReplace, String name, boolean replaceAll) {
        final RPsiElement rPsiElement = elementToReplace.getExpression();
        PsiElement psiElement = elementToReplace.getElement();
        final List<PsiElement> list2 = elementToReplace.getOccurrences();
        if (!TemplateIntegrationUtils.getInstance().isTemplateFile(rPsiElement.getContainingFile().getFileType()) && this.supportsInplace() && editor2.getSettings().isVariableInplaceRenameEnabled() && !ApplicationManager.getApplication().isUnitTestMode()) {
            IntroduceValidator introduceValidator = this.createValidator(psiElement, list2);
            final List<String> list3 = this.getSuggestedNames((PsiElement)rPsiElement, introduceValidator);
            OccurrencesChooser.simpleChooser((Editor)editor2).showChooser((Object)psiElement, list2, (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){
                private static final long a = com.jetbrains.python.psi.c.a(-3575577162567145381L, -7994880753900209421L, MethodHandles.lookup().lookupClass()).a(148651949564082L);

                public void pass(OccurrencesChooser.ReplaceChoice choice) {
                    long l2 = a ^ 0x2D42E8C444BDL;
                    boolean bl2 = choice == OccurrencesChooser.ReplaceChoice.ALL;
                    PsiElement psiElement = RubyIntroduceHandlerBase.this.a(project, elementToReplace, list3.isEmpty() ? RubyIntroduceHandlerBase.this.getDefaultName() : (String)list3.get(0), bl2);
                    editor2.getCaretModel().moveToOffset(psiElement.getTextRange().getStartOffset());
                    final RPsiElement rPsiElement2 = RubyIntroduceHandlerBase.this.getSearchScope(psiElement);
                    PsiElement[] psiElementArray = list2.toArray(PsiElement.EMPTY_ARRAY);
                    if (!(psiElement instanceof RAssignmentExpression)) {
                        a.error("element is not RAssignmentExpression", new String[]{psiElement.getText(), rPsiElement.getText()});
                    }
                    PsiNamedElement psiNamedElement = (PsiNamedElement)((RAssignmentExpression)psiElement).getObject();
                    InplaceVariableIntroducer<PsiElement> inplaceVariableIntroducer = new InplaceVariableIntroducer<PsiElement>(psiNamedElement, editor2, project, RubyIntroduceHandlerBase.this.getTitle(), psiElementArray, (PsiElement)rPsiElement){

                        protected PsiElement checkLocalScope() {
                            return rPsiElement2;
                        }

                        public String getInitialName() {
                            return this.myElementToRename instanceof RField ? ((RField)this.myElementToRename).getPrefix() + super.getInitialName() : super.getInitialName();
                        }
                    };
                    inplaceVariableIntroducer.performInplaceRefactoring(new LinkedHashSet(list3));
                }
            });
        } else {
            Pair<String, Boolean> pair = this.getParametersForRefactoring(project, (PsiElement)rPsiElement, list2, name, replaceAll);
            if (pair.first == null && pair.second == null) {
                return;
            }
            this.a(project, elementToReplace, (String)pair.first, (Boolean)pair.second);
        }
    }

    private PsiElement a(Project project, RubyReplacementBase rubyReplacementBase, String string, boolean bl2) {
        RExpression rExpression = this.createDeclaration(project, rubyReplacementBase, string, this.isSplatAllowed());
        Ref ref = Ref.create();
        CommandProcessor.getInstance().executeCommand(project, () -> this.a(project, ref, (PsiElement)rExpression, rubyReplacementBase, string, bl2), this.getTitle(), null);
        return ((SmartPsiElementPointer)ref.get()).getElement();
    }

    protected PsiElement performReplace(Project project, PsiElement declaration, RubyReplacementBase elementToReplace, String name, boolean replaceAll) {
        PsiElement psiElement;
        RPsiElement rPsiElement;
        RPsiElement rPsiElement2 = elementToReplace.getExpression();
        Pair pair = (Pair)rPsiElement2.getUserData(RubyPsiUtil.SELECTION_BREAKS_AST_NODE);
        if (pair != null) {
            rPsiElement = (RPsiElement)pair.first;
            psiElement = this.insertDeclaration(name, declaration, (PsiElement)rPsiElement, elementToReplace.getOccurrences(), replaceAll);
        } else {
            psiElement = this.insertDeclaration(name, declaration, (PsiElement)rPsiElement2, elementToReplace.getOccurrences(), replaceAll);
        }
        rPsiElement = psiElement == null ? null : SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(psiElement);
        String string = name;
        if (rPsiElement2 instanceof RListOfExpressions && !(((RListOfExpressions)rPsiElement2).getFirstElement() instanceof RAssoc)) {
            string = "*" + name;
        }
        elementToReplace.replaceOccurrences(project, string, replaceAll);
        return rPsiElement == null ? null : rPsiElement.getElement();
    }

    protected RExpression createDeclaration(Project project, RubyReplacementBase elementToReplace, String name, boolean isListAllowed) {
        String string = elementToReplace.getExtractedText(name, false, isListAllowed);
        LanguageLevel languageLevel = RubyLanguageLevelPusher.getInstance().getLanguageLevelByElement((PsiElement)elementToReplace.getExpression());
        return RubyElementFactory.createExpressionFromText(project, string, languageLevel);
    }

    protected Pair<String, Boolean> getParametersForRefactoring(Project project, PsiElement element, List<PsiElement> occurrences, String name, boolean replaceAll) {
        IntroduceValidator introduceValidator = this.createValidator(element, occurrences);
        if (name != null) {
            String string = introduceValidator.check(new RubyIntroduceSettings(name, true, true));
            if (string != null) {
                throw new RuntimeException(string);
            }
        } else {
            List<String> list2 = this.getSuggestedNames(element, introduceValidator);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                name = list2.get(0);
            } else {
                RubyIntroduceDialog rubyIntroduceDialog = new RubyIntroduceDialog(project, this.getTitle(), this.getHelpId(), occurrences.size(), introduceValidator, ArrayUtilRt.toStringArray(list2));
                if (!rubyIntroduceDialog.showAndGet()) {
                    return Pair.create(null, null);
                }
                name = rubyIntroduceDialog.getName();
                replaceAll = rubyIntroduceDialog.doReplaceAllOccurrences();
            }
        }
        return Pair.create((Object)name, (Object)replaceAll);
    }

    protected boolean supportsInplace() {
        return true;
    }

    protected void smartIntroduce(final Project project, PsiFile file, final Editor editor2, final String name, final boolean replaceAll, int position) {
        RubyReplacementElement rubyReplacementElement;
        PsiElement psiElement;
        long l2 = c ^ 0x4DD210F95260L;
        int n2 = editor2.getCaretModel().getOffset();
        PsiElement psiElement2 = file.findElementAt(n2);
        PsiElement psiElement3 = psiElement2 = psiElement2 == null && n2 > 0 ? file.findElementAt(n2 - 1) : psiElement2;
        if (psiElement2 == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)RBundle.message("refactoring.introduce.context.error"), (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        IElementType iElementType = psiElement2.getNode().getElementType();
        PsiElement psiElement4 = psiElement2 = RubyRefactoringUtil.isTypeToIgnore(iElementType) ? PsiTreeUtil.prevLeaf((PsiElement)psiElement2) : psiElement2;
        if (psiElement2 != null && !(psiElement2.getParent() instanceof RExpression)) {
            psiElement = PsiTreeUtil.prevLeaf((PsiElement)psiElement2);
            psiElement2 = psiElement != null && psiElement.getParent() instanceof RExpression ? psiElement : psiElement2;
        }
        psiElement = new ArrayList();
        ArrayList<RubyReplacementElement> arrayList = new ArrayList<RubyReplacementElement>();
        while (psiElement2 != null && !(psiElement2 instanceof RCompoundStatement)) {
            if (psiElement2 instanceof RExpression && RefactoringPsiHelper.checkCanExtract((RPsiElement)psiElement2, true, this.getHelpId()) == null && (rubyReplacementElement = new RubyReplacementElement(psiElement2, (RPsiElement)psiElement2, this.getSearchScope(psiElement2))).getExpression() != null) {
                psiElement.add((RExpression)psiElement2);
                arrayList.add(rubyReplacementElement);
            }
            psiElement2 = psiElement2.getParent();
        }
        if (psiElement.size() == 1 || ApplicationManager.getApplication().isUnitTestMode() && !psiElement.isEmpty()) {
            rubyReplacementElement = (RubyReplacementElement)arrayList.get(Math.min(position, psiElement.size() - 1));
            this.performActionOnElement(project, editor2, rubyReplacementElement, name, replaceAll);
        } else if (psiElement.size() > 1) {
            IntroduceTargetChooser.showChooser((Editor)editor2, (List)psiElement, (Pass)new Pass<RExpression>(){

                public void pass(RExpression expression) {
                    RubyIntroduceHandlerBase.this.performActionOnElement(project, editor2, new RubyReplacementElement((PsiElement)expression, expression, RubyIntroduceHandlerBase.this.getSearchScope((PsiElement)expression)), name, replaceAll);
                }
            }, rExpression -> rExpression.getText());
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)RBundle.message("refactoring.introduce.context.error"), (String)this.getTitle(), (String)this.getHelpId());
        }
    }

    protected boolean isSplatAllowed() {
        return true;
    }

    protected abstract String getHelpId();

    protected abstract String getTitle();

    protected abstract String getFeatureID();

    protected abstract IntroduceValidator createValidator(PsiElement var1, List<PsiElement> var2);

    @Nullable
    protected abstract RPsiElement getSearchScope(PsiElement var1);

    protected abstract PsiElement insertDeclaration(String var1, PsiElement var2, PsiElement var3, List<PsiElement> var4, boolean var5);

    protected List<String> getSuggestedNames(PsiElement expression, IntroduceValidator validator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : NamesSuggestor.getSuggestedNames(expression)) {
            if (!validator.isNameValid(string) || validator.checkPossibleName(string) != null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            RubyIntroduceHandlerBase.a(2);
        }
        if (elements == null) {
            RubyIntroduceHandlerBase.a(3);
        }
    }

    protected static PsiElement insertDeclaration(PsiElement declaration, PsiElement expression) {
        RContainer rContainer = RefactoringPsiHelper.getClassOrModuleOrFile(expression);
        assert (rContainer != null);
        List<RPsiElement> list2 = rContainer.getStatements();
        assert (!list2.isEmpty());
        boolean bl2 = false;
        RPsiElement rPsiElement = null;
        for (RPsiElement rPsiElement2 : list2) {
            boolean bl3 = RubyIntroduceHandlerBase.a(rPsiElement2);
            if (bl2 && !bl3) {
                return rPsiElement.getParent().addAfter(declaration, (PsiElement)rPsiElement);
            }
            bl2 |= bl3;
            rPsiElement = rPsiElement2;
        }
        RPsiElement rPsiElement3 = list2.get(0);
        return rPsiElement3.getParent().addBefore(declaration, (PsiElement)rPsiElement3);
    }

    private static boolean a(RPsiElement rPsiElement) {
        return rPsiElement instanceof RAssignmentExpression;
    }

    private /* synthetic */ void a(Project project, Ref ref, PsiElement psiElement, RubyReplacementBase rubyReplacementBase, String string, boolean bl2) {
        PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> ref.set((Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(this.performReplace(project, psiElement, rubyReplacementBase, string, bl2)))));
    }

    static {
        c = com.jetbrains.python.psi.c.a(-7056142630182047528L, -1953522877328399348L, MethodHandles.lookup().lookupClass()).a(276412669217091L);
        a = Logger.getInstance(RubyIntroduceHandlerBase.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x9B83D8BF21FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/RubyIntroduceHandlerBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/RubyIntroduceHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

