/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.net.NetUtils;
import com.jetbrains.python.psi.c;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.TestFrameworkConfigurator;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyCommandLineExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

public abstract class RubyAbstractRunner
implements RubyRunner {
    private static final Logger b;
    private static final Key<ThrowableRunnable<ExecutionException>> e;
    @NonNls
    private static final String c = "-X19";
    @NonNls
    private static final String a = "RM_INFO";
    @Nullable
    protected final Module myModule;
    @NotNull
    private final RubySdkSystemAccessor d;
    private static final long h;

    protected RubyAbstractRunner(@Nullable Module module2, @NotNull RubySdkSystemAccessor systemAccessor) {
        if (systemAccessor == null) {
            RubyAbstractRunner.b(0);
        }
        this.myModule = module2;
        this.d = systemAccessor;
    }

    @Override
    @NotNull
    public final RubySdkSystemAccessor getSystemAccessor() {
        RubySdkSystemAccessor rubySdkSystemAccessor = this.d;
        if (rubySdkSystemAccessor == null) {
            RubyAbstractRunner.b(1);
        }
        return rubySdkSystemAccessor;
    }

    private void a(@NotNull Sdk sdk, @NotNull PathMappingSettings pathMappingSettings, @NotNull Map<String, String> map2) {
        TestFrameworkConfigurator[] testFrameworkConfiguratorArray;
        if (sdk == null) {
            RubyAbstractRunner.b(2);
        }
        if (pathMappingSettings == null) {
            RubyAbstractRunner.b(3);
        }
        if (map2 == null) {
            RubyAbstractRunner.b(4);
        }
        if ((testFrameworkConfiguratorArray = (TestFrameworkConfigurator[])TestFrameworkConfigurator.EP_NAME.getExtensions()).length > 0) {
            try {
                testFrameworkConfiguratorArray[0].configureTestFrameworkSupport(sdk, pathMappingSettings, map2, this.myModule);
            }
            catch (ExecutionException executionException) {
                b.warn((Throwable)executionException);
            }
        }
    }

    @Override
    @NotNull
    public RubyCommandLine createCommandLine(@NotNull RubyRunnerExecutionContext context) {
        long l2 = h ^ 0x7E722B8B181L;
        if (context == null) {
            RubyAbstractRunner.b(5);
        }
        RubyCommandLine rubyCommandLine = new RubyCommandLine(this, context.isAskForSudo(), context.getExecutionData());
        rubyCommandLine.withPty(context.isAllocatePty());
        Sdk sdk = context.getRubySdk();
        PathMappingSettings pathMappingSettings = this.addDefaultMappings(context.getPathMappings());
        String string = context.getWorkingDirPath();
        String string2 = context.getExecutablePath();
        rubyCommandLine.setExePath(this.toSystemDependentName(string2, pathMappingSettings));
        if (string != null) {
            rubyCommandLine.withWorkDirectory(this.toSystemDependentName(string, pathMappingSettings));
        }
        if (JRubySdkType.isJRubyExecutable(string2)) {
            JRubySdkUtil.addJRubyClassPath(rubyCommandLine, RubyAbstractRunner.a(context.getAdditionalEnvs()));
        }
        if (JRubySdkUtil.isJRubySDK(sdk)) {
            JRubySdkUtil.specifyLanguageLevel(rubyCommandLine, sdk);
        } else if (RubySdkUtil.isRubinius(sdk) && RubySdkUtil.isRuby19(sdk)) {
            rubyCommandLine.addParameter(c);
        }
        rubyCommandLine.addParameters(context.getExecutableArguments());
        Map<String, String> map2 = RubyAbstractRunner.addRMEnvironment(context.getAdditionalEnvs());
        EnvironmentUtil.inlineParentOccurrences(map2, this.getParentEnv());
        this.passParentEnv(context.isWithParentEnv(), rubyCommandLine);
        Map map3 = rubyCommandLine.getEnvironment();
        if (!context.isSpringPreloaderEnabled()) {
            SpringUtil.disableSpring(map3);
        }
        map3.putAll(map2);
        if (!map3.containsKey("ANSICON")) {
            map3.put("ANSICON", "");
        }
        if (SystemInfo.isMac && !map3.containsKey("LANG")) {
            map3.put("LANG", Locale.getDefault().toString() + ".UTF-8");
        }
        if (sdk != null) {
            this.a(sdk, pathMappingSettings, map3);
            if (context.isPatchWithVersionManager()) {
                e.set((UserDataHolder)rubyCommandLine, () -> RubyVersionManagerHandler.patchCommandLine(this, rubyCommandLine, map3, map2, sdk, pathMappingSettings));
            }
        }
        RubyCommandLine rubyCommandLine2 = context.preprocessCommandLine(rubyCommandLine);
        if (rubyCommandLine2 == null) {
            RubyAbstractRunner.b(6);
        }
        return rubyCommandLine2;
    }

    protected void passParentEnv(boolean passParentEnvs, @NotNull GeneralCommandLine cmdLine) {
        if (cmdLine == null) {
            RubyAbstractRunner.b(7);
        }
        cmdLine.withParentEnvironmentType(passParentEnvs ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
    }

    @NotNull
    public abstract String toSystemDependentName(@NotNull String var1, @NotNull PathMappingSettings var2);

    @Override
    @Nullable
    public ProcessOutput execute(@NotNull RubyCommandLineExecutionContext context) throws ExecutionException {
        if (context == null) {
            RubyAbstractRunner.b(8);
        }
        RubyCommandLine rubyCommandLine = context.getCommandLine();
        ExecutionMode executionMode = context.getExecutionMode();
        String string = context.getExecutionID();
        ProcessHandler processHandler = this.a(rubyCommandLine, null, string);
        CapturingProcessAdapter capturingProcessAdapter = new CapturingProcessAdapter();
        if (!executionMode.inBackGround()) {
            processHandler.addProcessListener((ProcessListener)capturingProcessAdapter);
        }
        for (ProcessListener processListener : executionMode.getProcessListeners()) {
            processHandler.addProcessListener(processListener);
        }
        this.applyLastPatchTo(processHandler).startNotify();
        ExecutionHelper.executeExternalProcess((Project)context.getProject(), (ProcessHandler)processHandler, (ExecutionMode)executionMode, (GeneralCommandLine)rubyCommandLine);
        if (executionMode.inBackGround()) {
            return null;
        }
        return capturingProcessAdapter.getOutput();
    }

    @NotNull
    public ProcessHandler applyLastPatchTo(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            RubyAbstractRunner.b(9);
        }
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            RubyAbstractRunner.b(10);
        }
        return processHandler2;
    }

    @Deprecated
    @NotNull
    protected ProcessHandler createProcessHandlerInner(@NotNull RubyCommandLine commandLine, @Nullable String runnerId, boolean allocatePty) throws ExecutionException {
        if (commandLine == null) {
            RubyAbstractRunner.b(11);
        }
        ProcessHandler processHandler = this.createProcessHandlerInner(commandLine.withPty(allocatePty), runnerId);
        if (processHandler == null) {
            RubyAbstractRunner.b(12);
        }
        return processHandler;
    }

    @NotNull
    protected abstract ProcessHandler createProcessHandlerInner(@NotNull RubyCommandLine var1, @Nullable String var2) throws ExecutionException;

    @NotNull
    protected ProcessHandler processProcessHandler(@NotNull ProcessHandler processHandler, @Nullable String executionID) {
        if (processHandler == null) {
            RubyAbstractRunner.b(13);
        }
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            RubyAbstractRunner.b(14);
        }
        return processHandler2;
    }

    @Override
    @NotNull
    public final ProcessHandler createProcessHandler(@NotNull RubyCommandLine commandLine, @Nullable String runnerId) throws ExecutionException {
        if (commandLine == null) {
            RubyAbstractRunner.b(15);
        }
        ProcessHandler processHandler = this.a(commandLine, runnerId, null);
        if (processHandler == null) {
            RubyAbstractRunner.b(16);
        }
        return processHandler;
    }

    @NotNull
    private static RubyCommandLine a(@NotNull RubyCommandLine rubyCommandLine) throws ExecutionException {
        ThrowableRunnable throwableRunnable;
        if (rubyCommandLine == null) {
            RubyAbstractRunner.b(17);
        }
        if ((throwableRunnable = (ThrowableRunnable)e.get((UserDataHolder)rubyCommandLine)) != null) {
            throwableRunnable.run();
        }
        RubyCommandLine rubyCommandLine2 = rubyCommandLine;
        if (rubyCommandLine2 == null) {
            RubyAbstractRunner.b(18);
        }
        return rubyCommandLine2;
    }

    @NotNull
    private ProcessHandler a(@NotNull RubyCommandLine rubyCommandLine, @Nullable String string, @Nullable String string2) throws ExecutionException {
        Application application;
        long l2 = h ^ 0x10D3A2E667AEL;
        if (rubyCommandLine == null) {
            RubyAbstractRunner.b(19);
        }
        if (Registry.is((String)"ruby.execution.lock.control") && (application = ApplicationManager.getApplication()).isReadAccessAllowed() && !application.isUnitTestMode()) {
            b.warn("Ruby command should not be executed under lock. [Read lock: " + application.isReadAccessAllowed() + "; Write lock: " + application.isWriteAccessAllowed() + "; EDT: " + application.isDispatchThread() + "]", new Throwable());
        }
        ProcessHandler processHandler = this.processProcessHandler(this.createProcessHandlerInner(RubyAbstractRunner.a(rubyCommandLine), string), string2);
        if (processHandler == null) {
            RubyAbstractRunner.b(20);
        }
        return processHandler;
    }

    @Override
    @NotNull
    public Pair<PortForwarding, PortForwarding> getDebuggerForwardings() throws ExecutionException {
        Pair pair;
        long l2 = h ^ 0x94E4FA4D51EL;
        try {
            int[] nArray = NetUtils.findAvailableSocketPorts((int)2);
            int[] nArray2 = this.findAvailableRemotePorts(nArray);
            pair = Pair.create((Object)PortForwarding.remoteToLocal("localhost", nArray2[0], nArray[0]), (Object)PortForwarding.localToRemote("localhost", nArray[1], nArray2[1]));
        }
        catch (IOException iOException) {
            throw new ExecutionException(RBundle.message("ruby.debugger.cannot.find.free.port"));
        }
        if (pair == null) {
            RubyAbstractRunner.b(21);
        }
        return pair;
    }

    @NotNull
    protected abstract int[] findAvailableRemotePorts(@NotNull int[] var1) throws ExecutionException;

    @Nullable
    private static String a(@Nullable Map<String, String> map2) {
        long l2 = h ^ 0x4A18557135D2L;
        return map2 == null ? null : map2.get("CLASSPATH");
    }

    @NotNull
    public static Map<String, String> addRMEnvironment(@Nullable Map<String, String> environment) {
        long l2 = h ^ 0x3754AE1AAC35L;
        HashMap<String, String> hashMap = environment != null ? new HashMap<String, String>(environment) : new HashMap();
        hashMap.put(a, ApplicationInfoEx.getInstanceEx().getBuild().asString());
        HashMap<String, String> hashMap2 = hashMap;
        if (hashMap2 == null) {
            RubyAbstractRunner.b(22);
        }
        return hashMap2;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @Override
    @NotNull
    public final ProcessHandler createConsoleProcessHandler(@NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            RubyAbstractRunner.b(23);
        }
        ProcessHandler processHandler = this.createConsoleProcessHandlerInner(RubyAbstractRunner.a(commandLine));
        if (processHandler == null) {
            RubyAbstractRunner.b(24);
        }
        return processHandler;
    }

    @NotNull
    protected abstract ProcessHandler createConsoleProcessHandlerInner(@NotNull RubyCommandLine var1) throws ExecutionException;

    @Override
    @NotNull
    public final List<String> getCommandsSequence(List<String> ... commands) {
        long l2 = h ^ 0x62890A3B73EBL;
        if (commands == null) {
            RubyAbstractRunner.b(25);
        }
        List list3 = new GeneralCommandLine(this.wrapWithShell(false, false, Stream.of(commands).map(list2 -> new GeneralCommandLine(list2).getCommandLineString()).collect(Collectors.joining(" && ")))).getCommandLineList(null);
        if (list3 == null) {
            RubyAbstractRunner.b(26);
        }
        return list3;
    }

    @Override
    @NotNull
    public final List<String> wrapWithShell(boolean isLogin, boolean isInteractive, @NotNull String command) {
        long l2 = h ^ 0x7170DCC9E66DL;
        if (command == null) {
            RubyAbstractRunner.b(27);
        }
        if (this.getSystemAccessor().isWindows()) {
            throw new RuntimeException("Not supposed to be invoked on Windows");
        }
        String string = this.getLinuxShellCommand();
        if (!"bash".equals(PathUtil.getFileName((String)string))) {
            command = StringUtil.join(Arrays.asList("bash", "-c", CommandLineUtil.posixQuote((String)command)), (String)" ");
        }
        List list2 = EnvironmentUtil.buildShellProcessCommand((String)string, (boolean)isLogin, (boolean)isInteractive, (boolean)true);
        list2.add(command);
        List list3 = list2;
        if (list3 == null) {
            RubyAbstractRunner.b(28);
        }
        return list3;
    }

    @NotNull
    protected abstract String getLinuxShellCommand();

    static {
        h = com.jetbrains.python.psi.c.a(-7289874234861779376L, -2018004804315380426L, MethodHandles.lookup().lookupClass()).a(48672159601724L);
        long l2 = h ^ 0xC0C2713BBCL;
        b = Logger.getInstance(RubyAbstractRunner.class);
        e = Key.create((String)"ruby.version.manager.patch");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x144FA7D8E133L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemAccessor";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/RubyAbstractRunner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envMap";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/RubyAbstractRunner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemAccessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyLastPatchTo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandlerInner";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processProcessHandler";
                break;
            }
            case 16: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "applyVersionManagerPatch";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerForwardings";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addRMEnvironment";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleProcessHandler";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandsSequence";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithShell";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureTestFrameworkSupport";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "passParentEnv";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyLastPatchTo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandlerInner";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processProcessHandler";
                break;
            }
            case 15: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyVersionManagerPatch";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleProcessHandler";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCommandsSequence";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithShell";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

